/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.stc;

import cds.aladin.Coord;
import cds.aladin.stc.STCFrame;
import cds.aladin.stc.STCObj;

public class STCCircle
extends STCObj {
    private Coord center;
    private double radius;

    public STCCircle() {
    }

    public STCCircle(STCFrame frame, double ra, double dec, double radius) {
        this();
        this.frame = frame;
        this.center = new Coord(ra, dec);
        this.radius = radius;
    }

    public STCCircle(double ra, double dec, double radius) {
        this();
        this.center = new Coord(ra, dec);
        this.radius = radius;
    }

    public STCCircle(STCFrame frame, String ra, String dec, String radius) {
        this(Double.parseDouble(ra), Double.parseDouble(dec), Double.parseDouble(radius));
        this.frame = frame;
    }

    @Override
    public STCObj.ShapeType getShapeType() {
        return STCObj.ShapeType.CIRCLE;
    }

    @Override
    public boolean isIn(double lon, double lat) {
        boolean isIn = false;
        double distance = Coord.getDist(this.center, new Coord(lat, lon));
        if (distance <= this.radius) {
            isIn = true;
        }
        return isIn;
    }

    public void setFrame(STCFrame frame) {
        this.frame = frame;
    }

    public Coord getCenter() {
        return this.center;
    }

    public void setCenter(Coord center) {
        this.center = center;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public String toString() {
        StringBuffer toPrint = new StringBuffer();
        toPrint.append((Object)this.getShapeType()).append(" ").append((Object)this.frame).append(" ").append(this.center.al).append(" ").append(this.center.del).append(" ").append(this.radius);
        return toPrint.toString();
    }
}

