/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.prop;

import cds.aladin.prop.Filet;
import cds.aladin.prop.Prop;
import cds.aladin.prop.Propable;
import cds.tools.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropPanel
extends JPanel {
    private JFrame frame;
    private Vector<Prop> propList;

    public PropPanel(Propable obj) {
        this(null, obj);
    }

    public PropPanel(JFrame frame, Propable obj) {
        this.frame = frame;
        this.propList = obj.getProp();
        this.createPanel();
    }

    public int apply() {
        int rep = -1;
        for (Prop p : this.propList) {
            int a = p.apply();
            if (a == 0) {
                rep = a;
                continue;
            }
            if (rep != -1 || a != 1 && a != 2) continue;
            rep = a;
        }
        if (rep == 2 && this.frame != null) {
            this.frame.setVisible(false);
        }
        return rep;
    }

    public void resume() {
        for (Prop p : this.propList) {
            p.resume();
        }
    }

    private void createPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.setLayout(g);
        for (Prop p : this.propList) {
            PropPanel.addCouple(this.frame, this, p.getLabel(), p.getHelp(), p.getWidget(), g, c, 13);
        }
    }

    public static void addCouple(Component frame, JPanel p, Object titre, String help, Component valeur, GridBagLayout g, GridBagConstraints c) {
        PropPanel.addCouple(frame, p, titre, help, valeur, g, c, 17);
    }

    public static void addCouple(JPanel p, Object titre, Component valeur, GridBagLayout g, GridBagConstraints c) {
        PropPanel.addCouple(null, p, titre, null, valeur, g, c, 17);
    }

    public static void addCouple(Component frame, JPanel p, Object titre, String help, Component valeur, GridBagLayout g, GridBagConstraints c, int titleAnchor) {
        PropPanel.addCouple(frame, p, titre, help, valeur, g, c, titleAnchor, 0);
    }

    public static void addCouple(Component frame, JPanel p, Object titre, String help, Component valeur, GridBagLayout g, GridBagConstraints c, int titleAnchor, int fillComp) {
        Component t;
        if (titre == null) {
            t = new JLabel();
        } else if (titre instanceof String) {
            JLabel l = new JLabel((String)titre);
            l.setFont(l.getFont().deriveFont(2));
            t = l;
        } else {
            t = (Component)titre;
        }
        if (help != null) {
            JPanel p2 = new JPanel();
            p2.add(t);
            JButton h = Util.getHelpButton(frame, help);
            p2.add(h);
            t = p2;
        }
        c.anchor = titleAnchor;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        g.setConstraints(t, c);
        p.add(t);
        if (valeur instanceof JButton) {
            JPanel p1 = new JPanel();
            p1.add(valeur);
            t = p1;
        } else {
            t = valeur;
        }
        c.gridwidth = 0;
        c.fill = titre == null ? 2 : fillComp;
        c.weightx = 1.0;
        c.anchor = 17;
        g.setConstraints(t, c);
        p.add(t);
    }

    public static void addInfo(JPanel p, String info, GridBagLayout g, GridBagConstraints c) {
        c.fill = 0;
        c.gridwidth = 0;
        c.anchor = 10;
        c.fill = 2;
        JLabel l = new JLabel(Util.fold("<center>" + info + "</center>", 80, true), 0);
        l.setFont(l.getFont().deriveFont(2));
        g.setConstraints(l, c);
        p.add(l);
    }

    public static void addSectionTitle(JPanel p, String title, GridBagLayout g, GridBagConstraints c) {
        JLabel l = new JLabel(title);
        PropPanel.addSectionTitle(p, l, g, c);
    }

    public static void addSectionTitle(JPanel p, JLabel l, GridBagLayout g, GridBagConstraints c) {
        l.setFont(l.getFont().deriveFont(1));
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 1;
        g.setConstraints(l, c);
        p.add(l);
    }

    public static void addFilet(JPanel p, GridBagLayout g, GridBagConstraints c, int h, int type) {
        Filet f = new Filet(h, type);
        GridBagConstraints c1 = (GridBagConstraints)c.clone();
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 1;
        g.setConstraints(f, c);
        p.add(f);
        c = c1;
    }

    public static void addFilet(JPanel p, GridBagLayout g, GridBagConstraints c) {
        PropPanel.addFilet(p, g, c, 5, 1);
    }
}

