/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.bookmark;

import cds.aladin.Aladin;
import cds.aladin.Cache;
import cds.aladin.Command;
import cds.aladin.Function;
import cds.aladin.Glu;
import cds.aladin.MyInputStream;
import cds.aladin.Tok;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.aladin.bookmark.ButtonBookmark;
import cds.aladin.bookmark.FrameBookmarks;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class Bookmarks
extends JToolBar
implements Widget {
    private Aladin aladin;
    private FrameBookmarks frameBookmarks;
    private Color cbg;
    private String memoDefaultList = "";
    private String defaultBookmarkListByGlu = null;
    private String gluTag = null;
    private boolean remoteBookmarksLoaded = false;
    private WidgetControl voc = null;

    public Bookmarks(Aladin aladin) {
        this.aladin = aladin;
        this.frameBookmarks = null;
        this.setRollover(true);
        this.setFloatable(false);
        this.setBorderPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(aladin.getBackground());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.aladin.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void init(boolean noCache) {
        this.createBookmarks(noCache);
        this.aladin.getCommand().setFunctionModif(false);
    }

    public FrameBookmarks getFrameBookmarks() {
        if (this.frameBookmarks == null) {
            this.frameBookmarks = new FrameBookmarks(this.aladin, this);
        }
        return this.frameBookmarks;
    }

    public void reload() {
        String list = this.aladin.configuration.getBookmarks();
        this.aladin.configuration.resetBookmarks();
        this.init(true);
        StringTokenizer tok = new StringTokenizer(list == null ? "" : list, ",");
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            Function f = this.aladin.getCommand().getFunction(name);
            if (!f.isLocalDefinition()) continue;
            f.setBookmark(true);
        }
        Bookmarks bookmarks = this;
        if (bookmarks.aladin.hasGUI()) {
            this.resumeToolBar();
        }
    }

    public JToolBar getToolBar() {
        return this;
    }

    public String getUniqueName(String name) {
        int j = name.indexOf(40);
        if (j > 0) {
            name = name.substring(0, j);
        }
        Vector<Function> v = this.aladin.getCommand().getBookmarkFunctions();
        int i = 0;
        while (true) {
            boolean trouve = false;
            String sn = name + (i == 0 ? "" : "~" + i);
            Enumeration<Function> e = v.elements();
            while (e.hasMoreElements()) {
                Function f = e.nextElement();
                if (!sn.equals(f.getName())) continue;
                trouve = true;
                break;
            }
            if (!trouve) {
                return sn;
            }
            ++i;
        }
    }

    private void populateToolBar(JToolBar toolBar) {
        Enumeration<Function> e;
        try {
            e = this.aladin.getCommand().getBookmarkFunctions().elements();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
        while (e.hasMoreElements()) {
            Function f = e.nextElement();
            ButtonBookmark bkm = new ButtonBookmark(this.aladin, f);
            toolBar.add(bkm);
        }
        JButton plus = new JButton("+");
        plus.setBackground(this.aladin.getBackground());
        plus.setForeground(Aladin.COLOR_LABEL);
        plus.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        Bookmarks bookmarks = this;
        plus.setToolTipText(bookmarks.aladin.getChaine().getString("BKMEDITOR"));
        plus.setFont(plus.getFont().deriveFont(1));
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Bookmarks.this.editFrame();
            }
        });
        toolBar.add(plus);
    }

    public void resumeToolBar() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.resumeToolBar1();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Bookmarks.this.resumeToolBar1();
                }
            });
        }
    }

    private void resumeToolBar1() {
        this.removeAll();
        this.populateToolBar(this);
        this.revalidate();
        this.aladin.repaint();
        if (this.aladin.f != null) {
            this.aladin.f.repaint();
        }
    }

    public void showFrame() {
        this.getFrameBookmarks().setVisible(true);
    }

    public void editFrame() {
        this.getFrameBookmarks().setVisibleEdit();
    }

    public boolean isDefaultList() {
        return this.memoDefaultList.equals(this.getBookmarkList());
    }

    public void memoDefaultList(String s) {
        this.memoDefaultList = s;
    }

    public String getBookmarkList() {
        return this.getBookmarkList(false);
    }

    public String getBookmarkList(boolean onlyLocal) {
        StringBuffer bkm = new StringBuffer();
        Enumeration<Function> e = this.aladin.getCommand().getBookmarkFunctions().elements();
        while (e.hasMoreElements()) {
            Function f = e.nextElement();
            if (onlyLocal && !f.isLocalDefinition()) continue;
            if (bkm.length() > 0) {
                bkm.append(',');
            }
            bkm.append(f.getName());
        }
        return bkm.toString();
    }

    public boolean canBeSaved() {
        return this.remoteBookmarksLoaded;
    }

    public void setBookmarkList(String names) {
        int mode = 0;
        if (names.length() > 1) {
            if (names.charAt(0) == '+') {
                mode = 1;
                names = names.substring(1);
            } else if (names.charAt(0) == '-') {
                mode = -1;
                names = names.substring(1);
            }
        }
        if (mode == 0) {
            this.aladin.getCommand().resetBookmarks();
            mode = 1;
        }
        Tok tok = new Tok(names, ",");
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken().trim();
            Function f = this.aladin.getCommand().getFunction(name);
            if (f == null) continue;
            f.setBookmark(mode == 1);
        }
        this.resumeToolBar();
    }

    public void memoGluBookmarks(String actionName, String aladinBookmarks) {
        Aladin.trace(3, "Bookmarks.memoBookmarks() %A=" + actionName + " %Aladin.Bookmarks=" + aladinBookmarks);
        this.gluTag = actionName;
        this.defaultBookmarkListByGlu = aladinBookmarks;
    }

    public void createBookmarks(boolean noCache) {
        File f;
        Glu glu = this.aladin.getGlu();
        Cache cache = this.aladin.getCache();
        Command command = this.aladin.getCommand();
        if (this.gluTag != null) {
            try {
                Aladin.trace(3, "Remote bookmarks loaded...");
                command.setFunctionLocalDefinition(false);
                if (noCache) {
                    String u = glu.getURL(this.gluTag, "", false, false) + "";
                    cache.putInCache(u);
                }
                MyInputStream in = new MyInputStream(cache.get(glu.getURL(this.gluTag, "", false, false)));
                this.aladin.getCommand().execScript(new String(in.readFully()), false, true, false);
                in.close();
                this.remoteBookmarksLoaded = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Remote bookmarks error: " + e.getMessage());
            }
        }
        if ((f = new File(this.aladin.getConfiguration().getLocalBookmarksFileName())).canRead()) {
            try {
                Aladin.trace(3, "Local bookmarks loaded [" + f.getCanonicalPath() + "]...");
                command.setFunctionLocalDefinition(true);
                MyInputStream in = new MyInputStream(new FileInputStream(f));
                command.execScript(new String(in.readFully()), false, true, false);
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Local bookmarks error: " + e.getMessage());
            }
        }
        if (this.defaultBookmarkListByGlu != null) {
            this.memoDefaultList(this.defaultBookmarkListByGlu);
        }
        String t = "Default ";
        String s = this.aladin.configuration.getBookmarks();
        if (s == null || s.trim().length() == 0) {
            s = this.defaultBookmarkListByGlu;
        } else {
            t = "Local ";
        }
        if (s != null) {
            Aladin.trace(2, t + "bookmarks: " + s);
            this.setBookmarkList(s);
        }
        command.setFunctionLocalDefinition(true);
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetControl(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
        this.voc.setCollapsed(false);
    }

    @Override
    public void paintCollapsed(Graphics g) {
    }

    @Override
    public boolean onNothing(MouseEvent e) {
        return false;
    }
}

