/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanHips;
import cds.aladin.Server;
import cds.aladin.ViewSimple;
import cds.aladin.ZoomChoice;
import cds.aladin.ZoomTime;
import cds.aladin.ZoomView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class Zoom
extends JPanel {
    static int[] mzn = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2};
    static int[] mzd = new int[]{4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 3};
    static final int MINZOOM = mzn.length;
    static final int MAXZOOM = 88;
    public static final int MINSLIDERBG = 0;
    public static final int MAXSLIDERBG = 81;
    public static final int MINSLIDER = mzn.length - 7;
    public static final int MAXSLIDER = mzn.length + 7;
    ZoomView zoomView;
    JComboBox cZoom;
    protected ZoomChoice zoomChoicePanel;
    protected ZoomTime zoomTime = null;
    Aladin aladin;
    private boolean flagNoAction = false;

    protected Zoom() {
    }

    protected Zoom(Aladin aladin) {
        int i;
        this.aladin = aladin;
        this.zoomView = new ZoomView(aladin);
        this.zoomTime = new ZoomTime(this.zoomView);
        this.zoomView.setZoomTime(this.zoomTime);
        this.setLayout(new BorderLayout(5, 10));
        this.cZoom = new JComboBox();
        this.cZoom.setFont(this.cZoom.getFont().deriveFont(0));
        for (i = 0; i < MINZOOM; ++i) {
            this.cZoom.addItem(mzn[i] + "/" + mzd[i] + "x");
        }
        for (i = 0; i < 88; ++i) {
            this.cZoom.addItem((1 << i) + "x");
        }
        this.cZoom.setSelectedIndex(MINZOOM);
        this.zoomChoicePanel = new ZoomChoice(aladin, this.cZoom);
        this.add((Component)this.zoomView, "Center");
    }

    protected JPanel getZoomChoicePanel() {
        return this.zoomChoicePanel;
    }

    protected double getNearestZoomFct(double z) {
        if (this.aladin.calque.getPlanBase() instanceof PlanHips) {
            return z;
        }
        int n = this.cZoom.getItemCount();
        double min = Double.MAX_VALUE;
        double nz = this.getValue(0);
        for (int i = 1; i < n; ++i) {
            double x = this.getValue(i);
            double diff = Math.abs(z - x);
            if (!(diff < min)) continue;
            min = diff;
            nz = x;
        }
        return nz;
    }

    protected double getNearestZoom(String sZoom) {
        double z = sZoom.indexOf(120) > 0 ? this.parseZoomString(sZoom) : this.getNearestZoomFromRadius(sZoom);
        return this.getNearestZoomFct(z);
    }

    private double parseZoomString(String sZoom) {
        int fin = sZoom.indexOf(120);
        if (fin < 0) {
            fin = sZoom.length();
        }
        int slash = sZoom.indexOf(47);
        boolean flagDiv = true;
        if (slash < 0) {
            flagDiv = false;
            slash = fin;
        }
        double res = Double.parseDouble(sZoom.substring(0, slash));
        if (flagDiv) {
            double den = Double.parseDouble(sZoom.substring(slash + 1, fin));
            res /= den;
        }
        return res;
    }

    protected double getNearestZoomFromRadius(String radius) {
        return this.getNearestZoomFromRadius(null, radius);
    }

    protected double getNearestZoomFromRadius(ViewSimple v, String radius) {
        try {
            double deg = Server.getAngleInArcmin(radius, 1) / 60.0;
            if (v == null) {
                v = this.aladin.view.getCurrentView();
            }
            double pixelSize = v.getProj().getPixResDelta();
            double nbPixel = deg / pixelSize;
            double viewSize = v.getWidth();
            double z = viewSize / nbPixel;
            return this.getNearestZoomFct(z);
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    protected double getValue() {
        int n;
        if (this.aladin.calque.slider.zoomSlider != null) {
            n = (int)this.aladin.calque.slider.zoomSlider.getValue();
            try {
                this.cZoom.setSelectedIndex(n);
            }
            catch (Exception exception) {}
        } else {
            n = this.cZoom.getSelectedIndex();
        }
        return this.getValue(n);
    }

    protected double getValue(int i) {
        return this.getValue(i, false);
    }

    protected double getValue(int i, boolean flagPow2) {
        ViewSimple v = this.aladin.view.getCurrentView();
        Plan p = this.aladin.calque.getPlanBase();
        if (!flagPow2 && (p != null && p instanceof PlanHips || v != null && v.isPlot())) {
            return this.getValueTest(i);
        }
        return this.getValuePow2(i);
    }

    protected double getValueTest(int i) {
        double z = Math.pow(1.15, i - MINZOOM);
        return z /= 10.0;
    }

    protected double getValuePow2(int i) {
        double z = i >= MINZOOM ? (double)(1 << i - MINZOOM) : (double)mzn[i] / (double)mzd[i];
        return z;
    }

    protected int getNbPixelSrc(double z) {
        int i = this.getIndex(z);
        return i >= MINZOOM ? 1 : mzd[i];
    }

    protected int getNbPixelDst(double z) {
        int i = this.getIndex(z);
        return i >= MINZOOM ? 1 << i - MINZOOM : mzn[i];
    }

    protected String getItem(double z) {
        return (String)this.cZoom.getItemAt(this.getIndex(z));
    }

    protected int getIndex() {
        return this.cZoom.getSelectedIndex();
    }

    protected double getNextValue(double z, int sens, boolean flagPow2) {
        int i = this.getIndex(z, flagPow2);
        if (i + sens < 0 || i + sens > MINZOOM + 88) {
            return -1.0;
        }
        return this.getValue(i += sens, flagPow2);
    }

    protected boolean setZoom(String fct) {
        if (fct.equals("+") || fct.equals("plus")) {
            this.incZoom(1);
        } else if (fct.equals("-")) {
            this.incZoom(-1);
        } else {
            double z = this.getNearestZoom(fct);
            if (z < 0.0) {
                return false;
            }
            this.aladin.view.setZoomRaDecForSelectedViews(z, null);
        }
        return true;
    }

    protected void incZoom(int sens) {
        double z1 = this.getValue();
        double z = this.getNextValue(z1, sens, false);
        if (z == -1.0) {
            return;
        }
        this.aladin.view.setZoomRaDecForSelectedViews(z, null);
    }

    protected void newZoom() {
        ViewSimple v = this.aladin.view.getCurrentView();
        if (v != null) {
            this.zoomView.newZoom(v.xzoomView, v.yzoomView);
        }
    }

    protected void submit() {
        if (!this.flagNoAction) {
            this.aladin.view.setZoomRaDecForSelectedViews(this.getValue(), null);
        }
    }

    protected Rectangle getZoom() {
        ViewSimple v = this.aladin.view.getCurrentView();
        if (v == null || v.rzoom == null) {
            return null;
        }
        return new Rectangle(Zoom.floor(v.rzoom.x), Zoom.floor(v.rzoom.y), Zoom.top(v.rzoom.width), Zoom.top(v.rzoom.height));
    }

    protected void setValue(double z) {
        int i = this.getIndex(z);
        if (i != -1 && this.cZoom.getSelectedIndex() != i) {
            this.flagNoAction = true;
            try {
                this.cZoom.setSelectedIndex(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.aladin.calque.slider.zoomSlider != null) {
                this.aladin.calque.slider.zoomSlider.setValue(i);
            }
            this.flagNoAction = false;
        }
    }

    protected boolean isHips() {
        Plan p = this.aladin.calque.getPlanBase();
        return p != null && p instanceof PlanHips;
    }

    private int getIndex(double z) {
        return this.getIndex(z, false);
    }

    private int getIndex(double z, boolean flagPow2) {
        int n = this.cZoom.getItemCount() + 250;
        for (int i = 0; i < n; ++i) {
            if (!(this.getValue(i, flagPow2) >= z)) continue;
            return i;
        }
        return -1;
    }

    public void zoomSliderReset() {
        if (this.aladin.calque.slider.zoomSlider != null) {
            this.aladin.calque.slider.zoomSlider.setEnabled(!this.aladin.calque.isFree());
        }
    }

    protected void reset() {
        this.reset(true);
    }

    protected void reset(boolean withImagette) {
        if (withImagette) {
            this.zoomView.resetImgID();
        }
        this.newZoom();
    }

    protected void wenOn() {
        if (this.aladin.toolBox.tool[6].mode == -1) {
            this.zoomView.wenOn();
        }
    }

    protected void wenOff() {
        if (this.aladin.toolBox.tool[6].mode != 1) {
            this.zoomView.wenOff();
        }
    }

    protected boolean redrawWen(double x, double y) {
        if (this.aladin.toolBox.tool[6].mode == -1) {
            this.zoomView.wen(x, y);
            return true;
        }
        return false;
    }

    protected void redrawCut() {
        if (this.zoomView.flagCut) {
            this.zoomView.repaint();
        }
    }

    protected static int round(double x) {
        return (int)(x + 0.5);
    }

    protected static int floor(double x) {
        return (int)x;
    }

    protected static int top(double x) {
        return (double)((int)x) == x ? (int)x : (int)(x + 1.0);
    }
}

