/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Spectrogram;
import cds.aladin.WidgetControl;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class WidgetSpectrogram
extends WidgetControl {
    private int parentWidth;
    private int parentHeight;

    public WidgetSpectrogram(JComponent c, int x, int y, int width, int height, float opacity, JComponent parent) {
        super(c, x, y, width, height, opacity, parent);
        this.parentWidth = parent.getWidth();
        this.parentHeight = parent.getHeight();
    }

    public boolean adjustWidgetControl() {
        JComponent c = this.getParent();
        if (this.parentWidth == c.getWidth() && this.parentHeight == c.getHeight()) {
            return false;
        }
        double fctWidth = (double)c.getWidth() / (double)this.parentWidth;
        this.width = (int)((double)this.width * fctWidth);
        this.x = (int)((double)this.x * fctWidth);
        double fctHeight = (double)c.getHeight() / (double)this.parentHeight;
        int h = (int)((double)this.height * fctHeight);
        this.y += h - this.height;
        this.height = h;
        this.parentWidth = c.getWidth();
        this.parentHeight = c.getHeight();
        return true;
    }

    protected void activateFlagControl(boolean flag) {
        this.flagControl = flag;
    }

    protected boolean isFlagControl() {
        return this.flagControl;
    }

    @Override
    public boolean isMouseIn(MouseEvent e) {
        if (((Spectrogram)this.getWidget()).inTarget(e)) {
            return true;
        }
        return super.isMouseIn(e);
    }

    @Override
    protected boolean inShowHead(MouseEvent e) {
        return false;
    }

    @Override
    protected int getHeadHeight() {
        return 0;
    }
}

