/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

public class WidgetController {
    private ArrayList<Widget> widgets = new ArrayList();
    private Cursor cursor = null;

    public void addWidget(Widget vo) {
        if (this.widgets.contains(vo)) {
            return;
        }
        this.widgets.add(vo);
    }

    public void removeWidget(Widget vo) {
        this.widgets.remove(vo);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void paint(Graphics g) {
        for (Widget vo : this.widgets) {
            vo.getWidgetControl().paint(g);
        }
    }

    public boolean mouseMoved(MouseEvent e) {
        return this.mouseAction(e, 0);
    }

    public boolean mouseDragged(MouseEvent e) {
        return this.mouseAction(e, 1);
    }

    public boolean mousePressed(MouseEvent e) {
        return this.mouseAction(e, 2);
    }

    public boolean mouseReleased(MouseEvent e) {
        return this.mouseAction(e, 3);
    }

    public boolean mouseWheel(MouseEvent e) {
        return this.mouseAction(e, 4);
    }

    private boolean mouseAction(MouseEvent e, int action) {
        boolean rep = false;
        WidgetControl voc = null;
        for (Widget vo : this.widgets) {
            voc = vo.getWidgetControl();
            if (!voc.isActivated(e)) continue;
            rep = this.mouseActionOne(e, vo, action);
            break;
        }
        if (!rep) {
            for (int i = this.widgets.size() - 1; i >= 0; --i) {
                Widget vo;
                vo = this.widgets.get(i);
                voc = vo.getWidgetControl();
                if (!voc.isDragging() && !voc.isMouseIn(e)) continue;
                rep = this.mouseActionOne(e, vo, action);
                break;
            }
        }
        if (rep) {
            this.cursor = voc.getCursor();
        }
        return rep;
    }

    private boolean mouseActionOne(MouseEvent e, Widget vo, int action) {
        WidgetControl voc = vo.getWidgetControl();
        switch (action) {
            case 0: {
                voc.mouseMoved(e);
                return true;
            }
            case 1: {
                voc.mouseDragged(e);
                return true;
            }
            case 2: {
                voc.mousePressed(e);
                return true;
            }
            case 3: {
                int code = voc.mouseReleased(e);
                if (code == 1) {
                    this.widgets.remove(vo);
                } else if (code == 2) {
                    this.widgets.remove(vo);
                    this.widgets.add(vo);
                }
                return true;
            }
            case 4: {
                voc.mouseWheel((MouseWheelEvent)e);
                return true;
            }
        }
        return false;
    }
}

