/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Widget;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;

public class WidgetControl {
    private static final int IN = 0;
    private static final int HG = 1;
    private static final int H = 2;
    private static final int HD = 3;
    private static final int D = 4;
    private static final int BD = 5;
    private static final int B = 6;
    private static final int BG = 7;
    private static final int G = 8;
    private static final int INHEAD = 9;
    private static final int INCOLLAPSED = 10;
    private static final int NW = 0;
    private static final int NE = 16;
    private static final int SE = 17;
    private static final int SW = 1;
    public static final int NOTHING = 0;
    public static final int DISPOSE = 1;
    public static final int UP = 2;
    static final int[] CURSOR = new int[]{12, 6, 8, 7, 11, 5, 9, 4, 10};
    private static final Color BLUE = new Color(150, 150, 255);
    private static int HB = 12;
    private static final int WCOLLAPSED = 25;
    private static final int DS = 5;
    private static final int W = 16;
    private int position = 0;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private float opacity = 1.0f;
    private JComponent c;
    private Rectangle closeButton;
    private boolean movable = true;
    private boolean resizable = false;
    private boolean collapsable = true;
    private boolean fadable = true;
    private JComponent parent = null;
    private boolean isCollapsed = false;
    private boolean in = false;
    private boolean inHead = false;
    private boolean inCollapsed = false;
    private boolean inShowHead = false;
    protected boolean flagControl = false;
    private int poignee = -1;
    private int dragPoignee = -1;
    private int xDrag = 0;
    private int yDrag = 0;
    private boolean flagMove = false;
    private boolean draggedDone = false;

    public WidgetControl(JComponent c, int x, int y, int width, int height, float opacity, JComponent parent) {
        this.c = c;
        this.parent = parent;
        this.setX(x);
        this.setY(y);
        if (opacity <= 0.0f) {
            opacity = 1.0f;
        }
        this.setOpacity(opacity);
        if (width <= 0) {
            width = c.getWidth();
        }
        if (height <= 0) {
            height = c.getHeight();
        }
        HB = this.getHeadHeight();
        this.setSize(width, height);
        this.setCollapsed(true);
    }

    public JComponent getWidget() {
        return this.c;
    }

    protected int getHeadHeight() {
        return 12;
    }

    public void setSize(int width, int height) {
        this.c.setSize(width, height);
        this.width = this.c.getWidth();
        this.height = this.c.getHeight();
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setMovable(boolean flag) {
        this.movable = flag;
    }

    public void setResizable(boolean flag) {
        this.resizable = flag;
    }

    public void setCollapsable(boolean flag) {
        this.collapsable = flag;
    }

    public void setFadable(boolean flag) {
        this.fadable = flag;
    }

    public void setCollapsed(boolean flag) {
        if (flag == this.isCollapsed) {
            return;
        }
        this.isCollapsed = flag;
        int x = this.getX();
        int y = this.getY();
        int dx = 0;
        int dy = 0;
        if (this.aDroite()) {
            dx = this.width - 25;
        }
        if (this.enBas()) {
            dy = this.height - 25;
        }
        if (this.isCollapsed) {
            x += dx;
            y += dy;
        } else {
            x -= dx;
            y -= dy;
        }
        this.setX(x);
        this.setY(y);
        this.draggedDone = false;
        this.flagMove = false;
    }

    public boolean isDragging() {
        return this.draggedDone;
    }

    public int getX() {
        if (this.parent == null) {
            return this.x;
        }
        if (this.aDroite()) {
            return this.parent.getWidth() - this.x;
        }
        return this.x;
    }

    public int getY() {
        if (this.parent == null) {
            return this.y;
        }
        if (this.enBas()) {
            return this.parent.getHeight() - this.y;
        }
        return this.y;
    }

    private void setX(int x) {
        if (this.parent == null) {
            this.x = x;
        } else {
            this.position = x > this.parent.getWidth() / 2 ? (this.position |= 0x10) : (this.position &= 1);
        }
        this.x = this.aDroite() ? this.parent.getWidth() - x : x;
    }

    private void setY(int y) {
        if (this.parent == null) {
            this.y = y;
        } else {
            this.position = y > this.parent.getHeight() / 2 ? (this.position |= 1) : (this.position &= 0x10);
        }
        this.y = this.enBas() ? this.parent.getHeight() - y : y;
    }

    private boolean aDroite() {
        return (this.position & 0x10) != 0;
    }

    private boolean enBas() {
        return (this.position & 1) != 0;
    }

    public Cursor getCursor() {
        if (this.parent == null) {
            return null;
        }
        Cursor cursor = this.c.getCursor();
        this.parent.setCursor(cursor);
        return cursor;
    }

    public boolean isActivated(MouseEvent e) {
        this.isMouseIn(e);
        return this.flagMove || this.flagControl;
    }

    public boolean isCollapsed() {
        return this.collapsable;
    }

    public boolean isMouseIn(MouseEvent e) {
        boolean inNow;
        int xm = e.getX();
        int ym = e.getY();
        int x = this.getX();
        int y = this.getY();
        if (this.isCollapsed) {
            this.in = x <= xm && xm <= x + 25 && y <= ym && ym < y + 25;
            return this.in;
        }
        int m = this.flagControl ? 8 : 0;
        boolean bl = inNow = x - m <= xm && xm <= x + this.width + m && y - HB - m <= ym && ym < y + this.height + m;
        if (this.c instanceof MouseListener) {
            if (!this.in && inNow) {
                ((MouseListener)((Object)this.c)).mouseEntered(e);
            } else if (this.in && !inNow) {
                ((MouseListener)((Object)this.c)).mouseExited(e);
            }
            e.translatePoint(-x, -y);
            if (((Widget)((Object)this.c)).onNothing(e)) {
                e.translatePoint(x, y);
                this.in = inNow;
                return false;
            }
            e.translatePoint(x, y);
        }
        this.in = inNow;
        this.inHead = this.inHead(e);
        this.inShowHead = this.inShowHead(e);
        return inNow || this.inHead;
    }

    protected boolean inShowHead(MouseEvent e) {
        return this.inHead(e);
    }

    protected boolean inHead(MouseEvent e) {
        int xm = e.getX();
        int ym = e.getY();
        int x = this.getX();
        int y = this.getY();
        return (this.movable || this.resizable || this.collapsable) && x <= xm && xm <= x + this.width && y - HB <= ym && ym <= y;
    }

    public void mouseMoved(MouseEvent e) {
        int x = this.getX();
        int y = this.getY();
        boolean bl = this.inCollapsed = this.closeButton != null && this.closeButton.contains(e.getX() - x, e.getY() - y);
        if (this.flagControl) {
            this.poignee = this.getPoignee(e.getX() - x, e.getY() - y);
            if (this.poignee >= 0 && this.poignee < CURSOR.length) {
                Cursor cursor = Cursor.getPredefinedCursor(CURSOR[this.poignee]);
                this.c.setCursor(cursor);
            }
        } else if (this.inHead(e)) {
            this.c.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.c.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (!(this.c instanceof MouseMotionListener)) {
            return;
        }
        e.translatePoint(-x, -y);
        ((MouseMotionListener)((Object)this.c)).mouseMoved(e);
        e.translatePoint(x, y);
    }

    public void mousePressed(MouseEvent e) {
        if (this.inHead && !this.flagControl && this.movable) {
            this.startMove(e);
        } else if (this.flagControl && this.resizable) {
            this.startResize(e);
        } else {
            if (!(this.c instanceof MouseListener)) {
                return;
            }
            int x = this.getX();
            int y = this.getY();
            e.translatePoint(-x, -y);
            ((MouseListener)((Object)this.c)).mousePressed(e);
            e.translatePoint(x, y);
        }
        this.draggedDone = false;
    }

    private void startMove(MouseEvent e) {
        this.xDrag = e.getX();
        this.yDrag = e.getY();
        this.dragPoignee = 9;
        this.flagMove = true;
    }

    private void startResize(MouseEvent e) {
        this.xDrag = e.getX();
        this.yDrag = e.getY();
        int x = this.getX();
        int y = this.getY();
        this.dragPoignee = this.getPoignee(this.xDrag - x, this.yDrag - y);
    }

    public int mouseReleased(MouseEvent e) {
        int ret = this.inHead && !this.draggedDone ? 2 : 0;
        int x = this.getX();
        int y = this.getY();
        int act = this.getAction(e.getX() - x, e.getY() - y);
        if (act == 10 && !this.draggedDone) {
            this.setCollapsed(!this.isCollapsed);
        } else if (this.flagControl) {
            this.flagControl = this.draggedDone || this.poignee > 0 && this.poignee < 9;
            this.draggedDone = false;
            this.setSize(this.width, this.height);
        } else if (this.flagMove && !this.draggedDone && this.resizable) {
            this.flagControl = true;
            this.flagMove = false;
        } else if (this.flagMove) {
            this.flagMove = false;
        } else {
            if (!(this.c instanceof MouseListener)) {
                return ret;
            }
            e.translatePoint(-x, -y);
            ((MouseListener)((Object)this.c)).mouseReleased(e);
            e.translatePoint(x, y);
        }
        this.draggedDone = false;
        return ret;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isCollapsed) {
            return;
        }
        this.draggedDone = true;
        if (this.flagMove || this.flagControl) {
            this.mouseDrag(e);
            return;
        }
        if (this.c instanceof MouseMotionListener) {
            int x = this.getX();
            int y = this.getY();
            e.translatePoint(-x, -y);
            ((MouseMotionListener)((Object)this.c)).mouseDragged(e);
            e.translatePoint(x, y);
        }
    }

    public void mouseWheel(MouseWheelEvent e) {
        if (this.inHead) {
            if (this.fadable) {
                this.opacity = (float)((double)this.opacity + (double)e.getWheelRotation() / 5.0);
                if ((double)this.opacity < 0.2) {
                    this.opacity = 0.2f;
                } else if (this.opacity > 1.0f) {
                    this.opacity = 1.0f;
                }
            }
        } else if (this.c instanceof MouseWheelListener) {
            int x = this.getX();
            int y = this.getY();
            e.translatePoint(-x, -y);
            ((MouseWheelListener)((Object)this.c)).mouseWheelMoved(e);
            e.translatePoint(x, y);
        }
    }

    private void mouseDrag(MouseEvent e) {
        int dx = e.getX() - this.xDrag;
        int dy = e.getY() - this.yDrag;
        if (dx == 0 && dy == 0) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        this.xDrag = e.getX();
        this.yDrag = e.getY();
        switch (this.dragPoignee) {
            case 0: 
            case 9: {
                x += dx;
                y += dy;
                break;
            }
            case 1: {
                x += dx;
                y += dy;
                this.width -= dx;
                this.height -= dy;
                break;
            }
            case 3: {
                y += dy;
                this.width += dx;
                this.height -= dy;
                break;
            }
            case 5: {
                this.width += dx;
                this.height += dy;
                break;
            }
            case 7: {
                x += dx;
                this.width -= dx;
                this.height += dy;
                break;
            }
            case 2: {
                y += dy;
                this.height -= dy;
                break;
            }
            case 4: {
                this.width += dx;
                break;
            }
            case 6: {
                this.height += dy;
                break;
            }
            case 8: {
                x += dx;
                this.width -= dx;
            }
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + this.width > this.parent.getWidth()) {
            x = this.parent.getWidth() - this.width;
        }
        if (y + this.height > this.parent.getHeight()) {
            y = this.parent.getHeight() - this.height;
        }
        this.setX(x);
        this.setY(y);
    }

    protected JComponent getParent() {
        return this.parent;
    }

    private int getPoignee(int xm, int ym) {
        if (this.width == 1 || this.height == 1) {
            return 5;
        }
        if (this.closeButton != null && this.closeButton.contains(xm, ym)) {
            return 10;
        }
        for (int i = 1; i <= 8; ++i) {
            Rectangle rc = this.getRectPoignee(i);
            if (!rc.contains(xm, ym)) continue;
            return i;
        }
        return this.inHead ? 9 : (this.in ? 0 : -1);
    }

    private int getAction(int xm, int ym) {
        if (this.isCollapsed && this.in) {
            return 10;
        }
        if (this.closeButton != null && this.closeButton.contains(xm, ym)) {
            return 10;
        }
        return -1;
    }

    private Rectangle getRectPoignee(int poignee) {
        int w = 16;
        int w2 = w / 2;
        switch (poignee) {
            case 1: {
                return new Rectangle(-w2, -w2 - HB, w, w);
            }
            case 3: {
                return new Rectangle(this.width - w2, -w2 - HB, w, w);
            }
            case 5: {
                return new Rectangle(this.width - w2, this.height - w2, w, w);
            }
            case 7: {
                return new Rectangle(-w2, this.height - w2, w, w);
            }
            case 2: {
                return new Rectangle(this.width / 2 - w2, -w2 - HB, w, w);
            }
            case 4: {
                return new Rectangle(this.width - w2, this.height / 2 - w2, w, w);
            }
            case 8: {
                return new Rectangle(-w2, this.height / 2 - w2, w, w);
            }
            case 6: {
                return new Rectangle(this.width / 2 - w2, this.height - w2, w, w);
            }
        }
        return null;
    }

    private void drawControl(Graphics g) {
        if (!this.movable && !this.resizable) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int xp = (i == 0 || i >= 6 ? 0 : (i == 1 || i == 5 ? this.width / 2 : this.width)) - 2;
            int yp = (i <= 2 ? -HB : (i == 3 || i == 7 ? this.height / 2 : this.height)) - 2;
            g.setColor(i + 1 == this.poignee ? Color.red : Color.green);
            this.drawPoignee(g, xp, yp);
        }
    }

    protected void drawPoignee(Graphics g, int xp, int yp) {
        g.fillRect(xp + 1, yp + 1, 5, 5);
        g.setColor(Color.black);
        g.drawRect(xp, yp, 5, 5);
    }

    private void drawClose(Graphics g) {
        if (!this.collapsable) {
            return;
        }
        if (HB == 0) {
            return;
        }
        int w = HB / 2 + 1;
        int yc = -(HB + w) / 2 - 1;
        int xc = this.width - w - 3;
        g.setColor(this.inCollapsed ? Color.red : new Color(220, 220, 220));
        g.fillRect(xc, yc, w + 1, w + 1);
        g.setColor(this.inCollapsed ? Color.white : Color.red);
        g.drawLine(xc + w / 2 - 3, yc + w / 2 - 3, xc + w / 2 + 3, yc + w / 2 + 3);
        g.drawLine(xc + w / 2 - 2, yc + w / 2 - 3, xc + w / 2 + 4, yc + w / 2 + 3);
        g.drawLine(xc + w / 2 - 3, yc + w / 2 + 3, xc + w / 2 + 3, yc + w / 2 - 3);
        g.drawLine(xc + w / 2 - 2, yc + w / 2 + 3, xc + w / 2 + 4, yc + w / 2 - 3);
        this.closeButton = new Rectangle(xc, yc, w, w);
    }

    protected void drawHead(Graphics g) {
        if (!(this.movable || this.resizable || this.collapsable)) {
            return;
        }
        g.setColor(BLUE);
        g.fillRect(0, -HB, this.width, HB);
        this.drawClose(g);
    }

    private void drawBorder(Graphics g) {
        g.setColor(Color.black);
        g.drawRect(0, -HB, this.width, this.height + HB);
        g.setColor(Color.gray);
        g.drawRect(1, -HB + 1, this.width, this.height + HB);
    }

    protected void paintControlHead(Graphics g) {
    }

    private void paintControl(Graphics g) {
        if (!(this.in || this.inHead || this.flagControl)) {
            return;
        }
        g.setClip(-2, -HB - 2, this.width + 5 + 1, this.height + HB + 5 + 1);
        if (this.inShowHead || this.flagControl) {
            this.drawHead(g);
        }
        if (this.flagControl) {
            this.drawBorder(g);
            this.drawControl(g);
        }
    }

    private void paintCollapsed(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform saveTransform = g2d.getTransform();
        Shape saveClip = g2d.getClip();
        int x = this.getX();
        int y = this.getY();
        g2d.translate(x, y);
        g2d.setClip(0, 0, this.width, this.height);
        g.setColor(Color.lightGray);
        g.fillRoundRect(0, 0, 25, 25, 3, 3);
        ((Widget)((Object)this.c)).paintCollapsed(g);
        g.setColor(Color.gray);
        g.drawRoundRect(0, 0, 25, 25, 3, 3);
        g.drawRoundRect(1, 1, 23, 23, 3, 3);
        g2d.setTransform(saveTransform);
        g2d.setClip(saveClip);
    }

    public void paint(Graphics g) {
        if (this.isCollapsed) {
            this.paintCollapsed(g);
            return;
        }
        this.setSize(this.width, this.height);
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform saveTransform = g2d.getTransform();
        Composite saveComposite = g2d.getComposite();
        Shape saveClip = g2d.getClip();
        if (this.opacity != 1.0f) {
            Composite myComposite = Util.getImageComposite(this.opacity);
            g2d.setComposite(myComposite);
        }
        int x = this.getX();
        int y = this.getY();
        g2d.translate(x, y);
        g2d.setClip(0, 0, this.width, this.height);
        this.c.paint(g2d);
        if (this.opacity != 1.0f) {
            g2d.setComposite(saveComposite);
        }
        this.paintControl(g);
        this.paintControlHead(g);
        g2d.setTransform(saveTransform);
        g2d.setClip(saveClip);
    }

    private String getPosCode() {
        return this.position == 0 ? "NW" : (this.position == 16 ? "NE" : (this.position == 1 ? "SW" : "SE"));
    }

    public String toString() {
        return this.c.getClass().getCanonicalName() + " (" + this.x + "," + this.y + " " + this.width + "x" + this.height + ") pos=" + this.getPosCode();
    }
}

