/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ServerTap;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class WhereGridConstraint
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final String[] operators = new String[]{"=", "!=", "<", ">", "<=", ">=", "BETWEEN", "NOT BETWEEN", "IS", "IS NOT", "LIKE", "NOT LIKE"};
    protected static final String defaultValue = "IS NOT NULL";
    protected static final String[] andOrOptions = new String[]{"AND", "OR"};
    protected static final String DELETEBUTTON_TOOLTIP = "Click to delete this constraint";
    protected ServerTap serverTap;
    JComboBox<String> andOrOperator;
    JComponent firstGridComponent;
    JComponent secondGridComponent;
    JComponent thirdGridComponent;
    JButton removeButton;

    public WhereGridConstraint(ServerTap serverTap) {
        this.serverTap = serverTap;
        this.andOrOperator = new JComboBox<String>(andOrOptions);
        this.andOrOperator.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WhereGridConstraint.this.write();
            }
        });
        Image image = Aladin.aladin.getImagette("delete_button.png");
        this.removeButton = image == null ? new JButton("X") : new JButton(new ImageIcon(image));
        this.removeButton.setToolTipText(DELETEBUTTON_TOOLTIP);
        this.removeButton.setActionCommand("REMOVEWHERECONSTRAINT");
    }

    public WhereGridConstraint(ServerTap serverTap, JComponent firstGridComponent, JComponent secondGridComponent, JComponent thirdGridComponent) {
        this(serverTap);
        this.firstGridComponent = firstGridComponent;
        this.secondGridComponent = secondGridComponent;
        this.thirdGridComponent = thirdGridComponent;
    }

    public WhereGridConstraint(ServerTap serverTap, Vector columnNames) {
        this(serverTap);
        this.firstGridComponent = new JComboBox(columnNames);
        this.secondGridComponent = new JTextField(6);
        this.thirdGridComponent = new JComboBox<String>(operators);
    }

    public void addWhereConstraints() {
        this.setLayout(new FlowLayout(0));
        this.add(this.andOrOperator);
        this.add(this.firstGridComponent);
        this.add(this.secondGridComponent);
        this.add(this.thirdGridComponent);
        this.add(this.removeButton);
    }

    public void removeAndOr() {
        this.remove(this.andOrOperator);
    }

    public void write() {
        this.serverTap.writeQuery();
    }

    public static void removeFirstAndOrOperator(JPanel whereClausesPanel) {
        if (whereClausesPanel.getComponentCount() > 0) {
            WhereGridConstraint whereGridConstraint = (WhereGridConstraint)whereClausesPanel.getComponent(0);
            if (whereGridConstraint.andOrOperator != null) {
                whereGridConstraint.remove(whereGridConstraint.andOrOperator);
                whereGridConstraint.andOrOperator = null;
            }
        }
    }

    public abstract String getAdqlString() throws Exception;

    public JComboBox<String> getAndOrOperator() {
        return this.andOrOperator;
    }

    public void setAndOrOperator(JComboBox<String> andOrOperator) {
        this.andOrOperator = andOrOperator;
    }

    public JComponent getFirstGridComponent() {
        return this.firstGridComponent;
    }

    public void setFirstGridComponent(JComponent firstGridComponent) {
        this.firstGridComponent = firstGridComponent;
    }

    public JComponent getSecondGridComponent() {
        return this.secondGridComponent;
    }

    public void setSecondGridComponent(JComponent secondGridComponent) {
        this.secondGridComponent = secondGridComponent;
    }

    public JComponent getThirdGridComponent() {
        return this.thirdGridComponent;
    }

    public void setThirdGridComponent(JComponent thirdGridComponent) {
        this.thirdGridComponent = thirdGridComponent;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public void setRemoveButton(JButton removeButton) {
        this.removeButton = removeButton;
    }
}

