/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanHips;
import cds.aladin.PlanImage;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.aladin.stc.STCObj;
import java.awt.Color;

public class ViewSimpleStatic
extends ViewSimple {
    protected ViewSimpleStatic(Aladin aladin) {
        super(aladin);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.setDoubleBuffered(false);
    }

    protected void setViewParam(PlanHips p, int width, int height, Coord c, double radius) {
        this.pref = p;
        this.setDimension(width, height);
        p.projd.setProjCenter(c.al, c.del);
        p.setDefaultZoom(c, radius, width);
        this.setZoomXY(p.initZoom, -1.0, -1.0, true);
        Aladin.trace(3, "ImageMaker->setViewParam c=" + c + " zoom=" + this.zoom + " radius=" + Coord.getUnit(radius) + " rzoom=" + this.rzoom);
    }

    @Override
    protected PlanImage cropAreaBG(RectangleD rcrop, String label, double zoom, double resMult, boolean fullRes, boolean inStack) throws Exception {
        PlanImage pi = null;
        PlanHips pref = (PlanHips)this.pref;
        pref.projd = this.pref.projd.copy();
        if (pref.color) {
            throw new Exception("Not a HiPS fits");
        }
        if (!pref.hasOriginalPixels()) {
            throw new Exception("No fits tiles");
        }
        try {
            pi = new PlanImage(this.aladin, pref);
            pi.type = 1;
            double zoomFct = zoom * resMult;
            pi.width = pi.naxis1 = (int)Math.round(rcrop.width * zoomFct);
            pi.height = pi.naxis2 = (int)Math.round(rcrop.height * zoomFct);
            pi.initZoom = 1.0;
            pref.getCurrentBufPixels(pi, rcrop, zoomFct, resMult, fullRes);
            pi.projd.cropAndZoom(rcrop.x, rcrop.y, rcrop.width, rcrop.height, zoomFct);
            double deltaX = 0.5 * zoomFct;
            double deltaY = 0.5 * zoomFct;
            pi.projd.deltaProjXYCenter(-deltaX, -deltaY);
            pi.noCacheFromOriginalFile();
            pi.setHasSpecificCalib();
            pi.flagOk = true;
        }
        catch (Exception e) {
            if (pi != null) {
                pi.error = e.getMessage();
            }
            e.printStackTrace();
        }
        return pi;
    }

    @Override
    protected PlanImage cropAreaBG(RectangleD rcrop, STCObj stcObj, String label, double zoom, double resMult, boolean fullRes, boolean inStack) throws Exception {
        PlanImage pi = null;
        PlanHips pref = (PlanHips)this.pref;
        pref.projd = this.pref.projd.copy();
        if (pref.color) {
            throw new Exception("Not a HiPS fits");
        }
        if (!pref.hasOriginalPixels()) {
            throw new Exception("No fits tiles");
        }
        try {
            pi = new PlanImage(this.aladin, pref);
            pi.type = 1;
            double zoomFct = zoom * resMult;
            pi.width = pi.naxis1 = (int)Math.round(rcrop.width * zoomFct);
            pi.height = pi.naxis2 = (int)Math.round(rcrop.height * zoomFct);
            pi.initZoom = 1.0;
            if (this.aladin.bubbleWrapIMProcessing && this.aladin.imListener != null) {
                pref.getCurrentBufPixelsBubbleWrapped(pi, rcrop, stcObj, zoomFct, resMult, fullRes);
            } else {
                pref.getCurrentBufPixels(pi, rcrop, stcObj, zoomFct, resMult, fullRes);
            }
            pi.projd.cropAndZoom(rcrop.x, rcrop.y, rcrop.width, rcrop.height, zoomFct);
            double deltaX = 0.5 * zoomFct;
            double deltaY = 0.5 * zoomFct;
            pi.projd.deltaProjXYCenter(-deltaX, -deltaY);
            pi.noCacheFromOriginalFile();
            pi.setHasSpecificCalib();
            pi.flagOk = true;
        }
        catch (Exception e) {
            if (pi != null) {
                pi.error = e.getMessage();
            }
            e.printStackTrace();
        }
        return pi;
    }
}

