/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.SAMPUtil;
import cds.aladin.Save;
import cds.aladin.TapManager;
import cds.aladin.TapTable;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class UploadFacade
extends JFrame {
    private static final long serialVersionUID = 399753558953437543L;
    static String TABLENAMEINPUTTIP;
    static String UPLOADINVALIDTABLENAME;
    static String UPLOADDPLICATETABLENAME;
    private Aladin aladin;
    protected Map<String, String> uploadTableNameDict = new HashMap<String, String>();
    Map<String, TapTable> uploadTablesMetaData;

    protected void createChaine() {
        TABLENAMEINPUTTIP = Aladin.chaine.getString("TABLENAMEINPUTTIP");
        UPLOADINVALIDTABLENAME = Aladin.chaine.getString("UPLOADINVALIDTABLENAME");
        UPLOADDPLICATETABLENAME = Aladin.chaine.getString("UPLOADDPLICATETABLENAME");
    }

    protected UploadFacade(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.uploadTablesMetaData = new HashMap<String, TapTable>();
        this.initUploadParameters();
    }

    public Vector<String> initUploadParameters() {
        PlanCatalog planCatalog = null;
        Vector<String> canUploadVOTablesNames = new Vector<String>();
        Plan[] plan = this.aladin.calque.plan;
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].flagOk || plan[i].pcat == null || !(plan[i] instanceof PlanCatalog) || !plan[i].pcat.flagVOTable) continue;
            canUploadVOTablesNames.add(plan[i].label);
            try {
                this.allowPlanIntoUploadFacade(plan[i]);
                planCatalog = (PlanCatalog)plan[i];
                this.updateUploadGuiWithNewUpload(planCatalog);
                continue;
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                Aladin.trace(3, "Unable to parse " + plan[i].label + " data for upload");
            }
        }
        return canUploadVOTablesNames;
    }

    public void addUploadToSubmitParams(List<String> referencedUploadTables, Map<String, Object> requestParams) throws Exception {
        StringBuffer uploadParam = null;
        for (String referencedTable : referencedUploadTables) {
            if (!this.uploadTableNameDict.containsValue(referencedTable)) continue;
            String uploadFileName = null;
            for (Map.Entry<String, String> entry : this.uploadTableNameDict.entrySet()) {
                if (!entry.getValue().equals(referencedTable)) continue;
                uploadFileName = entry.getKey();
                break;
            }
            if (uploadFileName != null) {
                if (uploadParam == null) {
                    uploadParam = new StringBuffer();
                } else {
                    uploadParam.append(";");
                }
                uploadParam.append(this.getUploadParam(referencedTable, uploadFileName));
            }
            if (requestParams == null || uploadParam == null || uploadFileName == null) continue;
            requestParams.put("UPLOAD", uploadParam.toString());
            File tmpFile = this.aladin.createTempFile(SAMPUtil.sanitizeFilename(referencedTable), ".xml");
            if (tmpFile == null) {
                Aladin.trace(3, "ERROR in aladin.createTempFile for " + uploadFileName);
                throw new Exception("Unable to parse " + uploadFileName + " data for upload!");
            }
            if (this.aladin.save == null) {
                this.aladin.save = new Save(this.aladin);
            }
            Plan plan = this.aladin.calque.getPlan(uploadFileName, 1);
            PlanCatalog planCatalog = (PlanCatalog)plan;
            this.aladin.save.saveCatVOTable(tmpFile, planCatalog, false, false);
            tmpFile.deleteOnExit();
            requestParams.put(uploadFileName, tmpFile);
        }
    }

    protected String getUploadParam(String tableName, String fileName) {
        return tableName.replace("TAP_UPLOAD.", "").concat(",param:").concat(fileName);
    }

    public void uploadSettingsClickAction(JButton button) {
        JTextField userInput = new JTextField();
        JLabel tip = new JLabel(TABLENAMEINPUTTIP);
        Object[] uploadTableName = new Object[]{"Upload table name:", userInput, tip};
        int option = JOptionPane.showConfirmDialog(this.getContentPane(), uploadTableName, "Edit upload table name", 2);
        if (option == 0) {
            String tableNameConstr = userInput.getText();
            if (tableNameConstr.isEmpty() || !this.isTableNameValid(tableNameConstr)) {
                Aladin.error(this.getContentPane(), UPLOADINVALIDTABLENAME);
                return;
            }
            tableNameConstr = "TAP_UPLOAD." + TapTable.getQueryPart(tableNameConstr, false);
            if (this.tableAlreadyExists(tableNameConstr)) {
                Aladin.error(this.getContentPane(), UPLOADDPLICATETABLENAME);
                return;
            }
            String fileName = this.getCorrespondingUploadTableName(button);
            String oldTableName = this.uploadTableNameDict.get(fileName);
            this.uploadTableNameDict.put(fileName, tableNameConstr);
            TapManager tapManager = TapManager.getInstance(this.aladin);
            tapManager.changeUploadTableName(oldTableName, tableNameConstr, this.uploadTablesMetaData);
        }
    }

    public String getCorrespondingUploadTableName(JButton button) {
        String result = null;
        JPanel wrapper = (JPanel)SwingUtilities.getAncestorOfClass(JPanel.class, button);
        if (wrapper != null) {
            block0: for (Component component : wrapper.getComponents()) {
                JComboBox tablesGui;
                String tableName;
                if (!(component instanceof JComboBox) || !component.getName().equals("table") || !this.uploadTableNameDict.containsValue(tableName = (String)(tablesGui = (JComboBox)component).getSelectedItem())) continue;
                for (Map.Entry<String, String> entry : this.uploadTableNameDict.entrySet()) {
                    if (!entry.getValue().equals(tableName)) continue;
                    result = entry.getKey();
                    break block0;
                }
            }
        }
        return result;
    }

    public void allowPlanIntoUploadFacade(Plan plan) throws Exception {
        if (!(plan instanceof PlanCatalog)) {
            throw new Exception("Cannot parse " + plan.label + " data for upload. Please select a catalog!");
        }
        String uploadTableName = this.generateSuffix();
        this.uploadTableNameDict.put(plan.label, uploadTableName);
    }

    public void updateUploadGuiWithNewUpload(PlanCatalog planCatalog) {
        if (this.uploadTableNameDict.containsKey(planCatalog.label)) {
            String uploadTableName = this.uploadTableNameDict.get(planCatalog.label);
            TapManager.getInstance(this.aladin).initialiseUploadFacadeFromAladinPlan(planCatalog, uploadTableName);
        }
    }

    public void deleteAvailableUploadTable(Plan planInDeletion) {
        if (planInDeletion.pcat != null && planInDeletion.pcat.flagVOTable) {
            TapManager tapManager = TapManager.getInstance(this.aladin);
            String tableToDiscard = this.uploadTableNameDict.get(planInDeletion.label);
            if (this.uploadTablesMetaData != null && !this.uploadTablesMetaData.isEmpty()) {
                this.uploadTablesMetaData.remove(tableToDiscard);
                tapManager.uploadTablesModel.removeElement(tableToDiscard);
            }
            this.uploadTableNameDict.remove(planInDeletion.label);
        }
    }

    public boolean tableAlreadyExists(String input) {
        return this.uploadTableNameDict.containsValue(input);
    }

    public String getUploadTableName(String planeName) {
        String result = null;
        if (this.uploadTableNameDict.containsKey(planeName)) {
            result = this.uploadTableNameDict.get(planeName);
        }
        return result;
    }

    public boolean isTableNameValid(String input) {
        boolean result = false;
        Pattern regex = Pattern.compile("[^A-Za-z0-9]");
        Matcher matcher = regex.matcher(input);
        if (!matcher.find() && (matcher = (regex = Pattern.compile("[A-Za-z]")).matcher(input)).find()) {
            result = true;
        }
        return result;
    }

    public String generateUploadTableName(String prefix) {
        String uploadTableName = prefix + new Random().nextInt(31);
        if (!this.tableAlreadyExists(uploadTableName)) {
            return uploadTableName;
        }
        return this.generateUploadTableName(prefix);
    }

    private String generateSuffix() {
        String uploadTableSuffix = "AladinTable" + new Random().nextInt(31);
        String uploadTableName = "TAP_UPLOAD.".concat(uploadTableSuffix);
        if (!this.tableAlreadyExists(uploadTableName)) {
            return uploadTableName;
        }
        return this.generateSuffix();
    }
}

