/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.Coord;
import cds.aladin.Directory;
import cds.aladin.Glu;
import cds.aladin.GluApp;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanMoc;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.ServerMocQuery;
import cds.aladin.ServerXmatch;
import cds.aladin.TapManager;
import cds.aladin.Tok;
import cds.aladin.TreeObj;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.aladin.prop.Propable;
import cds.hipsgen.Context;
import cds.moc.Healpix;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.mocmulti.MocItem2;
import cds.mocmulti.MultiMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TreeObjDir
extends TreeObj
implements Propable {
    public static final int DEFAULTRADIUS = 3;
    public static final String DIRECT = "DIRECT/";
    public String internalId;
    private String url;
    public String description;
    public String verboseDescr;
    public String ack;
    public String copyright;
    public String copyrightUrl;
    public String hpxParam;
    public String version;
    public String aladinProfile;
    private String skyFraction;
    public String aladinLabel;
    public int minOrder;
    public int maxOrder;
    private boolean useCache;
    private boolean cubefreq;
    private boolean cubeseq;
    private boolean cube;
    private boolean color;
    private boolean inFits;
    private boolean inJPEG;
    private boolean inPNG;
    private boolean truePixels;
    private boolean truePixelsSet;
    private boolean cat;
    private boolean progen;
    private boolean map;
    private boolean moc;
    public int cubeDepth;
    public int cubeFirstFrame;
    public int frame;
    public Coord target;
    public double radius;
    public int nside;
    public boolean local;
    public Image previewImg;
    public Image previewImgHips2Fits;
    public boolean previewError;
    public String previewUrlHips2Fits;
    public boolean previewErrorHips2Fits;
    public boolean previewLoading;
    protected MyProperties prop;
    private boolean scanning;
    private MyInputStream inScan;
    static final String DMAPGLUHIPS = "getDMapHiPS";
    public static String BROWSING_KEY = "Browsing";
    public static String[] BROWSING = new String[]{"outreach/SIA/SSA only", "any catalog", "never"};
    public static String BROWSING_TITLE;
    public static String BROWSING_HELP;
    public static String XMATCH_RADIUS_KEY;
    public static String XMATCH_RADIUS_TITLE;
    public static String XMATCH_RADIUS_HELP;
    public static String XMATCH_SELECTION_KEY;
    public static String[] XMATCH_SELECTION;
    public static String XMATCH_SELECTION_TITLE;
    public static String XMATCH_SELECTION_HELP;
    public static String HIPS_FORMAT_KEY;
    public static String[] HIPS_FORMAT;
    public static String HIPS_FORMAT_TITLE;
    public static String HIPS_FORMAT_HELP;
    public static String CAT_LIMIT_KEY;
    public static String[] CAT_LIMIT;
    public static String CAT_LIMIT_TITLE;
    public static String CAT_LIMIT_HELP;
    public static String CAT_COLUMNS_KEY;
    public static String[] CAT_COLUMNS;
    public static String CAT_COLUMNS_TITLE;
    public static String CAT_COLUMNS_HELP;

    protected String getVizieRLongTitre() {
        String titre = this.description;
        if (!this.internalId.startsWith("CDS/")) {
            return titre;
        }
        if (this.internalId.startsWith("CDS/P") || this.internalId.startsWith("CDS/C") || this.internalId.startsWith("CDS/Simbad")) {
            return titre;
        }
        if (this.prop.getFirst("client_category") == null) {
            return titre;
        }
        String tableTitle = this.prop.getFirst("obs_title");
        String tableLabel = this.prop.getFirst("obs_label");
        String catalogTitle = this.prop.getFirst("obs_collection");
        String prefix = this.prop.getFirst("obs_collection_label");
        Directory cfr_ignored_0 = this.aladin.directory;
        return Directory.addLabelPrefix(prefix, (catalogTitle != null ? catalogTitle + " - " + tableTitle : tableTitle) + (tableLabel != null ? " (" + tableLabel + ")" : ""));
    }

    private void adjustVizieR() {
        if (!this.internalId.startsWith("CDS/")) {
            return;
        }
        if (this.internalId.startsWith("CDS/P") || this.internalId.startsWith("CDS/C") || this.internalId.startsWith("CDS/Simbad")) {
            return;
        }
        if (this.prop.getFirst("client_category") == null) {
            return;
        }
        Directory dir = this.aladin.directory;
        if (!dir.hasMultiple(Directory.getCatParent(this.internalId))) {
            String catalogTitle = this.prop.getFirst("obs_collection");
            if (catalogTitle != null) {
                if (catalogTitle.indexOf(32) < 0) {
                    return;
                }
                this.label = catalogTitle;
            }
            String prefix = this.prop.getFirst("obs_collection_label");
            this.label = Directory.addLabelPrefix(prefix, this.label);
        } else {
            String suffixe = this.prop.getFirst("obs_label");
            if (suffixe != null && this.label.indexOf("(" + suffixe + ")") < 0) {
                this.label = this.label + " (" + suffixe + ")";
            }
        }
        this.aladinLabel = this.label = Directory.cleanLatexMacro(this.label);
    }

    public void checkHiPSProp(MyProperties prop) throws Exception {
        String id = MultiMoc.getID(prop);
        if (id == null) {
            throw new Exception("Not an HiPS (no ID)");
        }
    }

    public TreeObjDir(Aladin aladin, String pathOrUrl) throws Exception {
        this(aladin, pathOrUrl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeObjDir(Aladin aladin, String pathOrUrl, boolean flagCheck) throws Exception {
        String s;
        MyProperties prop;
        block93: {
            String strFrame;
            this.version = "";
            this.minOrder = -1;
            this.maxOrder = -1;
            this.useCache = true;
            this.cube = false;
            this.color = false;
            this.inFits = false;
            this.inJPEG = false;
            this.inPNG = false;
            this.truePixels = false;
            this.truePixelsSet = false;
            this.cat = false;
            this.progen = false;
            this.map = false;
            this.moc = false;
            this.cubeDepth = -1;
            this.cubeFirstFrame = 0;
            this.frame = 3;
            this.target = null;
            this.radius = -1.0;
            this.nside = -1;
            this.local = false;
            this.previewImg = null;
            this.previewImgHips2Fits = null;
            this.previewError = false;
            this.previewUrlHips2Fits = null;
            this.previewErrorHips2Fits = false;
            this.previewLoading = false;
            this.prop = null;
            this.scanning = false;
            this.inScan = null;
            this.aladin = aladin;
            this.local = !pathOrUrl.startsWith("http:") && !pathOrUrl.startsWith("https:") && !pathOrUrl.startsWith("ftp:");
            boolean bl = this.progen = pathOrUrl.endsWith("HpxFinder") || pathOrUrl.endsWith("HpxFinder/");
            if (this.progen) {
                this.maxOrder = 15;
            }
            prop = new MyProperties();
            InputStreamReader in = null;
            try {
                if (!this.local) {
                    if (pathOrUrl.indexOf(63) > 0) {
                        throw new Exception("Probably not an HiPS URL");
                    }
                    in = new InputStreamReader((InputStream)Util.openStream(pathOrUrl + "/" + "properties"), "UTF-8");
                } else {
                    in = new InputStreamReader((InputStream)Util.openAnyStream(Util.concatDir(pathOrUrl, "properties")), "UTF-8");
                }
                prop.load(in);
                this.checkHiPSProp(prop);
            }
            catch (Exception e) {
                if (flagCheck && !this.progen) {
                    throw e;
                }
                Aladin.trace(3, "No properties file found => auto discovery...");
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (this.progen && flagCheck) {
                InputStreamReader meta = null;
                try {
                    meta = !this.local ? new InputStreamReader((InputStream)Util.openStream(pathOrUrl + "/" + "metadata.xml"), "UTF-8") : new InputStreamReader((InputStream)Util.openAnyStream(Util.concatDir(pathOrUrl, "metadata.xml")), "UTF-8");
                }
                catch (Exception e) {
                    if (flagCheck) {
                        throw e;
                    }
                    Aladin.trace(3, "No metadata.xml file found => auto discovery...");
                }
                finally {
                    if (meta != null) {
                        try {
                            meta.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            if ((strFrame = prop.getProperty("hips_frame")) == null) {
                strFrame = prop.getProperty("coordsys");
            }
            if (strFrame == null) {
                strFrame = "galactic";
            }
            if (strFrame.equals("equatorial") || strFrame.equals("C") || strFrame.equals("Q")) {
                this.frame = 0;
            } else if (strFrame.equals("ecliptic") || strFrame.equals("E")) {
                this.frame = 2;
            } else if (strFrame.equals("galactic") || strFrame.equals("G")) {
                this.frame = 3;
            }
            this.url = pathOrUrl;
            s = prop.getProperty("obs_collection");
            if (s == null) {
                s = prop.getProperty("label");
            }
            if (s != null) {
                this.label = s;
            } else {
                int c = this.local ? (int)Util.FS.charAt(0) : 47;
                int end = pathOrUrl.length();
                int offset = pathOrUrl.lastIndexOf(c);
                if (offset == end - 1 && offset > 0) {
                    end = offset;
                    offset = pathOrUrl.lastIndexOf(c, end - 1);
                }
                this.label = pathOrUrl.substring(offset + 1, end);
            }
            this.id = this.internalId = DIRECT + System.currentTimeMillis() / 1000L + "/" + MultiMoc.getID(prop);
            s = prop.getProperty("version");
            if (s != null) {
                this.version = s;
            }
            this.description = prop.getProperty("obs_title");
            if (this.description == null) {
                this.description = prop.getProperty("description");
            }
            if (this.description == null) {
                this.description = prop.getProperty("obs_collection");
            }
            this.verboseDescr = prop.getProperty("obs_description");
            if (this.verboseDescr == null) {
                this.verboseDescr = prop.getProperty("verboseDescription");
            }
            this.copyright = prop.getProperty("obs_copyright");
            if (this.copyright == null) {
                this.copyright = prop.getProperty("copyright");
            }
            this.copyrightUrl = prop.getProperty("obs_copyright_url");
            if (this.copyrightUrl == null) {
                this.copyrightUrl = prop.getProperty("copyrightUrl");
            }
            this.useCache = !this.local && Boolean.parseBoolean(prop.getProperty("useCache", "True"));
            this.skyFraction = prop.getProperty("moc_sky_fraction");
            this.adjustVizieR();
            s = prop.getProperty("hips_initial_ra");
            if (s != null) {
                String s1 = prop.getProperty("hips_initial_dec");
                s = s1 != null ? s + " " + s1 : null;
            }
            if (s == null) {
                s = prop.getProperty("target");
            }
            if (s == null) {
                this.target = null;
            } else {
                try {
                    this.target = new Coord(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "HiPS target error for " + this.id + " [" + s + "]!");
                    this.target = null;
                }
            }
            double div2 = 2.0;
            s = prop.getProperty("hips_initial_fov");
            if (s == null) {
                s = prop.getProperty("targetRadius");
                div2 = 1.0;
            }
            if (s == null) {
                this.radius = -1.0;
            } else {
                try {
                    this.radius = Server.getAngleInArcmin(s, 8) / 60.0 / div2;
                }
                catch (Exception e) {
                    Aladin.trace(3, "HiPS radius error for " + this.id + " [" + s + "]!");
                    this.radius = -1.0;
                }
            }
            s = prop.getProperty("hips_tile_width");
            if (s == null) {
                s = prop.getProperty("nside");
            }
            if (s != null) {
                try {
                    this.nside = Integer.parseInt(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "NSIDE number not parsable !");
                    this.nside = -1;
                }
            }
            if ((s = prop.getProperty("hips_order")) == null) {
                s = prop.getProperty("maxOrder");
            }
            try {
                this.maxOrder = new Integer(s);
            }
            catch (Exception e) {
                this.maxOrder = this.getMaxOrderByPath(pathOrUrl, this.local);
                if (this.maxOrder != -1) break block93;
                Aladin.trace(3, "No maxOrder found (even with scanning dir.) => assuming 11");
                this.maxOrder = 11;
            }
        }
        String s1 = prop.getProperty("dataproduct_type");
        if (s1 != null) {
            this.cube = s1.indexOf("cube") >= 0;
            this.cubefreq = s1.indexOf("cubefreq") >= 0 || s1.indexOf("spectral-cube") >= 0;
            this.cubeseq = s1.indexOf("sequence-cube") >= 0;
        } else {
            try {
                this.cube = new Boolean(prop.getProperty("isCube"));
            }
            catch (Exception e) {
                this.cube = false;
            }
        }
        if (this.cube) {
            s = prop.getProperty("hips_cube_depth");
            if (s == null) {
                s = prop.getProperty("cubeDepth");
            }
            if (s != null) {
                try {
                    this.cubeDepth = Integer.parseInt(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "CubeDepth syntax error [" + s + "] => trying autodetection");
                    this.cubeDepth = -1;
                }
            }
            if ((s = prop.getProperty("hips_cube_firstframe")) == null) {
                s = prop.getProperty("cubeFirstFrame");
            }
            if (s != null) {
                try {
                    this.cubeFirstFrame = Integer.parseInt(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "cubeFirstFrame syntax error [" + s + "] => assuming frame 0");
                    this.cubeFirstFrame = -1;
                }
            }
        }
        this.cat = (s = prop.getProperty("dataproduct_type")) != null ? s.indexOf("catalog") >= 0 : ((s = prop.getProperty("isCatalog")) != null ? new Boolean(s).booleanValue() : this.getFormatByPath(pathOrUrl, this.local, 2));
        String keyColor = prop.getProperty("dataproduct_subtype");
        if (keyColor != null) {
            this.color = keyColor.indexOf("color") >= 0;
        } else {
            keyColor = prop.getProperty("isColor");
            if (keyColor == null) {
                keyColor = prop.getProperty("isColor");
            }
            if (keyColor == null) {
                keyColor = prop.getProperty("isColored");
            }
            if (keyColor != null) {
                this.color = new Boolean(keyColor);
            }
        }
        if (!this.cat && !this.progen) {
            String format = prop.getProperty("hips_tile_format");
            if (format == null) {
                format = prop.getProperty("format");
            }
            if (format != null) {
                int a = Util.indexOfIgnoreCase(format, "fit");
                this.inFits = a >= 0;
                int b = Util.indexOfIgnoreCase(format, "jpeg");
                this.inJPEG = b >= 0 || (b = Util.indexOfIgnoreCase(format, "jpg")) >= 0;
                b = Util.indexOfIgnoreCase(format, "png");
                this.inPNG = b >= 0;
                this.truePixels = this.inFits && a < b;
            } else {
                this.inFits = this.getFormatByPath(pathOrUrl, this.local, 0);
                this.inJPEG = this.getFormatByPath(pathOrUrl, this.local, 1);
                this.inPNG = this.getFormatByPath(pathOrUrl, this.local, 3);
                boolean bl = this.truePixels = this.local && this.inFits || this.local || !this.inJPEG && !this.inPNG;
            }
            if (keyColor == null) {
                this.color = this.getIsColorByPath(pathOrUrl, this.local);
            }
            if (this.color) {
                this.truePixels = false;
            }
        }
        if (this.color && !this.inJPEG && !this.inPNG) {
            this.inJPEG = true;
        }
        Aladin.trace(4, this.toString1());
    }

    private String createLabel(String id, boolean cat) {
        String label = id;
        int p1 = id.indexOf(47);
        int p2 = id.indexOf(47, p1 + 1);
        if (cat) {
            if (p1 > 0) {
                label = id.substring(p1 + 1);
            }
        } else if (p2 > 0) {
            label = id.substring(p2 + 1);
        }
        return label.replace('/', ' ');
    }

    public TreeObjDir(Aladin aladin, String id, MyProperties prop) {
        this.version = "";
        this.minOrder = -1;
        this.maxOrder = -1;
        this.useCache = true;
        this.cube = false;
        this.color = false;
        this.inFits = false;
        this.inJPEG = false;
        this.inPNG = false;
        this.truePixels = false;
        this.truePixelsSet = false;
        this.cat = false;
        this.progen = false;
        this.map = false;
        this.moc = false;
        this.cubeDepth = -1;
        this.cubeFirstFrame = 0;
        this.frame = 3;
        this.target = null;
        this.radius = -1.0;
        this.nside = -1;
        this.local = false;
        this.previewImg = null;
        this.previewImgHips2Fits = null;
        this.previewError = false;
        this.previewUrlHips2Fits = null;
        this.previewErrorHips2Fits = false;
        this.previewLoading = false;
        this.prop = null;
        this.scanning = false;
        this.inScan = null;
        this.aladin = aladin;
        this.id = this.internalId = id;
        this.prop = prop;
        String s = prop.getProperty("dataproduct_type");
        if (s != null) {
            if (s.indexOf("catalog") >= 0) {
                this.cat = true;
            }
            if (s.indexOf("cubefreq") >= 0 || s.indexOf("spectral-cube") >= 0) {
                this.cubefreq = true;
            }
            if (s.indexOf("sequence-cube") >= 0) {
                this.cubeseq = true;
            }
            if (s.indexOf("cube") >= 0) {
                this.cube = true;
            }
            if (s.indexOf("progen") >= 0) {
                this.progen = true;
            }
        } else {
            boolean bl = this.cat = prop.getProperty("cs_service_url") != null;
        }
        this.frame = (s = prop.getProperty("hips_frame")) != null ? Context.getFrameVal(s) : (this.cat ? 0 : 3);
        s = prop.getProperty("obs_title");
        if (s == null) {
            s = prop.getProperty("obs_collection");
        }
        this.label = s != null ? s : this.createLabel(id, this.cat);
        this.aladinLabel = this.label;
        this.adjustVizieR();
        this.setTri();
        this.setPath();
        this.description = prop.getProperty("obs_title");
        if (this.description == null) {
            this.description = prop.getProperty("obs_collection");
        }
        this.verboseDescr = prop.getProperty("obs_description");
        this.copyright = prop.getProperty("obs_copyright");
        this.copyrightUrl = prop.getProperty("obs_copyright_url");
        this.skyFraction = prop.getProperty("moc_sky_fraction");
        s = prop.getProperty("hips_initial_ra");
        if (s != null) {
            String s1 = prop.getProperty("hips_initial_dec");
            s = s1 != null ? s + " " + s1 : null;
        }
        if (s == null) {
            this.target = null;
        } else {
            try {
                this.target = new Coord(s);
            }
            catch (Exception e) {
                Aladin.trace(3, "HiPS target error for " + id + " [" + s + "]!");
                this.target = null;
            }
        }
        double div2 = 2.0;
        s = prop.getProperty("hips_initial_fov");
        if (s == null) {
            this.radius = -1.0;
        } else {
            try {
                this.radius = Server.getAngleInArcmin(s, 8) / 60.0 / div2;
                if (this.radius > 180.0) {
                    this.radius = 180.0;
                }
            }
            catch (Exception e) {
                Aladin.trace(3, "HiPS radius error for " + id + " [" + s + "]!");
                this.radius = -1.0;
            }
        }
        s = prop.getProperty("hips_tile_width");
        if (s != null) {
            try {
                this.nside = Integer.parseInt(s);
            }
            catch (Exception e) {
                Aladin.trace(3, "NSIDE number not parsable !");
                this.nside = -1;
            }
        }
        s = prop.getProperty("hips_order");
        try {
            this.maxOrder = new Integer(s);
        }
        catch (Exception e) {
            this.maxOrder = 11;
        }
        if (this.cube) {
            s = prop.getProperty("hips_cube_depth");
            if (s != null) {
                try {
                    this.cubeDepth = Integer.parseInt(s);
                }
                catch (Exception e) {
                    this.cubeDepth = -1;
                }
            }
            if ((s = prop.getProperty("hips_cube_firstframe")) != null) {
                try {
                    this.cubeFirstFrame = Integer.parseInt(s);
                }
                catch (Exception e) {
                    this.cubeFirstFrame = -1;
                }
            }
        }
        if ((s = prop.getProperty("dataproduct_subtype")) == null) {
            s = prop.getProperty("isColor");
            if (s == null) {
                s = prop.getProperty("isColor");
            }
            if (s != null) {
                s = "color";
            }
        }
        if (s != null) {
            boolean bl = this.color = s.indexOf("color") >= 0;
        }
        if (!this.cat && !this.progen) {
            String format = prop.getProperty("hips_tile_format");
            if (format != null) {
                int a = Util.indexOfIgnoreCase(format, "fit");
                this.inFits = a >= 0;
                int b = Util.indexOfIgnoreCase(format, "jpeg");
                this.inJPEG = b >= 0 || (b = Util.indexOfIgnoreCase(format, "jpg")) >= 0;
                b = Util.indexOfIgnoreCase(format, "png");
                this.inPNG = b >= 0;
                boolean bl = this.truePixels = this.inFits && a < b;
            }
            if (this.color) {
                this.truePixels = false;
            }
        }
        if (this.color && !this.inJPEG && !this.inPNG) {
            this.inJPEG = true;
        }
    }

    protected void setTri() {
        this.ordre = this.prop.getProperty("client_sort_key");
        String ordre2 = this.prop.getProperty("internal_sort_key");
        if (ordre2 != null) {
            String string = this.ordre = this.ordre == null ? ordre2 : ordre2 + "//" + this.ordre;
        }
        if (this.ordre == null) {
            this.ordre = "Z";
        }
    }

    protected void setPath() {
        String s = this.prop.getProperty("internal_category");
        if (!this.aladin.directory.isGlobalSorted()) {
            if (s == null) {
                s = this.prop.getProperty("client_category");
            }
            if (s == null) {
                s = "Others";
            }
        }
        this.path = s == null ? this.label.replace("/", "\\/") : s + "/" + this.label.replace("/", "\\/");
    }

    public TreeObjDir(Aladin aladin, String actionName, String id, String aladinMenuNumber, String url, String aladinLabel, String description, String verboseDescr, String ack, String aladinProfile, String copyright, String copyrightUrl, String path, String aladinHpxParam, String skyFraction) {
        super(aladin, actionName, aladinMenuNumber, aladinLabel, path);
        char c;
        this.version = "";
        this.minOrder = -1;
        this.maxOrder = -1;
        this.useCache = true;
        this.cube = false;
        this.color = false;
        this.inFits = false;
        this.inJPEG = false;
        this.inPNG = false;
        this.truePixels = false;
        this.truePixelsSet = false;
        this.cat = false;
        this.progen = false;
        this.map = false;
        this.moc = false;
        this.cubeDepth = -1;
        this.cubeFirstFrame = 0;
        this.frame = 3;
        this.target = null;
        this.radius = -1.0;
        this.nside = -1;
        this.local = false;
        this.previewImg = null;
        this.previewImgHips2Fits = null;
        this.previewError = false;
        this.previewUrlHips2Fits = null;
        this.previewErrorHips2Fits = false;
        this.previewLoading = false;
        this.prop = null;
        this.scanning = false;
        this.inScan = null;
        this.aladinLabel = aladinLabel;
        this.url = url;
        this.description = description;
        this.verboseDescr = verboseDescr;
        this.ack = ack;
        this.copyright = copyright;
        this.copyrightUrl = copyrightUrl;
        this.hpxParam = aladinHpxParam;
        this.aladinProfile = aladinProfile;
        this.internalId = id;
        this.skyFraction = skyFraction;
        if (this.url != null && ((c = this.url.charAt(this.url.length() - 1)) == '/' || c == '\\')) {
            this.url = this.url.substring(0, this.url.length() - 1);
        }
        boolean first = true;
        if (this.hpxParam != null) {
            StringTokenizer st = new StringTokenizer(this.hpxParam);
            try {
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        int n = Integer.parseInt(s);
                        if (this.maxOrder != -1) {
                            this.minOrder = this.maxOrder;
                            this.maxOrder = n;
                        } else {
                            this.maxOrder = n;
                        }
                    }
                    catch (Exception n) {
                        // empty catch block
                    }
                    if (Util.indexOfIgnoreCase(s, "nocache") >= 0) {
                        this.useCache = false;
                    }
                    if (Util.indexOfIgnoreCase(s, "color") >= 0) {
                        this.color = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "cubefreq") >= 0 || Util.indexOfIgnoreCase(skyFraction, "spectral-cube") >= 0) {
                        this.cubefreq = true;
                    }
                    if (Util.indexOfIgnoreCase(skyFraction, "sequence-cube") >= 0) {
                        this.cubeseq = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "cube") >= 0) {
                        this.cube = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "fits") >= 0) {
                        this.inFits = true;
                        if (first) {
                            first = false;
                            this.truePixels = true;
                        }
                    }
                    if (Util.indexOfIgnoreCase(s, "jpeg") >= 0 || Util.indexOfIgnoreCase(s, "jpg") >= 0) {
                        this.inJPEG = true;
                        if (first) {
                            first = false;
                            this.truePixels = false;
                        }
                    }
                    if (Util.indexOfIgnoreCase(s, "png") >= 0) {
                        this.inPNG = true;
                        if (first) {
                            first = false;
                            this.truePixels = false;
                        }
                    }
                    if (Util.indexOfIgnoreCase(s, "gal") >= 0) {
                        this.frame = 3;
                    }
                    if (Util.indexOfIgnoreCase(s, "ecl") >= 0) {
                        this.frame = 2;
                    }
                    if (Util.indexOfIgnoreCase(s, "equ") >= 0) {
                        this.frame = 0;
                    }
                    if (Util.indexOfIgnoreCase(s, "cat") >= 0) {
                        this.cat = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "progen") >= 0) {
                        this.progen = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "map") >= 0) {
                        this.map = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "moc") >= 0) {
                        this.moc = true;
                    }
                    if (s.charAt(0) != 'v') continue;
                    try {
                        double n = Double.parseDouble(s.substring(1));
                        this.version = "-" + s;
                    }
                    catch (Exception exception) {}
                }
                if (this.minOrder == -1) {
                    this.minOrder = 2;
                }
                if (this.maxOrder == -1) {
                    this.maxOrder = 8;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (url != null && !url.startsWith("http") && !url.startsWith("ftp")) {
            this.useCache = false;
        }
        if (this.color && !this.inJPEG && !this.inPNG) {
            this.inJPEG = true;
        }
    }

    protected boolean isHiPS() {
        if (this.prop == null) {
            return true;
        }
        return this.prop.getProperty("hips_service_url") != null;
    }

    protected String getProgenitorsUrl() {
        if (this.prop == null) {
            return null;
        }
        return this.prop.getProperty("hips_progenitor_url");
    }

    protected String getSpaceCoverage() {
        if (this.prop == null) {
            return null;
        }
        return Plan.getCoverageSpace(this.prop.getFirst("moc_sky_fraction"));
    }

    protected String getEnergy() {
        if (this.prop == null) {
            return null;
        }
        return Plan.getCoverageEnergy(this.prop.getFirst("em_min"), this.prop.getFirst("em_max"));
    }

    protected String getPeriod() {
        if (this.prop == null) {
            return null;
        }
        return Plan.getCoverageTime(this.prop.getFirst("t_min"), this.prop.getFirst("t_max"));
    }

    protected String getProperty(String key) {
        if (this.prop == null) {
            return null;
        }
        return this.prop.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getIsColorByPath(String path, boolean local) {
        boolean bl;
        String ext = this.inPNG ? "png" : "jpg";
        MyInputStream in = null;
        try {
            if (local) {
                boolean bl2 = Util.isJPEGColored(Context.findOneNpixFile(path, ext));
                return bl2;
            }
            in = new MyInputStream(Util.openStream(path + "/Norder3/Allsky." + ext));
            byte[] buf = in.readFully();
            bl = Util.isColoredImage(buf);
        }
        catch (Exception e) {
            Aladin.trace(3, "Allsky." + ext + " not found => assume B&W survey");
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private boolean getFormatByPath(String path, boolean local, int fmt) {
        String ext = fmt == 0 ? "fits" : (fmt == 1 ? "jpg" : (fmt == 3 ? "png" : "xml"));
        return local && Context.findOneNpixFile(path, ext) != null || !local && Util.isUrlResponding(path + "/Norder3/Allsky." + ext);
    }

    private int getMaxOrderByPath(String urlOrPath, boolean local) {
        for (int n = 25; n >= 1; --n) {
            if ((!local || !new File(urlOrPath + Util.FS + "Norder" + n).isDirectory()) && (local || !Util.isUrlResponding(urlOrPath + "/Norder" + n))) continue;
            return n;
        }
        return -1;
    }

    @Override
    protected JPanel createPanel() {
        JLabel lab = new JLabel(this.label);
        lab.setBackground(background);
        this.gc = new GridBagConstraints();
        this.gc.fill = 3;
        this.gc.anchor = 10;
        this.gc.gridx = -1;
        this.gc.insets = new Insets(0, 0, 0, 5);
        this.gb = new GridBagLayout();
        JPanel panel = new JPanel(this.gb);
        panel.setBackground(background);
        this.gb.setConstraints(lab, this.gc);
        panel.add(lab);
        return panel;
    }

    public String toString1() {
        Coord c = this.getTarget();
        double r = this.getRadius();
        return "GluSky [" + this.id + "]" + (this.isCatalog() ? " catalog" : (this.isProgen() ? " progen" : (this.isMap() ? " fitsMap" : " survey"))) + " maxOrder:" + this.getMaxOrder() + (this.getLosangeOrder() >= 0 ? " cellOrder:" + this.getLosangeOrder() : "") + (!this.isCatalog() && this.isColored() ? " colored" : " B&W") + (!this.isCube() ? "" : " cube" + (this.cubeDepth == -1 ? "" : "/" + this.cubeDepth + (this.cubeFirstFrame == 0 ? "" : "/" + this.cubeFirstFrame))) + (!this.isFits() ? "" : (this.isTruePixels() ? " *inFits*" : " inFits")) + (!this.isJPEG() ? "" : (this.isTruePixels() ? " inJPEG" : " *inJPEG*")) + (!this.isPNG() ? "" : (this.isTruePixels() ? " inPNG" : " *inPNG*")) + (this.loadMocNow() ? " withMoc" : "") + (this.useCache() ? " cache" : " nocache") + " " + Localisation.getFrameName(this.getFrame()) + (this.isLocalDef() ? " localDef" : "") + (this.isLocal() ? " local" : "") + (c != null ? " target:" + c : "") + (r != -1.0 ? "/" + Coord.getUnit(r) : "") + " \"" + this.label + "\" => " + this.getUrl();
    }

    protected boolean isLocalDef() {
        return this.aladinProfile != null && this.aladinProfile.indexOf("localdef") >= 0;
    }

    protected boolean isMap() {
        return this.map;
    }

    protected boolean isCatalog() {
        return this.cat;
    }

    protected boolean hasVizieRAssocData() {
        if (!this.isCDSCatalog() || this.prop == null) {
            return false;
        }
        String s = this.prop.get("associated_dataproduct_type");
        return s != null;
    }

    protected boolean isVizierTimeOnly() {
        if (!this.isCDSCatalog() || this.prop == null) {
            return false;
        }
        if (this.prop == null) {
            return false;
        }
        String t = this.prop.get("moc_type");
        return t != null && t.equals("tmoc");
    }

    protected boolean isSimbadLive() {
        return Aladin.CDS && this.internalId.equals("CDS/Simbad");
    }

    protected boolean isSimbad() {
        return this.internalId.equals("CDS/Simbad");
    }

    protected boolean isCDSCatalog() {
        return this.cat && this.internalId.startsWith("CDS/");
    }

    protected boolean hasSIA() {
        return this.hasSIAv1() || this.hasSIAv2();
    }

    protected boolean hasSIAv1() {
        return this.prop != null && (this.prop.get("sia_service_url") != null || this.prop.get("sia_glutag") != null);
    }

    protected boolean hasSIAv2() {
        return this.prop != null && (this.prop.get("sia2_service_url") != null || this.prop.get("sia2_glutag") != null);
    }

    protected boolean hasSSA() {
        return this.prop != null && (this.prop.get("ssa_service_url") != null || this.prop.get("ssa_glutag") != null);
    }

    protected boolean hasHips() {
        return this.prop != null && (this.prop.get("hips_service_url") != null || this.prop.get("hips_service_path") != null);
    }

    protected boolean hasLinks() {
        return this.prop != null && this.prop.get("client_link") != null;
    }

    protected boolean isHipsCat() {
        if (!this.hasHips()) {
            return false;
        }
        String s = this.prop.get("dataproduct_type");
        return s != null && s.indexOf("catalog") >= 0;
    }

    protected boolean hasTAP() {
        if (this.prop == null) {
            return false;
        }
        return this.prop.get("tap_glutag") != null || this.prop.get("tap_service_url") != null;
    }

    protected boolean hasCustom() {
        return this.prop != null && (this.prop.get("glutag") != null || this.prop.get("cs_glutag") != null || this.prop.get("tap_glutag") != null || this.prop.get("sia_glutag") != null || this.prop.get("sia2_glutag") != null || this.prop.get("ssa_glutag") != null);
    }

    protected boolean hasCS() {
        return this.isCDSCatalog() || this.prop != null && this.prop.get("cs_service_url") != null;
    }

    protected boolean hasGlobalAccess() {
        return this.prop != null && this.prop.get("access_url") != null;
    }

    protected boolean hasAllAccess() {
        if (!this.isCDSCatalog()) {
            return false;
        }
        try {
            long nbRows = Long.parseLong(this.getProperty("nb_rows"));
            return nbRows > -1L && nbRows < 20000L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean hasPreview() {
        return this.isCDSCatalog() && !this.isVizierTimeOnly() || this.isHiPS();
    }

    protected String getPreviewUrl() {
        if (this.isCDSCatalog() && !this.isVizierTimeOnly()) {
            String s;
            if (this.internalId.startsWith("CDS/Simbad")) {
                s = "simbad";
            } else {
                s = Util.getSubpath(this.internalId, 1, -1);
                s = "vizier/" + s.replace("/", "_");
            }
            return this.aladin.glu.getURL("Vignettes.CDS", s) + "";
        }
        if (this.isHiPS()) {
            return this.getUrl() + "/preview.jpg";
        }
        return null;
    }

    protected boolean hasInfo() {
        return this.prop != null && (this.prop.get("web_access_url") != null || this.prop.get("obs_description_url") != null);
    }

    protected boolean isNew() {
        return this.isNewHips() || this.isNewObsRelease();
    }

    protected String getDataType() {
        if (this.isVizierTimeOnly()) {
            return "Time serie";
        }
        if (this.hasCS() || this.hasTAP() || this.isHipsCat()) {
            return "Catalog";
        }
        if (this.hasHips() || this.hasSIA()) {
            return "Image";
        }
        if (this.hasSSA()) {
            return "Spectrum";
        }
        return "";
    }

    protected boolean isNewObsRelease() {
        if (this.prop == null) {
            return false;
        }
        return this.lastDays(this.prop.getProperty("obs_release_date"), 90);
    }

    protected boolean isNewHips() {
        if (this.prop == null) {
            return false;
        }
        String date = this.prop.getProperty("hips_creation_date");
        if (date == null) {
            date = this.prop.getProperty("hips_release_date");
        }
        return this.lastDays(date, 90);
    }

    private boolean lastDays(String date, int days) {
        if (date == null) {
            return false;
        }
        try {
            long t = Util.getTimeFromISO(date);
            long now = System.currentTimeMillis();
            return now - t < 86400L * (long)days * 1000L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getMocType() {
        String s;
        if (!this.hasMoc()) {
            return "";
        }
        if (this.prop == null || (s = this.prop.get("moc_type")) == null) {
            return "MOC";
        }
        return s.toUpperCase();
    }

    protected boolean hasMoc() {
        return this.hasMocByMocServer() || this.prop != null && this.prop.getProperty("moc_access_url") != null || this.isHiPS();
    }

    private boolean hasMocByMocServer() {
        return this.prop != null && (this.prop.get("moc_type") != null || this.prop.get("moc_sky_fraction") != null || this.prop.getProperty("moc_access_url") != null);
    }

    protected String getCSUrl() {
        if (this.prop == null) {
            return null;
        }
        if (this.isVizierTimeOnly()) {
            return null;
        }
        if (this.prop.get("cs_glutag") != null) {
            return null;
        }
        String u = this.prop.get("cs_service_url");
        if (u != null && !u.endsWith("?") && !u.endsWith("&")) {
            u = u + '?';
        }
        return u;
    }

    protected String getGlobalAccessUrl() {
        if (this.prop == null) {
            return null;
        }
        String u = this.prop.get("access_url");
        return u;
    }

    protected String getInfoUrl() {
        if (this.prop == null) {
            return null;
        }
        String url = this.prop.get("obs_description_url");
        if (url == null) {
            url = this.prop.get("web_access_url");
        }
        return url;
    }

    protected boolean isProgen() {
        return this.progen;
    }

    protected boolean isColored() {
        return this.color;
    }

    protected boolean isCube() {
        return this.cube;
    }

    protected boolean isCubeFreq() {
        return this.cubefreq;
    }

    protected boolean isCubeSeq() {
        return this.cubeseq;
    }

    protected boolean isHips3D() {
        return this.cubefreq || this.cubeseq;
    }

    protected int getFrame() {
        return this.frame;
    }

    protected boolean isFits() {
        return this.inFits;
    }

    protected int getMaxOrder() {
        return this.maxOrder;
    }

    protected Coord getTarget() {
        return this.target;
    }

    protected double getRadius() {
        return this.radius;
    }

    protected String getVersion() {
        return this.version == null ? "" : this.version;
    }

    protected int getLosangeOrder() {
        if (this.progen || this.cat || this.nside == -1) {
            return -1;
        }
        return (int)CDSHealpix.log2(this.nside);
    }

    @Override
    protected Color isInStack() {
        return this.aladin.calque.isLoaded(this.internalId);
    }

    protected boolean isLocal() {
        return this.local;
    }

    protected boolean loadMocNow() {
        return this.moc;
    }

    protected boolean isJPEG() {
        return this.inJPEG;
    }

    protected boolean isPNG() {
        return this.inPNG;
    }

    protected boolean isTruePixels() {
        if (this.truePixelsSet) {
            return this.truePixels;
        }
        return !this.isColored() && (this.inFits && this.local || !this.inJPEG && !this.inPNG && !this.local);
    }

    protected boolean useCache() {
        return this.useCache;
    }

    protected String getUrl() {
        String path;
        if (this.id != null && this.id.startsWith(DIRECT) && this.url != null) {
            return this.url;
        }
        if (this.prop != null && (path = this.prop.getProperty("hips_service_path")) != null) {
            return path;
        }
        try {
            if (this.id != null && this.aladin.glu.aladinDic.get(this.id) != null) {
                return this.aladin.glu.getURL(this.id, "", false, false, 1) + "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.url;
    }

    protected String getAladinTree() {
        int i = this.path.lastIndexOf(47);
        if (i == -1) {
            return "";
        }
        return this.path.substring(0, i);
    }

    public String getGluDic() {
        StringBuffer s = new StringBuffer();
        s.append(GluApp.glu("ActionName", this.id));
        s.append(GluApp.glu("Description", this.description));
        s.append(GluApp.glu("Url", this.getUrl()));
        s.append(GluApp.glu("Aladin.Label", this.label));
        s.append(GluApp.glu("Aladin.Tree", this.getAladinTree()));
        s.append(GluApp.glu("Aladin.HpxParam", this.hpxParam));
        s.append(GluApp.glu("Aladin.Profile", this.aladinProfile));
        s.append(GluApp.glu("Copyright", this.copyright));
        s.append(GluApp.glu("Copyright.Url", this.copyrightUrl));
        s.append(GluApp.glu("VerboseDescr", this.verboseDescr));
        s.append(Util.CR);
        return s.toString();
    }

    protected void load() {
        if (this.hasGlobalAccess()) {
            this.loadGlobalAccess();
        } else if (this.hasAllAccess()) {
            this.loadAll();
        } else if (this.hasSIA()) {
            this.loadSIA();
        } else if (this.hasSSA()) {
            this.loadSSA();
        } else if (this.getUrl() == null && this.isCatalog()) {
            this.loadCS();
        } else {
            this.loadHips();
        }
    }

    void queryByXmatch() {
        ServerXmatch serverXmatch = new ServerXmatch(this.aladin);
        Plan plan = null;
        for (Object p : this.aladin.calque.getSelectedPlanes()) {
            if (!((Plan)p).isSimpleCatalog() || !((Plan)p).flagOk) continue;
            plan = (Plan)p;
            break;
        }
        if (plan == null) {
            for (Plan p : this.aladin.calque.getPlans()) {
                if (!p.isSimpleCatalog() || !p.flagOk) continue;
                plan = p;
                break;
            }
        }
        if (plan == null) {
            Aladin.error("You need to select or have a catalog plane in the stack");
            return;
        }
        serverXmatch.setPlan(plan);
        serverXmatch.setCatName(this.internalId);
        serverXmatch.setPlanName(this.internalId);
        serverXmatch.setSeparation(this.aladin.directory.getParam(XMATCH_RADIUS_KEY));
        serverXmatch.setSelection(this.aladin.directory.getParam(XMATCH_SELECTION_KEY));
        serverXmatch.setLimit(this.aladin.directory.getParam(CAT_LIMIT_KEY));
        serverXmatch.submit();
    }

    void queryByTap() {
        String gluTag = this.prop.get("tap_glutag");
        String url = this.prop.getFirst("tap_service_url");
        String id = this.prop.get("ID");
        String defaultTables = this.prop.get("tap_tablename");
        if (defaultTables == null && id.startsWith("CDS/") && !id.equals("CDS/Simbad")) {
            defaultTables = id.substring(4);
            System.err.println("Missing tablename for VizieR => assuming " + defaultTables);
        }
        if (id != null && url != null) {
            try {
                long startTime = TapManager.getTimeToLog();
                if (Aladin.levelTrace >= 4) {
                    System.out.println("In queryByTap starting to load: " + startTime);
                }
                TapManager.getInstance(this.aladin).loadTapServerForSimpleFrame(gluTag, id, url, defaultTables);
            }
            catch (Exception e) {
                e.printStackTrace();
                Aladin.error("Error unable to load " + url + "\n" + e.getMessage());
            }
        } else {
            Aladin.error("Error! No TAP form configured for " + id);
        }
    }

    private void exec(String cmd) {
        this.aladin.console.addLot(cmd);
    }

    protected void loadSSA() {
        this.loadSSA(this.getDefaultTarget() + " " + this.getDefaultRadius(3.0));
    }

    protected void loadSSA(String cone) {
        if (cone == null) {
            this.loadSSA();
            return;
        }
        this.exec(this.addBrowse(this.getSSACmd() + " " + cone));
    }

    protected String getSSABkm() {
        return this.addBrowse(this.getSSACmd() + " $TARGET $RADIUS");
    }

    protected String getSSACmd() {
        String gluTag = this.prop.get("ssa_glutag");
        if (this.prop.get("ssa_service_url") != null) {
            gluTag = "SSA(" + this.internalId + ")";
        }
        return "get " + gluTag;
    }

    protected void loadAssoc() {
        this.loadAssoc(this.getDefaultTarget() + " " + this.getDefaultRadius(3.0));
    }

    protected void loadAssoc(String cone) {
        if (cone == null) {
            this.loadAssoc();
            return;
        }
        String ident = "\"AD " + this.internalId + "\"";
        this.exec(ident + " = " + this.getAssocCmd() + " " + cone + "; select " + ident);
    }

    protected String getAssocCmd() {
        String cat = Directory.getCatParent(this.internalId.substring(this.internalId.indexOf(47) + 1));
        return "get VizieRAssocData(" + cat + ")";
    }

    protected void loadSIA() {
        this.loadSIA(this.getDefaultTarget() + " " + this.getDefaultRadius(3.0));
    }

    protected void loadSIA(String cone) {
        if (cone == null) {
            this.loadSIA();
            return;
        }
        this.exec(this.addBrowse(this.getSIACmd() + " " + cone));
    }

    protected String getSIABkm() {
        return this.addBrowse(this.getSIACmd() + " $TARGET $RADIUS");
    }

    protected String getSIACmd() {
        String gluTag = null;
        if (this.prop.get("sia2_service_url") != null) {
            gluTag = "SIA2(" + this.internalId + ")";
        } else if (this.prop.get("sia_service_url") != null) {
            gluTag = "SIA(" + this.internalId + ")";
        }
        if (gluTag == null) {
            gluTag = this.prop.get("sia2_glutag");
        }
        if (gluTag == null) {
            gluTag = this.prop.get("sia_glutag");
        }
        return "get " + gluTag;
    }

    protected void loadGlobalAccess() {
        this.exec(this.addBrowse(this.getGlobalAccessCmd(), false));
    }

    protected String getGlobalAccessBkm() {
        return this.addBrowse(this.getGlobalAccessCmd(), false);
    }

    protected String getGlobalAccessCmd() {
        String cmd = null;
        String id = Tok.quote(this.internalId);
        if (this.prop != null && this.hasGlobalAccess()) {
            cmd = id + " = load " + this.getGlobalAccessUrl();
        }
        return cmd;
    }

    private String addBrowse(String s) {
        return this.addBrowse(s, true);
    }

    private String addBrowse(String s, boolean onlySelect) {
        if (s == null) {
            return s;
        }
        String browse = this.aladin.directory.getParam(BROWSING_KEY);
        if ((this.hasSIA() || this.hasSSA() || this.hasGlobalAccess()) && browse.equals(BROWSING[0]) || browse.equals(BROWSING[1])) {
            s = onlySelect ? s + "; select " + this.id : s + "; browse " + this.id;
        }
        return s;
    }

    protected void loadLiveSimbad() {
        this.loadLiveSimbad(this.getDefaultTarget() + " " + this.getDefaultRadius(3.0));
    }

    protected void loadLiveSimbad(String cone) {
        if (cone == null) {
            this.loadLiveSimbad();
            return;
        }
        this.exec(this.addBrowse(this.getLiveSimbadCmd() + " " + cone));
    }

    protected String getLiveSimbadBkm() {
        return this.addBrowse(this.getLiveSimbadCmd() + " $TARGET $RADIUS");
    }

    private String getLiveSimbadCmd() {
        if (this.aladin.glu.get("SimbadLive") != null) {
            return "get SimbadLive";
        }
        return "get Simbad(live)";
    }

    protected void loadCS() {
        this.loadCS(this.getDefaultTarget() + " " + this.getDefaultRadius(3.0));
    }

    protected void loadCS(Coord c, double radius) {
        this.loadCS(this.aladin.localisation.ICRSToFrame(c).getDeg() + " " + Coord.getUnit(radius));
    }

    protected void loadCS(String cone) {
        if (cone == null) {
            this.loadCS();
            return;
        }
        this.exec(this.addBrowse(this.getCSCmd() + " " + cone));
    }

    protected String getCSBkm() {
        return this.addBrowse(this.getCSCmd(false) + " $TARGET $RADIUS");
    }

    protected String getCSCmd() {
        return this.getCSCmd(true);
    }

    protected String getCSCmd(boolean flagReplace) {
        String cmd = null;
        String allcolumns = this.aladin.directory.getParam("QueryCatColumns");
        String label = "";
        if (!Aladin.NOGUI && flagReplace && this.aladin.calque.isCSAlreadyLoaded(this.internalId)) {
            if (Aladin.confirmation(this.aladin, Aladin.chaine.getString("CSALREADYLOADED"))) {
                label = Tok.quote(this.internalId) + "=";
            }
        }
        if (this.isCDSCatalog()) {
            int i = this.internalId.indexOf(47);
            String cat = this.internalId.substring(i + 1);
            if (this.internalId.startsWith("CDS/Simbad")) {
                cmd = "get Simbad";
            } else {
                boolean hasTime = this.getMocType().indexOf(84) >= 0;
                String s = allcolumns.equals("all") || hasTime ? ",allcolumns" : "";
                cmd = "get VizieR(" + cat + s + ")";
            }
        } else if (this.prop != null && this.prop.get("cs_service_url") != null) {
            String s = allcolumns.equals("all") ? ",3" : "";
            cmd = "get CS(" + this.internalId + s + ")";
        }
        return label + cmd;
    }

    protected void loadCustom() {
        String glutag = this.prop.get("glutag");
        if (glutag == null) {
            glutag = this.prop.get("cs_glutag");
        }
        if (glutag == null) {
            glutag = this.prop.get("sia_glutag");
        }
        if (glutag == null) {
            glutag = this.prop.get("sia2_glutag");
        }
        if (glutag == null) {
            glutag = this.prop.get("ssa_glutag");
        }
        if (glutag == null) {
            glutag = this.prop.get("tap_glutag");
        }
        if (!this.aladin.dialog.showByGlutag(glutag, this.internalId)) {
            Aladin.error(this.aladin, "Mission GLU record [" + glutag + "]");
        }
    }

    protected String getCustomBkm() {
        String glutag = this.prop.get("glutag");
        return "get " + glutag + "(....) $TARGET $RADIUS";
    }

    protected void loadMoc() {
        this.exec(this.getMocCmd());
    }

    protected String getMocBkm() {
        return this.getMocCmd();
    }

    private String getMocCmd() {
        String param = this.aladin.directory.mocServerVersion >= 5.0 ? ",anymoc" : "";
        return "get MOC(" + Tok.quote(this.internalId) + param + ")";
    }

    protected void loadHips() {
        String trg = null;
        if (this.getIsIn() != 0) {
            trg = this.getDefaultTarget();
        } else {
            Aladin.trace(4, "TreeObjDir.loadHips(): default target out of HiPS field => no target");
        }
        String s = trg == null ? "" : " " + trg + " " + this.getDefaultRadius();
        this.exec(this.getHipsCmd() + s);
    }

    protected String getHipsBkm() {
        return this.getHipsCmd() + " $TARGET $RADIUS";
    }

    protected String getHipsCmd() {
        String id = Tok.quote(this.internalId != null ? this.internalId : this.label);
        String mode = "";
        if (!this.isCatalog()) {
            String s = this.aladin.directory.getParam(HIPS_FORMAT_KEY);
            mode = s.indexOf("fits") >= 0 ? ",fits" : (s.indexOf("preview") > 0 ? (this.isPNG() ? ",png" : (this.isJPEG() ? ",jpeg" : "")) : "");
        }
        String cmd = "get HiPS(" + id + mode + ")";
        return cmd;
    }

    protected void loadProgenitors() {
        this.exec(this.getProgenitorsCmd());
    }

    protected String getProgenitorsBkm() {
        return this.getProgenitorsCmd();
    }

    private String getProgenitorsCmd() {
        String progen = this.getProgenitorsUrl();
        if (progen == null) {
            progen = this.url + "/" + "HpxFinder";
        }
        return Tok.quote(this.internalId + " PGN") + "=load " + progen;
    }

    protected void loadAll() {
        this.exec(this.addBrowse(this.getLoadAllCmd()));
    }

    protected String getAllBkm() {
        return this.addBrowse(this.getLoadAllCmd());
    }

    private String getLoadAllCmd() {
        int i = this.internalId.indexOf(47);
        String cat = this.internalId.substring(i + 1);
        return "get VizieR(" + cat + ",allsky,allcolumns)";
    }

    protected String getDefaultTarget() {
        try {
            if (this.aladin.view.isFree() || !Projection.isOk(this.aladin.view.getCurrentView().getProj())) {
                return null;
            }
            Coord coo = this.aladin.view.getCurrentView().getCooCentre();
            coo = this.aladin.localisation.ICRSToFrame(coo);
            return coo.getDeg();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getDefaultRadius() {
        return this.getDefaultRadius(-1.0);
    }

    protected String getDefaultRadius(double maxRad) {
        if (this.aladin.view.isFree() || !Projection.isOk(this.aladin.view.getCurrentView().getProj())) {
            return "14'";
        }
        double radius = this.aladin.view.getCurrentView().getTaille();
        if (maxRad >= 0.0 && radius > maxRad) {
            radius = maxRad;
        }
        return Coord.getUnit(radius);
    }

    synchronized void setScanning(boolean flag) {
        this.scanning = flag;
    }

    synchronized boolean isScanning() {
        return this.scanning;
    }

    protected void scan(MocItem2 mo) {
        this.setScanning(true);
        try {
            this.scan1(mo);
        }
        finally {
            this.setScanning(false);
        }
    }

    protected void scan1(MocItem2 mo) {
        block19: {
            double rad;
            Coord c;
            block18: {
                String url = null;
                c = this.aladin.view.getCurrentView().getCooCentre();
                rad = this.aladin.view.getCurrentView().getTaille();
                if (rad > 1.0) {
                    rad = 1.0;
                }
                String radius = Util.myRound(rad);
                if (this.hasCS()) {
                    url = this.getCSUrl();
                    if (!url.endsWith("?") && !url.endsWith("&")) {
                        url = url + "?";
                    }
                    url = url + "RA=" + c.al + "&DEC=" + c.del + "&SR=" + radius + "&VERB=2";
                } else if (this.hasSIA()) {
                    int qm;
                    boolean flagFormat = false;
                    url = this.prop.get("sia_service_url");
                    if (url != null) {
                        qm = url.indexOf(63);
                        boolean bl = flagFormat = qm >= 0 && url.lastIndexOf("FORMAT=") > qm;
                        if (!url.endsWith("?") && !url.endsWith("&")) {
                            url = url + "?";
                        }
                        url = url + "POS=" + c.al + "," + c.del + "&SIZE=" + radius + (flagFormat ? "" : "&FORMAT=image/fits");
                    } else {
                        url = this.prop.get("sia2_service_url");
                        qm = url.indexOf(63);
                        boolean bl = flagFormat = qm >= 0 && url.lastIndexOf("FORMAT=") > qm;
                        if (url != null) {
                            if (!url.endsWith("?") && !url.endsWith("&")) {
                                url = url + "?";
                            }
                            url = url + "REQUEST=query&POS=CIRCLE=" + c.al + " " + c.del + " " + radius + (flagFormat ? "" : "&FORMAT=image/fits");
                        }
                    }
                } else if (this.hasSSA()) {
                    url = this.prop.get("ssa_service_url");
                    if (!url.endsWith("?") && !url.endsWith("&")) {
                        url = url + "?";
                    }
                    url = url + "REQUEST=queryData&POS=" + c.al + "," + c.del + "&SIZE=" + radius;
                }
                if (url == null) {
                    return;
                }
                try {
                    Moc moc = this.scan(url);
                    mo.moc = mo.moc == null ? moc : mo.moc.union(moc);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block18;
                    e.printStackTrace();
                }
            }
            try {
                int order = 11;
                SMoc moc = CDSHealpix.getMocByCircle(order, c.al, c.del, Math.toRadians(rad), false);
                mo.mocRef = mo.mocRef == null ? moc : mo.mocRef.union(moc);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block19;
                e.printStackTrace();
            }
        }
    }

    protected void abortScan() {
        try {
            if (this.inScan != null) {
                this.inScan.close();
                this.inScan = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Moc scan(String url) {
        Pcat pcat = new Pcat(this.aladin);
        pcat.plan = new PlanCatalog(this.aladin);
        pcat.plan.label = "test";
        SMoc moc = null;
        int order = 11;
        try {
            moc = new SMoc(order);
            moc.bufferOn();
            this.inScan = new MyInputStream(Util.openStream(url, false, true, 30000));
            pcat.tableParsing(this.inScan, null);
            Iterator<Obj> it = pcat.iterator();
            Healpix hpx = new Healpix();
            boolean n = false;
            while (it.hasNext()) {
                Obj o = it.next();
                if (!(o instanceof Position) || Double.isNaN(((Position)o).raj)) continue;
                try {
                    double[] c = CDSHealpix.normalizeRaDec(((Position)o).raj, ((Position)o).dej);
                    long pix = hpx.ang2pix(order, c[0], c[1]);
                    moc.add(order, pix);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) continue;
                    e.printStackTrace();
                }
            }
            moc.bufferOff();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
        }
        finally {
            if (this.inScan != null) {
                try {
                    this.inScan.close();
                    this.inScan = null;
                }
                catch (Exception exception) {}
            }
        }
        return moc;
    }

    void loadCopyright() {
        this.aladin.glu.showDocument(this.copyrightUrl);
    }

    void setDefaultMode(int mode) {
        this.truePixelsSet = true;
        if (mode == 2 && this.inFits) {
            this.truePixels = true;
        } else if (mode == 1 && (this.inJPEG || this.inPNG)) {
            this.truePixels = false;
        }
    }

    protected void reset() {
        this.truePixelsSet = false;
    }

    void setMoc() {
        if (this.skyFraction == null || this.skyFraction.equals("1")) {
            return;
        }
        JButton b = new JButton(" (get Moc)");
        b.setFont(b.getFont().deriveFont(2));
        b.setForeground(Color.blue);
        b.setBackground(background);
        b.setContentAreaFilled(false);
        b.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.blue));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeObjDir.this.loadMoc();
            }
        });
        this.gc.insets.bottom = 7;
        this.gb.setConstraints(b, this.gc);
        this.getPanel().add(b);
    }

    void loadDensityMap() {
        int off1 = this.internalId.indexOf(47);
        String catId = this.internalId.substring(off1 + 1);
        URL url = this.aladin.glu.getURL(DMAPGLUHIPS, Glu.quote(catId));
        String label = this.internalId + " DMAP";
        off1 = this.internalId.indexOf("CDS/");
        if (off1 >= 0) {
            label = "CDS/P/DM/" + catId;
        }
        int n = this.aladin.calque.newPlanBG(url, label, null, null);
        String cmd = Glu.quote(label) + "=load " + url;
        this.aladin.console.printCommand(cmd);
    }

    void queryByMoc(PlanMoc planMoc) {
        ServerMocQuery serverMoc = new ServerMocQuery(this.aladin);
        serverMoc.setPlan(planMoc);
        int i = this.internalId.indexOf(47);
        String catName = this.internalId.substring(i + 1);
        serverMoc.setCatName(catName);
        serverMoc.setPlanName(this.internalId);
        serverMoc.setLimit(this.aladin.directory.getParam(CAT_LIMIT_KEY));
        serverMoc.submit();
    }

    void setUrl(String url) {
        this.url = url;
    }

    void setCopyright(String copyright) {
        JComponent c = null;
        if (this.copyrightUrl == null) {
            JLabel l;
            c = l = new JLabel("(" + copyright + ")");
            this.gc.insets.bottom = 0;
        } else {
            JButton b = new JButton(copyright != null ? copyright : "Copyright");
            b.setFont(b.getFont().deriveFont(2));
            b.setForeground(Color.blue);
            b.setBackground(background);
            b.setContentAreaFilled(false);
            b.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.blue));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeObjDir.this.loadCopyright();
                }
            });
            c = b;
            this.gc.insets.bottom = 5;
        }
        this.gb.setConstraints(c, this.gc);
        this.getPanel().add(c);
    }

    public static HashMap<String, String> paramsFactory() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(XMATCH_RADIUS_KEY, "5");
        params.put(XMATCH_SELECTION_KEY, XMATCH_SELECTION[0]);
        params.put(HIPS_FORMAT_KEY, HIPS_FORMAT[0]);
        params.put(CAT_COLUMNS_KEY, CAT_COLUMNS[0]);
        params.put(CAT_LIMIT_KEY, CAT_LIMIT[CAT_LIMIT.length - 1]);
        params.put(BROWSING_KEY, BROWSING[0]);
        return params;
    }

    private boolean hasHipsFmt() {
        if (this.prop == null) {
            return false;
        }
        String s = this.prop.get("hips_tile_format");
        if (s == null) {
            return false;
        }
        return s.indexOf("fits") >= 0 && (s.indexOf("jpeg") >= 0 || s.indexOf("png") >= 0);
    }

    @Override
    public boolean hasProp() {
        return this.hasHipsFmt() || this.isCatalog() || this.hasSIA() || this.hasSSA() || this.hasGlobalAccess();
    }

    @Override
    public Vector<Prop> getProp() {
        Vector<Prop> v = new Vector<Prop>();
        if (this.hasHipsFmt()) {
            v.add(this.getHipsFmtProp());
        }
        if (this.isCatalog()) {
            v.add(this.getCatLimitProp());
            v.add(this.getCatColumnProp());
        }
        if (this.isCDSCatalog()) {
            v.add(this.getXmatchRadiusProp());
            v.add(this.getXmatchSelectionProp());
        }
        if (this.isCatalog() || this.hasGlobalAccess() || this.hasSIA() || this.hasSSA()) {
            v.add(this.getBrowsingProp());
        }
        return v;
    }

    public static void loadString(Chaine chaine) {
        XMATCH_RADIUS_TITLE = chaine.getString("XMATCH_RADIUS_TITLE");
        XMATCH_RADIUS_HELP = chaine.getString("XMATCH_RADIUS_HELP");
        XMATCH_SELECTION_TITLE = chaine.getString("XMATCH_SELECTION_TITLE");
        XMATCH_SELECTION_HELP = chaine.getString("XMATCH_SELECTION_HELP");
        HIPS_FORMAT_TITLE = chaine.getString("HIPS_FORMAT_TITLE");
        HIPS_FORMAT_HELP = chaine.getString("HIPS_FORMAT_HELP");
        CAT_LIMIT_TITLE = chaine.getString("CAT_LIMIT_TITLE");
        CAT_LIMIT_HELP = chaine.getString("CAT_LIMIT_HELP");
        CAT_COLUMNS_TITLE = chaine.getString("CAT_COLUMNS_TITLE");
        CAT_COLUMNS_HELP = chaine.getString("CAT_COLUMNS_HELP");
        BROWSING_TITLE = chaine.getString("BROWSING_TITLE");
        BROWSING_HELP = chaine.getString("BROWSING_HELP");
    }

    public Prop getBrowsingProp() {
        final JComboBox<String> combo = new JComboBox<String>(BROWSING);
        PropAction update = new PropAction(){

            @Override
            public int action() {
                combo.setSelectedItem(TreeObjDir.this.aladin.directory.getParam(BROWSING_KEY));
                return 1;
            }
        };
        PropAction change = new PropAction(){

            @Override
            public int action() {
                String s = (String)combo.getSelectedItem();
                if (s.equals(TreeObjDir.this.aladin.directory.getParam(BROWSING_KEY))) {
                    return -1;
                }
                TreeObjDir.this.aladin.directory.setParam(BROWSING_KEY, s);
                return 1;
            }
        };
        return Prop.propFactory(BROWSING_KEY, BROWSING_TITLE, BROWSING_HELP, combo, update, change);
    }

    public Prop getXmatchRadiusProp() {
        final JTextField testRadius = new JTextField(10);
        final PropAction update = new PropAction(){

            @Override
            public int action() {
                testRadius.setText(TreeObjDir.this.aladin.directory.getParam(XMATCH_RADIUS_KEY));
                return 1;
            }
        };
        PropAction change = new PropAction(){

            @Override
            public int action() {
                testRadius.setForeground(Color.black);
                String oval = TreeObjDir.this.aladin.directory.getParam(XMATCH_RADIUS_KEY);
                try {
                    String nval = testRadius.getText();
                    if (nval.equals(oval)) {
                        return -1;
                    }
                    TreeObjDir.this.aladin.directory.setParam(XMATCH_RADIUS_KEY, nval);
                    return 1;
                }
                catch (Exception e1) {
                    update.action();
                    testRadius.setForeground(Color.red);
                    return 0;
                }
            }
        };
        return Prop.propFactory(XMATCH_RADIUS_KEY, XMATCH_RADIUS_TITLE, XMATCH_RADIUS_HELP, testRadius, update, change);
    }

    public Prop getXmatchSelectionProp() {
        final JComboBox<String> combo = new JComboBox<String>(XMATCH_SELECTION);
        PropAction update = new PropAction(){

            @Override
            public int action() {
                combo.setSelectedItem(TreeObjDir.this.aladin.directory.getParam(XMATCH_SELECTION_KEY));
                return 1;
            }
        };
        PropAction change = new PropAction(){

            @Override
            public int action() {
                String s = (String)combo.getSelectedItem();
                if (s.equals(TreeObjDir.this.aladin.directory.getParam(XMATCH_SELECTION_KEY))) {
                    return -1;
                }
                TreeObjDir.this.aladin.directory.setParam(XMATCH_SELECTION_KEY, s);
                return 1;
            }
        };
        return Prop.propFactory(XMATCH_SELECTION_KEY, XMATCH_SELECTION_TITLE, XMATCH_SELECTION_HELP, combo, update, change);
    }

    public Prop getHipsFmtProp() {
        final JComboBox<String> combo = new JComboBox<String>(HIPS_FORMAT);
        PropAction update = new PropAction(){

            @Override
            public int action() {
                combo.setSelectedItem(TreeObjDir.this.aladin.directory.getParam(HIPS_FORMAT_KEY));
                return 1;
            }
        };
        PropAction change = new PropAction(){

            @Override
            public int action() {
                String s = (String)combo.getSelectedItem();
                if (s.equals(TreeObjDir.this.aladin.directory.getParam(HIPS_FORMAT_KEY))) {
                    return -1;
                }
                TreeObjDir.this.aladin.directory.setParam(HIPS_FORMAT_KEY, s);
                return 1;
            }
        };
        return Prop.propFactory(HIPS_FORMAT_KEY, HIPS_FORMAT_TITLE, HIPS_FORMAT_HELP, combo, update, change);
    }

    public Prop getCatLimitProp() {
        final JComboBox<String> combo = new JComboBox<String>(CAT_LIMIT);
        PropAction update = new PropAction(){

            @Override
            public int action() {
                combo.setSelectedItem(TreeObjDir.this.aladin.directory.getParam(CAT_LIMIT_KEY));
                return 1;
            }
        };
        PropAction change = new PropAction(){

            @Override
            public int action() {
                String s = (String)combo.getSelectedItem();
                if (s.equals(TreeObjDir.this.aladin.directory.getParam(CAT_LIMIT_KEY))) {
                    return -1;
                }
                TreeObjDir.this.aladin.directory.setParam(CAT_LIMIT_KEY, s);
                return 1;
            }
        };
        return Prop.propFactory(CAT_LIMIT_KEY, CAT_LIMIT_TITLE, CAT_LIMIT_HELP, combo, update, change);
    }

    public Prop getCatColumnProp() {
        final JComboBox<String> combo = new JComboBox<String>(CAT_COLUMNS);
        PropAction update = new PropAction(){

            @Override
            public int action() {
                combo.setSelectedItem(TreeObjDir.this.aladin.directory.getParam(CAT_COLUMNS_KEY));
                return 1;
            }
        };
        PropAction change = new PropAction(){

            @Override
            public int action() {
                String s = (String)combo.getSelectedItem();
                if (s.equals(TreeObjDir.this.aladin.directory.getParam(CAT_COLUMNS_KEY))) {
                    return -1;
                }
                TreeObjDir.this.aladin.directory.setParam(CAT_COLUMNS_KEY, s);
                return 1;
            }
        };
        return Prop.propFactory(CAT_COLUMNS_KEY, CAT_COLUMNS_TITLE, CAT_COLUMNS_HELP, combo, update, change);
    }

    static {
        XMATCH_RADIUS_KEY = "QueryXmatchRadius";
        XMATCH_SELECTION_KEY = "QueryXmatchSelection";
        XMATCH_SELECTION = new String[]{"best", "all"};
        HIPS_FORMAT_KEY = "QueryHipsFormat";
        HIPS_FORMAT = new String[]{"default", "preview (jpg|png)", "full dynamic (fits)"};
        CAT_LIMIT_KEY = "QueryCatLimit";
        CAT_LIMIT = new String[]{"100", "1000", "10000", "100000", "unlimited"};
        CAT_COLUMNS_KEY = "QueryCatColumns";
        CAT_COLUMNS = new String[]{"default", "all"};
    }
}

