/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.BasicTree;
import cds.aladin.Coord;
import cds.aladin.Fov;
import cds.aladin.MetaDataTree;
import cds.aladin.ResourceNode;
import cds.aladin.SIAPExtBuilder;
import cds.aladin.Server;
import cds.aladin.TreeView;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCStringParser;
import cds.astro.Astrocoo;
import cds.astro.Coo;
import cds.savot.model.FieldSet;
import cds.savot.model.InfoSet;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.pull.SavotPullParser;
import cds.tools.Util;
import java.awt.Color;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class TreeBuilder {
    static final int VOTABLE_IDHA = 0;
    static final int VIZIER = 1;
    static final int SIAP = 2;
    static final int SSA = 3;
    static final int SIAP_EVOL = 4;
    static final int SIAP_EXT = 5;
    private int indexCriteria = 0;
    private int indexValue = 1;
    private static final String SIAP_IMAGE_TITLE = "VOX:Image_Title";
    private static final String SIAP_IMAGE_TITLE2 = "OBS_ID";
    protected static final String SIAP_RA = "POS_EQ_RA_MAIN";
    protected static final String SIAP_DE = "POS_EQ_DEC_MAIN";
    private static final String SSAP_UTYPE_SPATIAL_COVERAGE = "Char.SpatialAxis.Coverage.Location.Value";
    protected static final String SIAP_RA_UCD1P = "pos.eq.ra;meta.main";
    protected static final String SIAP_DE_UCD1P = "pos.eq.dec;meta.main";
    private static final String SIAP_SCALE = "VOX:Image_Scale";
    private static final String SIAP_NAXIS = "VOX:Image_Naxis";
    private static final String SIAP_IMAGE_FORMAT = "VOX:Image_Format";
    private static final String SIAP_URL = "VOX:Image_AccessReference";
    private static final String SIAP_URL2 = "DATA_LINK";
    private static final String FORMAT = "FORMAT";
    private static final String ESAC_AXES = "VOX:Spectrum_axes";
    private static final String ESAC_UNITS = "VOX:Spectrum_units";
    private static final String ESAC_DIMEQ = "VOX:Spectrum_dimeq";
    private static final String ESAC_SCALEQ = "VOX:Spectrum_scaleq";
    protected static final String MAPPARAM = "MapPare";
    protected static final String SIAP_BANDPASS_ID = "VOX:BandPass_ID";
    private static final String FOOTPRINT_REF_UTYPE = "dal:footprint.geom.id";
    private static final String RESTYPE = "resourceType";
    private static final String IDSURVEY = "ObservingProgram";
    private static final String IDBAND = "Observation_Group";
    private static final String IDIMAGE = "Observation";
    private static final String IDMAPPING = "StorageMapping";
    private static final String IDSTORED = "StoredImage";
    private static final String OBS_NAME = "Observation_Name";
    private static final String CUTOUT = "CUTOUTS";
    private static final String AVAILABLE_CODINGS = "COMPRESSION";
    private static final String AVAILABLE_PROCESSINGS = "MODE";
    private static final String OBS_DATE = "date";
    private static final String ORIGIN = "Origin";
    private static final String INDEXING = "Indexing";
    protected static final String NB_OF_PATCHES = "number";
    private static final String RESOLUTION = "RESOLUTION";
    private static final String MACHINE = "MACHINE";
    private static final String MAX_SIZE = "size";
    private static final String LOCATION = "Location";
    private static final String GLULINK = "GLink";
    private static final String FILTER_NAME = "Filter_Name";
    private static final String UTYPE_DM_SSA = "Dataset.DataModel";
    private static final String UTYPE_DSLENGTH_SSA = "Dataset.Length";
    private static final String UTYPE_ACREF_SSA = "Access.Reference";
    private static final String UTYPE_DATATITLE_SSA = "DataID.Title";
    private static final String UCD1P_TITLE = "meta.title";
    public static final String UTYPE_STCS_REGION1 = "*ObservationLocation.AstroCoordArea.Region";
    public static final String UTYPE_STCS_REGION2 = "*Char.SpatialAxis.Coverage.Support.Area";
    public static final String XTYPE_MOC = "Moc";
    private double xVal;
    private double yVal;
    private double alphaVal;
    private double deltaVal;
    private double[] xValTab;
    private double[] yValTab;
    String[] descFilter;
    double angleVal = Double.NaN;
    private int type;
    private Server server = null;
    private static Color[] colTab = new Color[]{Color.green, Color.orange, Color.magenta, Color.cyan, Color.pink};
    private static int colorNb = 0;
    private ResourceNode nodeMemo;
    private Color fovColor;
    private double maxSize;
    private double pixSize;
    private String pixSizeUnit = "";
    private Astrocoo frame = new Astrocoo();
    String nameSiapEvolStr;
    private InputStream is;
    private URL url;
    private String file;
    private SavotPullParser savotParser;
    private String objet;
    private String targetObjet;
    private Coord targetObjetCoo;
    private String error;
    protected String[] sortItems;
    private int nameIndex = 0;
    private String currentSurvey;
    private String currentColor;
    private String currentWavelength;
    private String currentFilterName;
    private FieldSet surveyFieldSet;
    private FieldSet bandFieldSet;
    private FieldSet imageFieldSet;
    private FieldSet filterFieldSet;
    private FieldSet mappingFieldSet;
    private FieldSet storedFieldSet;
    private Hashtable fieldSetMapping = new Hashtable();
    Aladin aladin;
    private String targetFound = null;
    private String requestedPos;
    Hashtable ACSFilters = new Hashtable();
    Hashtable fieldsPool = new Hashtable();
    int myIndexRA;
    int myIndexDE;

    TreeBuilder(Aladin aladin, URL url, int type, Server server, String target) {
        this.aladin = aladin;
        this.url = url;
        this.type = type;
        this.server = server;
        this.objet = target;
    }

    TreeBuilder(Aladin aladin, String target) {
        this.aladin = aladin;
        this.objet = target;
    }

    TreeBuilder(Aladin aladin, InputStream is, int type, Server server, String target) {
        this.aladin = aladin;
        this.is = is;
        this.type = type;
        this.server = server;
        this.objet = target;
    }

    private void suite() {
        if (this.objet == null && this.server != null && this.server.target != null) {
            this.objet = this.server.target.getText();
        }
        this.targetObjet = TreeView.resolveTarget(this.objet, this.aladin);
        this.targetObjetCoo = TreeView.resolveTargetCoo(this.objet, this.aladin);
        this.createSavotParser();
    }

    protected boolean mayBeSSA(SavotVOTable vot) {
        SavotResource firstRes = (SavotResource)vot.getResources().getItemAt(0);
        InfoSet infos = firstRes.getInfos();
        for (int i = 0; i < infos.getItemCount(); ++i) {
            SavotInfo info = (SavotInfo)infos.getItemAt(i);
            if (!info.getContent().equals("SSAP")) continue;
            return true;
        }
        if (firstRes.getFieldSet(0) == null || firstRes.getFieldSet(0).getItems() == null) {
            return false;
        }
        List fields = firstRes.getFieldSet(0).getItems();
        for (SavotField curField : fields) {
            String curUtype = this.stripNSForUtype(curField.getUtype().trim());
            String curUCD = curField.getUcd();
            if ((!curUtype.equalsIgnoreCase(UTYPE_ACREF_SSA) || curUCD.equalsIgnoreCase(SIAP_URL)) && !curUtype.equalsIgnoreCase(UTYPE_DM_SSA) && !curUtype.equalsIgnoreCase(UTYPE_DSLENGTH_SSA)) continue;
            return true;
        }
        return false;
    }

    private void detectFormat() {
        FieldSet fSet;
        String tmp;
        String string = this.file != null ? this.file : (tmp = this.url != null ? this.url.toString() : "stream");
        if (this.type >= 0) {
            Aladin.trace(3, "detect format of " + tmp + ": format was already specified");
            return;
        }
        SavotResource firstRes = (SavotResource)this.savotParser.getVOTable().getResources().getItemAt(0);
        int nbRes = this.savotParser.getVOTable().getResources().getItemCount();
        SavotResource secondRes = null;
        if (nbRes >= 2) {
            secondRes = (SavotResource)this.savotParser.getVOTable().getResources().getItemAt(1);
        }
        if (firstRes == null) {
            Aladin.trace(3, "Could not determine type, stream contains no RESOURCE");
            return;
        }
        String utype = firstRes.getUtype();
        if (utype != null && utype.equals("dal:SimpleQueryResponse")) {
            this.type = 5;
            return;
        }
        if (firstRes.getTableCount() > 0 && (fSet = firstRes.getFieldSet(0)) != null && fSet.getItems() != null) {
            List e = fSet.getItems();
            for (SavotField savotField : e) {
                if (!savotField.getUtype().equalsIgnoreCase(FOOTPRINT_REF_UTYPE)) continue;
                this.type = 5;
                return;
            }
        }
        if (this.mayBeSSA(this.savotParser.getVOTable())) {
            this.type = 3;
            return;
        }
        String myType = firstRes.getType();
        if (myType == null) {
            myType = "";
        }
        if (myType.equals("results")) {
            if (secondRes != null && secondRes.getType() != null && (secondRes.getType().equals("GeneralFeatures") || secondRes.getName().equals("GeneralFeatures"))) {
                this.type = 4;
                return;
            }
            this.type = 2;
            return;
        }
        String name = firstRes.getId();
        if (name == null || name.length() == 0) {
            name = firstRes.getName();
        }
        if (name != null && (name.equalsIgnoreCase(IDSURVEY) || name.equals(IDBAND))) {
            this.type = 0;
            return;
        }
    }

    private String stripNSForUtype(String utype) {
        String ret;
        String prefix = "SSA.";
        int idx = utype.indexOf(58);
        String string = ret = idx != -1 && utype.length() > idx + 1 ? utype.substring(idx + 1) : utype;
        if (ret.startsWith("SSA.")) {
            ret = ret.substring("SSA.".length());
        }
        return ret;
    }

    protected ResourceNode build() throws Exception {
        this.suite();
        this.searchTarget();
        this.detectFormat();
        Aladin.trace(3, "Detected format of document : " + this.readableFormat(this.type));
        if (this.type == 0) {
            return this.buildVotable();
        }
        if (this.type == 1) {
            return this.buildCatVotable();
        }
        if (this.type == 2 || this.type == 3) {
            return this.buildSIAPVotable();
        }
        if (this.type == 4) {
            return this.buildSIAPEvolVotable();
        }
        if (this.type == 5) {
            return this.buildSIAPExtVotable();
        }
        return this.buildSIAPVotable();
    }

    private String readableFormat(int t) {
        if (t == 0) {
            return "VOTABLE_IDHA";
        }
        if (t == 1) {
            return "VIZIER";
        }
        if (t == 2) {
            return "SIAP";
        }
        if (t == 3) {
            return "SSA";
        }
        if (t == 4) {
            return "SIAP_EVOL";
        }
        if (t == 5) {
            return "SIAP_EXT";
        }
        return "unknown";
    }

    private void searchTarget() {
        ParamSet params;
        if (this.savotParser == null) {
            return;
        }
        InfoSet infos = this.savotParser.getVOTable().getInfos();
        for (int i = 0; i < infos.getItemCount(); ++i) {
            SavotInfo info = (SavotInfo)infos.getItemAt(i);
            if (!info.getId().equalsIgnoreCase("position")) continue;
            this.targetFound = info.getValue();
            if (this.targetObjet == null) {
                this.targetObjet = this.targetFound;
            }
            return;
        }
        try {
            params = ((SavotResource)this.savotParser.getVOTable().getResources().getItemAt(0)).getParams();
        }
        catch (Exception e) {
            return;
        }
        for (int i = 0; i < params.getItemCount(); ++i) {
            SavotParam param = (SavotParam)params.getItemAt(i);
            if (!param.getName().equalsIgnoreCase("INPUT:POS")) continue;
            this.targetFound = param.getValue();
            return;
        }
    }

    protected String getTarget() {
        return this.targetFound;
    }

    protected void setRequestedPos(String s) {
        this.requestedPos = s;
    }

    protected String getRequestedPos() {
        return this.requestedPos;
    }

    private ResourceNode buildCatVotable() {
        if (this.savotParser == null) {
            return null;
        }
        ResourceNode n = new ResourceNode(this.aladin, "root");
        n.type = 0;
        SavotVOTable voTable = this.savotParser.getVOTable();
        ResourceSet resources = voTable.getResources();
        for (int i = 0; i < resources.getItemCount(); ++i) {
            SavotResource curResource = (SavotResource)resources.getItemAt(i);
            ResourceNode newNode = new ResourceNode(this.aladin, curResource.getName());
            newNode.isLeaf = true;
            newNode.type = 2;
            InfoSet infos = curResource.getInfos();
            String[] expla = new String[infos.getItemCount()];
            String[] desc = new String[infos.getItemCount()];
            String oKeyword = null;
            for (int j = 0; j < infos.getItemCount(); ++j) {
                SavotInfo info = (SavotInfo)infos.getItemAt(j);
                String keyWord = info.getName();
                String value = info.getValue();
                if (keyWord.startsWith("-")) {
                    keyWord = keyWord.substring(1);
                }
                if (keyWord.startsWith("kw.")) {
                    keyWord = keyWord.substring(3);
                }
                if (oKeyword == null || !keyWord.equals(oKeyword)) {
                    desc[j] = keyWord;
                    expla[j] = value;
                    oKeyword = keyWord;
                    continue;
                }
                desc[j] = "  \"   \"";
                expla[j] = value;
            }
            n.addChild(newNode);
            newNode.description = desc;
            newNode.explanation = expla;
        }
        return n;
    }

    private void createSavotParser() {
        if (this.url != null) {
            try {
                this.savotParser = new SavotPullParser(this.url, 0, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.savotParser = null;
            }
        } else if (this.file != null) {
            try {
                this.savotParser = new SavotPullParser(this.file, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.savotParser = null;
            }
        } else if (this.is != null) {
            this.savotParser = new SavotPullParser(this.is, 0, null);
        }
    }

    private ResourceNode buildSIAPExtVotable() throws Exception {
        SIAPExtBuilder builder = new SIAPExtBuilder(this.aladin, this.objet);
        builder.setRequestedPos(this.getRequestedPos());
        return builder.build(this.savotParser);
    }

    private ResourceNode buildSIAPEvolVotable() {
        int obsLocationIndex = -1;
        if (this.savotParser == null) {
            return null;
        }
        SavotVOTable vot = this.savotParser.getVOTable();
        ResourceSet rootResSet = vot.getResources();
        ResourceNode root = new ResourceNode(this.aladin, "root");
        root.type = 0;
        root.isSIAPEvol = true;
        SavotResource res = null;
        res = (SavotResource)rootResSet.getItemAt(0);
        if (res == null) {
            return null;
        }
        SavotField[] initFields = this.createDescription(res.getFieldSet(0));
        String[] idFields = new String[initFields.length];
        for (int i = 0; i < initFields.length; ++i) {
            idFields[i] = initFields[i].getId();
        }
        SavotResource res2 = (SavotResource)rootResSet.getItemAt(2);
        SavotField[] fields2 = this.createDescription(res2.getFieldSet(0));
        int toto = this.findFieldByID("RelatedObservation", fields2);
        String totoStr = fields2[toto].getRef();
        this.nameSiapEvolStr = totoStr.trim();
        this.processSIAPEvolResource(res, root);
        Hashtable<String, ResourceNode> namesToNodes = new Hashtable<String, ResourceNode>();
        Hashtable altNamesToNodes = new Hashtable();
        String refName = ((SavotField)((SavotResource)rootResSet.getItemAt(2)).getFieldSet(0).getItemAt(0)).getRef();
        res = (SavotResource)rootResSet.getItemAt(1);
        if (res != null && root.nbChildren > 0) {
            Vector<String> desc = new Vector<String>();
            ResourceNode n = (ResourceNode)root.getChildrenAt(0);
            int obsRefIndex = this.findValIndex(idFields, refName);
            obsLocationIndex = this.findValIndex(idFields, LOCATION);
            int idxRefRelObs = this.findValIndex(idFields, totoStr);
            for (int i = 0; i < n.description.length; ++i) {
                desc.addElement(n.description[i]);
            }
            Hashtable genFeatNodes = new Hashtable();
            this.processGenFeat(res, genFeatNodes, desc);
            Enumeration e = root.getChildren();
            while (e.hasMoreElements()) {
                n = (ResourceNode)e.nextElement();
                namesToNodes.put(n.explanation[obsRefIndex], n);
                if (altNamesToNodes.get(n.explanation[idxRefRelObs]) == null) {
                    altNamesToNodes.put(n.explanation[idxRefRelObs], new Vector());
                }
                ((Vector)altNamesToNodes.get(n.explanation[idxRefRelObs])).addElement(n);
                n.links = new Hashtable();
                for (int i = 0; i < n.description.length; ++i) {
                    String key = n.description[i] + n.explanation[i];
                    ResourceNode associatedNode = (ResourceNode)genFeatNodes.get(key);
                    if (associatedNode == null) continue;
                    associatedNode.isLeaf = false;
                    n.links.put(n.description[i], associatedNode);
                }
            }
        }
        if ((res = (SavotResource)rootResSet.getItemAt(2)) != null) {
            root.removeAllChild();
            SavotField[] fields = this.createDescription(res.getFieldSet(0));
            int nbTr = res.getTRCount(0);
            TRSet obsSet = res.getData(0).getTableData().getTRs();
            Hashtable obsToSubObs = new Hashtable();
            Vector<ResourceNode> alreadyAdded = new Vector<ResourceNode>();
            int locationIndex = this.findFieldByUtype("Observation.Provenance.DataViewsAndAccess.AccessReference", fields);
            if (locationIndex < 0) {
                locationIndex = this.findFieldByID("LinktoPixels", fields);
            }
            int dataOrgIndex = this.findFieldByID("DataOrganisation", fields);
            int relatedObsIndex = this.findFieldByID("RelatedObservation", fields);
            int obsRefIndex = this.findFieldByID("ObservationReference", fields);
            int numberIndex = this.findFieldByID(NB_OF_PATCHES, fields);
            int mapParamIndex = this.findFieldByID(MAPPARAM, fields);
            int indexingIndex = this.findFieldByID(INDEXING, fields);
            int descIndex = this.findFieldByID("desc", fields);
            for (int i = 0; i < nbTr; ++i) {
                String[] params;
                TDSet tdSet = obsSet.getTDSet(i);
                int nbTD = tdSet.getItemCount();
                String key = tdSet.getContent(0).trim();
                String cutoutVal = tdSet.getContent(dataOrgIndex).trim();
                boolean cutout = cutoutVal.equals(CUTOUT);
                boolean lowerLev = cutoutVal.equals("LOWERLEVEL");
                String location = tdSet.getContent(locationIndex);
                String nbPatch = "";
                if (numberIndex >= 0 && numberIndex < nbTD) {
                    nbPatch = tdSet.getContent(numberIndex).trim();
                }
                String mapParam = "";
                if (mapParamIndex >= 0 && mapParamIndex < nbTD) {
                    mapParam = tdSet.getContent(mapParamIndex).trim();
                }
                String indexing = "";
                if (indexingIndex >= 0 && indexingIndex < nbTD) {
                    indexing = tdSet.getContent(indexingIndex).trim();
                }
                String relatedObs = tdSet.getContent(relatedObsIndex);
                ResourceNode curNode = (ResourceNode)namesToNodes.get(key);
                if (curNode == null) continue;
                ResourceNode newNode = new ResourceNode(this.aladin, curNode);
                if (nbPatch.length() > 0) {
                    newNode.maxImgNumber = nbPatch;
                }
                if (mapParam.length() > 0 && (params = TreeBuilder.split(mapParam, ",")).length == 2) {
                    try {
                        newNode.beginVel = Double.valueOf(params[0]);
                        newNode.velStep = Double.valueOf(params[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (indexing.length() > 0) {
                    newNode.indexing = indexing;
                }
                newNode.cutout = cutout;
                newNode.location = location;
                if (cutoutVal != null && cutoutVal.length() > 0) {
                    newNode.altName = cutoutVal;
                }
                if (cutoutVal.equals("PREVIEW")) {
                    newNode.name = newNode.name + "_PREVIEW";
                }
                if (newNode.cutout) {
                    if (this.targetObjet != null) {
                        newNode.setCutoutTarget(this.targetObjet);
                        newNode.targetObjet = this.targetObjet;
                    } else {
                        newNode.setCutoutTarget(newNode.explanation[newNode.ra] + " " + newNode.explanation[newNode.de], false);
                    }
                }
                newNode.name = cutoutVal;
                if (descIndex >= 0 && descIndex < nbTD) {
                    String desc = tdSet.getContent(descIndex);
                    if (desc != null) {
                        desc = desc.trim();
                    }
                    if (desc.length() > 0) {
                        newNode.name = desc;
                    }
                }
                if (!lowerLev) {
                    curNode.addChild(newNode);
                    curNode.isLeaf = false;
                    newNode.isLeaf = true;
                } else {
                    newNode.description = null;
                    curNode.isLeaf = false;
                    newNode.isLeaf = false;
                    Vector v = (Vector)altNamesToNodes.get(relatedObs);
                    Enumeration e = v.elements();
                    int l = 0;
                    boolean cycle = false;
                    while (e.hasMoreElements()) {
                        ResourceNode n = (ResourceNode)e.nextElement();
                        newNode.addChild(n);
                        if (n == curNode) {
                            cycle = true;
                        }
                        alreadyAdded.addElement(n);
                        n.name = n.name + "-" + ++l;
                    }
                    if (cycle) {
                        System.out.println("cycle detected !");
                        ResourceNode pere = new ResourceNode(this.aladin, curNode);
                        curNode.isLeaf = true;
                        root.addChild(pere);
                        pere.isLeaf = false;
                        pere.addChild(newNode);
                    } else {
                        curNode.addChild(newNode);
                    }
                }
                if (!alreadyAdded.contains(curNode)) {
                    root.addChild(curNode);
                    curNode.isLeaf = false;
                    alreadyAdded.addElement(curNode);
                }
                Enumeration e = root.getChildren();
                while (e.hasMoreElements()) {
                    ((ResourceNode)e.nextElement()).isObs = true;
                }
            }
        }
        if (obsLocationIndex >= 0) {
            Vector v = new Vector();
            BasicTree.getAllNonLeaves(root, v);
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                ResourceNode curNode = (ResourceNode)e.nextElement();
                curNode.explanation[obsLocationIndex] = "";
            }
        }
        return root;
    }

    protected void processGenFeat(SavotResource res, Hashtable nodes, Vector desc) {
        int nbTab = res.getTableCount();
        for (int i = 0; i < nbTab; ++i) {
            SavotField[] fields = this.createDescription(res.getFieldSet(i));
            if (res.getData(i) == null || res.getData(i).getTableData() == null) continue;
            TRSet obsSet = res.getData(i).getTableData().getTRs();
            int nbRows = obsSet.getItemCount();
            for (int j = 0; j < nbRows; ++j) {
                ResourceNode n = this.createSIAPNode((SavotTR)obsSet.getItemAt(j), fields);
                n.name = n.explanation[0];
                nodes.put(n.description[0] + n.name, n);
            }
        }
    }

    private void processSIAPEvolResource(SavotResource res, ResourceNode root) {
        SavotField[] fields = this.createDescription(res.getFieldSet(0));
        if (res.getData(0) == null) {
            return;
        }
        if (res.getData(0).getTableData() == null) {
            return;
        }
        TRSet obsSet = res.getData(0).getTableData().getTRs();
        ResourceNode[] resTab = new ResourceNode[obsSet.getItemCount()];
        for (int i = 0; i < resTab.length; ++i) {
            resTab[i] = this.createSIAPNode((SavotTR)obsSet.getItemAt(i), fields);
            resTab[i].isSIAPEvol = true;
            root.addChild(resTab[i]);
        }
    }

    private ResourceNode buildSIAPVotable() {
        if (this.savotParser == null) {
            return null;
        }
        SavotVOTable vot = this.savotParser.getVOTable();
        this.searchSortOrder(vot);
        ResourceSet rootResSet = vot.getResources();
        ResourceNode root = new ResourceNode(this.aladin, "root");
        root.type = 0;
        SavotResource mainRes = null;
        SavotResource curRes = null;
        for (int i = 0; i < rootResSet.getItemCount(); ++i) {
            curRes = (SavotResource)rootResSet.getItemAt(i);
            if (!curRes.getType().equals("results")) continue;
            mainRes = curRes;
            break;
        }
        if (mainRes == null && (mainRes = curRes) == null) {
            return null;
        }
        this.processSIAPResource(mainRes, root);
        if (this.type == 3) {
            root.type = 3;
        }
        if (this.sortItems != null) {
            MetaDataTree.doSortSiapEvol(this.sortItems, root);
        }
        return root;
    }

    private void processSIAPResource(SavotResource res, ResourceNode root, boolean sort) {
        this.processInfo(res);
        if (res.getTables().getItemCount() == 0) {
            return;
        }
        SavotField[] fields = this.createDescription(res.getFieldSet(0));
        if (res.getData(0) == null) {
            return;
        }
        if (res.getData(0).getTableData() == null) {
            return;
        }
        TRSet obsSet = res.getData(0).getTableData().getTRs();
        ResourceNode[] resTab = new ResourceNode[obsSet.getItemCount()];
        if (sort) {
            ResourceNode curSurvey = null;
            ResourceNode curColor = null;
            for (int i = 0; i < resTab.length; ++i) {
                resTab[i] = this.createSIAPNode((SavotTR)obsSet.getItemAt(i), fields);
                if (curSurvey == null || !resTab[i].survey.equals(curSurvey.name)) {
                    curSurvey = new ResourceNode(this.aladin, resTab[i].survey);
                    curSurvey.type = 1;
                    root.addChild(curSurvey);
                    curColor = null;
                }
                if (curColor == null || !resTab[i].bandPass.equals(curColor.name)) {
                    curColor = new ResourceNode(this.aladin, resTab[i].bandPass);
                    curColor.type = 1;
                    curSurvey.addChild(curColor);
                }
                curColor.addChild(resTab[i]);
            }
        } else {
            Hashtable<String, ResourceNode> colors = new Hashtable<String, ResourceNode>();
            for (int i = 0; i < resTab.length; ++i) {
                ResourceNode parent = root;
                resTab[i] = this.createSIAPNode((SavotTR)obsSet.getItemAt(i), fields);
                if (resTab[i].bandPass != null) {
                    ResourceNode tmp = (ResourceNode)colors.get(resTab[i].bandPass);
                    if (tmp != null) {
                        parent = tmp;
                    } else {
                        parent = new ResourceNode(this.aladin);
                        parent.name = resTab[i].bandPass;
                        parent.type = 1;
                        colors.put(parent.name, parent);
                        root.addChild(parent);
                    }
                }
                parent.addChild(resTab[i]);
            }
        }
    }

    private void processInfo(SavotResource res) {
        InfoSet infos = res.getInfos();
        if (infos.getItemCount() == 0) {
            return;
        }
        SavotInfo qStatusInfo = null;
        for (int i = 0; i < infos.getItemCount(); ++i) {
            SavotInfo curInfo = (SavotInfo)infos.getItemAt(i);
            if (!curInfo.getName().equalsIgnoreCase("QUERY_STATUS")) continue;
            qStatusInfo = curInfo;
            break;
        }
        if (qStatusInfo == null) {
            return;
        }
        String val = qStatusInfo.getValue();
        String content = qStatusInfo.getContent();
        if (!val.equalsIgnoreCase("OK")) {
            this.error = val + ": " + content;
        }
    }

    protected String getError() {
        return this.error;
    }

    private void processSIAPResource(SavotResource res, ResourceNode root) {
        this.processSIAPResource(res, root, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceNode createSIAPNode(SavotTR tr, SavotField[] desc) {
        String cd;
        this.myIndexDE = -1;
        this.myIndexRA = -1;
        boolean cutout = false;
        TDSet tdSet = tr.getTDs();
        int nbTd = tdSet.getItemCount();
        String[] expla = new String[nbTd];
        boolean[] hidden = new boolean[nbTd];
        String[] ucds = new String[nbTd];
        String[] utypes = new String[nbTd];
        String[] allUnits = new String[nbTd];
        String[] descStr = new String[desc.length];
        String[] originalExpla = new String[nbTd];
        String scale = null;
        String naxis = null;
        String imgFormat = null;
        String color = null;
        String survey = null;
        String machine = null;
        String resol = null;
        String plateNumber = null;
        String stcRegion = null;
        String ssaScaleq = null;
        String ssaDimeq = null;
        String ssaUnits = null;
        String ssaAxes = null;
        int index = -1;
        int indexDE = -1;
        int indexRA = -1;
        int indexLocation = -1;
        int indexNaxis = -1;
        int indexScale = -1;
        int indexImgFormat = -1;
        int indexOrigin = -1;
        int idxAngleVal = -1;
        int indexSpatialLocation = -1;
        String[] descId = new String[desc.length];
        String resType = null;
        for (int i = 0; i < desc.length; ++i) {
            String name = desc[i].getName();
            descStr[i] = name.length() > 0 ? name : desc[i].getId();
            descId[i] = desc[i].getId();
            hidden[i] = false;
        }
        for (int i = 0; i < nbTd; ++i) {
            expla[i] = ((SavotTD)tdSet.getItemAt(i)).getContent();
            originalExpla[i] = expla[i];
            try {
                String utype;
                String ucd;
                ucds[i] = ucd = desc[i].getUcd().trim();
                utypes[i] = utype = desc[i].getUtype().trim();
                String strippedUtype = this.stripNSForUtype(utype);
                allUnits[i] = desc[i].getUnit();
                if (ucd.equalsIgnoreCase(SIAP_IMAGE_TITLE) || ucd.equalsIgnoreCase(UCD1P_TITLE) || ucd.equalsIgnoreCase(SIAP_IMAGE_TITLE2) || strippedUtype.equalsIgnoreCase(UTYPE_DATATITLE_SSA)) {
                    index = i;
                    continue;
                }
                if (utype.toLowerCase().endsWith(SSAP_UTYPE_SPATIAL_COVERAGE.toLowerCase())) {
                    indexSpatialLocation = i;
                    String[] coo = Util.split(expla[i], " ");
                    this.alphaVal = new Double(coo[0]);
                    this.deltaVal = new Double(coo[1]);
                    expla[indexSpatialLocation] = this.alphaVal + " " + this.deltaVal;
                    continue;
                }
                if (ucd.equalsIgnoreCase(SIAP_RA) || ucd.equalsIgnoreCase(SIAP_RA_UCD1P) || strippedUtype.equalsIgnoreCase("Char.SpatialAxis.Coverage.Ra")) {
                    indexRA = i;
                    this.alphaVal = new Double(expla[i]);
                    continue;
                }
                if (ucd.equalsIgnoreCase(SIAP_DE) || ucd.equalsIgnoreCase(SIAP_DE_UCD1P) || strippedUtype.equalsIgnoreCase("Char.SpatialAxis.Coverage.Dec")) {
                    indexDE = i;
                    this.deltaVal = new Double(expla[i]);
                    continue;
                }
                if (descId[i].equals(ORIGIN)) {
                    indexOrigin = i;
                    continue;
                }
                if (ucd.equalsIgnoreCase(SIAP_URL) || ucd.equalsIgnoreCase(SIAP_URL2) && indexLocation == -1 || strippedUtype.equalsIgnoreCase(UTYPE_ACREF_SSA)) {
                    indexLocation = i;
                    continue;
                }
                if (indexLocation == -1 && (desc[i].getName().toLowerCase().startsWith("url") || desc[i].getId().toLowerCase().startsWith("url"))) {
                    Aladin.trace(3, "Using field starting with 'url' for location, possible misrespect of SIAP standard");
                    indexLocation = i;
                    continue;
                }
                if (ucd.equalsIgnoreCase(SIAP_SCALE)) {
                    indexScale = i;
                    scale = expla[i];
                    continue;
                }
                if (ucd.equalsIgnoreCase(SIAP_NAXIS)) {
                    indexNaxis = i;
                    naxis = expla[i];
                    continue;
                }
                if (ucd.equalsIgnoreCase(SIAP_IMAGE_FORMAT)) {
                    indexImgFormat = i;
                    imgFormat = expla[i];
                    continue;
                }
                if (desc[i].getId().equalsIgnoreCase(FORMAT) || desc[i].getName().equalsIgnoreCase(FORMAT)) {
                    resType = expla[i];
                    continue;
                }
                if (ucd.equalsIgnoreCase(ESAC_AXES)) {
                    ssaAxes = expla[i];
                    continue;
                }
                if (ucd.equalsIgnoreCase(ESAC_UNITS)) {
                    ssaUnits = expla[i];
                    continue;
                }
                if (ucd.equalsIgnoreCase(ESAC_DIMEQ)) {
                    ssaDimeq = expla[i];
                    continue;
                }
                if (ucd.equalsIgnoreCase(ESAC_SCALEQ)) {
                    ssaScaleq = expla[i];
                    continue;
                }
                if (descId[i].equals("regionSTCS") || descStr[i].equals("stcs") || descStr[i].equals("position_bounds") || utypes[i].equals(UTYPE_STCS_REGION1)) {
                    stcRegion = expla[i];
                    continue;
                }
                if (ucd.equalsIgnoreCase(SIAP_BANDPASS_ID)) {
                    color = expla[i];
                    continue;
                }
                if (desc[i].getId().equalsIgnoreCase(IDSURVEY)) {
                    survey = expla[i];
                    continue;
                }
                if (desc[i].getId().equalsIgnoreCase("Machine_Name")) {
                    machine = expla[i];
                    continue;
                }
                if (desc[i].getId().equalsIgnoreCase("Resolution")) {
                    resol = expla[i];
                    continue;
                }
                if (desc[i].getId().equalsIgnoreCase("PlateNumber")) {
                    plateNumber = expla[i];
                    continue;
                }
                if (desc[i].getId().equalsIgnoreCase("Cutout")) {
                    cutout = expla[i].equals("CUTOUT");
                    continue;
                }
                if (!descId[i].equals("AP") && !descId[i].equals("PA") && !descStr[i].equals("Position Angle")) continue;
                idxAngleVal = i;
                this.angleVal = new Double(expla[i]);
                continue;
            }
            catch (Exception coo) {
                continue;
            }
            finally {
                if (i < desc.length && i != indexSpatialLocation && i != indexRA && i != indexDE && i != indexLocation && i != index) {
                    String unit = desc[i].getUnit();
                    if (expla[i].length() > 0 && unit.length() > 0) {
                        expla[i] = TreeBuilder.getUnit(expla[i], unit);
                    }
                }
            }
        }
        if (indexRA >= 0 && indexDE >= 0 || indexSpatialLocation >= 0) {
            try {
                if (indexSpatialLocation >= 0) {
                    this.frame.set(expla[indexSpatialLocation]);
                } else {
                    this.frame.set(expla[indexRA] + " " + expla[indexDE]);
                }
                this.frame.setPrecision(6);
                String coord = this.frame.toString(":");
                int beginDE = coord.indexOf("+");
                if (beginDE == -1) {
                    beginDE = coord.indexOf("-");
                }
                if (indexSpatialLocation >= 0) {
                    expla[indexSpatialLocation] = coord;
                } else {
                    expla[indexRA] = coord.substring(0, beginDE);
                    expla[indexDE] = coord.substring(beginDE);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.myIndexRA = indexRA;
        this.myIndexDE = indexDE;
        ResourceNode node = new ResourceNode(this.aladin);
        node.type = 1;
        node.server = this.server;
        if (this.objet != null) {
            node.objet = this.objet;
        }
        node.description = descStr;
        node.ra = indexRA;
        node.de = indexDE;
        if (indexOrigin >= 0) {
            node.origin = expla[indexOrigin];
        }
        for (int i = 0; i < descStr.length; ++i) {
            if (!desc[i].getType().equals("hidden")) continue;
            hidden[i] = true;
        }
        node.explanation = expla;
        node.hidden = hidden;
        node.originalExpla = originalExpla;
        node.ucds = ucds;
        node.utypes = utypes;
        node.allUnits = allUnits;
        node.bandPass = color;
        node.survey = survey;
        node.machine = machine;
        node.resol = resol;
        node.plateNumber = plateNumber;
        node.isLeaf = true;
        if (index >= 0) {
            node.name = expla[index];
        }
        if (color == null && node.server != null && node.server.aladinLabel.indexOf("SDSS") >= 0) {
            node.bandPass = this.guessBandIDFromTitle(node.name);
        }
        if (cutout) {
            MetaDataTree cfr_ignored_0 = this.server.tree;
            String target = MetaDataTree.resolveTarget(this.server.getTarget(), this.aladin);
            String coord = null;
            try {
                this.frame.set(target);
                this.frame.setPrecision(6);
                coord = TreeView.getDeciCoord(target).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (coord != null) {
                int beginDE = coord.indexOf("+");
                if (beginDE == -1) {
                    beginDE = coord.indexOf("-");
                }
                this.alphaVal = new Double(coord.substring(0, beginDE));
                this.deltaVal = new Double(coord.substring(beginDE));
            }
        }
        if (node.cutout && this.myIndexRA >= 0 && this.myIndexDE >= 0 && this.targetObjet != null) {
            node.setCutoutTarget(this.targetObjet);
            node.targetObjet = this.targetObjet;
        }
        if (indexLocation >= 0) {
            node.location = expla[indexLocation];
        }
        if (resType == null) {
            resType = node.getFieldValFromUtype("Access.Format");
        }
        if (resType != null && resType.equalsIgnoreCase("catalog")) {
            node.type = 2;
        } else if (resType != null && resType.toLowerCase().startsWith("catalog")) {
            node.type = 2;
        } else if (resType != null && resType.startsWith("spectrum") || this.type == 3) {
            node.type = 3;
            node.format = resType;
        }
        if (ssaAxes != null) {
            node.axes = TreeBuilder.split(ssaAxes, " ");
        }
        if (ssaUnits != null) {
            node.units = TreeBuilder.split(ssaUnits, " ");
        }
        if (ssaDimeq != null) {
            node.dimeq = TreeBuilder.split(ssaDimeq, " ");
        }
        if (ssaScaleq != null) {
            node.scaleq = TreeBuilder.split(ssaScaleq, " ");
        }
        if (indexScale >= 0 && indexNaxis >= 0) {
            String unitScale;
            String[] imScale = TreeBuilder.split(scale, ", ");
            String[] format = TreeBuilder.split(naxis, ", ");
            if (imScale.length == 1) {
                String[] tmp;
                tmp = new String[]{imScale[0], tmp[0]};
                imScale = tmp;
            }
            if (format.length >= 2 && imScale.length >= 2) {
                try {
                    this.xVal = Math.abs(new Double(imScale[0]) * new Double(format[0]));
                    this.yVal = Math.abs(new Double(imScale[1]) * new Double(format[1]));
                }
                catch (NumberFormatException tmp) {
                    // empty catch block
                }
            }
            if ((unitScale = desc[indexScale].getUnit()) != null && unitScale.length() > 0 && imScale.length > 1) {
                expla[indexScale] = TreeBuilder.getUnit(imScale[0], unitScale) + "  " + TreeBuilder.getUnit(imScale[1], unitScale);
                node.setPixSize(TreeBuilder.getUnit(imScale[0], unitScale) + "/pix");
                try {
                    double p = new Double(imScale[0]);
                    p = TreeBuilder.toDegrees(unitScale, p);
                    node.setPixSizeDeg(p);
                }
                catch (Exception p) {
                    // empty catch block
                }
                if (format.length >= 2 && imScale.length >= 2) {
                    try {
                        double p1 = TreeBuilder.toDegrees(unitScale, new Double(imScale[0]));
                        double p2 = TreeBuilder.toDegrees(unitScale, new Double(imScale[1]));
                        this.xVal = Math.abs(p1 * new Double(format[0]));
                        this.yVal = Math.abs(p2 * new Double(format[1]));
                    }
                    catch (Exception p1) {
                        // empty catch block
                    }
                }
            }
        }
        if (indexImgFormat >= 0) {
            node.formats = TreeBuilder.split(imgFormat, ",");
            node.curFormat = node.formats[0];
        }
        if (idxAngleVal == -1 && (cd = node.getFieldValFromUcd("VOX:WCS_CDMatrix")) != null) {
            boolean computeAngle = true;
            String[] cdVal = TreeBuilder.split(cd, " ,");
            double cd11 = 0.0;
            double cd01 = 0.0;
            try {
                cd01 = Double.valueOf(cdVal[1]);
                cd11 = Double.valueOf(cdVal[3]);
            }
            catch (Exception e) {
                computeAngle = false;
            }
            if (computeAngle) {
                this.angleVal = Math.atan2(cd01, cd11) * 180.0 / Math.PI;
                if (Double.isNaN(this.angleVal)) {
                    this.angleVal = 0.0;
                }
            }
        }
        this.setDistanceToCenter(node, this.alphaVal, this.deltaVal);
        this.createFov(node, stcRegion);
        this.setProperties(node);
        return node;
    }

    private void setDistanceToCenter(ResourceNode node, double ra, double dec) {
        if (this.targetObjetCoo != null && !Double.isNaN(ra) && !Double.isNaN(dec)) {
            double dist = Coo.distance(ra, dec, this.targetObjetCoo.al, this.targetObjetCoo.del);
            node.setDistanceToCenter(dist);
        }
    }

    private String guessBandIDFromTitle(String title) {
        int idx = title.lastIndexOf(45);
        return idx != -1 && idx + 1 < title.length() ? title.substring(idx + 1).trim() : null;
    }

    protected static String[] split(String str, String sep) {
        StringTokenizer st = new StringTokenizer(str, sep);
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i] = st.nextToken();
            ++i;
        }
        return ret;
    }

    private ResourceNode buildVotable() {
        if (this.savotParser == null) {
            return null;
        }
        SavotVOTable vot = this.savotParser.getVOTable();
        ResourceSet rootResSet = vot.getResources();
        ResourceNode root = new ResourceNode(this.aladin, "root");
        root.type = 0;
        for (int i = 0; i < rootResSet.getItemCount(); ++i) {
            this.processResource(rootResSet, i, root);
        }
        return root;
    }

    private void processObsGroup(SavotResource sr, ResourceNode parent) {
        int i;
        TRSet trSet = sr.getTRSet(0);
        int nbTR = trSet.getItemCount();
        String[] criteria = new String[nbTR];
        String[] value = new String[nbTR];
        Hashtable<String, String> critVal = new Hashtable<String, String>();
        Hashtable<String, SavotResource> infoVal = new Hashtable<String, SavotResource>();
        SavotResource storageMapping = null;
        SavotResource storedImage = null;
        SavotResource processedObs = null;
        String epoch = null;
        boolean resetWavelength = true;
        for (int i2 = 0; i2 < nbTR; ++i2) {
            TDSet tdSet = trSet.getTDSet(i2);
            criteria[i2] = tdSet.getContent(this.indexCriteria).replace('\"', ' ').trim().toLowerCase();
            value[i2] = tdSet.getContent(this.indexValue);
            critVal.put(criteria[i2], value[i2]);
            if (criteria[i2].equals("filter")) {
                if (value[i2].equals(this.currentColor)) {
                    resetWavelength = false;
                }
                this.currentColor = value[i2];
            }
            if (!criteria[i2].equals("epoch")) continue;
            epoch = value[i2];
        }
        if (resetWavelength) {
            this.currentWavelength = null;
            this.currentFilterName = null;
        }
        if (parent.sortCriteria == null) {
            parent.sortCriteria = criteria;
        }
        ResourceSet set = sr.getResources();
        for (int i3 = 0; i3 < set.getItemCount(); ++i3) {
            SavotResource curRes = (SavotResource)set.getItemAt(i3);
            if (curRes.getName().equalsIgnoreCase(IDIMAGE)) {
                processedObs = curRes;
                continue;
            }
            if (curRes.getName().equalsIgnoreCase(IDMAPPING)) {
                storageMapping = curRes;
                continue;
            }
            if (curRes.getName().equalsIgnoreCase(IDSTORED)) {
                storedImage = curRes;
                continue;
            }
            infoVal.put(curRes.getName().toLowerCase(), curRes);
        }
        TRSet obsSet = processedObs.getData(0).getTableData().getTRs();
        ResourceNode[] resTab = new ResourceNode[obsSet.getItemCount()];
        Hashtable<String, Integer> indexToNode = new Hashtable<String, Integer>();
        double[] xValSave = new double[resTab.length];
        double[] yValSave = new double[resTab.length];
        double[][] xValTabSave = new double[resTab.length][];
        double[][] yValTabSave = new double[resTab.length][];
        double[] alphaValSave = new double[resTab.length];
        double[] deltaValSave = new double[resTab.length];
        double[] angleValSave = new double[resTab.length];
        if (this.imageFieldSet == null) {
            this.imageFieldSet = processedObs.getFieldSet(0);
        }
        SavotField[] desc = this.getDescription(processedObs);
        TRSet trMapping = storageMapping.getData(0).getTableData().getTRs();
        if (this.mappingFieldSet == null) {
            this.mappingFieldSet = storageMapping.getFieldSet(0);
        }
        SavotField[] descMapping = this.getDescription(storageMapping);
        TRSet trStored = storedImage.getData(0).getTableData().getTRs();
        if (this.storedFieldSet == null) {
            this.storedFieldSet = storedImage.getFieldSet(0);
        }
        SavotField[] descStored = this.getDescription(storedImage);
        for (int i4 = 0; i4 < resTab.length; ++i4) {
            resTab[i4] = this.createNode((SavotTR)obsSet.getItemAt(i4), 0, desc, IDIMAGE);
            resTab[i4].criteriaVal = critVal;
            xValSave[i4] = this.xVal;
            yValSave[i4] = this.yVal;
            xValTabSave[i4] = this.xValTab;
            yValTabSave[i4] = this.yValTab;
            alphaValSave[i4] = this.alphaVal;
            deltaValSave[i4] = this.deltaVal;
            angleValSave[i4] = this.angleVal;
            this.yVal = Double.NaN;
            this.xVal = Double.NaN;
            this.deltaVal = Double.NaN;
            this.alphaVal = Double.NaN;
            this.angleVal = Double.NaN;
            this.yValTab = null;
            this.xValTab = null;
            resTab[i4].survey = this.currentSurvey;
            resTab[i4].bandPass = this.currentColor;
            resTab[i4].epoch = epoch;
            if (this.pixSize > 0.0) {
                resTab[i4].setPixSize(TreeBuilder.getUnit(Double.toString(this.pixSize), this.pixSizeUnit) + "/pix");
                try {
                    double p = TreeBuilder.toDegrees(this.pixSizeUnit, this.pixSize);
                    resTab[i4].setPixSizeDeg(p);
                }
                catch (Exception p) {
                    // empty catch block
                }
            }
            indexToNode.put(resTab[i4].name, new Integer(i4));
        }
        int idxNameColumn = this.findFieldByID(OBS_NAME, descMapping);
        if (storageMapping != null && idxNameColumn >= 0) {
            for (i = 0; i < trMapping.getItemCount(); ++i) {
                int intIndexFather;
                ResourceNode fatherSubObs;
                TDSet tds = ((SavotTR)trMapping.getItemAt(i)).getTDs();
                String mapName = ((SavotTD)tds.getItemAt(idxNameColumn)).getContent();
                Integer indexFather = (Integer)indexToNode.get(mapName);
                if (indexFather == null) {
                    indexFather = new Integer(i);
                }
                if ((fatherSubObs = resTab[intIndexFather = indexFather.intValue()]) == null) continue;
                ResourceNode subObs = new ResourceNode(this.aladin);
                subObs.type = fatherSubObs.type;
                subObs.survey = fatherSubObs.survey;
                subObs.origin = fatherSubObs.origin;
                subObs.isLeaf = true;
                fatherSubObs.addChild(subObs);
                for (int j = 0; j < tds.getItemCount(); ++j) {
                    String[] params;
                    String content;
                    SavotTD td = (SavotTD)tds.getItemAt(j);
                    String descStr = descMapping[j].getId();
                    if (descStr.length() == 0) {
                        descStr = descMapping[j].getName();
                    }
                    if (descStr.equalsIgnoreCase("Cutout")) {
                        subObs.name = td.getContent();
                        if (!td.getContent().equals(CUTOUT)) continue;
                        subObs.cutout = true;
                        if (this.myIndexRA < 0 || this.myIndexDE < 0 || this.targetObjet == null) continue;
                        subObs.setCutoutTarget(this.targetObjet);
                        subObs.targetObjet = this.targetObjet;
                        continue;
                    }
                    if (descStr.equalsIgnoreCase("desc")) {
                        subObs.desc = td.getContent();
                        continue;
                    }
                    if (descStr.equalsIgnoreCase(INDEXING)) {
                        subObs.indexing = td.getContent();
                        continue;
                    }
                    if (descStr.equalsIgnoreCase(MAX_SIZE)) {
                        try {
                            this.maxSize = new Double(td.getContent());
                        }
                        catch (NumberFormatException e) {
                            this.maxSize = -1.0;
                        }
                        continue;
                    }
                    if (descStr.equals(RESOLUTION)) {
                        subObs.resol = td.getContent();
                        continue;
                    }
                    if (descStr.equals(NB_OF_PATCHES)) {
                        String maxImg = td.getContent();
                        if (maxImg.length() <= 0) continue;
                        subObs.maxImgNumber = maxImg;
                        continue;
                    }
                    if (!descStr.equals(MAPPARAM) || (content = td.getContent()).trim().length() <= 0 || (params = TreeBuilder.split(content, ",")).length != 2) continue;
                    try {
                        subObs.beginVel = Double.valueOf(params[0]);
                        subObs.velStep = Double.valueOf(params[1]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.xVal = xValSave[intIndexFather];
                this.yVal = yValSave[intIndexFather];
                this.xValTab = xValTabSave[intIndexFather];
                this.yValTab = yValTabSave[intIndexFather];
                this.alphaVal = alphaValSave[intIndexFather];
                this.deltaVal = deltaValSave[intIndexFather];
                this.angleVal = angleValSave[intIndexFather];
                this.pixSize = fatherSubObs.getPixSizeDeg();
                this.createFov(subObs, null);
                this.maxSize = -1.0;
            }
        }
        ResourceNode[] terminalObs = new ResourceNode[trMapping.getItemCount()];
        int idxTerminal = 0;
        for (i = 0; i < resTab.length; ++i) {
            if (resTab[i].nbChildren == 1) {
                ResourceNode curSubObs = (ResourceNode)resTab[i].getChildrenAt(0);
                resTab[i].removeAllChild();
                resTab[i].cutout = curSubObs.cutout;
                resTab[i].targetObjet = curSubObs.targetObjet;
                resTab[i].setCutoutTarget(curSubObs.targetObjet);
                if (resTab[i].cutout && resTab[i].name != null && resTab[i].name.indexOf("CDF-SOUTH") >= 0) {
                    resTab[i].setCutoutTarget(resTab[i].explanation[this.myIndexRA] + " " + resTab[i].explanation[this.myIndexDE], false);
                }
                resTab[i].resol = curSubObs.resol;
                resTab[i].setFov(curSubObs.getFov());
                resTab[i].isLeaf = true;
                terminalObs[idxTerminal++] = resTab[i];
                continue;
            }
            if (resTab[i].nbChildren <= 1) continue;
            Enumeration e = resTab[i].getChildren();
            while (e.hasMoreElements()) {
                terminalObs[idxTerminal++] = (ResourceNode)e.nextElement();
            }
        }
        Hashtable<String, ResourceNode> lowerLevelNodes = new Hashtable<String, ResourceNode>();
        if (storedImage != null) {
            for (int i5 = 0; i5 < trStored.getItemCount(); ++i5) {
                ResourceNode curNode = terminalObs[i5];
                if (curNode == null) continue;
                TDSet tds = ((SavotTR)trStored.getItemAt(i5)).getTDs();
                for (int j = 0; j < tds.getItemCount(); ++j) {
                    String gluLink;
                    String location;
                    SavotTD td = (SavotTD)tds.getItemAt(j);
                    String descStr = descStored[j].getId();
                    if (descStr.length() == 0) {
                        descStr = descStored[j].getName();
                    }
                    if (descStr.equalsIgnoreCase(LOCATION) && (location = td.getContent()) != null && location.length() > 0) {
                        curNode.location = location;
                    }
                    if (!descStr.equalsIgnoreCase(GLULINK) || (gluLink = td.getContent()) == null || gluLink.trim().length() <= 0) continue;
                    curNode.gluLink = gluLink;
                }
                if (!curNode.name.startsWith("LOWERLEVEL")) continue;
                curNode.isLeaf = false;
                lowerLevelNodes.put(curNode.location, curNode);
            }
            if (lowerLevelNodes.size() > 0) {
                this.processLowerLevel(lowerLevelNodes, storedImage, desc);
            }
        }
        this.sortAndCreate(resTab, parent, parent.sortCriteria, infoVal);
    }

    private void processLowerLevel(Hashtable lowLevNodes, SavotResource res, SavotField[] desc) {
        SavotTD td;
        ResourceNode curNode;
        SavotResource obsRes = (SavotResource)res.getResources().getItemAt(0);
        SavotResource mapRes = (SavotResource)res.getResources().getItemAt(1);
        SavotResource storedRes = (SavotResource)res.getResources().getItemAt(2);
        TRSet obsSet = obsRes.getData(0).getTableData().getTRs();
        int nbNodes = obsSet.getItemCount();
        Hashtable<String, ResourceNode> nodes = new Hashtable<String, ResourceNode>();
        for (int i = 0; i < nbNodes; ++i) {
            SavotTR tr = (SavotTR)obsSet.getItemAt(i);
            curNode = this.createNode(tr, 0, desc, IDIMAGE);
            ResourceNode father = (ResourceNode)lowLevNodes.get(curNode.name);
            if (father == null) continue;
            curNode.name = curNode.refNumber;
            curNode.isLeaf = true;
            father.addChild(curNode);
            nodes.put(curNode.name, curNode);
            this.createFov(curNode, null);
        }
        SavotField[] descMapping = this.getDescription(mapRes);
        TRSet trMapping = mapRes.getData(0).getTableData().getTRs();
        int idxNameColumn = this.findFieldByID(OBS_NAME, descMapping);
        if (this.type == 4) {
            idxNameColumn = this.findFieldByID(this.nameSiapEvolStr, descMapping);
        }
        if (mapRes != null && idxNameColumn >= 0) {
            for (int i = 0; i < trMapping.getItemCount(); ++i) {
                TDSet tds = ((SavotTR)trMapping.getItemAt(i)).getTDs();
                String mapName = ((SavotTD)tds.getItemAt(idxNameColumn)).getContent();
                ResourceNode curObs = (ResourceNode)nodes.get(mapName);
                if (curObs == null) continue;
                for (int j = 0; j < tds.getItemCount(); ++j) {
                    String[] params;
                    String content;
                    td = (SavotTD)tds.getItemAt(j);
                    String descStr = descMapping[j].getId();
                    if (descStr.length() == 0) {
                        descStr = descMapping[j].getName();
                        continue;
                    }
                    if (descStr.equalsIgnoreCase("desc")) {
                        curObs.desc = td.getContent();
                        continue;
                    }
                    if (descStr.equalsIgnoreCase(INDEXING)) {
                        curObs.indexing = td.getContent();
                        continue;
                    }
                    if (descStr.equalsIgnoreCase(MAX_SIZE)) {
                        try {
                            this.maxSize = new Double(td.getContent());
                        }
                        catch (NumberFormatException e) {
                            this.maxSize = -1.0;
                        }
                        continue;
                    }
                    if (descStr.equals(RESOLUTION)) {
                        curObs.resol = td.getContent();
                        continue;
                    }
                    if (descStr.equals(NB_OF_PATCHES)) {
                        String maxImg = td.getContent();
                        if (maxImg.length() <= 0) continue;
                        curObs.maxImgNumber = maxImg;
                        continue;
                    }
                    if (!descStr.equals(MAPPARAM) || (content = td.getContent()).trim().length() <= 0 || (params = TreeBuilder.split(content, ",")).length != 2) continue;
                    try {
                        curObs.beginVel = Double.valueOf(params[0]);
                        curObs.velStep = Double.valueOf(params[1]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.maxSize = -1.0;
            }
        }
        if (storedRes != null) {
            TRSet trStored = storedRes.getData(0).getTableData().getTRs();
            SavotField[] descStored = this.getDescription(storedRes);
            for (int i = 0; i < trStored.getItemCount(); ++i) {
                TDSet tds = ((SavotTR)trStored.getItemAt(i)).getTDs();
                String mapName = ((SavotTD)tds.getItemAt(idxNameColumn)).getContent();
                curNode = (ResourceNode)nodes.get(mapName);
                if (curNode == null) continue;
                for (int j = 0; j < tds.getItemCount(); ++j) {
                    String gluLink;
                    String location;
                    td = (SavotTD)tds.getItemAt(j);
                    String descStr = descStored[j].getId();
                    if (descStr.length() == 0) {
                        descStr = descStored[j].getName();
                    }
                    if (descStr.equalsIgnoreCase(LOCATION) && (location = td.getContent()) != null && location.length() > 0) {
                        curNode.location = location;
                    }
                    if (!descStr.equalsIgnoreCase(GLULINK) || (gluLink = td.getContent()) == null || gluLink.trim().length() <= 0) continue;
                    curNode.gluLink = gluLink;
                }
            }
        }
    }

    protected int findFieldByUtype(String utype, SavotField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getUtype().equalsIgnoreCase(utype)) continue;
            return i;
        }
        return -1;
    }

    protected int findFieldByID(String id, SavotField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getId().equalsIgnoreCase(id) && !fields[i].getRef().equalsIgnoreCase(id)) continue;
            return i;
        }
        return -1;
    }

    protected int findValIndex(String[] tab, String val) {
        for (int i = 0; i < tab.length; ++i) {
            if (!tab[i].equals(val)) continue;
            return i;
        }
        return -1;
    }

    protected int findFieldByUCD(String ucd, SavotField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getUcd().equalsIgnoreCase(ucd)) continue;
            return i;
        }
        return -1;
    }

    public static String URLDecode(String encoded) {
        StringBuffer decoded = new StringBuffer();
        int i = 0;
        while (i < encoded.length()) {
            char currentChar = encoded.charAt(i);
            if (currentChar == '+') {
                decoded.append(" ");
                ++i;
                continue;
            }
            if (currentChar == '%') {
                String charCode = encoded.substring(i + 1, i + 3);
                char decodedChar = (char)Integer.parseInt(charCode, 16);
                decoded.append(decodedChar);
                i += 3;
                continue;
            }
            decoded.append(currentChar);
            ++i;
        }
        return decoded.toString();
    }

    private void sortAndCreate(ResourceNode[] tab, ResourceNode parent, String[] criteria, Hashtable info) {
        int i;
        if (tab.length == 0) {
            return;
        }
        Hashtable value = tab[0].criteriaVal;
        ResourceNode curParent = parent;
        String name = null;
        for (i = 0; i < criteria.length; ++i) {
            name = (String)value.get(criteria[i]);
            ResourceNode node = (ResourceNode)curParent.getChild(name);
            if (node == null) {
                SavotResource sr = (SavotResource)info.get(criteria[i]);
                if (sr != null) {
                    node = this.createNode((SavotTR)sr.getData(0).getTableData().getTRs().getItemAt(0), -1, this.getDescription(sr), criteria[i]);
                } else {
                    node = new ResourceNode(this.aladin);
                    node.type = 1;
                }
                node.name = name;
                node.criteria = criteria[i];
                node.valueCriteria = name;
                curParent.addChild(node);
            }
            curParent = node;
        }
        curParent.col = TreeBuilder.getNextColor();
        for (i = 0; i < tab.length; ++i) {
            curParent.addChild(tab[i]);
            tab[i].col = curParent.col;
            if (tab[i].getFov() != null) {
                tab[i].getFov().color = curParent.col;
            }
            tab[i].wavelength = this.currentWavelength;
            if (this.currentFilterName == null || this.currentFilterName.length() <= 0) continue;
            tab[i].wavelengthExpla = this.currentFilterName;
        }
    }

    private void processResource(ResourceSet set, int indexRes, ResourceNode father) {
        SavotResource sr = (SavotResource)set.getItemAt(indexRes);
        if (sr.getType().equals("results")) {
            this.processSIAPResource(sr, father, true);
            return;
        }
        SavotField[] desc = null;
        String id = ((SavotTable)sr.getTables().getItemAt(0)).getId();
        String ref = ((SavotTable)sr.getTables().getItemAt(0)).getRef();
        if (id.length() != 0) {
            if (id.equalsIgnoreCase(IDSURVEY)) {
                this.surveyFieldSet = sr.getFieldSet(0);
            } else if (id.equalsIgnoreCase(IDBAND)) {
                this.bandFieldSet = sr.getFieldSet(0);
            } else if (id.equalsIgnoreCase(IDIMAGE)) {
                this.imageFieldSet = sr.getFieldSet(0);
            }
        } else {
            id = ref;
        }
        desc = this.getDescription(sr);
        if (id.equalsIgnoreCase(IDMAPPING)) {
            return;
        }
        TRSet trSet = sr.getData(0).getTableData().getTRs();
        String nameRes = sr.getName();
        int nbTr = trSet.getItemCount();
        this.nameIndex = nameRes.equalsIgnoreCase(IDBAND) ? 1 : 0;
        ResourceNode newNode = null;
        if (nameRes.equalsIgnoreCase(IDBAND)) {
            this.processObsGroup(sr, father);
            return;
        }
        for (int i = 0; i < nbTr; ++i) {
            newNode = this.createNode((SavotTR)trSet.getItemAt(i), this.nameIndex, desc, nameRes);
            father.addChild(newNode);
        }
        if (id.equalsIgnoreCase(IDSURVEY) && newNode != null) {
            this.currentSurvey = newNode.explanation[0];
        }
        ResourceSet rSet = sr.getResources();
        for (int i = 0; i < rSet.getItemCount(); ++i) {
            this.processResource(rSet, i, newNode);
        }
    }

    private static Color getNextColor() {
        float factor = 0.3f * (float)colorNb + 0.05f;
        ++colorNb;
        return Color.getHSBColor((float)((double)factor - Math.floor(factor)), 0.7f, 1.0f);
    }

    private void createFov(ResourceNode node, String stcRegion) {
        boolean isSpectra;
        boolean bl = isSpectra = node.type == 3;
        if (!(this.xValTab != null && this.yValTab != null || !Double.isNaN(this.xVal) && !Double.isNaN(this.yVal) || isSpectra || stcRegion != null)) {
            return;
        }
        if (Double.isNaN(this.angleVal)) {
            this.angleVal = 0.0;
        }
        if (stcRegion != null) {
            STCStringParser parser = new STCStringParser();
            List<STCObj> stcObjs = parser.parse(stcRegion);
            node.setFov(new Fov(stcObjs));
        } else if (this.xValTab != null && this.yValTab != null) {
            node.setFov(new Fov(this.alphaVal, this.deltaVal, this.xValTab, this.yValTab, this.angleVal, this.xVal, this.yVal));
        } else if (isSpectra) {
            node.setFov(new Fov(this.alphaVal, this.deltaVal, this.angleVal));
        } else {
            node.setFov(new Fov(this.alphaVal, this.deltaVal, this.xVal, this.yVal, this.angleVal));
        }
        this.yVal = Double.NaN;
        this.xVal = Double.NaN;
        this.deltaVal = Double.NaN;
        this.alphaVal = Double.NaN;
        this.angleVal = Double.NaN;
        this.yValTab = null;
        this.xValTab = null;
        if (node.getParent() != null) {
            node.getFov().color = ((ResourceNode)node.getParent()).col;
        }
        if (node.cutout) {
            node.getFov().cutout_x = node.getFov().cutout_y = this.maxSize * this.pixSize;
        }
    }

    private SavotField[] getDescription(SavotResource sr) {
        SavotField[] desc;
        String id = ((SavotTable)sr.getTables().getItemAt(0)).getId();
        String ref = ((SavotTable)sr.getTables().getItemAt(0)).getRef();
        if (id.length() != 0) {
            desc = this.createDescription(sr.getFieldSet(0));
            this.fieldSetMapping.put(id, desc);
        } else {
            desc = (SavotField[])this.fieldSetMapping.get(ref);
        }
        return desc;
    }

    protected SavotField[] createDescription(FieldSet fs) {
        int nb = fs.getItemCount();
        SavotField[] desc = new SavotField[nb];
        for (int i = 0; i < nb; ++i) {
            SavotField tmp;
            desc[i] = (SavotField)fs.getItemAt(i);
            String id = desc[i].getId();
            String ref = desc[i].getRef();
            if (id.length() == 0 && ref.length() > 0 && (tmp = (SavotField)this.fieldsPool.get(ref)) != null) {
                desc[i] = tmp;
                continue;
            }
            if (id.length() <= 0) continue;
            this.fieldsPool.put(id, desc[i]);
        }
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceNode createNode(SavotTR tr, int index, SavotField[] desc, String resourceName) {
        this.myIndexDE = -1;
        this.myIndexRA = -1;
        TDSet tdSet = tr.getTDs();
        int nbTd = tdSet.getItemCount();
        String[] expla = new String[nbTd];
        String[] descStr = new String[desc.length];
        String[] originalExpla = new String[nbTd];
        double yLim = 0.0;
        double xLim = 0.0;
        int indexDE = -1;
        int indexRA = -1;
        int indexImgFormat = -1;
        int indexPosAng = -1;
        int indexDate = -1;
        int indexProcModes = -1;
        int indexOrigin = -1;
        int indexMachine = -1;
        int indexResType = -1;
        int indexRefNb = -1;
        String[] descId = new String[desc.length];
        for (int i = 0; i < desc.length; ++i) {
            String name = desc[i].getName();
            descStr[i] = name.length() > 0 ? name : desc[i].getId();
            descId[i] = desc[i].getId();
        }
        for (int i = 0; i < nbTd; ++i) {
            expla[i] = ((SavotTD)tdSet.getItemAt(i)).getContent();
            originalExpla[i] = expla[i];
            try {
                int k;
                String[] split;
                if (descId[i].equals("PixelSize")) {
                    this.pixSize = Math.abs(new Double(expla[i]));
                    this.pixSizeUnit = desc[i].getUnit();
                }
                if (descId[i].equals("Size_alpha")) {
                    this.xVal = Math.abs(new Double(expla[i]));
                    continue;
                }
                if (descId[i].equals("Size_delta")) {
                    this.yVal = Math.abs(new Double(expla[i]));
                    continue;
                }
                if (descId[i].equals("alpha")) {
                    this.alphaVal = new Double(expla[i]);
                    indexRA = i;
                    continue;
                }
                if (descId[i].equals("delta")) {
                    this.deltaVal = new Double(expla[i]);
                    indexDE = i;
                    continue;
                }
                if (descId[i].equals("AP") || descStr[i].equals("Position Angle")) {
                    indexPosAng = i;
                    this.angleVal = new Double(expla[i]);
                    continue;
                }
                if (descId[i].equals("XLim")) {
                    split = TreeBuilder.split(expla[i], ", ");
                    if (split.length == 1) {
                        xLim = new Double(expla[i]);
                        continue;
                    }
                    this.xValTab = new double[split.length];
                    for (k = 0; k < split.length; ++k) {
                        this.xValTab[k] = new Double(split[k]) / 2.0;
                    }
                    continue;
                }
                if (descId[i].equals("YLim")) {
                    split = TreeBuilder.split(expla[i], ", ");
                    if (split.length == 1) {
                        yLim = new Double(expla[i]);
                        continue;
                    }
                    this.yValTab = new double[split.length];
                    for (k = 0; k < split.length; ++k) {
                        this.yValTab[k] = new Double(split[k]) / 2.0;
                    }
                    continue;
                }
                if (descId[i].equals(AVAILABLE_CODINGS)) {
                    indexImgFormat = i;
                    continue;
                }
                if (descId[i].equals(AVAILABLE_PROCESSINGS)) {
                    indexProcModes = i;
                    continue;
                }
                if (descId[i].equals(MACHINE)) {
                    indexMachine = i;
                    continue;
                }
                if (descId[i].equals(ORIGIN)) {
                    indexOrigin = i;
                    continue;
                }
                if (descId[i].equals(OBS_DATE)) {
                    indexDate = i;
                    continue;
                }
                if (descId[i].endsWith("wavelength") && expla[i].length() > 0) {
                    if (descId[i].equals("Effective_wavelength")) {
                        this.currentWavelength = TreeBuilder.getUnit(expla[i], desc[i].getUnit());
                        continue;
                    }
                    if (this.currentWavelength != null) continue;
                    this.currentWavelength = TreeBuilder.getUnit(expla[i], desc[i].getUnit());
                    continue;
                }
                if (descId[i].equals(FILTER_NAME)) {
                    this.currentFilterName = expla[i];
                    continue;
                }
                if (descId[i].equalsIgnoreCase(RESTYPE)) {
                    indexResType = i;
                    continue;
                }
                if (!descId[i].equalsIgnoreCase("ReferenceNumber")) continue;
                indexRefNb = i;
                continue;
            }
            catch (Exception split) {
                continue;
            }
            finally {
                if (i < desc.length && i != indexRA && i != indexDE && i != index) {
                    String unit = desc[i].getUnit();
                    if (expla[i].length() > 0 && unit.length() > 0) {
                        expla[i] = i != indexPosAng ? TreeBuilder.getUnit(expla[i], unit) : TreeBuilder.floor(this.angleVal, 2, 3) + TreeBuilder.getUnit(unit);
                    }
                }
            }
        }
        if (indexRA >= 0 && indexDE >= 0) {
            try {
                this.frame.set(expla[indexRA] + " " + expla[indexDE]);
                this.frame.setPrecision(6);
                String coord = this.frame.toString(":");
                int beginDE = coord.indexOf("+");
                if (beginDE == -1) {
                    beginDE = coord.indexOf("-");
                }
                expla[indexRA] = coord.substring(0, beginDE);
                expla[indexDE] = coord.substring(beginDE);
            }
            catch (Exception coord) {
                // empty catch block
            }
        }
        ResourceNode node = new ResourceNode(this.aladin);
        node.type = 1;
        node.server = this.server;
        if (this.objet != null) {
            node.objet = this.objet;
        }
        node.description = descStr;
        node.explanation = expla;
        node.originalExpla = originalExpla;
        node.ra = indexRA;
        node.de = indexDE;
        if (xLim != 0.0 && yLim != 0.0) {
            this.xVal = Math.abs(2.0 * xLim);
            this.yVal = Math.abs(2.0 * yLim);
        }
        if (index >= 0) {
            node.name = expla[index];
        }
        this.myIndexRA = indexRA;
        this.myIndexDE = indexDE;
        if (indexImgFormat >= 0) {
            node.formats = TreeBuilder.split(expla[indexImgFormat], " ");
            if (node.formats != null && node.formats.length > 0) {
                node.curFormat = node.formats[0];
            }
        }
        if (indexProcModes >= 0) {
            node.modes = TreeBuilder.split(expla[indexProcModes], " ");
            if (node.modes != null && node.modes.length > 0) {
                node.curMode = node.modes[0];
            }
            if (node.modes != null && node.modes.length > 1 && this.targetObjet != null) {
                node.setMosaicTarget(this.targetObjet);
                node.targetObjet = this.targetObjet;
            }
        }
        if (indexMachine >= 0) {
            node.machine = expla[indexMachine];
        }
        if (indexOrigin >= 0) {
            node.origin = expla[indexOrigin];
        }
        if (indexDate >= 0) {
            node.obsDate = expla[indexDate];
        }
        if (indexResType >= 0) {
            if (expla[indexResType].equalsIgnoreCase("SPECTRUM")) {
                node.type = 3;
            } else if (expla[indexResType].equalsIgnoreCase("CUBE")) {
                node.type = 4;
            }
        }
        if (indexRefNb >= 0) {
            node.refNumber = expla[indexRefNb];
        }
        for (int i = 0; i < descStr.length; ++i) {
            if (!desc[i].getType().equals("hidden")) continue;
            expla[i] = "";
        }
        return node;
    }

    private void setProperties(ResourceNode node) {
        if (node == null) {
            return;
        }
        node.properties = new Hashtable();
        node.propertiesUnits = new Hashtable();
        for (int i = 0; i < node.description.length; ++i) {
            String s = node.description[i];
            if (s == null) continue;
            try {
                node.properties.put(s, node.originalExpla[i]);
                node.propertiesUnits.put(s, node.allUnits[i]);
                continue;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
        node.isObs = true;
    }

    protected static String getUnit(String angleStr, String unit) {
        double x;
        if (unit == null) {
            return angleStr;
        }
        try {
            x = new Double(angleStr);
        }
        catch (NumberFormatException e) {
            return angleStr + unit;
        }
        if (Double.isNaN(x)) {
            return x + "";
        }
        try {
            x = TreeBuilder.toDegrees(unit, x);
        }
        catch (Exception e) {
            x = TreeBuilder.floor(x, 1, 3);
            return x + unit;
        }
        String s = null;
        if (Math.abs(x) >= 1.0) {
            s = "deg";
        }
        if (Math.abs(x) < 1.0) {
            s = "arcmin";
            x *= 60.0;
        }
        if (Math.abs(x) < 1.0) {
            s = "arcsec";
            x *= 60.0;
        }
        x = TreeBuilder.floor(x, 1, 3);
        s = x + TreeBuilder.getUnit(s);
        return s;
    }

    private static double floor(double d, int nbDec1, int nbDec2) {
        double fact = 1.0;
        int nbDec = Math.abs(d) > 1.0 ? nbDec1 : nbDec2;
        for (int i = 0; i < nbDec; ++i) {
            fact *= 10.0;
        }
        return Math.ceil(d * fact) / fact;
    }

    protected static double toDegrees(String unitDes, double value) throws Exception {
        if (unitDes.equalsIgnoreCase("deg")) {
            value /= 1.0;
        } else if (unitDes.equalsIgnoreCase("arcmin")) {
            value /= 60.0;
        } else if (unitDes.equalsIgnoreCase("arcsec")) {
            value /= 3600.0;
        } else {
            throw new Exception("Unknown unit");
        }
        return value;
    }

    private static String getUnit(String unit) {
        if (unit.equalsIgnoreCase("deg")) {
            return "\u00b0";
        }
        if (unit.equalsIgnoreCase("arcmin")) {
            return "'";
        }
        if (unit.equalsIgnoreCase("arcsec")) {
            return "\"";
        }
        return unit;
    }

    protected void searchSortOrder(SavotVOTable vot) {
        ParamSet params = vot.getParams();
        int nbParam = params.getItemCount();
        for (int i = 0; i < nbParam; ++i) {
            SavotParam param = (SavotParam)params.getItemAt(i);
            if (!param.getName().equalsIgnoreCase("SORTORDER")) continue;
            String value = param.getValue();
            if (value != null && value.length() > 0) {
                this.sortItems = TreeBuilder.split(param.getValue(), " ");
            }
            return;
        }
    }
}

