/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.Cote;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanContour;
import cds.aladin.PlanHips;
import cds.aladin.PlanHips3D;
import cds.aladin.PlanImageBlink;
import cds.aladin.PlanMoc;
import cds.aladin.RepereSpectrum;
import cds.aladin.Slide;
import cds.aladin.SourceStat;
import cds.aladin.SwingWidgetFinder;
import cds.aladin.Tag;
import cds.aladin.Tool;
import cds.aladin.ViewSimple;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class ToolBox
extends JComponent
implements MouseMotionListener,
MouseListener,
SwingWidgetFinder,
Widget {
    static int NUMBERTOOL = 0;
    static final int SELECT = 0;
    static final int DRAW = 1;
    static final int TAG = 2;
    static final int PHOT = 3;
    static final int DIST = 4;
    static final int DEL = 5;
    static final int WEN = 6;
    static final int PROP = 7;
    static final int PAN = 8;
    public static final int HIST = 9;
    static final int BNOTE = 10;
    static final int RGB = 11;
    static final int CONTOUR = 12;
    static final int FILTER = 13;
    static final int SYNC = 14;
    static final int BLINK = 15;
    static final int ZOOM = 16;
    static final int XMATCH = 17;
    static final int RESAMP = 18;
    static final int CROP = 19;
    static final int PLOT = 20;
    static final int SPECT = 21;
    static final int MOC = 22;
    static int NBTOOL = 23;
    private int[] drawn = new int[]{0, 8, 4, 3, 1, 2, 22, 21, 13, 17, 20, 11, 15, 19, 12, 9, 7, 5};
    static int[] OUTREACHDRAWN = new int[]{0, 8, 4, 3, 1, 2, 12, 9, 7, 5};
    static int[] to = new int[]{19, 0, 1, 2, 3, 4, 8, 7, 16, 21};
    static int[] exc = new int[]{19, 0, 1, 2, 3, 4, 8, 16, 21};
    static int[] forTool = new int[]{1, 2, 3, 4, 21};
    static int[] up = new int[]{10, 5, 7, 13, 20};
    static int[] imgmode = new int[]{20};
    static int[] imghugemode = new int[]{11, 15, 6, 20};
    static int[] contourmode = new int[]{9, 1, 2, 3, 4, 19, 20};
    static int[] toolmode = new int[]{9, 19, 20};
    static int[] catmode = new int[]{9, 19};
    static int[] fieldmode = new int[]{9, 19, 20};
    static int[] viewplotmode = new int[]{4, 2, 3, 1, 21, 19};
    private int W;
    private int HMIN;
    private int HREC;
    private int L;
    private int ICONEGAP;
    String ICONEBAR;
    String DRAWING;
    Aladin aladin;
    Calque calque;
    int ws;
    int hs;
    int nc;
    int nb;
    int H;
    public Tool[] tool;
    boolean flagDelAll;
    private boolean firstTag = true;
    private boolean firstRepere = true;
    private int oc = 0;
    private int lastTipShown = -1;
    private Timer timerTip = null;
    private int currentButton = -1;
    private int oldCurrentButton = -1;
    private WidgetControl voc = null;

    protected ToolBox(Aladin aladin) {
        this.aladin = aladin;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.ICONEBAR = Aladin.chaine.getString("TBBAR");
        this.DRAWING = Aladin.chaine.getString("TBDRAW");
        double scale = (double)(Aladin.getUIScale() - 1.0f) / 1.5 + 1.0;
        this.W = (int)(34.0 * scale);
        this.HMIN = this.W - (int)(5.0 * scale);
        this.HREC = this.W + (int)(2.0 * scale);
        this.L = (int)(3.0 * scale);
        this.ICONEGAP = (int)(12.0 * scale);
        this.ws = this.W;
        this.hs = 600;
        this.calcConf(500 - this.ICONEGAP);
        this.init();
    }

    protected void init() {
        this.tool = new Tool[NBTOOL];
        for (int i = 0; i < NBTOOL; ++i) {
            this.tool[i] = new Tool(i, this.aladin);
        }
    }

    protected int getTool() {
        for (int i = 0; i < to.length; ++i) {
            if (this.tool[ToolBox.to[i]].mode != -1) continue;
            return to[i];
        }
        return -1;
    }

    protected Obj newTool(Plan plan, ViewSimple v, double x, double y) {
        int tool = this.getTool();
        switch (tool) {
            case 1: {
                Ligne ligne = new Ligne(plan, v, x, y);
                ligne.bout = (byte)4;
                return ligne;
            }
            case 2: {
                if (this.firstTag && this.aladin.configuration.isHelp() && this.aladin.configuration.showHelpIfOk("TAGINFO")) {
                    this.firstTag = false;
                    return null;
                }
                return new Tag(plan, v, x, y);
            }
            case 3: {
                if (this.firstRepere && this.aladin.configuration.isHelp() && this.aladin.calque.getPlanBase().hasAvailablePixels() && this.aladin.configuration.showHelpIfOk("REPEREINFO")) {
                    this.firstRepere = false;
                    return null;
                }
                SourceStat r = new SourceStat(plan, v, x, y, null);
                return r;
            }
            case 21: {
                RepereSpectrum rep = new RepereSpectrum(plan, v, x, y);
                return rep;
            }
            case 4: {
                return new Cote(plan, v, x, y);
            }
        }
        return null;
    }

    protected void setMode(int i, int mode) {
        if (this.tool[i].mode == mode) {
            return;
        }
        this.tool[i].mode = mode;
        this.repaint();
    }

    protected void setGraphicButton(int n) {
        this.tool[21].mode = 1;
        this.tool[8].mode = 1;
        this.tool[0].mode = 1;
        this.tool[4].mode = 1;
        this.tool[3].mode = 1;
        this.tool[2].mode = 1;
        this.tool[1].mode = 1;
        this.tool[n].mode = -1;
        this.repaint();
    }

    protected void toolMode() {
        this.toolMode(true);
    }

    protected void toolMode(boolean withRepaint) {
        Plan p;
        ViewSimple v;
        int j;
        int i;
        Plan[] allPlan = this.aladin.calque.getPlans();
        int[] omode = new int[NBTOOL];
        int[] mode = new int[NBTOOL];
        int[] ex = new int[]{};
        boolean aucun = true;
        boolean dorepaint = false;
        int nbSimpleImg = 0;
        int nbBlinkImg = 0;
        int nbSimpleCat = 0;
        int nbMoc = 0;
        int nbCat = 0;
        this.aladin.setMemory();
        for (i = 0; i < omode.length; ++i) {
            omode[i] = this.tool[i].mode;
            mode[i] = 0;
        }
        for (i = 0; i < allPlan.length; ++i) {
            if (allPlan[i].type == 0 || !allPlan[i].flagOk) continue;
            if (allPlan[i].isPixel() && allPlan[i].isSimpleImage()) {
                ++nbSimpleImg;
            }
            if (allPlan[i] instanceof PlanImageBlink) {
                ++nbBlinkImg;
            }
            if (allPlan[i].type == 8) {
                ++nbSimpleCat;
            }
            if (allPlan[i].isCatalog()) {
                ++nbCat;
            }
            if (allPlan[i].isMoc()) {
                ++nbMoc;
            }
            aucun = false;
            if (!allPlan[i].selected) continue;
            switch (allPlan[i].type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 16: 
                case 20: {
                    ex = imgmode;
                    break;
                }
                case 15: {
                    ex = imghugemode;
                    break;
                }
                case 8: 
                case 18: {
                    ex = catmode;
                    break;
                }
                case 9: {
                    ex = toolmode;
                    break;
                }
                case 10: {
                    ex = fieldmode;
                    break;
                }
                case 13: {
                    ex = fieldmode;
                    break;
                }
                case 12: {
                    ex = contourmode;
                }
            }
            if (allPlan[i] instanceof PlanContour) {
                ex = contourmode;
            }
            for (j = 0; j < mode.length; ++j) {
                boolean flagEx = false;
                for (int k = 0; k < ex.length; ++k) {
                    if (j != ex[k]) continue;
                    flagEx = true;
                    break;
                }
                if (flagEx) continue;
                mode[j] = 1;
            }
        }
        if (nbCat == 0) {
            mode[13] = 0;
        }
        if (nbSimpleCat < 1) {
            mode[17] = 0;
        }
        if (nbSimpleImg < 2) {
            mode[15] = 0;
            mode[18] = 0;
            mode[11] = 0;
        }
        if (nbMoc < 1) {
            mode[22] = 0;
        }
        if ((v = this.aladin.view.getCurrentView()) == null || v.isFree() || !v.pref.isPixel()) {
            mode[12] = 0;
        }
        if (v == null || v.isFree() || v.pref.type != 4 && !(v.pref instanceof PlanHips3D)) {
            mode[21] = 0;
        }
        if (this.aladin.calque.getFirstSelectedPlan() instanceof PlanMoc) {
            mode[19] = 1;
        }
        if (this.aladin.view.hasOnlyPlotView()) {
            for (j = 0; j < viewplotmode.length; ++j) {
                mode[j] = 0;
            }
        }
        if ((p = this.aladin.calque.getFirstSelectedPlan()) == null || !p.isPixel() && p.type != 2 && p.type != 16) {
            mode[9] = 0;
        }
        if (v != null && !v.isFree() && (v.pref instanceof PlanHips || v.northUp)) {
            mode[6] = 0;
        }
        if (aucun) {
            for (i = 0; i < mode.length; ++i) {
                mode[i] = 0;
            }
        }
        if (!this.aladin.calque.isFree()) {
            mode[5] = 1;
            mode[7] = 1;
        }
        for (i = 0; i < mode.length; ++i) {
            if (mode[i] == 1 && omode[i] == -1) {
                mode[i] = -1;
            }
            if (mode[i] != omode[i]) {
                dorepaint = true;
            }
            this.tool[i].setMode(mode[i]);
        }
        if (!aucun) {
            boolean trouve = false;
            for (i = 0; i < exc.length; ++i) {
                if (mode[exc[i]] != -1) continue;
                trouve = true;
            }
            if (!trouve) {
                this.tool[0].setMode(-1);
                dorepaint = true;
            }
        }
        if (withRepaint && dorepaint) {
            this.repaint();
        }
        this.postAction();
    }

    protected void postAction() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolBox.this.aladin.calque.select.hideMessageError();
            }
        });
    }

    protected boolean isExcTool(int n) {
        for (int i = 0; i < exc.length; ++i) {
            if (n != exc[i]) continue;
            return true;
        }
        return false;
    }

    protected static boolean isForTool(int n) {
        for (int i = 0; i < forTool.length; ++i) {
            if (n != forTool[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int y;
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
            return;
        }
        int x = e.getX();
        int i = this.getToolNumber(x, y = e.getY());
        if (i < 0) {
            return;
        }
        if (i == 19) {
            if (this.tool[i].mode != -1) {
                if (this.aladin.view.crop != null) {
                    this.aladin.view.crop.setVisible(false);
                } else if (this.aladin.view.crop != null) {
                    this.aladin.view.crop.reset();
                }
            }
            this.aladin.view.repaintAll();
        }
        if (i != 9 && i != 14 && i != 17 && this.tool[i].mode != -1) {
            return;
        }
        switch (i) {
            case 7: {
                if (this.aladin.view.isPropObjet()) {
                    this.aladin.view.propSelectedObj();
                    break;
                }
                this.aladin.calque.select.propertiesOfSelectedPlanes();
                break;
            }
            case 9: {
                this.aladin.updatePixel();
                break;
            }
            case 11: {
                this.aladin.updateRGB();
                break;
            }
            case 22: {
                this.aladin.updateMocOperation();
                break;
            }
            case 15: {
                this.aladin.updateBlink(0);
                break;
            }
            case 17: {
                if (this.tool[i].mode == -1) {
                    this.aladin.xmatch();
                    break;
                }
                if (this.aladin.frameCDSXMatch == null) break;
                this.aladin.frameCDSXMatch.setVisible(false);
                break;
            }
            case 20: {
                if (this.tool[i].mode != -1) break;
                this.aladin.createPlotCat();
                break;
            }
            case 12: {
                this.aladin.updateContour();
                break;
            }
            case 13: {
                this.aladin.filter();
                break;
            }
            case 5: {
                if (this.aladin.view.isDelSelObjet()) {
                    this.aladin.view.delSelObjet();
                    break;
                }
                if (e.isShiftDown()) {
                    this.aladin.reset();
                    this.tool[5].setMode(0);
                    this.aladin.console.printCommand("reset");
                    break;
                }
                if (this.aladin.view.isViewSelected() && this.aladin.view.isMultiView()) {
                    this.aladin.view.freeSelected();
                    this.aladin.dialog.resume();
                    this.aladin.calque.repaintAll();
                    break;
                }
                this.aladin.calque.FreeSet(true);
                this.aladin.dialog.resume();
            }
        }
        for (int j = 0; j < up.length; ++j) {
            if (up[j] != i) continue;
            this.tool[i].Push();
            break;
        }
        this.handCursor();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y;
        int x = e.getX();
        int i = this.getToolNumber(x, y = e.getY());
        if (i < 0) {
            return;
        }
        if (this.tool[i].mode == 0) {
            return;
        }
        this.waitCursor();
        if (this.isExcTool(i)) {
            for (int j = 0; j < exc.length; ++j) {
                if (exc[j] == i || this.tool[ToolBox.exc[j]].mode != -1) continue;
                this.tool[exc[j]].setMode(1);
            }
        }
        this.tool[i].Push();
        this.repaint();
    }

    private void handCursor() {
        this.makeCursor(2);
    }

    private void waitCursor() {
        this.makeCursor(1);
    }

    private void defaultCursor() {
        this.makeCursor(0);
    }

    private void makeCursor(int c) {
        if (this.oc == c) {
            return;
        }
        if (Aladin.makeCursor(this, c)) {
            this.oc = c;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.oc = -1;
        int i = this.getTool();
        this.showCurrentButton(-1);
        if (i == 16 || i == 2) {
            this.setMode(i, 1);
            this.setMode(0, -1);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.oc = -1;
        this.currentButton = -1;
        if (this.timerTip != null) {
            this.timerTip.stop();
            this.timerTip = null;
        }
        Aladin.makeCursor(this, 0);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.aladin.inHelp) {
            int n = y >= this.hs - 2 * this.L ? -2 : this.getToolNumber(x, y);
            this.aladin.help.setText(this.Help(n));
            return;
        }
        int i = this.getToolNumber(x, y);
        if (i < 0) {
            return;
        }
        if (this.timerTip == null) {
            this.timerTip = new Timer(6000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolBox.this.showTip();
                }
            });
        }
        this.timerTip.restart();
        if (this.tool[i].mode != 0) {
            this.handCursor();
        } else {
            this.defaultCursor();
        }
        String s = this.tool[i].getInfo();
        Util.toolTip(this, Util.fold(s, 20, true));
        this.showCurrentButton(i);
    }

    private void showTip() {
        if (this.lastTipShown == this.currentButton) {
            return;
        }
        String key = "Tool." + Tool.label[this.currentButton];
        String tip = Aladin.chaine.getString(key);
        if (!Aladin.BETA && tip.startsWith("[")) {
            return;
        }
        this.aladin.calque.select.setMessageTip(null, tip);
        Util.toolTip(this, null);
        this.lastTipShown = this.currentButton;
    }

    protected int getToolNumber(int x, int y) {
        for (int i = 0; i < this.drawn.length; ++i) {
            if (!this.tool[this.drawn[i]].in(x, y)) continue;
            return this.drawn[i];
        }
        return -1;
    }

    private int getToolOrder(int number) {
        for (int order = 0; order < this.drawn.length; ++order) {
            if (this.drawn[order] != number) continue;
            return order;
        }
        return -1;
    }

    protected void drawButton(int order, int number, Graphics g, boolean currentButton) {
        Plan p;
        int x = order / this.nb * this.W;
        int y = order % this.nb * this.H;
        this.tool[number].drawIcone(g, x, y, currentButton);
        if (number == 20 && this.tool[number].mode != 0 && (p = this.aladin.calque.getFirstSelectedPlan()).hasSources() && p.isTime()) {
            Slide.drawClock(g, x + 11, y + 15, 4, Color.black, Color.white);
        }
    }

    protected void calcConf(int hs) {
        int nbtoolParCol = 0;
        int nbtool = this.drawn.length;
        this.nc = 1;
        while (this.nc < 50) {
            nbtoolParCol = nbtool / this.nc;
            if (nbtool % this.nc != 0) {
                ++nbtoolParCol;
            }
            this.H = hs / nbtoolParCol;
            if (this.H >= this.HMIN) break;
            ++this.nc;
        }
        this.H = this.HREC;
        while (this.H > this.HMIN && this.H * nbtoolParCol >= hs) {
            --this.H;
        }
        this.nb = hs / this.H;
        if (this.nb < 1) {
            this.nb = 1;
            hs = this.H;
        }
        this.ws = this.ws = this.nc * this.W;
        this.hs = hs + this.ICONEGAP;
        super.setSize(this.ws, hs + this.ICONEGAP);
        Tool.resize(this.W, this.H);
    }

    private void showCurrentButton(int i) {
        if (this.oldCurrentButton == i) {
            return;
        }
        Graphics g = this.getGraphics();
        if (this.oldCurrentButton >= 0) {
            this.drawButton(this.getToolOrder(this.oldCurrentButton), this.oldCurrentButton, g, false);
        }
        this.oldCurrentButton = this.currentButton = i;
        if (this.currentButton >= 0) {
            this.drawButton(this.getToolOrder(this.currentButton), this.currentButton, g, true);
        }
    }

    @Override
    public void setSize(int width, int height) {
        this.calcConf(height - this.ICONEGAP);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getSize().width != this.ws || this.getSize().height != this.hs) {
            this.calcConf(this.getSize().height - this.ICONEGAP);
        }
        this.aladin.setAliasing(g);
        for (int i = 0; i < this.drawn.length; ++i) {
            this.drawButton(i, this.drawn[i], g, this.currentButton == i);
        }
        this.showCurrentButton(this.currentButton);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.ws, this.hs);
    }

    protected String Help(int n) {
        if (n == -1) {
            return Aladin.chaine.getString("ToolBox.HELP1");
        }
        if (n == -2) {
            return Aladin.chaine.getString("ToolBox.HELP2");
        }
        return Aladin.chaine.getString("ToolBox.HELP1") + "\n!Tool: " + Tool.label[n] + "\n" + Aladin.chaine.getString("Tool." + Tool.label[n]) + "\n";
    }

    @Override
    public boolean findWidget(String name) {
        return name.equalsIgnoreCase("contour") || name.equalsIgnoreCase("filter") || name.equalsIgnoreCase("rgb");
    }

    @Override
    public Point getWidgetLocation(String name) {
        for (int i = 0; i < this.drawn.length; ++i) {
            if (!name.equalsIgnoreCase(this.tool[this.drawn[i]].nom)) continue;
            return this.tool[this.drawn[i]].getWidgetLocation();
        }
        return new Point(0, 0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetControl(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics g) {
        Tool.drawVOPointer(g, 10, 5);
    }

    @Override
    public boolean onNothing(MouseEvent e) {
        return false;
    }
}

