/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.aladin.PlanHips;
import cds.aladin.PlanHipsRgb;
import cds.aladin.PlanImage;
import cds.aladin.Tile;
import cds.aladin.ViewSimple;
import cds.fits.Fits;
import cds.hipsgen.BuilderRgb;
import cds.hipsgen.TabRgb;
import cds.tools.Util;
import cds.tools.pixtools.Addr;
import java.awt.image.IndexColorModel;

public class TileRgb
extends Tile {
    protected Tile[] cmp;
    private int missing;

    protected TileRgb(PlanHipsRgb planRgb, Addr addr) {
        super(planRgb, addr, 0);
        this.fromNet = false;
        this.missing = planRgb.tabRgb.getMissing();
        this.cmp = new Tile[3];
        for (int c = 0; c < 3; ++c) {
            if (c == this.missing) continue;
            PlanHips p = c == 0 ? planRgb.red : (c == 1 ? planRgb.green : planRgb.blue);
            this.cmp[c] = p.getTile(addr, true);
        }
    }

    protected TileRgb(TileRgb father, int child) {
        super(father, child);
    }

    @Override
    protected int getStatus() {
        return 6;
    }

    @Override
    protected boolean shouldBeCached() {
        return false;
    }

    @Override
    protected void loadNow() throws Exception {
        Aladin.makeCursor(Aladin.aladin, 1);
        if (this.anc != null) {
            this.anc.loadNow();
            return;
        }
        for (int c = 0; c < 3; ++c) {
            if (c == this.missing) continue;
            this.cmp[c].loadNow();
            if (this.width != 0) continue;
            this.height = this.width = this.cmp[c].width;
        }
        Aladin.makeCursor(Aladin.aladin, 0);
    }

    @Override
    protected int[] getPixelFromAncetreRGB(ViewSimple v, int channel) throws Exception {
        if (this.anc.rgb == null) {
            this.anc.rgb = this.anc.getPixelRgb(v, channel);
        }
        return super.getPixelFromAncetreRGB(v, channel);
    }

    @Override
    protected int[] getPixelRgb(ViewSimple v, int channel) {
        if (this.rgb == null) {
            this.createRGB(v, channel);
        }
        return this.rgb;
    }

    protected void createRGB(ViewSimple v, int channel) {
        Fits[] fits = new Fits[3];
        double[] pixelMin = new double[3];
        double[] pixelMax = new double[3];
        byte[][] tcm = new byte[3][];
        double luptonQ = 20.0;
        double[] luptonM = new double[3];
        double[] luptonS = new double[3];
        TabRgb t = ((PlanHipsRgb)this.plan).tabRgb;
        int mode = t.getRGBMethod();
        int format = t.getFormat();
        boolean flagGauss = false;
        try {
            for (int c = 0; c < 3; ++c) {
                if (c == this.missing) continue;
                Tile a = this.cmp[c];
                if (a == null) {
                    throw new Exception("Composante " + c + " pour " + this.addr + " est nulle !!");
                }
                fits[c] = new Fits(a.width, a.width, a.plan.bitpix);
                fits[c].bscale = a.plan.bScale;
                fits[c].bzero = a.plan.bZero;
                fits[c].blank = a.plan.blank;
                if (a.pixelsOrigin == null) {
                    a.loadPixelsOrigin(2);
                }
                if (a.pixelsOrigin == null) {
                    throw new Exception("Composante " + c + " pour " + this.addr + " n'a pas (encore) les pixelsOriginaux !!");
                }
                fits[c].pixels = a.pixelsOrigin;
                if (mode == 0) {
                    pixelMin[c] = t.getCutMin(c);
                    pixelMax[c] = t.getCutMax(c);
                    IndexColorModel cm = null;
                    if (t.hasManual()) {
                        double pixelMiddle = t.getCutMiddle(c);
                        int indexMiddle = (int)(256.0 * (pixelMiddle - pixelMin[c]) / (pixelMax[c] - pixelMin[c]));
                        int transfertFct = PlanImage.getTransfertFct(t.getTransfertFct(c));
                        cm = CanvasColorMap.getCM(0, indexMiddle, 255, false, 0, transfertFct, true);
                    } else {
                        cm = (IndexColorModel)a.plan.getCM();
                    }
                    tcm[c] = Util.getTableCM(cm, 2);
                    continue;
                }
                luptonQ = t.getLuptonQ();
                luptonM[c] = t.getLuptonM(c);
                luptonS[c] = t.getLuptonS(c);
            }
            Fits out = null;
            out = mode == 0 ? BuilderRgb.createLeaveRGBClassic(fits, this.width, format, flagGauss, this.missing, pixelMin, pixelMax, tcm) : BuilderRgb.createLeaveRGBLupton(fits, this.width, format, flagGauss, this.missing, luptonQ, luptonM, luptonS);
            this.rgb = out.rgb;
            int[] line = new int[this.width];
            for (int y = 0; y < this.height / 2; ++y) {
                System.arraycopy(this.rgb, y * this.width, line, 0, this.width);
                System.arraycopy(this.rgb, (this.height - y - 1) * this.width, this.rgb, y * this.width, this.width);
                System.arraycopy(line, 0, this.rgb, (this.height - y - 1) * this.width, this.width);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

