/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.PlanHips;
import cds.aladin.Tile;
import cds.aladin.TilePol;
import cds.tools.Util;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.Hpix;

class TilePolAllsky
extends TilePol {
    protected int nbTiles;
    protected Tile[] tileList;

    protected TilePolAllsky(PlanHips plan, int order) {
        this.plan = plan;
        this.addr = new Addr(order, -1L, -1);
        this.allSky = true;
        this.resetTimer();
        String nameNet = "Norder" + order + "/Allsky";
        String nameCache = plan.getCacheName() + "/Norder" + order + "/Allsky";
        this.extCache = this.extNet = plan.getTileMode();
        this.fileCache = nameCache + EXT[this.extCache];
        this.fileNet = nameNet + EXT[this.extNet];
        this.alreadyCached = false;
        this.priority = -1;
        this.nbTiles = 12 * (int)Math.pow(4.0, order);
        this.tileList = null;
        this.setStatus(1);
    }

    TilePol createOneTile(int npix, int width, byte[] pix1, byte[] pix2) {
        TilePol h = new TilePol();
        h.plan = this.plan;
        h.addr = this.addr.clone();
        h.addr.npix = npix;
        h.hpix = new Hpix(h.addr.order, h.addr.npix, this.plan.frameOrigin);
        h.resetTimer();
        h.width = h.height = width;
        h.pixels = null;
        h.bitpix = this.bitpix;
        h.pixelsOrigin = pix1;
        h.bitpix2 = this.bitpix2;
        h.pixelsOrigin2 = pix2;
        h.alreadyCached = true;
        h.allSky = true;
        h.setStatus(6);
        return h;
    }

    public int getOrder1() {
        return this.addr.order;
    }

    public long getNpix() {
        return -1L;
    }

    protected void createTileList() {
        if (this.getStatus() != 6) {
            return;
        }
        int nbTileWidth = (int)Math.sqrt(this.nbTiles);
        int nbTileHeight = this.nbTiles / nbTileWidth;
        if ((double)(this.nbTiles / nbTileWidth) != (double)this.nbTiles / (double)nbTileWidth) {
            ++nbTileHeight;
        }
        int w = this.width / nbTileWidth;
        this.tileList = new Tile[this.nbTiles];
        for (int i = 0; i < this.nbTiles; ++i) {
            byte[] pix1 = null;
            byte[] pix2 = null;
            int npix1 = 0;
            int npix2 = 0;
            if (this.bitpix != 0) {
                npix1 = Math.abs(this.bitpix) / 8;
                pix1 = new byte[w * w * npix1];
            }
            if (this.bitpix2 != 0) {
                npix2 = Math.abs(this.bitpix2) / 8;
                pix2 = new byte[w * w * npix2];
            }
            int yTile = i / nbTileWidth * w;
            int xTile = i % nbTileWidth * w;
            if (i % 100 == 0) {
                Util.pause(10);
            }
            for (int y = 0; y < w; ++y) {
                for (int x = 0; x < w; ++x) {
                    int offset = (yTile + y) * this.width + (xTile + x);
                    int pos = y * w + x;
                    if (this.bitpix != 0) {
                        System.arraycopy(this.pixelsOrigin, offset * npix1, pix1, pos * npix1, npix1);
                    }
                    if (this.bitpix2 == 0) continue;
                    System.arraycopy(this.pixelsOrigin2, offset * npix2, pix2, pos * npix2, npix2);
                }
            }
            this.tileList[i] = this.createOneTile(i, w, pix1, pix2);
        }
        this.pixels = null;
        this.pixelsOrigin2 = null;
        this.pixelsOrigin = null;
    }

    @Override
    protected int free() {
        int n = 0;
        if (this.tileList != null) {
            n = this.tileList.length;
            for (int j = 0; j < this.tileList.length; ++j) {
                this.tileList[j].free();
            }
        }
        this.tileList = null;
        return n;
    }

    @Override
    protected void clearBuf() {
        if (this.tileList == null) {
            return;
        }
        for (int j = 0; j < this.tileList.length; ++j) {
            this.tileList[j].clearBuf();
        }
    }

    @Override
    Tile[] getTileList() {
        if (this.tileList == null) {
            this.createTileList();
        }
        return this.tileList;
    }
}

