/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanHips;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Tile;
import cds.aladin.ViewSimple;
import cds.tools.FastMath;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.CDSHealpix;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

class TilePol
extends Tile {
    protected int bitpix = 0;
    protected int bitpix2 = 0;
    protected byte[] pixelsOrigin = null;
    protected byte[] pixelsOrigin2 = null;
    protected double deltaAngle = 0.0;
    private static final int PIX8 = 0;
    private static final int PIXORIGIN = 1;
    private static final int PIXORIGIN2 = 2;
    private static final int MAXPOLARSIZE = 15;

    protected TilePol() {
    }

    protected TilePol(PlanHips planBG, Addr cell) {
        super(planBG, cell);
    }

    protected TilePol(TilePol father, int child) {
        super(father, child);
        this.bitpix = father.bitpix;
        this.bitpix2 = father.bitpix2;
        this.pixelsOrigin = null;
        this.pixelsOrigin2 = null;
    }

    private byte[] getPixelFromAncetre(int mode) throws Exception {
        byte[] pixAnc = null;
        switch (mode) {
            case 0: {
                return super.getPixelFromAncetre();
            }
            case 1: {
                if (this.bitpix == 0) {
                    throw new Exception("No pixelsOrigin in memory !");
                }
                pixAnc = ((TilePol)this.anc).pixelsOrigin == null ? ((TilePol)this.anc).getPixelFromAncetre(mode) : ((TilePol)this.anc).pixelsOrigin;
                return this.getPixelFromAncetre1(pixAnc, Math.abs(this.bitpix) / 8);
            }
            case 2: {
                if (this.bitpix2 == 0) {
                    throw new Exception("No pixelsOrigin2 in memory !");
                }
                pixAnc = ((TilePol)this.anc).pixelsOrigin2 == null ? ((TilePol)this.anc).getPixelFromAncetre(mode) : ((TilePol)this.anc).pixelsOrigin2;
                return this.getPixelFromAncetre1(pixAnc, Math.abs(this.bitpix2) / 8);
            }
        }
        return null;
    }

    private byte[] getPixelFromAncetre1(byte[] pixAnc, int npix) {
        byte[] pixels = new byte[this.width * this.height * npix];
        for (int y = 0; y < this.width; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.arraycopy(pixAnc, ((y + this.p.y) * this.anc.width + (x + this.p.x)) * npix, pixels, (y * this.width + x) * npix, npix);
            }
        }
        return pixels;
    }

    @Override
    protected int free1() {
        int rep = super.free1();
        if (this.pixelsOrigin != null) {
            this.pixelsOrigin = null;
            rep = 1;
        }
        if (this.pixelsOrigin2 != null) {
            this.pixelsOrigin2 = null;
            rep = 1;
        }
        return rep;
    }

    private final double getPixVal(byte[] t, int bitpix, int i) {
        switch (bitpix) {
            case 8: {
                return t[i] & 0xFF;
            }
            case 16: {
                return t[i *= 2] << 8 | t[i + 1] & 0xFF;
            }
            case 32: {
                return t[i *= 4] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
            }
            case -32: {
                return Float.intBitsToFloat(t[i *= 4] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF);
            }
            case -64: {
                return Double.longBitsToDouble((long)(t[i *= 8] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF) << 32 | (long)(t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF) & 0xFFFFFFFFL);
            }
        }
        return 0.0;
    }

    @Override
    protected int loadFits(String filename) throws Exception {
        int pos;
        block5: {
            byte[] buf = this.loadStream(filename);
            byte[] head = new byte[2880];
            System.arraycopy(buf, 0, head, 0, 2880);
            try {
                this.width = (int)this.getValue(head, "NAXIS1");
                this.height = (int)this.getValue(head, "NAXIS2");
                this.bitpix = (int)this.getValue(head, "BITPIX");
            }
            catch (Exception e) {
                this.height = 1024;
                this.width = 1024;
                this.bitpix = 8;
            }
            int taille = this.width * this.height * (Math.abs(this.bitpix) / 8);
            byte[] in = new byte[taille];
            System.arraycopy(buf, 2880, in, 0, taille);
            this.pixelsOrigin = new byte[in.length];
            this.invLine(in, this.pixelsOrigin, this.bitpix);
            pos = 2880 + taille;
            int deb = pos / 2880 * 2880;
            if (pos % 2880 != 0) {
                deb += 2880;
            }
            System.arraycopy(buf, deb, head, 0, 2880);
            try {
                this.bitpix2 = (int)this.getValue(head, "BITPIX");
                taille = this.width * this.height * (Math.abs(this.bitpix2) / 8);
                in = new byte[taille];
                System.arraycopy(buf, deb + 2880, in, 0, taille);
                this.pixelsOrigin2 = new byte[taille];
                this.invLine(in, this.pixelsOrigin2, this.bitpix2);
                pos = deb + taille + 2880;
            }
            catch (Exception e) {
                Aladin cfr_ignored_0 = this.plan.aladin;
                if (Aladin.levelTrace < 3) break block5;
                e.printStackTrace();
                System.err.println("Erreur \u00e0 la lecture de " + filename);
            }
        }
        return pos;
    }

    private int drawPolarisationFils(Graphics g, ViewSimple v, int parente) {
        int n = 0;
        if (this.width >= 1) {
            this.fils = this.getChild();
            if (this.fils != null) {
                for (int i = 0; i < 4; ++i) {
                    if (this.fils[i] == null) continue;
                    n += ((TilePol)this.fils[i]).drawPolarisation(g, v, parente + 1);
                }
            }
        }
        return n;
    }

    protected double getPixRes() {
        return CDSHealpix.pixRes(this.addr.order + (int)CDSHealpix.log2(this.width)) / 3600.0;
    }

    protected int drawPolarisation(Graphics g, ViewSimple v) {
        return this.drawPolarisation(g, v, 0);
    }

    protected int drawPolarisation(Graphics g, ViewSimple v, int parente) {
        try {
            PointD[] b = this.getProjViewCorners(v);
            if (b == null || b[0] == null || b[1] == null || b[2] == null || b[3] == null) {
                return 0;
            }
            if (this.isBehindSky(b, v)) {
                return 0;
            }
            if (parente < 8 && this.mustBeDivided(b)) {
                int n = this.drawPolarisationFils(g, v, parente + 1);
                this.resetTimer();
                return n;
            }
            double nbLosange = v.getTaille() / this.getPixRes();
            int gap = 1;
            double maxSize = 15.0f * this.plan.getSegmentDensityFactor();
            for (double nbPixelParLosange = (double)v.getWidth() / nbLosange; nbPixelParLosange < maxSize && gap * 2 < this.width; nbPixelParLosange *= 2.0) {
                gap *= 2;
            }
            byte[] pix1 = null;
            byte[] pix2 = null;
            pix1 = parente == 0 ? this.pixelsOrigin : this.getPixelFromAncetre(1);
            pix2 = parente == 0 ? this.pixelsOrigin2 : this.getPixelFromAncetre(2);
            double deltaAngle = this.getDeltaAngle(v);
            g.setColor(this.plan.c == Color.black ? Color.green : this.plan.c);
            double m = 0.5;
            for (int y = gap / 2; y < this.height; y += gap) {
                for (int x = gap / 2; x < this.width; x += gap) {
                    double fx = ((double)x + m) / (double)this.width;
                    double fy = ((double)y + m) / (double)this.height;
                    double x1 = b[0].x + (b[2].x - b[0].x) * fx;
                    double y1 = b[0].y + (b[2].y - b[0].y) * fx;
                    double x2 = b[1].x + (b[3].x - b[1].x) * fx;
                    double y2 = b[1].y + (b[3].y - b[1].y) * fx;
                    double x3 = x1 + (x2 - x1) * fy;
                    double y3 = y1 + (y2 - y1) * fy;
                    int Y = y;
                    int X = x;
                    int offset = Y * this.width + X;
                    double polaQ = this.getPixVal(pix1, this.bitpix, offset);
                    double polaU = this.getPixVal(pix2, this.bitpix2, offset);
                    if (this.plan.isSegmentIAUConv()) {
                        polaU = -polaU;
                    }
                    double angle = Math.toDegrees(0.5 * Math.atan2(polaU, polaQ));
                    double norme = Math.sqrt(polaU * polaU + polaQ * polaQ);
                    angle = 90.0 + angle + deltaAngle;
                    this.drawSegment(g, x3, y3, Math.toRadians(angle), norme *= (double)(100.0f * this.plan.getSegmentLenFactor()), this.plan.getSegmentThickness());
                }
            }
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private double getDeltaAngle(ViewSimple v) {
        Coord[] corners = this.getCorners();
        if (corners == null) {
            return 0.0;
        }
        Coord c = new Coord(corners[0].al, corners[0].del);
        Projection proj = v.getProj();
        proj.getXY(c);
        Coord c1 = new Coord(corners[3].al, corners[3].del);
        c1.del = c1.del + 0.01 > 90.0 ? c1.del - 0.01 : c1.del + 0.01;
        proj.getXY(c1);
        double angle1 = Math.toDegrees(Math.atan2(c1.y - c.y, c1.x - c.x));
        return Double.isNaN(angle1) ? 0.0 : 90.0 + angle1;
    }

    private void drawSegment(Graphics g, double x, double y, double angle, double norme, int thickness) {
        double x1 = x + norme * FastMath.cos(angle);
        double y1 = y + norme * FastMath.sin(angle);
        double dx = (x1 - x) / 2.0;
        double dy = (y1 - y) / 2.0;
        if (thickness > 1 && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke saveStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(thickness));
            g2d.drawLine((int)(x - dx), (int)(y - dy), (int)(x + dx), (int)(y + dy));
            g2d.setStroke(saveStroke);
        } else {
            g.drawLine((int)(x - dx), (int)(y - dy), (int)(x + dx), (int)(y + dy));
        }
    }
}

