/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Legende;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.PlanHips;
import cds.aladin.PlanHipsCat;
import cds.aladin.Tile;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import cds.tools.pixtools.Addr;
import java.awt.Graphics;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class TileCat
extends Tile {
    Pcat pcat = null;
    int mem = 0;
    boolean last = false;
    int nLoaded;
    int nTotal = 0;
    private static final char[] COMPLETENESS = new char[]{'#', ' ', 'C', 'o', 'm', 'p', 'l', 'e', 't', 'e', 'n', 'e', 's', 's', ' ', '=', ' '};

    protected TileCat(PlanHips planBG, Addr cell) {
        super(planBG, cell, 1);
    }

    @Override
    protected void updateCacheIfRequired(int time) throws Exception {
        if (!this.plan.live) {
            return;
        }
    }

    @Override
    protected long loadCache(String filename) throws Exception {
        this.loadTSV(filename);
        this.stream = null;
        return 0L;
    }

    @Override
    protected long loadNet(String filename) throws Exception {
        this.loadTSV(filename);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTSV(String filename) throws Exception {
        this.pcat = new Pcat(this.plan);
        this.stream = this.loadStream(filename);
        this.mem = this.stream.length;
        try (MyInputStream in = null;){
            block9: {
                try {
                    this.testLast(this.stream);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block9;
                    e.printStackTrace();
                }
            }
            Aladin cfr_ignored_0 = this.plan.aladin;
            int trace = Aladin.levelTrace;
            Aladin cfr_ignored_1 = this.plan.aladin;
            Aladin.levelTrace = 0;
            if (((PlanHipsCat)this.plan).hasGenericPcat()) {
                this.pcat.leg = ((PlanHipsCat)this.plan).getGenericPcat().leg;
            }
            in = new MyInputStream(this.getInputStreamFromStream());
            in.setFileName(filename);
            this.pcat.tableParsing(in, null);
            Aladin cfr_ignored_2 = this.plan.aladin;
            Aladin.levelTrace = trace;
            if (!this.plan.useCache) {
                this.stream = null;
            }
            if (!((PlanHipsCat)this.plan).hasGenericPcat()) {
                ((PlanHipsCat)this.plan).setGenericPcat(this.pcat);
            }
            this.recomputePosition(((PlanHipsCat)this.plan).getFirstLegende(), this.pcat);
        }
    }

    protected InputStream getInputStreamFromStream() throws Exception {
        return new ByteArrayInputStream(this.stream);
    }

    public void recomputePosition(Legende leg, Pcat pcat) {
        int npmra = leg.getPmRa();
        int npmde = leg.getPmDe();
        int nra = leg.getRa();
        int nde = leg.getDe();
        this.plan.recomputePosition(pcat.iterator(), leg, nra, nde, npmra, npmde);
    }

    private boolean testLast(byte[] stream) {
        boolean rep = this.testLast(stream, 0, COMPLETENESS);
        if (!rep) {
            for (int i = 1; !rep && i < stream.length - 1; ++i) {
                if (stream[i] != 10 && stream[i] != 13) continue;
                if (stream[i + 1] == 35) {
                    rep = this.testLast(stream, i + 1, COMPLETENESS);
                    continue;
                }
                if (stream[i + 1] != 10 && stream[i + 1] != 13) break;
            }
        }
        return rep;
    }

    private boolean testLast(byte[] stream, int offset, char[] signature) {
        int fin;
        if (stream.length < signature.length) {
            return false;
        }
        for (int i = offset; i < signature.length; ++i) {
            if (signature[i] == stream[i]) continue;
            return false;
        }
        int deb = offset + signature.length;
        int slash = 0;
        for (fin = offset + signature.length; fin < stream.length && stream[fin] != 10 && stream[fin] != 13; ++fin) {
            if (stream[fin] != 47) continue;
            slash = fin;
        }
        if (slash == 0) {
            return false;
        }
        if (fin == stream.length) {
            return false;
        }
        try {
            this.nLoaded = Integer.parseInt(new String(stream, deb, slash - deb));
            this.nTotal = Integer.parseInt(new String(stream, slash + 1, fin - (slash + 1)));
            this.last = this.nLoaded == this.nTotal;
        }
        catch (Exception e) {
            this.nLoaded = 1;
            this.nTotal = 2;
            this.last = false;
        }
        return true;
    }

    protected boolean isLast() {
        return this.last;
    }

    protected boolean isReallyLast(ViewSimple v) {
        return this.last;
    }

    @Override
    protected int writeCache() throws Exception {
        int n = this.writeStream();
        this.stream = null;
        return n;
    }

    @Override
    protected int free() {
        return this.free(true);
    }

    protected int free(boolean force) {
        if (this.allSky) {
            return 0;
        }
        int status = this.getStatus();
        if (status == 4 || status == 5) {
            this.abort();
        } else if (status == 6 && this.plan.useCache) {
            this.write();
        }
        if (this.pcat != null) {
            if (!force && this.pcat.hasSelectedOrTaggedObj()) {
                return 0;
            }
            this.pcat.free();
            this.mem = 0;
        }
        ++this.plan.nbFree;
        this.setStatus(0);
        return 1;
    }

    @Override
    protected void clearBuf() {
    }

    @Override
    protected int getMem() {
        return this.mem;
    }

    @Override
    protected int draw(Graphics g, ViewSimple v, int channel) {
        return this.draw1(g, v, false);
    }

    protected int drawOnlySelected(Graphics g, ViewSimple v) {
        return this.draw1(g, v, true);
    }

    private int draw1(Graphics g, ViewSimple v, boolean onlySelected) {
        if (this.pcat == null || !this.pcat.hasObj()) {
            return 0;
        }
        int nb = this.pcat.draw(g, null, v, true, onlySelected, 0, 0);
        this.resetTimer();
        return nb;
    }

    protected void resetDrawnInView(ViewSimple v) {
        if (this.pcat == null || !this.pcat.hasObj()) {
            return;
        }
        this.pcat.resetDrawnInView(v);
    }

    private int getCounts() {
        if (this.getStatus() == 6 && this.pcat != null) {
            return this.pcat.getCount();
        }
        return 0;
    }

    @Override
    public String toString() {
        int status = this.getStatus();
        String code = status == 5 || status == 4 ? "**" : (status == 3 || status == 2 ? " x" : " .");
        return code + "[" + Util.align(this.priority + "", 5) + "] " + Util.align(this.getStringNumber(), 8) + Util.align(this.getCounts() + "s", 8) + Util.align(this.getLongFullMem(), 8) + Util.align(this.getStatusString(), 16) + (this.timer == -1L ? -1L : this.getCurrentLiveTime() / 1000L) + "s => " + VIE[-this.getLive()] + (this.getStatus() == 6 ? (this.fromNet ? " Net" : " Cache") + ":" + this.timeStream + "ms" : "") + (this.isLast() ? " last" : "") + (this.nTotal != 0 ? " " + this.nLoaded + "/" + this.nTotal : "");
    }
}

