/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.PlanHips;
import cds.aladin.Tile;
import cds.tools.Util;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.Hpix;
import java.io.File;

class TileAllsky
extends Tile {
    protected int nbPix;
    protected Tile[] pixList;
    private int mem;

    protected TileAllsky(PlanHips planBG, Addr cell) {
        this(planBG, cell, 1);
    }

    protected TileAllsky(PlanHips planBG, Addr c, int mode) {
        block6: {
            this.mem = 0;
            this.plan = planBG;
            this.addr = c.clone();
            this.allSky = true;
            this.resetTimer();
            String sZ = this.addr.z <= 0 ? "" : "_" + this.addr.z;
            String nameNet = "Norder" + this.addr.order + "/Allsky" + sZ;
            String nameCache = planBG.getCacheName() + "/Norder" + this.addr.order + "/Allsky" + sZ;
            this.extCache = this.extNet = planBG.getTileMode();
            this.fileCache = nameCache + EXT[this.extCache];
            this.fileNet = nameNet + EXT[this.extNet];
            this.alreadyCached = false;
            this.priority = -1;
            this.nbPix = 12 * (int)Math.pow(4.0, this.addr.order);
            this.pixList = null;
            this.setStatus(1);
            try {
                if (mode == 4) {
                    this.stream = this.loadStream(planBG.url + "/" + this.fileNet);
                    if (this.stream != null) {
                        this.sizeStream = this.stream.length;
                    }
                    this.stream = null;
                } else if (mode == 2 || mode == 3 && (planBG.useCache && this.isCached() || planBG.isLocalHips())) {
                    this.loadNow();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block6;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected boolean askGzip() {
        return Aladin.GZIP == 1 || Aladin.GZIP == 2;
    }

    @Override
    protected long getLiveTime() {
        return this.plan.aladin.enoughMemory() ? -1L : 3000L;
    }

    protected Tile createOneKey(int npix, int width, byte[] pix) {
        Tile h = new Tile();
        h.allSky = true;
        h.plan = this.plan;
        h.addr = this.addr.clone();
        h.addr.npix = npix;
        h.hpix = new Hpix(h.addr.order, h.addr.npix, this.plan.frameOrigin);
        h.resetTimer();
        h.width = h.height = width;
        h.pixels = pix;
        h.alreadyCached = true;
        h.setStatus(6);
        return h;
    }

    protected Tile createOneKeyRGB(int npix, int width, int[] rgb) {
        Tile h = new Tile();
        h.allSky = true;
        h.plan = this.plan;
        h.addr = this.addr.clone();
        h.addr.npix = npix;
        h.hpix = new Hpix(h.addr.order, h.addr.npix, this.plan.frameOrigin);
        h.resetTimer();
        h.width = h.height = width;
        h.rgb = rgb;
        h.alreadyCached = true;
        h.setStatus(6);
        return h;
    }

    static boolean isCached(PlanHips planBG, int order) {
        String pathName = planBG.getCacheDir();
        if (pathName == null) {
            return false;
        }
        String name = planBG.getCacheName() + "/Norder" + order + "/Allsky" + EXT[planBG.getTileMode()];
        File f = new File(pathName = pathName + Util.FS + name);
        return f.exists() && f.canRead();
    }

    protected void createPixList() {
        if (this.getStatus() != 6) {
            return;
        }
        try {
            if (this.plan.color) {
                this.createPixListRGB1();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int nbLosangeWidth = (int)Math.sqrt(this.nbPix);
        int nbLosangeHeight = this.nbPix / nbLosangeWidth;
        if ((double)(this.nbPix / nbLosangeWidth) != (double)this.nbPix / (double)nbLosangeWidth) {
            ++nbLosangeHeight;
        }
        int w = this.width / nbLosangeWidth;
        this.pixList = new Tile[this.nbPix];
        for (int i = 0; i < this.nbPix; ++i) {
            byte[] pix = new byte[w * w];
            int yLosange = i / nbLosangeWidth * w;
            int xLosange = i % nbLosangeWidth * w;
            for (int y = 0; y < w; ++y) {
                for (int x = 0; x < w; ++x) {
                    int offset = (yLosange + y) * this.width + (xLosange + x);
                    if (offset >= this.pixels.length) {
                        System.err.println("offset=" + offset + " pixels.length=" + this.pixels.length + " x,y=" + x + "," + y);
                        offset = this.pixels.length - 1;
                    }
                    int pos = y * w + x;
                    pix[pos] = this.pixels[offset];
                }
            }
            this.pixList[i] = this.createOneKey(i, w, pix);
            this.mem += this.pixList[i].getMem();
        }
        this.pixels = null;
    }

    @Override
    protected int getMem() {
        return this.mem;
    }

    private void createPixListRGB1() throws Exception {
        int nbLosangeWidth = (int)Math.sqrt(this.nbPix);
        int nbLosangeHeight = this.nbPix / nbLosangeWidth;
        if ((double)(this.nbPix / nbLosangeWidth) != (double)this.nbPix / (double)nbLosangeWidth) {
            ++nbLosangeHeight;
        }
        int w = this.width / nbLosangeWidth;
        this.pixList = new Tile[this.nbPix];
        for (int npix = 0; npix < this.nbPix; ++npix) {
            int[] pix = new int[w * w];
            int yLosange = npix / nbLosangeWidth * w;
            int xLosange = npix % nbLosangeWidth * w;
            for (int y = 0; y < w; ++y) {
                for (int x = 0; x < w; ++x) {
                    pix[y * w + x] = this.rgb[(yLosange + y) * this.width + (xLosange + x)];
                }
            }
            this.pixList[npix] = this.createOneKeyRGB(npix, w, pix);
            this.mem += this.pixList[npix].getMem();
        }
        this.rgb = null;
    }

    @Override
    protected int free() {
        int n = 0;
        if (this.pixList != null) {
            n = this.pixList.length;
            for (int j = 0; j < this.pixList.length; ++j) {
                if (this.pixList[j] == null) continue;
                this.pixList[j].free();
            }
        }
        this.pixList = null;
        this.mem = 0;
        return n;
    }

    @Override
    protected void clearBuf() {
        if (this.pixList == null) {
            return;
        }
        for (int j = 0; j < this.pixList.length; ++j) {
            if (this.pixList[j] == null) continue;
            this.pixList[j].clearBuf();
        }
    }

    @Override
    Tile[] getTileList() {
        if (this.pixList == null) {
            this.createPixList();
        }
        return this.pixList;
    }
}

