/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CalibFreq;
import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.PlanHips;
import cds.aladin.PlanHips3D;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Save;
import cds.aladin.Spectrogram;
import cds.aladin.TileAllsky;
import cds.aladin.TilePol;
import cds.aladin.TileRgb;
import cds.aladin.ViewSimple;
import cds.fits.Fits;
import cds.image.InputStreamAPNG;
import cds.tools.FastMath;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import cds.tools.pixtools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class Tile
implements Comparable<Tile> {
    static final int UNKNOWN = 0;
    static final int ASKING = 1;
    static final int TOBELOADFROMCACHE = 2;
    static final int TOBELOADFROMNET = 3;
    static final int LOADINGFROMCACHE = 4;
    static final int LOADINGFROMNET = 5;
    static final int READY = 6;
    static final int ERROR = 7;
    static final int ABORTING = 8;
    static final int PURGING = 9;
    public static int NBSTATUS = 10;
    public static final String[] STATUS = new String[]{"UNKOWN", "ASKING", "TOBELOADFROMCACHE", "TOBELOADFROMNET", "LOADINGFROMCACHE", "LOADINGFROMNET", "READY", "ERROR", "ABORTING", "PURGING"};
    protected int status;
    protected int mode;
    protected long timer;
    protected long timerLoad;
    protected int priority;
    protected PlanHips plan;
    protected Addr addr;
    protected Hpix hpix;
    protected String fileCache;
    protected String fileNet;
    protected int width;
    protected int height;
    protected int depth;
    protected byte[] pixels;
    protected byte[] pixelsOrigin;
    protected int[] rgb;
    protected Image imgBuf;
    protected int stateID;
    protected byte[] stream;
    protected boolean truePixels;
    protected boolean alreadyCached;
    protected boolean allSky;
    protected boolean fromNet;
    protected int timeStream;
    protected int timeNet;
    protected boolean gzipped;
    protected long sizeStream;
    private int timeUncmp;
    private int timePixel;
    private int typeColor;
    protected Tile[] fils;
    protected Tile anc;
    protected int parente;
    protected Point p;
    int oiz;
    int vHashCode;
    public static final int NOW = 0;
    public static final int ONLYIFRAMAVAIL = 1;
    public static final int ONLYIFDISKAVAIL = 2;
    public static final int PIX8 = 3;
    protected static final int JPEG = 0;
    protected static final int FITS = 1;
    protected static final int TSV = 2;
    protected static final int XML = 3;
    protected static final int PNG = 4;
    protected static final int IDX = 5;
    public static final String[] EXT = new String[]{".jpg", ".fits", ".tsv", ".xml", ".png", ""};
    protected int extCache;
    protected int extNet;
    public static final int NOLOAD = 0;
    public static final int ASYNC = 1;
    public static final int SYNC = 2;
    public static final int SYNCONLYIFLOCAL = 3;
    public static final int TESTNET = 4;
    public static final int NODISP = 5;
    boolean retry;
    static final int SIZESLOW = 512;
    static final int SIZEFAST = 8192;
    private static final int TIMEOUT = 10000;
    private Object lockFree;
    private boolean pixelOriginFreeable;
    private static final Component observer = new Label();
    private Object lockStatus;
    private boolean lockX;
    static final int DEATH = -1;
    static final int MAYBEDEATH = -2;
    static final int INLIFE = -3;
    static final int TIMEBEFOREDEATH = 3000;
    protected static final String[] VIE = new String[]{"", "DEATH", "MAYBEDEATH", "INLIFE"};
    private static final double FCT255 = 0.99609375;
    private static final int RASTER = 0;
    private static final int TOOLKIT = 1;
    private static boolean MODE_CHECK = true;
    private static final int MODE_MAX = 5;
    private static int MODE_NB = 0;
    private static int MODE = 0;
    private static long[] MODE_TIME = new long[]{0L, 0L};
    static final double M = 48400.0;
    static final double RAP = 0.7;
    protected static int nDraw = 0;
    protected static int nOut = 0;
    private static final long TIMEFADER = 600L;
    private static final float MINFADER = 0.1f;
    static final Color BLUE1 = new Color(0, 0, 255);
    static final Color BLUE2 = new Color(10, 52, 128);
    static final Color BLUE3 = new Color(51, 144, 198);

    public Tile() {
        this.status = 0;
        this.priority = -1;
        this.depth = 1;
        this.stateID = -2;
        this.fromNet = true;
        this.gzipped = false;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockFree = new Object();
        this.pixelOriginFreeable = false;
        this.lockStatus = new Object();
        this.lockX = false;
    }

    protected Tile(PlanHips planBG) {
        this.status = 0;
        this.priority = -1;
        this.depth = 1;
        this.stateID = -2;
        this.fromNet = true;
        this.gzipped = false;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockFree = new Object();
        this.pixelOriginFreeable = false;
        this.lockStatus = new Object();
        this.lockX = false;
        this.plan = planBG;
    }

    protected Tile(PlanHips planBG, Addr addr) {
        this(planBG, addr, 1);
    }

    protected Tile(PlanHips planBG, Addr addr, int mode) {
        block8: {
            this.status = 0;
            this.priority = -1;
            this.depth = 1;
            this.stateID = -2;
            this.fromNet = true;
            this.gzipped = false;
            this.fils = null;
            this.anc = null;
            this.parente = 0;
            this.p = new Point(0, 0);
            this.oiz = -1;
            this.vHashCode = -1;
            this.extCache = 0;
            this.extNet = 0;
            this.retry = false;
            this.lockFree = new Object();
            this.pixelOriginFreeable = false;
            this.lockStatus = new Object();
            this.lockX = false;
            this.plan = planBG;
            this.addr = addr.clone();
            this.mode = mode;
            this.hpix = new Hpix(addr.order, addr.npix, planBG.frameOrigin);
            if (mode == 0) {
                return;
            }
            this.allSky = false;
            this.alreadyCached = false;
            this.setStatus(1);
            if (!this.allSky) {
                ++planBG.nbCreated;
            }
            this.resetTimer();
            this.extCache = this.extNet = planBG.getTileMode();
            this.fileNet = this.getFileNet();
            this.fileCache = this.getFileCache();
            try {
                if (mode == 4) {
                    this.stream = this.loadStream(planBG.url + "/" + this.fileNet);
                    if (this.stream != null) {
                        this.sizeStream = this.stream.length;
                    }
                    this.stream = null;
                } else if (mode == 2 || (mode == 3 || mode == 5) && (planBG.useCache && this.isCached() || planBG.isLocalHips())) {
                    this.loadNow();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block8;
                e.printStackTrace();
            }
        }
    }

    protected Tile(Addr addr, int frame) {
        this.status = 0;
        this.priority = -1;
        this.depth = 1;
        this.stateID = -2;
        this.fromNet = true;
        this.gzipped = false;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockFree = new Object();
        this.pixelOriginFreeable = false;
        this.lockStatus = new Object();
        this.lockX = false;
        this.addr = addr;
        this.hpix = new Hpix(addr.order, addr.npix, frame);
    }

    protected String getFileNet() {
        String s = this.getFilePath(null, this.addr) + EXT[this.extNet];
        if (this.plan.isDynHips()) {
            s = s + "?" + this.plan.urlSuffix;
        }
        return s;
    }

    protected String getFileCache() {
        return this.getFilePath(this.plan.getCacheName(), this.addr) + EXT[this.extCache];
    }

    protected Tile(Tile father, int child) {
        this.status = 0;
        this.priority = -1;
        this.depth = 1;
        this.stateID = -2;
        this.fromNet = true;
        this.gzipped = false;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockFree = new Object();
        this.pixelOriginFreeable = false;
        this.lockStatus = new Object();
        this.lockX = false;
        this.plan = father.plan;
        this.addr = father.addr.clone();
        this.addr.order = father.addr.order + 1;
        this.addr.npix = father.addr.npix * 4L + (long)child;
        this.timerLoad = father.timerLoad;
        this.hpix = new Hpix(this.addr.order, this.addr.npix, this.plan.frameOrigin);
        this.anc = father.anc;
        if (this.anc == null) {
            this.anc = father;
        }
        this.width = this.height = father.width / 2;
        this.depth = father.depth;
        int offsetX = child == 2 || child == 3 ? this.width : 0;
        int offsetY = child == 1 || child == 3 ? this.width : 0;
        this.p = new Point(father.p.x + offsetX, father.p.y + offsetY);
        this.parente = father.parente + 1;
        this.resetTimer();
        this.pixels = null;
        this.rgb = null;
        this.alreadyCached = true;
        this.allSky = father.allSky;
        this.setStatus(0);
    }

    protected Tile[] getChild() {
        if (this.getStatus() != 6) {
            return null;
        }
        try {
            if (this.fils != null && this.fils[0].getStatus() == 6 && this.fils[1].getStatus() == 6 && this.fils[2].getStatus() == 6 && this.fils[3].getStatus() == 6) {
                return this.fils;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tile[] f1 = new Tile[4];
        for (int child = 0; child < 4; ++child) {
            Tile f = this instanceof TilePol ? new TilePol((TilePol)this, child) : (this instanceof TileRgb ? new TileRgb((TileRgb)this, child) : new Tile(this, child));
            f.setStatus(6);
            f1[child] = f;
        }
        this.fils = f1;
        return this.fils;
    }

    protected byte[] getPixelFromAncetre() throws Exception {
        byte[] pixels = new byte[this.width * this.height * this.depth];
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.width; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    pixels[z * this.width * this.width + y * this.width + x] = this.anc.pixels[z * this.anc.width * this.anc.width + (y + this.p.y) * this.anc.width + (x + this.p.x)];
                }
            }
        }
        return pixels;
    }

    protected int[] getPixelFromAncetreRGB(ViewSimple v, int channel) throws Exception {
        if (this.isModeRGB(v)) {
            this.anc.rgb = this.anc.getPixelRgb(v, channel);
        }
        int[] rgb = new int[this.width * this.height];
        for (int y = 0; y < this.width; ++y) {
            for (int x = 0; x < this.width; ++x) {
                rgb[y * this.width + x] = this.anc.rgb[(y + this.p.y) * this.anc.width + (x + this.p.x)];
            }
        }
        return rgb;
    }

    protected String getFilePath(String survey, Addr addr) {
        if (this.plan != null && this.plan instanceof PlanHips3D && ((PlanHips3D)this.plan).hips3dProto) {
            return (survey != null ? survey + "/" : "") + Util.getFilePathOld(addr.order, addr.npix, addr.orderZ, addr.npixZ);
        }
        return (survey != null ? survey + "/" : "") + Util.getFilePath(addr);
    }

    protected String getStringNumber() {
        return this.addr.toString();
    }

    public String toString() {
        String code = this.status == 5 || this.status == 4 ? ">>" : (this.status == 3 || this.status == 2 ? " >" : " .");
        String stime = "";
        stime = Aladin.levelTrace == 6 ? "load:" + (this.timeNet + this.timeStream) + "/uncmp:" + this.timeUncmp + "/extpixel:" + this.timePixel + "ms" : this.timeNet + this.timeStream + this.timeUncmp + this.timePixel + "ms";
        return code + "[" + cds.tools.Util.align(this.priority + "", 5) + "] " + cds.tools.Util.align(this.getStringNumber() + (this.fils != null ? ">" : " "), 15) + cds.tools.Util.align((this.sizeStream != 0L ? cds.tools.Util.getUnitDisk(this.sizeStream) + "->" : "") + this.getLongFullMem(), 14) + (this.truePixels ? " fits " : "      ") + cds.tools.Util.align(this.getStatusString(), 16) + (this.timer == -1L ? -1L : this.getCurrentLiveTime() / 1000L) + "s => " + VIE[-this.getLive()] + (this.getStatus() == 6 ? (this.fromNet ? " Net" : " Cache") + ":" + stime : "");
    }

    protected int free() {
        int rep = 0;
        try {
            rep += this.free1();
            rep += this.filsFree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rep;
    }

    protected int free1() {
        int rep = 0;
        int status = this.getStatus();
        if (this.parente == 0) {
            ++this.plan.nbFree;
            if (status == 4 || status == 5) {
                this.abort();
            } else if (status == 6 && this.plan.useCache) {
                this.write();
            }
        }
        this.setStatus(0);
        if (this.pixels != null) {
            this.pixels = null;
            rep = 1;
        }
        if (this.rgb != null) {
            this.rgb = null;
            rep = 1;
        }
        if (this.imgBuf != null) {
            this.imgBuf.flush();
            this.imgBuf = null;
            rep = 1;
        }
        if (this.pixelsOrigin != null && !this.isPixelsOriginFreeable()) {
            this.pixelsOrigin = null;
            rep = 1;
        }
        return rep;
    }

    protected int filsFree() {
        int rep = 0;
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                rep += this.fils[i].free();
            }
            this.fils = null;
        }
        return rep;
    }

    protected boolean purgeFils() {
        boolean rep = true;
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                if (this.fils[i] == null) continue;
                rep = rep && this.fils[i].purgeFils();
            }
        }
        if (rep) {
            if (this.parente == 0) {
                this.fils = null;
                return rep;
            }
            if (this.getLive() == -1) {
                this.free();
                return true;
            }
        }
        return false;
    }

    protected void clearBuf() {
        if (this.pixelsOrigin != null && !this.isPixelsOriginFreeable()) {
            this.pixelsOrigin = null;
        }
        if (this.imgBuf == null) {
            return;
        }
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                if (this.fils[i] == null) continue;
                this.fils[i].clearBuf();
            }
        }
        this.imgBuf = null;
    }

    protected void askForRepaint() {
        this.plan.askForRepaint();
    }

    protected void loadFromNet() {
        block6: {
            this.setStatus(5);
            try {
                long t = System.currentTimeMillis();
                String fileName = this.plan.url + "/" + this.fileNet;
                char c = this.plan.url.charAt(this.plan.url.length() - 1);
                if (c == '\\' || c == '/') {
                    fileName = this.plan.url + this.fileNet;
                }
                this.plan.nByteReadNet += this.loadNet(fileName);
                this.alreadyCached = false;
                this.resetTimer();
                this.setTimerLoad();
                this.setStatus(6);
                ++this.plan.nbLoadNet;
                this.parente = 0;
                this.fromNet = true;
                this.plan.cumulTimeLoadNet += (long)this.timeNet;
                this.plan.cumulTimeStream += (long)this.timeStream;
                this.plan.cumulTimeUncmp += (long)this.timeUncmp;
                this.plan.cumulTimePixel += (long)this.timePixel;
                if (this.mode != 5) {
                    this.askForRepaint();
                }
                Aladin.trace(5, "HealpixKey.LoadFromNet() by " + Thread.currentThread().getName() + " in " + (System.currentTimeMillis() - t) + "ms : " + this);
            }
            catch (Throwable e) {
                boolean notFoundError;
                this.pixels = null;
                this.rgb = null;
                if (this.getStatus() == 8) break block6;
                boolean bl = notFoundError = e instanceof FileNotFoundException || e.getMessage() != null && e.getMessage().indexOf("HTTP response code: 40") >= 0;
                if (!notFoundError && !this.retry && this.plan.checkSite(true)) {
                    System.err.println("retry other site");
                    this.retry = true;
                    this.loadFromNet();
                    return;
                }
                this.setStatus(7);
                if (this instanceof TileAllsky) {
                    this.askForRepaint();
                }
                if (Aladin.levelTrace < 6) break block6;
                System.err.println("Tile.loadFromNet error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected long loadNet(String fileName) throws Exception {
        long n = 0L;
        n = this.extNet == 0 || this.extNet == 4 ? (long)this.loadJpeg(fileName) : (long)this.loadFits(fileName);
        if (!this.plan.useCache) {
            this.stream = null;
        }
        return n;
    }

    protected void loadFromCache() {
        block7: {
            this.setStatus(4);
            try {
                long t = System.currentTimeMillis();
                String pathName = this.plan.getCacheDir();
                if (pathName == null) {
                    throw new Exception("Cache not ready");
                }
                pathName = pathName + cds.tools.Util.FS + this.fileCache;
                try {
                    this.updateCacheIfRequired(1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.plan.nByteReadCache += this.loadCache(pathName);
                    this.alreadyCached = true;
                    Aladin.trace(5, "HealpixKey.LoadFromCache() in " + (System.currentTimeMillis() - t) + "ms " + this);
                    this.resetTimer();
                    this.setTimerLoad();
                    this.setStatus(6);
                    this.parente = 0;
                    ++this.plan.nbLoadCache;
                    this.fromNet = false;
                    this.plan.cumulTimeLoadCache += System.currentTimeMillis() - t;
                    this.askForRepaint();
                    this.plan.touchCache();
                }
                catch (Exception e) {
                    System.err.println("Error on " + pathName);
                    e.printStackTrace();
                    new File(pathName).delete();
                    throw e;
                }
            }
            catch (Exception e) {
                this.pixels = null;
                this.alreadyCached = false;
                if (this.getStatus() == 8) break block7;
                this.setStatus(3);
                if (Aladin.levelTrace < 3) break block7;
                e.printStackTrace();
            }
        }
    }

    protected void updateCacheIfRequired(int time) throws Exception {
    }

    protected void loadNow() throws Exception {
        if (this.getStatus() != 6) {
            if (this.plan.useCache && this.isCached()) {
                this.setStatus(2);
                this.loadFromCache();
            }
            if (!this.plan.useCache || !this.isCached()) {
                this.setStatus(3);
                this.loadFromNet();
            }
        } else {
            this.resetTimer();
        }
        if (this.getStatus() == 6) {
            if (this.allSky) {
                this.plan.setOrderTile(this.getLosangeOrder());
            }
            if (this.plan.isTruePixels()) {
                this.loadPixelsOrigin(2);
            }
            if (this.plan.useCache) {
                this.write();
            }
        }
    }

    protected long loadCache(String pathName) throws Exception {
        long n = this.extCache == 0 || this.extCache == 4 ? (long)this.loadJpeg(pathName) : (long)this.loadFits(pathName);
        this.stream = null;
        File f = new File(pathName);
        f.setLastModified(System.currentTimeMillis());
        return n;
    }

    protected boolean isCached() {
        if (this.alreadyCached) {
            return true;
        }
        String pathName = this.plan.getCacheDir();
        if (pathName == null) {
            return false;
        }
        File f = new File(pathName = pathName + cds.tools.Util.FS + this.fileCache);
        if (f.exists() && f.canRead()) {
            this.alreadyCached = true;
            return true;
        }
        return false;
    }

    protected boolean shouldBeCached() {
        if (this.alreadyCached) {
            return false;
        }
        return this.getStatus() == 6;
    }

    protected void write() {
        if (this.alreadyCached) {
            return;
        }
        try {
            long t = System.currentTimeMillis();
            int n = this.writeCache();
            this.plan.nByteWriteCache += (long)n;
            ++this.plan.nbWriteCache;
            this.plan.cumulTimeWriteCache += System.currentTimeMillis() - t;
            PlanHips.addInCache(n / 1024);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.alreadyCached = true;
    }

    protected int writeCache() throws Exception {
        int n = 0;
        if (this.stream != null) {
            n = this.writeStream();
            this.stream = null;
        } else {
            n = this.writeFits();
        }
        return n;
    }

    protected void abort() {
        if (this.addr.npix == -1L) {
            return;
        }
        if (this.plan instanceof PlanHips3D) {
            return;
        }
        ++this.plan.nbAborted;
        this.setStatus(8, true);
    }

    private FileOutputStream openOutputStream() throws Exception {
        String pathName = this.plan.getCacheDir() + cds.tools.Util.FS + this.fileCache;
        File f = new File(pathName);
        if (f.exists()) {
            f.delete();
        }
        cds.tools.Util.createPath(pathName);
        FileOutputStream ois = new FileOutputStream(pathName);
        return ois;
    }

    private boolean slowDown() {
        return this.plan.aladin.view != null && this.plan.aladin.view.mustDrawFast();
    }

    public byte[] readFully(MyInputStream in, boolean fastLoad) throws Exception {
        Vector<byte[]> v = new Vector<byte[]>(10);
        Vector<Integer> vSize = new Vector<Integer>(10);
        int n = 0;
        int m = 0;
        int i = 0;
        int j = 0;
        long t = System.currentTimeMillis();
        boolean letTimeForDragging = this.slowDown();
        int size = 512;
        byte[] tmp = new byte[size];
        while ((n = in.read(tmp, 0, size)) != -1) {
            ++i;
            if (this.getStatus() == 8) {
                throw new Exception("readFullly aborted !");
            }
            v.addElement(tmp);
            long t1 = System.currentTimeMillis();
            if (t1 - t > 10L) {
                letTimeForDragging = this.slowDown();
                t = t1;
            }
            if (!fastLoad && letTimeForDragging) {
                cds.tools.Util.pause(10);
                size = 512;
            } else {
                size = 8192;
            }
            vSize.addElement(new Integer(n));
            m += n;
            tmp = new byte[size];
        }
        byte[] tab = new byte[m];
        j = v.size();
        n = 0;
        for (i = 0; i < j; ++i) {
            tmp = (byte[])v.elementAt(i);
            m = (Integer)vSize.elementAt(i);
            System.arraycopy(tmp, 0, tab, n, m);
            n += m;
        }
        return tab;
    }

    protected boolean askGzip() {
        if (Aladin.GZIP == 1) {
            return true;
        }
        if (Aladin.GZIP == 0) {
            return false;
        }
        int modegzip = this.plan.getGzippedMode();
        return modegzip == 1 || modegzip == -1;
    }

    private int getTimeOut() {
        return this.plan != null && this.plan.nbLoadNet > 2 ? -1 : 10000;
    }

    private int getDepthTileProto() {
        try {
            String s = this.plan.getProperty("hips_tile_depth");
            return s == null ? 1 : Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private byte[] getFits2DFrom3DTile(byte[] buf, int z, int skip) throws Exception {
        int tileDepth = Integer.parseInt(this.plan.getProperty("hips_tile_depth"));
        int tileWidth = Integer.parseInt(this.plan.getProperty("hips_tile_width"));
        int frame = z % tileDepth;
        System.err.println("getFits2DFrom3DTile frame=" + frame + " for z=" + z);
        ByteArrayInputStream ois = new ByteArrayInputStream(buf);
        MyInputStream dis = new MyInputStream(ois);
        Fits f = new Fits();
        f.loadFITS(dis, 0, 0, 0, frame, tileWidth, tileWidth, 1, true, false);
        return this.makeFits2D(f, skip);
    }

    private byte[] makeFits2D(Fits f, int skip) throws Exception {
        if (skip == 2880) {
            return f.pixels;
        }
        ByteArrayOutputStream ois = new ByteArrayOutputStream(f.pixels.length + 2880);
        int n = 0;
        ois.write(Save.getFitsLine("SIMPLE", "T", null));
        n += 80;
        ois.write(Save.getFitsLine("BITPIX", f.bitpix + "", null));
        n += 80;
        ois.write(Save.getFitsLine("NAXIS", "2", null));
        n += 80;
        ois.write(Save.getFitsLine("NAXIS1", f.width + "", null));
        n += 80;
        ois.write(Save.getFitsLine("NAXIS2", f.height + "", null));
        n += 80;
        ois.write(Save.getFitsLine("NORDER", this.addr.order + "", null));
        n += 80;
        ois.write(Save.getFitsLine("NPIX", this.addr.npix + "", null));
        ois.write(Save.getEndBourrage(n += 80));
        ois.write(f.pixels);
        byte[] buf = ois.toByteArray();
        if (skip > 0) {
            buf = Arrays.copyOfRange(buf, skip, buf.length);
        }
        return buf;
    }

    private byte[] getStreamFromPack(String path, Addr addr, String ext, int skip) throws Exception {
        int tileDepth = this.getDepthTileProto();
        int z1 = addr.z - addr.z % tileDepth;
        byte[] buf = Util.hipsUnpack(path, addr.order, addr.npix, ext, z1, skip);
        if (buf.length == 0) {
            throw new FileNotFoundException();
        }
        if (tileDepth > 1) {
            if (ext.indexOf("fits") < 0) {
                throw new Exception("No a 3D fits 3D tile. No yet supported !");
            }
            buf = this.getFits2DFrom3DTile(buf, addr.z, skip);
        }
        return buf;
    }

    protected byte[] loadStream(String filename) throws Exception {
        return this.loadStream(filename, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadStream(String filename, int skip) throws Exception {
        long t0 = System.currentTimeMillis();
        byte[] buf = null;
        boolean local = true;
        if (this.plan != null) {
            Aladin cfr_ignored_0 = this.plan.aladin;
            Aladin.trace(5, "Tile.loadStream(" + filename + ")...");
        }
        long t1 = cds.tools.Util.getTime();
        MyInputStream dis = null;
        boolean fastLoad = this instanceof TileAllsky;
        if (filename.startsWith("http://") || filename.startsWith("https://")) {
            local = false;
            try {
                dis = cds.tools.Util.openStream(filename, false, this.askGzip(), this.getTimeOut());
                boolean bl = this.gzipped = (dis.getType() & 0x20L) != 0L;
                if (skip > 0) {
                    dis.skip(skip);
                }
                buf = this.readFully(dis, fastLoad);
                this.detectTypeColor(buf);
            }
            finally {
                if (dis != null) {
                    dis.close();
                }
            }
        }
        if (!new File(filename).exists() && this.addr.npix >= 0L) {
            try {
                buf = this.getStreamFromPack(this.plan.url, this.addr, EXT[this.extNet].substring(1), skip);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (buf == null) {
            RandomAccessFile f = null;
            try {
                f = new RandomAccessFile(filename, "r");
                byte[] c = new byte[8];
                f.readFully(c);
                this.detectTypeColor(c);
                if ((c[0] & 0xFF) == 31 && (c[1] & 0xFF) == 139) {
                    this.gzipped = true;
                    FileInputStream fgz = new FileInputStream(new File(filename));
                    dis = new MyInputStream(new GZIPInputStream(fgz));
                    if (skip > 0) {
                        dis.skip(skip);
                    }
                    buf = this.readFully(dis, fastLoad);
                } else {
                    f.seek(skip);
                    buf = new byte[(int)(f.length() - (long)skip)];
                    f.readFully(buf);
                }
            }
            finally {
                if (f != null) {
                    f.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
        }
        int t = (int)(cds.tools.Util.getTime() - t1);
        if (local) {
            this.timeStream = t;
        } else {
            this.timeNet = t;
            this.plan.incrGzipMode(this.gzipped ? 1 : 2, t);
        }
        this.sizeStream = buf.length;
        return buf;
    }

    private void detectTypeColor(byte[] c) {
        if ((c[0] & 0xFF) == 255 && (c[1] & 0xFF) == 216) {
            this.typeColor = 0;
        } else if ((c[0] & 0xFF) == 137 && c[1] == 80 && c[2] == 78 && c[3] == 71 && c[4] == 13 && c[5] == 10 && c[6] == 26 && c[7] == 10) {
            this.typeColor = 4;
        }
    }

    private int loadJpeg(String filename) throws Exception {
        byte[] streamHere = this.loadStream(filename);
        int nBytes = 0;
        long t1 = cds.tools.Util.getTime();
        this.depth = (int)CDSHealpix.pow2(this.plan.getOrderZTile());
        if (this.depth == 1) {
            nBytes = this.loadJpeg(streamHere, 0);
        } else if (((PlanHips3D)this.plan).hips3dProto) {
            int z = 0;
            ByteArrayInputStream in = new ByteArrayInputStream(streamHere);
            InputStreamAPNG apng = new InputStreamAPNG(in);
            while (apng.hasNextInputStream()) {
                int b;
                InputStream in1 = apng.nextInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((b = in1.read()) != -1) {
                    out.write(b);
                }
                out.close();
                byte[] streamFrame = out.toByteArray();
                nBytes += this.loadJpeg(streamFrame, z++);
                if (z <= this.depth) continue;
                throw new Exception("Tile depth too large");
            }
            apng.close();
            if (z < this.depth) {
                System.err.println("Tile depth too short (z=" + z + " should be " + this.depth + ")");
            }
        } else {
            nBytes = this.loadJpegCube(streamHere);
        }
        if ((this.extCache == 0 || this.extCache == 4) && this.plan.useCache) {
            this.stream = streamHere;
        }
        this.timeUncmp = (int)(cds.tools.Util.getTime() - t1);
        return nBytes;
    }

    private int loadJpegCube(byte[] stream) throws Exception {
        long t1 = cds.tools.Util.getTime();
        this.truePixels = false;
        int n = stream.length;
        Image img = Toolkit.getDefaultToolkit().createImage(stream);
        boolean encore = true;
        while (encore) {
            try {
                if (this.getStatus() == 8) {
                    throw new Exception("Aborting");
                }
                MediaTracker mt = new MediaTracker(Aladin.aladin);
                mt.addImage(img, 0);
                mt.waitForID(0);
                encore = false;
            }
            catch (InterruptedException mt) {}
        }
        int mosaicWidth = img.getWidth(Aladin.aladin);
        if (mosaicWidth == -1) {
            throw new Exception("width = -1");
        }
        int mosaicHeight = img.getHeight(Aladin.aladin);
        this.depth = this.plan.getTileDepth();
        this.width = this.height = this.plan.getTileWidth();
        byte[] mosaicPixels = this.getPixels(img, mosaicWidth, mosaicHeight);
        int mosaicX = 0;
        int mosaicY = 0;
        this.pixels = new byte[this.width * this.height * this.depth];
        for (int z = 0; z < this.depth; ++z) {
            int srcPos = mosaicY * mosaicWidth + mosaicX;
            int destPos = z * this.width * this.height;
            for (int y = 0; y < this.height; ++y) {
                System.arraycopy(mosaicPixels, srcPos, this.pixels, destPos, this.width);
                srcPos += mosaicWidth;
                destPos += this.width;
            }
            if ((mosaicX += this.width) < mosaicWidth) continue;
            mosaicY += this.height;
            mosaicX = 0;
        }
        if (this.plan.pixMode == -1) {
            this.plan.setPixMode(this.extCache == 0 ? 3 : 4);
            this.plan.setBufPixels8(this.pixels);
            this.plan.pixelMin = 0.0;
            this.plan.pixelMax = 255.0;
            this.plan.dataMin = 0.0;
            this.plan.dataMax = 255.0;
            this.plan.creatDefaultCM();
            this.plan.colorPNG = this.typeColor == 4;
        }
        this.timeUncmp = (int)(cds.tools.Util.getTime() - t1);
        return n;
    }

    private int loadJpeg(byte[] stream, int z) throws Exception {
        this.truePixels = false;
        int n = stream.length;
        Image img = Toolkit.getDefaultToolkit().createImage(stream);
        boolean encore = true;
        while (encore) {
            try {
                if (this.getStatus() == 8) {
                    throw new Exception("Aborting");
                }
                MediaTracker mt = new MediaTracker(Aladin.aladin);
                mt.addImage(img, 0);
                mt.waitForID(0);
                encore = false;
            }
            catch (InterruptedException mt) {}
        }
        this.width = img.getWidth(Aladin.aladin);
        this.height = img.getHeight(Aladin.aladin);
        if (this.width == -1) {
            throw new Exception("width = -1");
        }
        if (this.plan.colorUnknown && this instanceof TileAllsky) {
            this.plan.color = cds.tools.Util.isColoredImage(stream);
            this.plan.colorUnknown = false;
        }
        if (z != 0 && this.plan.color) {
            throw new Exception("Cube RGB not supported yet");
        }
        if (!this.plan.color) {
            byte[] pixelsHere = this.getPixels(img, this.width, this.height);
            if (this.depth == 1) {
                this.pixels = pixelsHere;
            } else {
                if (this.pixels == null) {
                    this.pixels = new byte[this.width * this.height * this.depth];
                }
                int destPos = z * this.width * this.height;
                System.arraycopy(pixelsHere, 0, this.pixels, destPos, pixelsHere.length);
            }
        } else {
            this.rgb = this.getPixelsRGB(img, this.width, this.height);
        }
        if (z == 0 && this.plan.pixMode == -1) {
            if (!this.plan.color) {
                this.plan.setPixMode(this.extCache == 0 ? 3 : 4);
                this.plan.setBufPixels8(this.pixels);
                this.plan.pixelMin = 0.0;
                this.plan.pixelMax = 255.0;
                this.plan.dataMin = 0.0;
                this.plan.dataMax = 255.0;
            } else {
                this.plan.setPixMode(this.typeColor == 4 ? 0 : 1);
                this.plan.video = 0;
            }
            this.plan.creatDefaultCM();
            this.plan.colorPNG = this.typeColor == 4;
        }
        return n;
    }

    protected double getValue(byte[] head, String key) throws Exception {
        int n = head.length / 80;
        for (int i = 0; i < n; ++i) {
            String k = new String(head, i * 80, 8).trim();
            if (!k.equals(key)) continue;
            int pos = i * 80 + 9;
            while (head[pos] == 32) {
                ++pos;
            }
            int len = 0;
            while (Character.isDigit((char)head[pos + len]) || (char)head[pos + len] == '-' || (char)head[pos + len] == '.' || Character.toUpperCase((char)head[pos + len]) == 'E') {
                ++len;
            }
            return Double.parseDouble(new String(head, pos, len));
        }
        throw new Exception();
    }

    protected int getPixelRGB(long healpixIdxPixel) {
        long startIdx = this.addr.npix * (long)this.width * (long)this.width;
        int order = (int)CDSHealpix.log2(this.width);
        if (this.plan.hpx2xy == null || this.plan.hpx2xy.length != this.width * this.width) {
            try {
                this.plan.createHealpixOrder(order);
            }
            catch (Exception e) {
                return 0;
            }
        }
        int idx = this.plan.hpx2xy((int)(healpixIdxPixel - startIdx));
        int x = idx % this.width;
        int y = this.width - idx / this.width - 1;
        return this.rgb[y * this.width + x];
    }

    protected byte getPixelByte(long healpixIdxPixel, int channel) {
        long startIdx = this.addr.npix * (long)this.width * (long)this.width;
        int order = (int)CDSHealpix.log2(this.width);
        if (this.plan.hpx2xy == null || this.plan.hpx2xy.length != this.width * this.width) {
            try {
                this.plan.createHealpixOrder(order);
            }
            catch (Exception e) {
                return 0;
            }
        }
        int idx = this.plan.hpx2xy((int)(healpixIdxPixel - startIdx));
        int x = idx % this.width;
        int y = this.width - idx / this.width - 1;
        int offsetDepth = channel * this.width * this.height;
        return this.pixels[offsetDepth + y * this.width + x];
    }

    protected double getPixelValue(long healpixIdxPixel, int channel, int mode) {
        long startIdx = this.addr.npix * (long)this.width * (long)this.width;
        if (this.plan.hpx2xy == null || this.plan.hpx2xy.length != this.width * this.width) {
            int order = (int)CDSHealpix.log2(this.width);
            try {
                this.plan.createHealpixOrder(order);
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
        int idx = this.plan.hpx2xy((int)(healpixIdxPixel - startIdx));
        return this.getPixel(idx, channel, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double getPixel(int idx, int channel, int mode) {
        int offsetDepth = channel * this.width * this.height;
        if (mode == 3) {
            int x = idx % this.width;
            int y = this.width - idx / this.width - 1;
            return this.pixels[offsetDepth + y * this.width + x];
        }
        this.setPixelOriginFreeable(false);
        try {
            double pix;
            if (!this.loadPixelsOrigin(mode)) {
                double x = Double.NaN;
                return x;
            }
            this.resetTimer();
            double d = pix = this.plan.bitpix > 0 ? (double)this.getPixValInt(this.pixelsOrigin, this.plan.bitpix, offsetDepth + idx) : this.getPixValDouble(this.pixelsOrigin, this.plan.bitpix, offsetDepth + idx);
            if (this.plan.isBlank(pix)) {
                pix = Double.NaN;
            }
            double d2 = pix;
            return d2;
        }
        finally {
            this.setPixelOriginFreeable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPixelsOriginFreeable() {
        Object object = this.lockFree;
        synchronized (object) {
            return this.pixelOriginFreeable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPixelOriginFreeable(boolean flag) {
        Object object = this.lockFree;
        synchronized (object) {
            this.pixelOriginFreeable = flag;
        }
    }

    protected byte[] getSample(Coord coo, int w, byte[] pixelsOrigin, int width) throws Exception {
        coo = Localisation.frameToFrame(coo, 0, this.plan.frameOrigin);
        if (Double.isNaN(coo.al) || Double.isNaN(coo.del)) {
            throw new Exception();
        }
        double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
        int orderPix = this.addr.order + (int)CDSHealpix.log2(width);
        long healpixIdxPixel = CDSHealpix.ang2pix_nest(orderPix, polar[0], polar[1]);
        long startIdx = this.addr.npix * (long)width * (long)width;
        if (this.plan.hpx2xy == null || this.plan.hpx2xy.length != width * width) {
            this.plan.createHealpixOrder((int)CDSHealpix.log2(width));
        }
        int idx = this.plan.hpx2xy((int)(healpixIdxPixel - startIdx));
        int xc = idx % width;
        int yc = idx / width;
        int n = Math.abs(this.plan.bitpix) / 8;
        int w2 = w / 2;
        byte[] sample = new byte[w * w * n];
        for (int i = 0; i < w * w; ++i) {
            PlanImage.setPixVal(sample, this.plan.bitpix, i, this.plan.blank);
        }
        int offsetDepth = this.addr.z < 0 ? 0 : this.addr.z * width * width;
        int posSample = 0;
        for (int y = yc - w2; y < yc + (w - w2); ++y) {
            for (int x = xc - w2; x < xc + (w - w2); ++x) {
                if (x < 0 || x >= width || y < 0 || y >= width) continue;
                int pos = (y * width + x) * n;
                for (int i = 0; i < n; ++i) {
                    sample[posSample++] = pixelsOrigin[offsetDepth + pos + i];
                }
            }
        }
        return sample;
    }

    protected boolean isARGB(byte[] head) {
        int n = head.length / 80;
        for (int i = 0; i < n; ++i) {
            if (!new String(head, i * 80, 8).equals("COLORMOD")) continue;
            return true;
        }
        return false;
    }

    private final int getPixValInt(byte[] t, int bitpix, int i) {
        PlanImage.getPixVal1(t, bitpix, i);
        switch (bitpix) {
            case 8: {
                return t[i] & 0xFF;
            }
            case 16: {
                return t[i *= 2] << 8 | t[i + 1] & 0xFF;
            }
            case 32: {
                return t[i *= 4] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
            }
        }
        return 0;
    }

    private final double getPixValDouble(byte[] t, int bitpix, int i) {
        switch (bitpix) {
            case -32: {
                return Float.intBitsToFloat(t[i *= 4] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF);
            }
            case -64: {
                return Double.longBitsToDouble((long)(t[i *= 8] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF) << 32 | (long)(t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF) & 0xFFFFFFFFL);
            }
        }
        return 0.0;
    }

    private final byte[] to8bits(byte[] pixels, int bitpix, double min, double max, int pixMode) {
        byte[] out = new byte[pixels.length / (Math.abs(bitpix) / 8)];
        int range = pixMode == 4 ? 255 : 256;
        boolean gapTransp = pixMode == 4;
        double r = (double)range / (max - min);
        --range;
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                int srcPos = z * this.width * this.height + y * this.width;
                int trgPos = z * this.width * this.height + (this.height - 1 - y) * this.width;
                int x = 0;
                while (x < this.width) {
                    double pixIn = PlanImage.getPixVal1(pixels, bitpix, srcPos);
                    out[trgPos] = this.plan.isBlank(pixIn) ? (byte)0 : (byte)((int)((double)gapTransp + (pixIn <= min ? 0.0 : (pixIn >= max ? (double)range : (pixIn - min) * r))) & 0xFF);
                    ++x;
                    ++srcPos;
                    ++trgPos;
                }
            }
        }
        return out;
    }

    protected void invLine(byte[] src, byte[] dst, int bitpix) {
        int nbytes = Math.abs(bitpix) / 8;
        for (int z = 0; z < this.depth; ++z) {
            int offset = z * this.width * this.height;
            for (int h = 0; h < this.height; ++h) {
                System.arraycopy(src, offset + h * this.width * nbytes, dst, offset + (this.height - h - 1) * this.width * nbytes, this.width * nbytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fits internalFitsLoader(byte[] stream) throws Exception {
        Fits fits = new Fits();
        try (MyInputStream is = null;){
            is = new MyInputStream(new ByteArrayInputStream(stream));
            long t = cds.tools.Util.getTime();
            fits.loadFITS(is);
            this.timeUncmp = (int)(cds.tools.Util.getTime() - t);
        }
        return fits;
    }

    protected int loadFits(String filename) throws Exception {
        boolean initPixMode;
        this.stream = this.loadStream(filename);
        boolean bl = initPixMode = this.plan.pixMode == -1;
        if (initPixMode) {
            this.plan.setPixMode(2);
        }
        Fits fits = this.internalFitsLoader(this.stream);
        fits.setFilename(filename);
        int bitpix = 8;
        double pixelMin = this.plan.pixelMin;
        double pixelMax = this.plan.pixelMax;
        this.width = fits.headerFits.getIntFromHeader("NAXIS1");
        this.height = fits.headerFits.getIntFromHeader("NAXIS2");
        try {
            this.depth = fits.headerFits.getIntFromHeader("NAXIS3");
        }
        catch (Exception exception) {
            // empty catch block
        }
        bitpix = fits.headerFits.getIntFromHeader("BITPIX");
        boolean flagARGB = fits.headerFits.hasKey("COLORMOD");
        if (flagARGB) {
            bitpix = 0;
            if (initPixMode) {
                this.plan.setPixMode(0);
            }
        }
        if (bitpix != 8 && !flagARGB) {
            this.truePixels = true;
        }
        if (flagARGB) {
            this.plan.color = true;
            this.rgb = new int[this.width * this.height];
            for (int i = 0; i < this.width * this.height; ++i) {
                this.rgb[i] = (this.stream[2880 + i * 4] & 0xFF) << 24 | (this.stream[2880 + i * 4 + 1] & 0xFF) << 16 | (this.stream[2880 + i * 4 + 2] & 0xFF) << 8 | this.stream[2880 + i * 4 + 3] & 0xFF;
            }
        } else {
            boolean flagInit;
            byte[] in = fits.pixels;
            boolean bl2 = flagInit = this.plan.bitpix == 0 || this.plan.flagRecut;
            if (flagInit) {
                boolean init = this.plan.bitpix == 0;
                this.plan.bitpix = bitpix;
                this.plan.flagRecut = false;
                try {
                    this.plan.bScale = fits.headerFits.getDoubleFromHeader("BSCALE");
                }
                catch (Exception e) {
                    this.plan.bScale = 1.0;
                }
                try {
                    this.plan.bZero = fits.headerFits.getDoubleFromHeader("BZERO");
                }
                catch (Exception e) {
                    this.plan.bZero = 0.0;
                }
                try {
                    this.plan.blank = fits.headerFits.getDoubleFromHeader("BLANK");
                    this.plan.isBlank = true;
                }
                catch (Exception e) {
                    this.plan.isBlank = false;
                }
                boolean flagPixelRange = false;
                boolean flagPixelCut = false;
                if (init) {
                    double[] a;
                    if (this.plan.pixelRange != null && (a = this.split(this.plan.pixelRange)) != null) {
                        this.plan.dataMin = (a[0] - this.plan.bZero) / this.plan.bScale;
                        this.plan.dataMax = (a[1] - this.plan.bZero) / this.plan.bScale;
                        flagPixelRange = true;
                    }
                    if (this.plan.pixelCut != null && (a = this.split(this.plan.pixelCut)) != null) {
                        this.plan.pixelMin = pixelMin = (a[0] - this.plan.bZero) / this.plan.bScale;
                        this.plan.pixelMax = pixelMax = (a[1] - this.plan.bZero) / this.plan.bScale;
                        flagPixelCut = true;
                    }
                }
                if (!flagPixelCut && !flagPixelRange) {
                    int w = this.width;
                    if (this.plan.flagRecutRadius > 0.0) {
                        double angRes = CDSHealpix.pixRes(this.addr.order + (int)CDSHealpix.log2(this.width)) / 3600.0;
                        w = (int)(this.plan.flagRecutRadius / angRes);
                    }
                    if (w > this.width) {
                        w = this.width;
                    }
                    Fits tmp = new Fits(w, w, bitpix);
                    if (this.plan.isBlank) {
                        tmp.setBlank(this.plan.blank);
                    }
                    tmp.pixels = in;
                    if (this.plan.flagRecutRadius > 0.0 && (w != this.width || this.depth != 1)) {
                        try {
                            tmp.pixels = this.getSample(this.plan.flagRecutCoo, w, in, this.width);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    double[] range = tmp.findAutocutRange(0.0, 0.0, true);
                    if (!flagPixelCut) {
                        this.plan.pixelMin = pixelMin = range[0];
                        this.plan.pixelMax = pixelMax = range[1];
                    }
                    if (!flagPixelRange) {
                        this.plan.dataMin = range[2];
                        this.plan.dataMax = range[3];
                    }
                    Aladin cfr_ignored_0 = this.plan.aladin;
                    Aladin.trace(3, "Pixel range detection on " + this.getStringNumber() + "[" + w + "x" + w + "] NaN=" + cds.tools.Util.round(range[4] * 100.0, 1) + "% => PixelMinMax=[" + cds.tools.Util.myRound(this.plan.pixelMin) + "," + cds.tools.Util.myRound(this.plan.pixelMax) + "], DataMinMax=[" + cds.tools.Util.myRound(this.plan.dataMin) + "," + cds.tools.Util.myRound(this.plan.dataMax) + "] " + (this.plan.isBlank ? " Blank=" + this.plan.blank : "") + " bzero=" + this.plan.bZero + " bscale=" + this.plan.bScale);
                } else {
                    Aladin cfr_ignored_1 = this.plan.aladin;
                    Aladin.trace(3, "Pixel properties PixelMinMax=[" + cds.tools.Util.myRound(this.plan.pixelMin) + "," + cds.tools.Util.myRound(this.plan.pixelMax) + "], DataMinMax=[" + cds.tools.Util.myRound(this.plan.dataMin) + "," + cds.tools.Util.myRound(this.plan.dataMax) + "] " + (this.plan.isBlank ? " Blank=" + this.plan.blank : "") + " bzero=" + this.plan.bZero + " bscale=" + this.plan.bScale);
                }
                this.plan.restoreCM();
                if (this.plan.aladin.frameCM != null && this.plan.aladin.frameCM.isVisible()) {
                    this.plan.aladin.frameCM.showCM();
                }
            }
            this.pixels = this.to8bits(in, bitpix, pixelMin, pixelMax, 4);
            if (flagInit) {
                this.plan.initTileParam(this.width, this.height, bitpix, in, this.pixels);
            }
            in = null;
            fits.purge();
        }
        return this.stream.length;
    }

    private double[] split(String s) {
        double[] a = new double[3];
        StringTokenizer st = new StringTokenizer(s);
        a[0] = Double.parseDouble(st.nextToken());
        a[1] = Double.parseDouble(st.nextToken());
        if (st.hasMoreTokens()) {
            a[2] = PlanImage.getTransfertFct(st.nextToken());
            if (a[2] == -1.0) {
                a[2] = 3.0;
            }
        }
        return a;
    }

    private String getFileNameForPixelsOrigin() {
        String fileName;
        if (this.isCached() && (fileName = this.plan.getCacheDir()) != null) {
            return fileName + cds.tools.Util.FS + this.fileCache;
        }
        fileName = this.plan.url + "/" + this.fileNet;
        char c = this.plan.url.charAt(this.plan.url.length() - 1);
        if (c == '\\' || c == '/') {
            fileName = this.plan.url + this.fileNet;
        }
        return fileName;
    }

    protected boolean loadPixelsOrigin(int mode) {
        if (this.pixelsOrigin != null) {
            return true;
        }
        if (!this.plan.hasOriginalPixels()) {
            return false;
        }
        try {
            if (this.stream != null) {
                Aladin.trace(4, "HealpixKey.loadPixelsOrigin: from stream for " + this);
                this.pixelsOrigin = this.getPixelOriginFromStream(this.stream);
                return true;
            }
            if (mode == 1) {
                return false;
            }
            if (!(mode != 2 || this.plan.isLocalHips() || this.plan.useCache && this.isCached())) {
                return false;
            }
            String fileName = this.getFileNameForPixelsOrigin();
            this.stream = this.loadStream(fileName);
            this.pixelsOrigin = this.getPixelOriginFromStream(this.stream);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private byte[] getPixelOriginFromStream(byte[] stream) throws Exception {
        byte[] pixels = null;
        Fits fits = this.internalFitsLoader(stream);
        pixels = fits.pixels;
        return pixels;
    }

    protected int writeStream() throws Exception {
        FileOutputStream ois = this.openOutputStream();
        if (ois == null) {
            return 0;
        }
        ois.write(this.stream);
        ois.close();
        return this.stream.length;
    }

    private int writeFits() throws Exception {
        FileOutputStream ois = this.openOutputStream();
        if (ois == null) {
            return 0;
        }
        int n = 0;
        ois.write(Save.getFitsLine("SIMPLE", "T", null));
        n += 80;
        ois.write(Save.getFitsLine("BITPIX", "8", null));
        n += 80;
        ois.write(Save.getFitsLine("NAXIS", this.depth > 1 ? "3" : "2", null));
        n += 80;
        ois.write(Save.getFitsLine("NAXIS1", this.width + "", null));
        n += 80;
        ois.write(Save.getFitsLine("NAXIS2", this.height + "", null));
        n += 80;
        if (this.depth > 1) {
            ois.write(Save.getFitsLine("NAXIS3", this.depth + "", null));
            n += 80;
        }
        ois.write(Save.getFitsLine("NORDER", this.addr.order + "", null));
        n += 80;
        ois.write(Save.getFitsLine("NPIX", this.addr.npix + "", null));
        n += 80;
        if (this.addr.orderZ != -1) {
            ois.write(Save.getFitsLine("FORDER", this.addr.orderZ + "", null));
            n += 80;
            ois.write(Save.getFitsLine("FPIX", this.addr.npixZ + "", null));
            n += 80;
        }
        ois.write(Save.getEndBourrage(n));
        byte[] out = new byte[this.pixels.length];
        this.invLine(this.pixels, out, 8);
        ois.write(out);
        out = null;
        ois.close();
        return this.pixels.length + 2880;
    }

    protected byte[] getPixels(Image img, int width, int height) throws Exception {
        long t1 = cds.tools.Util.getTime();
        byte[] pixels = null;
        if (this.plan.pixMode == 4) {
            int[] rgb = this.getPixelsRGB1(img, width, height);
            pixels = new byte[rgb.length];
            for (int i = 0; i < pixels.length; ++i) {
                if ((rgb[i] & 0xFF000000) == 0) {
                    pixels[i] = 0;
                    continue;
                }
                byte p = (byte)(0xFF & rgb[i]);
                if (p == 0) {
                    p = 1;
                }
                pixels[i] = p;
            }
            rgb = null;
        } else {
            BufferedImage imgBuf = new BufferedImage(width, height, 10);
            Graphics g = imgBuf.getGraphics();
            g.drawImage(img, 0, 0, observer);
            g.finalize();
            g = null;
            pixels = ((DataBufferByte)imgBuf.getRaster().getDataBuffer()).getData();
            imgBuf.flush();
            imgBuf = null;
        }
        this.timePixel = (int)(cds.tools.Util.getTime() - t1);
        return pixels;
    }

    protected int[] getPixelsRGB(Image img, int width, int height) throws Exception {
        try {
            return this.getPixelsRGB1(img, width, height);
        }
        catch (Throwable e) {
            this.plan.garbage();
            return this.getPixelsRGB1(img, width, height);
        }
    }

    protected int[] getPixelsRGB1(Image img, int width, int height) throws Exception {
        long t1 = cds.tools.Util.getTime();
        BufferedImage imgBuf = new BufferedImage(width, height, 2);
        Graphics g = imgBuf.getGraphics();
        g.drawImage(img, 0, 0, observer);
        g.finalize();
        g = null;
        int[] rgb = ((DataBufferInt)imgBuf.getRaster().getDataBuffer()).getData();
        imgBuf.flush();
        imgBuf = null;
        this.timePixel = (int)(cds.tools.Util.getTime() - t1);
        return rgb;
    }

    protected void setStatus(int status) {
        this.setStatus(status, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(int status, boolean flagForce) {
        Object object = this.lockStatus;
        synchronized (object) {
            if (!flagForce && this.getStatus() == 8) {
                return;
            }
            this.status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getStatus() {
        Object object = this.lockStatus;
        synchronized (object) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitLock() {
        while (true) {
            if (this.lockX) {
                cds.tools.Util.pause(10);
                continue;
            }
            Object object = this.lockStatus;
            synchronized (object) {
                if (!this.lockX) {
                    this.lockX = true;
                }
            }
            if (this.lockX) break;
        }
    }

    protected void unLock() {
        this.lockX = false;
    }

    protected String getStatusString() {
        return STATUS[this.getStatus()];
    }

    protected int getMode() {
        return this.mode;
    }

    protected void setMode(int mode) {
        this.mode = mode;
    }

    public long getRam() {
        return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    private int getTimeBeforeDeath() {
        double ram = this.getRam();
        if (ram < 5.36870912E8) {
            return 3000;
        }
        double fct = ram / (double)Runtime.getRuntime().maxMemory();
        return fct < 0.1 ? 3000 : (fct < 0.25 ? 6000 : (fct < 0.5 ? 9000 : 12000));
    }

    protected int getLive() {
        int status = this.getStatus();
        long time = this.getLiveTime();
        if (time == -1L) {
            return -3;
        }
        if ((status == 7 || status == 5) && this.parente == 0) {
            return -3;
        }
        if (this.getCurrentLiveTime() <= time) {
            return -3;
        }
        if (this.getCurrentLiveTime() > time + (long)this.getTimeBeforeDeath()) {
            return -1;
        }
        return -2;
    }

    protected long getLiveTime() {
        if (this.addr.order == 0 && !this.plan.hasAllSky) {
            return -1L;
        }
        return 3000L;
    }

    protected long getCurrentLiveTime() {
        return System.currentTimeMillis() - this.timer;
    }

    protected void setOld() {
        this.timer -= 3000L;
    }

    protected void resetTimer() {
        this.timer = System.currentTimeMillis();
    }

    private void setTimerLoad() {
        this.timerLoad = System.currentTimeMillis();
    }

    public static PointD[] grow(PointD[] b, double val) throws Exception {
        int i;
        int j = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (b[i2] != null) continue;
            ++j;
        }
        if (j > 1) {
            return b;
        }
        PointD[] b1 = new PointD[b.length];
        for (i = 0; i < 4; ++i) {
            b1[i] = new PointD(b[i].x, b[i].y);
        }
        for (i = 0; i < 2; ++i) {
            int g;
            int d;
            int c;
            int a = i == 1 ? 1 : 0;
            int n = c = i == 1 ? 2 : 3;
            if (b1[a] == null) {
                if (a == 0 || a == 3) {
                    d = 1;
                    g = 2;
                } else {
                    d = 0;
                    g = 3;
                }
                b1[a] = new PointD((b1[d].x + b1[g].x) / 2.0, (b1[d].y + b1[g].y) / 2.0);
            }
            if (b1[c] == null) {
                if (c == 0 || c == 3) {
                    d = 1;
                    g = 2;
                } else {
                    d = 0;
                    g = 3;
                }
                b1[c] = new PointD((b1[d].x + b1[g].x) / 2.0, (b1[d].y + b1[g].y) / 2.0);
            }
            if (b1[a] == null || b1[c] == null) continue;
            double angle = FastMath.atan2(b1[c].y - b1[a].y, b1[c].x - b1[a].x);
            double chouilla = val * FastMath.cos(angle);
            b1[a].x -= chouilla;
            b1[c].x += chouilla;
            chouilla = val * FastMath.sin(angle);
            b1[a].y -= chouilla;
            b1[c].y += chouilla;
        }
        return b1;
    }

    private int drawFils(Graphics g, ViewSimple v, int channel) {
        return this.drawFils(g, v, channel, 1);
    }

    private int drawFils(Graphics g, ViewSimple v, int channel, int maxParente) {
        int n = 0;
        int limitOrder = 19;
        if (this.width > 1 && this.addr.order < limitOrder && this.parente < maxParente) {
            this.fils = this.getChild();
            if (this.fils != null) {
                for (int i = 0; i < 4; ++i) {
                    if (this.fils[i] == null) continue;
                    n += this.fils[i].draw(g, v, channel, maxParente);
                }
            }
        }
        return n;
    }

    private boolean isModeRGB(ViewSimple v) {
        Spectrogram sp = v.getSpectrogram();
        return sp != null && sp.isModeRGB();
    }

    protected int[] getPixelRgb(ViewSimple v, int channel) {
        if (this.isModeRGB(v)) {
            try {
                return this.createRGB3D(v, channel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.rgb;
    }

    protected double getFrequence(int depth, int channel) {
        try {
            int orderZTile = (int)CDSHealpix.log2(depth);
            int orderZFull = this.addr.orderZ + orderZTile;
            long npixZFull = (long)depth * this.addr.npixZ + (long)channel;
            return CalibFreq.pix2freq(orderZFull, npixZFull);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    protected long getPixZ(int depth, double freq) {
        try {
            int orderZtile = (int)CDSHealpix.log2(depth);
            int orderZFull = this.addr.orderZ + orderZtile;
            return CalibFreq.freq2pix(orderZFull, freq);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    protected int[] createRGB3D(ViewSimple v, int channel) throws Exception {
        byte[] rPix = null;
        byte[] gPix = this.getChannelPix8(this.parente == 0 ? this.pixels : this.getPixelFromAncetre(), channel);
        byte[] bPix = null;
        int depth = this.plan.getTileDepth();
        long pixZ = this.addr.npixZ * (long)depth + (long)channel;
        byte[] pix = null;
        for (int c = 0; c < 2; ++c) {
            double fq = c == 0 ? v.getSpectrogram().getFreqRed() : v.getSpectrogram().getFreqBlue();
            long cPixZ = this.getPixZ(depth, fq);
            int cChannel = (int)(cPixZ % (long)depth);
            int deltaTile = (int)(pixZ / (long)depth - cPixZ / (long)depth);
            if (deltaTile == 0) {
                pix = this.getChannelPix8(this.parente == 0 ? this.pixels : this.getPixelFromAncetre(), cChannel);
            } else {
                Addr cAddr = new Addr(this.addr.order, this.addr.npix, this.addr.orderZ, this.addr.npixZ - (long)deltaTile);
                Tile cTile = this.plan.getTile(cAddr, true, false);
                if (cTile.getStatus() == 6) {
                    pix = cTile.getChannelPix8(this.parente == 0 ? cTile.pixels : cTile.getPixelFromAncetre(), cChannel);
                }
            }
            if (c == 0) {
                rPix = pix;
                continue;
            }
            bPix = pix;
        }
        if (rPix == null || bPix == null) {
            bPix = gPix;
            rPix = gPix;
        }
        ColorModel cm = this.plan.getCM();
        int[] map = new int[256];
        for (int i = 0; i < map.length; ++i) {
            int val = cm.getRed(i);
            if (this.plan.pixMode == 3) {
                map[i] = 0xFF & val;
                continue;
            }
            int n = map[i] = i == 0 ? 0 : 1 + (0xFF & (int)Math.round((double)val * 0.99609375));
            if (map[i] <= 255) continue;
            map[i] = 255;
        }
        int[] rgb = new int[this.width * this.height];
        for (int i = 0; i < rgb.length; ++i) {
            int r = rPix == null ? 0 : map[0xFF & rPix[i]];
            int g = gPix == null ? 0 : map[0xFF & gPix[i]];
            int b = bPix == null ? 0 : map[0xFF & bPix[i]];
            rgb[i] = r == 0 && g == 0 && b == 0 ? 0 : 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
        return rgb;
    }

    private static Image createImageRGB_internal(int[] pix, int width, ColorModel colorModel, int mode) {
        Image img;
        int height = pix.length / width;
        if (mode == 0) {
            DataBufferInt dbuf = new DataBufferInt(pix, width * height);
            int[] bitMasks = new int[]{0xFF0000, 65280, 255, -16777216};
            SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, width, height, bitMasks);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
            img = new BufferedImage(colorModel, raster, true, null);
        } else {
            MemoryImageSource x = new MemoryImageSource(width, height, colorModel, pix, 0, width);
            img = Toolkit.getDefaultToolkit().createImage(x);
        }
        return img;
    }

    private static Image createImageByte_internal(byte[] pix, int width, ColorModel colorModel, int mode) {
        Image img;
        int height = pix.length / width;
        if (mode == 0) {
            img = new BufferedImage(width, height, 13, (IndexColorModel)colorModel);
            WritableRaster wr = img.getRaster();
            wr.setDataElements(0, 0, width, height, pix);
        } else {
            MemoryImageSource x = new MemoryImageSource(width, height, colorModel, pix, 0, width);
            img = Toolkit.getDefaultToolkit().createImage(x);
        }
        return img;
    }

    private Image createImage(ViewSimple v, int channel) throws Exception {
        Object[] pix;
        long t0;
        int newStateID = this.generateStateID(this.plan.imgID, v);
        boolean isModeRGB = this.isModeRGB(v);
        if (this.imgBuf != null && (this.plan.color && !isModeRGB || this.stateID == newStateID)) {
            if (!this.allSky) {
                ++this.plan.nbImgInBuf;
            }
            return this.imgBuf;
        }
        Image img = null;
        long l = t0 = MODE_CHECK ? (t0 = cds.tools.Util.getTime(0)) : 0L;
        if (this.plan.color || isModeRGB) {
            pix = this.parente == 0 ? this.getPixelRgb(v, channel) : this.getPixelFromAncetreRGB(v, channel);
            img = Tile.createImageRGB_internal(pix, this.width, ColorModel.getRGBdefault(), MODE);
        } else {
            pix = this.getChannelPix8(this.parente == 0 ? this.pixels : this.getPixelFromAncetre(), channel);
            img = Tile.createImageByte_internal((byte[])pix, this.width, this.plan.getCM(), MODE);
        }
        if (MODE_CHECK) {
            int n = MODE;
            MODE_TIME[n] = MODE_TIME[n] + (cds.tools.Util.getTime(0) - t0);
            if (MODE == 0 && ++MODE_NB == 5) {
                ++MODE;
                MODE_NB = 0;
            } else if (MODE == 1 && MODE_NB == 5) {
                long raster = MODE_TIME[0] / 5L;
                long toolkit = MODE_TIME[1] / 5L;
                if (raster < toolkit) {
                    MODE = 0;
                }
                MODE_CHECK = false;
                if (MODE == 1) {
                    Aladin cfr_ignored_0 = this.plan.aladin;
                    Aladin.trace(3, "Use toolkit MemoryImageSource (" + cds.tools.Util.myRound((double)raster / (double)toolkit) + "x faster than WritableRaster)");
                } else {
                    Aladin cfr_ignored_1 = this.plan.aladin;
                    Aladin.trace(3, "Use WritableRaster (" + cds.tools.Util.myRound((double)toolkit / (double)raster) + "x faster than toolkit MemoryImageSource)");
                }
            }
        }
        if (!this.allSky) {
            ++this.plan.nbImgCreated;
        }
        this.stateID = newStateID;
        if (this.plan.aladin.enoughMemory()) {
            this.imgBuf = img;
        }
        return img;
    }

    private int generateStateID(int imgID, ViewSimple v) {
        Spectrogram sp = v.getSpectrogram();
        int mode = sp == null ? 0 : sp.getStateID();
        return mode | imgID;
    }

    protected byte[] getChannelPix8(int channel) {
        return this.getChannelPix8(this.pixels, channel);
    }

    private byte[] getChannelPix8(byte[] pixels, int channel) {
        if (this.depth <= 1 || pixels == null) {
            return pixels;
        }
        byte[] pixelChannel = new byte[this.width * this.height];
        int offsetDepth = channel * this.width * this.height;
        System.arraycopy(pixels, offsetDepth, pixelChannel, 0, pixelChannel.length);
        return pixelChannel;
    }

    protected byte[] getSpectraPix8(double ra, double dec) {
        try {
            int order = (int)CDSHealpix.log2(this.width);
            double[] polar = CDSHealpix.radecToPolar(new double[]{ra, dec});
            int orderPix = order + this.addr.order;
            long npixPixel = CDSHealpix.ang2pix_nest(orderPix, polar[0], polar[1]);
            return this.getSpectraPix8(npixPixel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected byte[] getSpectraPix8(long npixPixel) {
        try {
            long startIdx = this.addr.npix * (long)this.width * (long)this.width;
            int order = (int)CDSHealpix.log2(this.width);
            if (this.plan.hpx2xy == null || this.plan.hpx2xy.length != this.width * this.width) {
                try {
                    this.plan.createHealpixOrder(order);
                }
                catch (Exception e) {
                    return null;
                }
            }
            int idx = this.plan.hpx2xy((int)(npixPixel - startIdx));
            byte[] pixelSpectra = new byte[this.depth];
            int x = idx % this.width;
            int y = this.width - idx / this.width - 1;
            int offset = y * this.width + x;
            for (int z = 0; z < this.depth; ++z) {
                pixelSpectra[z] = this.pixels[z * this.width * this.height + offset];
            }
            return pixelSpectra;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected int getMem() {
        int mem = 0;
        if (this.pixels != null) {
            mem += this.pixels.length;
        } else if (this.rgb != null) {
            mem += this.rgb.length;
        }
        if (this.stream != null) {
            mem += this.stream.length;
        }
        if (this.pixelsOrigin != null) {
            mem += this.pixelsOrigin.length;
        }
        return mem;
    }

    protected int getFullMem() {
        int mem = this.getMem();
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                mem += this.fils[i].getFullMem();
            }
        }
        return mem;
    }

    protected String getLongFullMem() {
        return cds.tools.Util.getUnitDisk(this.getFullMem());
    }

    protected boolean isBehindSky(PointD[] b, ViewSimple v) {
        double sgn = v.getProj().sym ? -1.0 : 1.0;
        return ((b[1].x - b[0].x) * (b[2].y - b[0].y) - (b[2].x - b[0].x) * (b[1].y - b[0].y)) * sgn <= 0.0;
    }

    protected boolean mustBeDivided(PointD[] b) throws Exception {
        double d2;
        double d1;
        double N;
        boolean animated;
        block6: {
            block5: {
                double d;
                animated = this.plan.aladin.isAnimated();
                double m = animated ? 290400.0 : 48400.0;
                N = 48400.0;
                d1 = Tile.dist(b, 0, 2);
                if (d1 > m) break block5;
                d2 = Tile.dist(b, 2, 1);
                if (!(d > m)) break block6;
            }
            return true;
        }
        if (d1 == 0.0 || d2 == 0.0) {
            throw new Exception("Rhomb error");
        }
        double diag1 = Tile.dist(b, 0, 3);
        double diag2 = Tile.dist(b, 1, 2);
        if (diag2 == 0.0 || diag2 == 0.0) {
            throw new Exception("Rhomb error");
        }
        double rap = animated ? 1.0 : (diag2 > diag1 ? diag1 / diag2 : diag2 / diag1);
        return rap < 0.7 && (diag1 > N || diag2 > N);
    }

    protected boolean isTooLarge(PointD[] b, int N) throws Exception {
        double d2;
        double d1;
        block8: {
            block7: {
                double d;
                if (this.plan.aladin.isAnimated()) {
                    N *= 6;
                }
                N *= N;
                d1 = Tile.dist(b, 0, 2);
                if (d1 > (double)N) break block7;
                d2 = Tile.dist(b, 2, 1);
                if (!(d > (double)N)) break block8;
            }
            return true;
        }
        if (d1 == 0.0 || d2 == 0.0) {
            throw new Exception("Rhomb error");
        }
        double diag1 = Tile.dist(b, 0, 3);
        double diag2 = Tile.dist(b, 1, 2);
        if (diag1 > (double)N || diag2 > (double)N) {
            return true;
        }
        if (diag2 == 0.0 || diag2 == 0.0) {
            throw new Exception("Rhomb error");
        }
        return false;
    }

    protected boolean mayCrossTheSky(ViewSimple v) {
        Projection proj = v.getProj();
        if (proj.t == 2 || proj.t == 1 || proj.t == 6) {
            return false;
        }
        return v.getTaille(proj) > 40.0;
    }

    protected int draw(Graphics g, ViewSimple v, int channel) {
        return this.draw(g, v, channel, -1);
    }

    private int draw(Graphics g, ViewSimple v, int channel, int maxParente) {
        if (this.addr.order < 3) {
            return this.drawFils(g, v, channel, 8);
        }
        long t1 = cds.tools.Util.getTime(0);
        int n = 0;
        PointD[] b = this.getProjViewCorners(v);
        ++nDraw;
        boolean out = false;
        if (b == null || (out = this.isOutView(v, b))) {
            if (out) {
                ++nOut;
            }
            return 0;
        }
        try {
            b = Tile.grow(b, 1.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean drawFast = this.plan.mustDrawFast();
        Projection proj = v.getProj();
        if (b[0] != null && b[1] != null && b[2] != null && b[3] != null) {
            boolean methodeTriangle;
            boolean bl = methodeTriangle = drawFast && (proj.t == 4 || proj.t == 11);
            if (methodeTriangle && (Tile.aDroite(b[0], b[1], b[2]) * Tile.aDroite(b[3], b[1], b[2]) >= 0.0 || Tile.aDroite(b[1], b[0], b[3]) * Tile.aDroite(b[2], b[0], b[3]) >= 0.0)) {
                double d03;
                double d12 = Tile.dist(b, 1, 2);
                if (d12 < (d03 = Tile.dist(b, 0, 3))) {
                    double p2;
                    double p1 = Tile.distCentre(b[0], b[1], b[2]);
                    if (p1 < (p2 = Tile.distCentre(b[3], b[1], b[2]))) {
                        b[3] = null;
                    } else {
                        b[0] = null;
                    }
                } else {
                    double p2;
                    double p1 = Tile.distCentre(b[1], b[0], b[3]);
                    if (p1 < (p2 = Tile.distCentre(b[2], b[0], b[3]))) {
                        b[2] = null;
                    } else {
                        b[1] = null;
                    }
                }
            } else {
                try {
                    boolean methodeRecursive;
                    boolean mayCrossTheSky = this.mayCrossTheSky(v);
                    boolean bl2 = methodeRecursive = (proj.t == 5 || proj.t == 3 || proj.t == 11 || proj.t == 4) && mayCrossTheSky || proj.t == 7 || proj.t == 17;
                    if (methodeRecursive && this.isTooLarge(b, proj.t == 3 ? 100 : 150)) {
                        this.resetTimer();
                        int rec = drawFast ? 1 : (proj.t == 5 ? 8 : 4);
                        int m = this.drawFils(g, v, channel, rec);
                        if (m > 0) {
                            return m;
                        }
                    } else if (!drawFast && this.mustBeDivided(b)) {
                        int m;
                        this.resetTimer();
                        int rec = 8;
                        if (this.plan.orderMax < 3) {
                            rec *= (int)CDSHealpix.pow2(3 - this.plan.orderMax);
                        }
                        if ((m = this.drawFils(g, v, channel, rec)) > 0) {
                            return m;
                        }
                    }
                    if (mayCrossTheSky && this.isTooLarge(b, Aladin.TESTHIPSDOUBLEPAINT && proj.t == 5 ? 125 : 150)) {
                        return 0;
                    }
                    if (proj.t == 6 && this.isTooLarge(b, 2 * v.rv.width / 3)) {
                        return 0;
                    }
                    if (this.isTooLarge(b, v.rv.width * 2)) {
                        return 0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        }
        if (!drawFast && (maxParente == -1 || this.parente < maxParente) && this.hpix.isPoleCorner() && (n = this.drawFils(g, v, channel, this.parente + 1)) > 0) {
            return n;
        }
        if (!(drawFast || b[0] != null && b[1] != null && b[2] != null && b[3] != null || (n = this.drawFils(g, v, channel)) <= 0)) {
            return n;
        }
        n = this.drawRhomb(g, b, v, channel);
        this.drawLosangeBorder(g, b);
        long t2 = cds.tools.Util.getTime(0);
        if (!this.allSky) {
            ++this.plan.nbImgDraw;
        }
        this.plan.cumulTimeDraw += t2 - t1;
        this.resetTimer();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int drawRhomb(Graphics g, PointD[] b, ViewSimple v, int channel) {
        boolean flagLosange = false;
        int n = 0;
        int th = -1;
        int tb = -1;
        if (b[0] == null) {
            th = 3;
        } else if (b[3] == null) {
            tb = 0;
        } else if (b[1] == null) {
            th = 2;
        } else if (b[2] == null) {
            tb = 1;
        } else {
            th = 0;
            tb = 3;
        }
        if (th == -1 && tb == -1) {
            return 0;
        }
        if (b[0] != null && b[1] != null && b[2] != null && b[3] != null && (int)b[0].x == (int)(b[1].x + b[2].x - b[3].x) && (int)b[0].y == (int)(b[2].y + b[1].y - b[3].y)) {
            flagLosange = true;
        }
        Image img = null;
        try {
            img = this.createImage(v, channel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        Graphics2D g2d = (Graphics2D)g;
        Shape clip = g2d.getClip();
        try {
            if (th != -1) {
                n += this.drawTriangle(g2d, img, b, th, !flagLosange);
            }
            if (tb != -1 && !flagLosange) {
                n += this.drawTriangle(g2d, img, b, tb, true);
            }
        }
        catch (Throwable e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.plan.garbage();
        }
        finally {
            g2d.setClip(clip);
        }
        if (this.parente > 0) {
            this.pixels = null;
            this.rgb = null;
        }
        return n;
    }

    protected float getFadingOpacity() {
        if (this.allSky || this.timerLoad == 0L) {
            return 1.0f;
        }
        long t0 = System.currentTimeMillis();
        long t = t0 - this.timerLoad;
        float op = t >= 600L ? 1.0f : 0.1f + (float)t / 600.0f * 0.9f;
        return op;
    }

    public static double aDroite(PointD a, PointD g, PointD d) {
        double dx = d.x - g.x;
        double dy = d.y - g.y;
        return dx * a.y - dy * a.x - d.y * dx + d.x * dy;
    }

    public static double distCentre(PointD a, PointD g, PointD d) {
        double mx = (g.x + d.x) / 2.0;
        double my = (g.y + d.y) / 2.0;
        return (a.x - mx) * (a.x - mx) + (a.y - my) * (a.y - my);
    }

    public static void symetric(PointD b, PointD a, PointD g, PointD d) {
        double alpha = Math.atan2(d.y - g.y, d.x - g.x);
        double beta = Math.atan2(a.y - g.y, a.x - g.x);
        double theta = alpha - beta;
        double ax = a.x - g.x;
        double ay = a.y - g.y;
        double cost = FastMath.cos(-2.0 * theta);
        double sint = FastMath.sin(-2.0 * theta);
        double x = ax * cost + ay * sint;
        double y = -ax * sint + ay * cost;
        b.x = x + g.x;
        b.y = y + g.y;
    }

    public static double dist(PointD[] b, int g, int d) {
        double dx = b[g].x - b[d].x;
        double dy = b[g].y - b[d].y;
        double size = dx * dx + dy * dy;
        return size;
    }

    protected int drawTriangle(Graphics2D g2d, Image img, PointD[] b, int h, boolean flagClip) {
        int g;
        int d;
        switch (h) {
            case 0: {
                d = 2;
                g = 1;
                break;
            }
            case 3: {
                d = 1;
                g = 2;
                break;
            }
            case 1: {
                d = 3;
                g = 0;
                break;
            }
            default: {
                d = 0;
                g = 3;
            }
        }
        if (b[d] == null || b[g] == null) {
            return 0;
        }
        if (flagClip) {
            PointD[] b1 = null;
            try {
                b1 = Tile.grow(b, 2.0);
                Polygon p = new Polygon(new int[]{(int)(b1[h].x + 0.5), (int)(b1[d].x + 0.5), (int)(b1[g].x + 0.5)}, new int[]{(int)(b1[h].y + 0.5), (int)(b1[d].y + 0.5), (int)(b1[g].y + 0.5)}, 3);
                g2d.setClip(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double hdx = b[h].x - b[d].x;
        if (h == 0 || h == 2) {
            hdx = -hdx;
        }
        double hdy = b[h].y - b[d].y;
        if (h == 0 || h == 2) {
            hdy = -hdy;
        }
        double angle = FastMath.atan2(hdy, hdx);
        double hd = Math.sqrt(hdx * hdx + hdy * hdy);
        double mx = hd / (double)this.width;
        double hgx = b[h].x - b[g].x;
        if (h == 0 || h == 2) {
            hgx = -hgx;
        }
        double hgy = b[h].y - b[g].y;
        if (h == 0 || h == 2) {
            hgy = -hgy;
        }
        double dhg = Math.sqrt(hgx * hgx + hgy * hgy);
        double anglehg = FastMath.atan2(hgy, hgx) - angle;
        double my = dhg * FastMath.sin(anglehg) / (double)this.width;
        double sx = dhg * FastMath.cos(anglehg) / hd;
        AffineTransform tr = new AffineTransform();
        if (h == 3 || h == 1) {
            tr.translate(b[d].x + b[g].x - b[h].x, b[d].y + b[g].y - b[h].y);
        } else {
            tr.translate(b[h].x, b[h].y);
        }
        tr.rotate(angle);
        tr.scale(mx, my);
        tr.shear(sx, 0.0);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.plan.mustDrawFast() && this.addr.order - this.parente < this.plan.orderMax || this.addr.order - this.parente >= this.plan.orderMax ? RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR : RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (img == null) {
            return 0;
        }
        g2d.drawImage(img, tr, this.plan.aladin);
        return 1;
    }

    protected final void drawLosangeBorder(Graphics g, PointD[] b1) {
        this.drawLosangeBorder(g, b1, false);
    }

    protected final void drawLosangeBorder(Graphics g, PointD[] b1, boolean force) {
        if (!this.plan.ref) {
            return;
        }
        if (!force) {
            Aladin cfr_ignored_0 = this.plan.aladin;
            if (Aladin.levelTrace < 6) {
                return;
            }
        }
        PointD[] b = new PointD[4];
        int j = 0;
        for (int i = 0; i < 4; ++i) {
            if (b1[i] == null) continue;
            b[j++] = b1[i];
        }
        Polygon p = null;
        if (j == 4) {
            p = new Polygon(new int[]{(int)b[0].x, (int)b[1].x, (int)b[3].x, (int)b[2].x}, new int[]{(int)b[0].y, (int)b[1].y, (int)b[3].y, (int)b[2].y}, 4);
        } else if (j == 3) {
            p = new Polygon(new int[]{(int)b[0].x, (int)b[1].x, (int)b[2].x}, new int[]{(int)b[0].y, (int)b[1].y, (int)b[2].y}, 3);
        } else {
            return;
        }
        Color c = this.parente > 0 ? new Color(100, 100, 0) : Color.green;
        g.setColor(j == 3 ? Color.red : c);
        g.drawPolygon(p);
    }

    protected final void drawTileBorder(Graphics g, ViewSimple v, Color gridColor, Color gridLabel1, Color gridLabel2) {
        PointD[] b = this.getProjViewCorners(v);
        if (b == null || b[0] == null || b[1] == null || b[2] == null || b[3] == null) {
            return;
        }
        double c0 = Tile.dist(b, 0, 1);
        double c1 = Tile.dist(b, 0, 2);
        double c2 = Tile.dist(b, 1, 3);
        double c3 = Tile.dist(b, 2, 3);
        double min = Math.min(Math.min(c0, c1), Math.min(c2, c3));
        double min2 = 20.0 * min;
        if (gridColor != null) {
            g.setColor(gridColor);
        }
        if (c0 < min2) {
            g.drawLine((int)b[0].x, (int)b[0].y, (int)b[1].x, (int)b[1].y);
        }
        if (c1 < min2) {
            g.drawLine((int)b[0].x, (int)b[0].y, (int)b[2].x, (int)b[2].y);
        }
        if (c2 < min2) {
            g.drawLine((int)b[1].x, (int)b[1].y, (int)b[3].x, (int)b[3].y);
        }
        if (c3 < min2) {
            g.drawLine((int)b[2].x, (int)b[2].y, (int)b[3].x, (int)b[3].y);
        }
        this.drawNumber(g, v, b, gridLabel1, gridLabel2);
    }

    private final void drawNumber(Graphics g, ViewSimple v, PointD[] b, Color colorLabel1, Color colorLabel2) {
        if (v.isAllSky()) {
            return;
        }
        String s = this.getStringNumber();
        FontMetrics m = g.getFontMetrics();
        int size = m.stringWidth(s);
        int h = m.getHeight();
        double xMin = Math.min(Math.min(b[0].x, b[1].x), Math.min(b[2].x, b[3].x));
        double xMax = Math.max(Math.max(b[0].x, b[1].x), Math.max(b[2].x, b[3].x));
        double dist = xMax - xMin;
        if ((double)size < dist) {
            int x = (int)(b[0].x + b[1].x + b[2].x + b[3].x) / 4 - size / 2;
            int y = (int)(b[0].y + b[1].y + b[2].y + b[3].y) / 4 + h / 2;
            boolean a = false;
            boolean c = false;
            a = x < 3;
            if (a) {
                x = 3;
            } else {
                a = x + size + 3 > v.rv.width;
                if (a) {
                    x = v.rv.width - size - 3;
                }
            }
            if (c = y < 25) {
                y = 25;
            } else {
                c = y + 25 > v.rv.height;
                if (c) {
                    y = v.rv.height - 25;
                }
            }
            if (a || c) {
                if (dist < 150.0) {
                    return;
                }
                Polygon pol = new Polygon();
                pol.addPoint((int)b[0].x, (int)b[0].y);
                pol.addPoint((int)b[1].x, (int)b[1].y);
                pol.addPoint((int)b[3].x, (int)b[3].y);
                pol.addPoint((int)b[2].x, (int)b[2].y);
                if (!pol.contains(x, y) || !pol.contains(x + size, y)) {
                    return;
                }
            }
            int w = m.stringWidth(this.addr.order + "");
            if (colorLabel1 != null) {
                g.setColor(colorLabel1);
            }
            g.drawString(this.addr.order + "", x, y - 4);
            if (colorLabel2 != null) {
                g.setColor(colorLabel2);
            }
            g.drawString(this.addr.npix + "", x + w + 4, y + 4);
            g.drawString("/", x + w, y);
        }
    }

    protected void drawRealBorders(Graphics g, ViewSimple v) {
        block4: {
            try {
                Projection proj = v.getProj();
                double[][] x = CDSHealpix.borders(this.addr.order, this.addr.npix, 50);
                for (int i = 0; i < x.length; ++i) {
                    Coord c = new Coord(x[i][0], x[i][1]);
                    int frame = this.hpix.getFrame();
                    if (frame != 0) {
                        c = Localisation.frameToFrame(c, frame, 0);
                    }
                    proj.getXY(c);
                    if (Double.isNaN(c.x)) continue;
                    PointD p = v.getViewCoordDble(c.x, c.y);
                    g.drawLine((int)p.x, (int)p.y, (int)p.x, (int)p.y);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
    }

    protected void drawCtrl(Graphics g1, ViewSimple v) {
        Graphics2D g = (Graphics2D)g1;
        Color c = g.getColor();
        g.setColor(Color.red);
        Stroke st = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        this.drawRealBorders(g, v);
        g.setStroke(st);
        PointD[] b = this.getProjViewCorners(v);
        if (b == null || b[0] == null || b[1] == null || b[2] == null || b[3] == null) {
            return;
        }
        String s = this.getStringNumber();
        g.setFont(Aladin.PLAIN);
        try {
            s = s + " (" + CDSHealpix.nest2ring(this.addr.order - this.parente, this.addr.npix / (long)Math.pow(4.0, this.parente)) + ")";
        }
        catch (Exception exception) {
            // empty catch block
        }
        int size = g.getFontMetrics().stringWidth(s);
        int x = (int)(b[0].x + b[1].x + b[2].x + b[3].x) / 4;
        int y = (int)(b[0].y + b[1].y + b[2].y + b[3].y) / 4 + 7;
        if (Math.abs(b[2].x - b[1].x) < (double)(size + 18)) {
            y = (int)Math.min(Math.min(b[0].y, b[1].y), Math.min(b[2].y, b[3].y)) - 10;
        }
        g.drawString(s, x - size / 2, y + 3);
        g.setColor(c);
    }

    protected long getFather() {
        return this.addr.npix / 4L;
    }

    protected long[] getChildren() {
        return this.getChildren(null);
    }

    protected long[] getChildren(long[] pixChild) {
        if (pixChild == null) {
            pixChild = new long[]{this.addr.npix * 4L, this.addr.npix * 4L + 1L, this.addr.npix * 4L + 2L, this.addr.npix * 4L + 3L};
        }
        return pixChild;
    }

    protected Coord[] getCorners() {
        return this.hpix.getCorners();
    }

    protected boolean isOutView(ViewSimple v) {
        return this.hpix.isOutView(v, null);
    }

    protected boolean isOutView(ViewSimple v, PointD[] b) {
        return this.hpix.isOutView(v, b);
    }

    protected final PointD[] getProjViewCorners(ViewSimple v) {
        return this.hpix.getProjViewCorners(v);
    }

    Tile[] getTileList() {
        return null;
    }

    protected int getLosangeOrder() {
        return (int)CDSHealpix.log2(this.width);
    }

    protected int getLosangeForder() {
        return (int)CDSHealpix.log2(32L);
    }

    @Override
    public int compareTo(Tile o) {
        return this.priority - o.priority;
    }
}

