/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Command;
import cds.aladin.Localisation;
import cds.aladin.Tok;
import cds.aladin.prop.PropPanel;
import cds.tools.Util;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TargetHistory {
    static final int MAX = 100;
    static final String SEP = ": ";
    static final String LAST = "Last: ";
    private Aladin aladin;
    private ArrayList<String> list;
    private FrameMemoLoc frameMemoLoc = null;

    protected TargetHistory(Aladin aladin) {
        this.aladin = aladin;
        this.list = new ArrayList();
    }

    protected ArrayList<String> getList() {
        return this.list;
    }

    protected static String getLabel(String target) {
        if (target == null) {
            return null;
        }
        int i = target.indexOf(SEP);
        if (i < 0) {
            return null;
        }
        return target.substring(0, i).trim();
    }

    protected static String getLoc(String target) {
        if (target == null) {
            return null;
        }
        int i = target.indexOf(SEP);
        if (i < 0) {
            return target;
        }
        return target.substring(i + SEP.length()).trim();
    }

    protected void add(String target) {
        this.add(target, true);
    }

    protected void add(String target, boolean check) {
        if (check && !Localisation.notCoord(target) && this.aladin.calque.isFree()) {
            return;
        }
        String label = TargetHistory.getLabel(target);
        String loc = TargetHistory.getLoc(target);
        if (loc == null || loc.length() == 0) {
            return;
        }
        loc = this.sexaCommaSep(loc);
        if (check) {
            if (!(Command.isDateCmd(loc) || Localisation.notCoord(loc) || Localisation.hasFoxSuffix(loc))) {
                loc = loc + " " + this.aladin.localisation.getFrameFox();
            }
            this.removeLoc(target);
            this.removeLabel(target);
        }
        target = loc;
        if (label != null && label.length() > 0) {
            target = label + SEP + loc;
        }
        this.list.add(target);
        if (this.list.size() > 100) {
            this.list.remove(0);
        }
        if (check) {
            this.aladin.notification("\n" + target + "\nadded in the target history");
        }
    }

    private String sexaCommaSep(String loc) {
        if (Localisation.notCoord(loc)) {
            return loc;
        }
        String fox = "";
        String loc1 = loc;
        if (Localisation.hasFoxSuffix(loc)) {
            int i = loc.lastIndexOf(32);
            fox = loc.substring(i);
            loc = loc.substring(0, i);
        }
        if (new Tok(loc, " ").countTokens() < 3) {
            return loc1;
        }
        int j = loc.indexOf(43);
        if (j < 0) {
            j = loc.indexOf(45);
        }
        Tok tok = new Tok(loc.substring(0, j), " ");
        StringBuilder res1 = new StringBuilder();
        while (tok.hasMoreTokens()) {
            if (res1.length() > 0) {
                res1.append(':');
            }
            res1.append(tok.nextToken());
        }
        tok = new Tok(loc.substring(j), " ");
        StringBuilder res2 = new StringBuilder();
        while (tok.hasMoreTokens()) {
            if (res2.length() > 0) {
                res2.append(':');
            }
            res2.append(tok.nextToken());
        }
        return res1 + " " + res2 + fox;
    }

    protected void setCurrentPos(String loc) {
        this.removeCurrentPos();
        this.list.add(LAST + loc);
    }

    private void removeCurrentPos() {
        this.removeLabel(LAST);
    }

    protected boolean removeLoc(String target) {
        int i;
        boolean rep = false;
        while ((i = this.findLoc(target)) >= 0) {
            this.list.remove(i);
            rep = true;
        }
        return rep;
    }

    private int findLoc(String target) {
        String loc = TargetHistory.getLoc(target);
        for (int i = 0; i < this.list.size(); ++i) {
            if (!TargetHistory.getLoc(this.list.get(i)).equals(loc)) continue;
            return i;
        }
        return -1;
    }

    protected boolean removeLabel(String target) {
        int i;
        boolean rep = false;
        while ((i = this.findLabel(target)) >= 0) {
            this.list.remove(i);
            rep = true;
        }
        return rep;
    }

    private int findLabel(String target) {
        String label = TargetHistory.getLabel(target);
        if (label == null) {
            return -1;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (!label.equals(TargetHistory.getLabel(this.list.get(i)))) continue;
            return i;
        }
        return -1;
    }

    protected String removeFox(String loc) {
        String fox = " " + this.aladin.localisation.getFrameFox();
        if (loc != null && loc.endsWith(fox)) {
            loc = loc.substring(0, loc.length() - fox.length());
        }
        return loc;
    }

    protected String getLast() {
        if (this.list.size() == 0) {
            return "";
        }
        String s = TargetHistory.getLoc(this.list.get(this.list.size() - 1));
        return this.removeFox(s);
    }

    protected ArrayList<String> getTargets4Menu(int index, int nb) {
        ArrayList<String> a = new ArrayList<String>(nb);
        int n = this.list.size() - 1 - index;
        for (int i = 0; i < nb && n >= 0; ++i, --n) {
            String target = this.list.get(n);
            a.add(target);
        }
        if (n > 0) {
            a.add("...");
        }
        return a;
    }

    protected void createFrame(String loc, String name) {
        if (this.frameMemoLoc == null) {
            this.frameMemoLoc = new FrameMemoLoc(this.aladin);
        } else {
            this.frameMemoLoc.setVisible(true);
        }
        this.frameMemoLoc.set(loc, name);
    }

    class FrameMemoLoc
    extends JFrame {
        protected Aladin aladin;
        private JTextField fieldLoc;
        private JTextField fieldLabel;

        protected FrameMemoLoc(Aladin aladin) {
            this.aladin = aladin;
            Aladin.setIcon(this);
            this.setTitle(Aladin.chaine.getString("MEMOLOCTITLE"));
            this.enableEvents(64L);
            Util.setCloseShortcut(this, true, aladin);
            this.setLocation(Aladin.computeLocation(this));
            this.getContentPane().add((Component)this.createPanel(), "Center");
            this.getContentPane().add((Component)this.getPanelBottom(), "South");
            this.pack();
            this.setVisible(true);
            final JTextField t = this.fieldLabel;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    t.grabFocus();
                    t.requestFocus();
                }
            });
        }

        @Override
        public void processWindowEvent(WindowEvent e) {
            if (e.getID() == 201) {
                TargetHistory.this.frameMemoLoc = null;
            }
            super.processWindowEvent(e);
        }

        private JPanel createPanel() {
            GridBagConstraints c = new GridBagConstraints();
            GridBagLayout g = new GridBagLayout();
            c.fill = 1;
            c.anchor = 17;
            c.gridwidth = 0;
            c.insets = new Insets(0, 0, 0, 0);
            JPanel p = new JPanel();
            p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            p.setLayout(g);
            JLabel label = new JLabel(Aladin.chaine.getString("MEMOLOC") + TargetHistory.SEP);
            label.setFont(label.getFont().deriveFont(1));
            JPanel p3 = new JPanel(new GridLayout(1, 2));
            this.fieldLoc = new JTextField(25);
            p3.add(this.fieldLoc);
            PropPanel.addCouple(p, label, p3, g, c);
            label = new JLabel(Aladin.chaine.getString("MEMOLOCNAME") + TargetHistory.SEP);
            label.setFont(label.getFont().deriveFont(1));
            p3 = new JPanel(new GridLayout(1, 2));
            this.fieldLabel = new JTextField(25);
            this.fieldLabel.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getExtendedKeyCode() == 10 && FrameMemoLoc.this.fieldLoc != null && FrameMemoLoc.this.fieldLoc.getText().length() > 1) {
                        FrameMemoLoc.this.submit();
                    }
                }
            });
            p3.add(this.fieldLabel);
            PropPanel.addCouple(p, label, p3, g, c);
            return p;
        }

        void set(String loc, String label) {
            this.fieldLoc.setText(loc);
            this.fieldLabel.setText(label);
        }

        protected JPanel getPanelBottom() {
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(1));
            JButton b = new JButton(Aladin.chaine.getString("MEMOSUBMIT"));
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameMemoLoc.this.submit();
                }
            });
            b = new JButton(Aladin.chaine.getString("SFCANCEL"));
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TargetHistory.this.frameMemoLoc = null;
                    FrameMemoLoc.this.dispose();
                }
            });
            b = new JButton(Aladin.chaine.getString("MEMOCLEAN"));
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameMemoLoc.this.resetList();
                    TargetHistory.this.frameMemoLoc = null;
                    FrameMemoLoc.this.dispose();
                }
            });
            JButton h = Util.getHelpButton(this, Aladin.chaine.getString("MEMOLOCHELP"));
            p.add(h);
            return p;
        }

        private void submit() {
            String s;
            int indiceLabel;
            String label = this.fieldLabel.getText().trim();
            String loc = this.fieldLoc.getText().trim();
            if (label.length() > 0 && (indiceLabel = TargetHistory.this.findLabel(label + TargetHistory.SEP)) >= 0 && !loc.equals(s = TargetHistory.getLoc((String)TargetHistory.this.list.get(indiceLabel)))) {
                if (!Aladin.confirmation(this, Aladin.chaine.getString("MEMOLOCDUP"))) {
                    return;
                }
            }
            String target = loc;
            if (label.length() > 0) {
                target = label + TargetHistory.SEP + loc;
            }
            this.aladin.targetHistory.add(target);
            TargetHistory.this.frameMemoLoc = null;
            this.dispose();
        }

        private void resetList() {
            if (!Aladin.confirmation(this, Aladin.chaine.getString("MEMOLOCCONFRESET"))) {
                return;
            }
            TargetHistory.this.list.clear();
        }
    }
}

