/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.DataLabelTable;
import cds.aladin.MocDataLabelTable;
import cds.aladin.MyProperties;
import cds.aladin.Server;
import cds.aladin.SimpleDataLabelTable;
import cds.aladin.TapManager;
import cds.mocmulti.MocItem2;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public final class TapFrameServer
extends JFrame
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    static String FSTAPCONTROLLER;
    static String INFO;
    static String CLOSE;
    static String TIPSUBMIT;
    static String TIPCLOSE;
    static String FILTER;
    static String RESET;
    static String GO;
    static String LOAD;
    static String TIPLOAD;
    static String TIPRELOAD;
    static String TAPNOFILELOAD;
    static String TAPNOFILERELOAD;
    static String SELECTSERVERLABEL;
    static String SELECTSERVERTOOLTIP;
    static String NOTAPSERVERSCONFIGUREDMESSAGE;
    static String TAPURLCLIENTFIELDLABEL;
    static String SELECTDIRTAPSERVERSTOOLTIP;
    static String SELECTSPLTAPSERVERSLABEL;
    static String SELECTSPLTAPSERVERSTOOLTIP;
    static String SELECTDIRTAPSERVERSLABEL;
    static String CHOOSEFROMTAPSERVERSTEXT;
    static String WAITLOADINGTAPSERVERSLIST;
    static String INCORRECTTAPURLMESSAGE;
    Aladin aladin;
    TapManager tapManager;
    JTextField filter = null;
    private JPanel splListPanelScroll;
    private JPanel completeListPanelScroll;
    JTable preselectedServersTable;
    JTable allServersTable;
    MocDataLabelTable allServersDataLabelTable;
    SimpleDataLabelTable splServersDataLabelTable;
    TableModelListener tableListener;
    JPanel registryPanel;
    JPanel splRegistryPanel;
    JPanel treeRegistryPanel;
    public Vector<String> selectedServerLabel;
    JTabbedPane options;
    JLabel info = new JLabel();
    public static int labelId;
    public static int urlId;
    public static int descriptionId;
    JTextField userProvidedTapUrl;

    protected void createChaine() {
        GO = Aladin.chaine.getString("FSGO");
        RESET = Aladin.chaine.getString("RESET");
        FILTER = Aladin.chaine.getString("FSFILTER");
        CLOSE = Aladin.chaine.getString("CLOSE");
        TIPSUBMIT = Aladin.chaine.getString("TIPSUBMIT");
        TIPCLOSE = Aladin.chaine.getString("TIPCLOSE");
        LOAD = Aladin.chaine.getString("FSLOAD");
        TIPLOAD = Aladin.chaine.getString("TIPLOAD");
        FSTAPCONTROLLER = Aladin.chaine.getString("FSTAPCONTROLLER");
        TIPRELOAD = Aladin.chaine.getString("TIPRELOAD");
        TAPNOFILELOAD = Aladin.chaine.getString("TAPNOFILELOAD");
        TAPNOFILERELOAD = Aladin.chaine.getString("TAPNOFILERELOAD");
        SELECTSERVERLABEL = Aladin.chaine.getString("SELECTSERVERLABEL");
        SELECTSERVERTOOLTIP = Aladin.chaine.getString("SELECTSERVERTOOLTIP");
        NOTAPSERVERSCONFIGUREDMESSAGE = Aladin.chaine.getString("NOTAPSERVERSCONFIGUREDMESSAGE");
        TAPURLCLIENTFIELDLABEL = Aladin.chaine.getString("TAPURLCLIENTFIELDLABEL");
        SELECTDIRTAPSERVERSTOOLTIP = Aladin.chaine.getString("SELECTDIRTAPSERVERSTOOLTIP");
        SELECTSPLTAPSERVERSLABEL = Aladin.chaine.getString("SELECTSPLTAPSERVERSLABEL");
        SELECTSPLTAPSERVERSTOOLTIP = Aladin.chaine.getString("SELECTSPLTAPSERVERSTOOLTIP");
        SELECTDIRTAPSERVERSLABEL = Aladin.chaine.getString("SELECTDIRTAPSERVERSLABEL");
        CHOOSEFROMTAPSERVERSTEXT = Aladin.chaine.getString("CHOOSEFROMTAPSERVERSTEXT");
        WAITLOADINGTAPSERVERSLIST = Aladin.chaine.getString("WAITLOADINGTAPSERVERSLIST");
        INCORRECTTAPURLMESSAGE = Aladin.chaine.getString("INCORRECTTAPURLMESSAGE");
    }

    protected TapFrameServer(Aladin aladin, TapManager tapManager) {
        this.setName("REGISTRYPANEL");
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(FSTAPCONTROLLER);
        this.tapManager = tapManager;
        this.aladin = aladin;
        this.setLocation(Aladin.computeLocation(this));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(650, 450);
    }

    public JPanel createCenterPane() {
        this.splRegistryPanel = new JPanel();
        this.treeRegistryPanel = new JPanel();
        this.registryPanel = new JPanel(new BorderLayout());
        this.setInit();
        this.options = new JTabbedPane();
        this.registryPanel.add((Component)this.options, "Center");
        this.registryPanel.setFont(Aladin.PLAIN);
        this.options.addTab(SELECTSPLTAPSERVERSLABEL, null, this.splRegistryPanel, SELECTSPLTAPSERVERSTOOLTIP);
        this.options.addTab(SELECTDIRTAPSERVERSLABEL, null, this.treeRegistryPanel, SELECTDIRTAPSERVERSTOOLTIP);
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.registryPanel, "Center");
        this.pack();
        return this.registryPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPreselectedServers() {
        JPanel jPanel = this.splRegistryPanel;
        synchronized (jPanel) {
            Aladin.makeCursor(this.splRegistryPanel, 1);
            this.splRegistryPanel.removeAll();
            this.splRegistryPanel.setLayout(new BorderLayout(0, 0));
            int scrollWidth = 400;
            int scrollHeight = 350;
            try {
                Vector<Vector<String>> datalabels = this.tapManager.getPreSelectedTapServers();
                if (datalabels != null && !datalabels.isEmpty()) {
                    JScrollPane scroll = new JScrollPane(this.splListPanelScroll);
                    scroll.setSize(scrollWidth, scrollHeight);
                    scroll.setBackground(Color.white);
                    scroll.getVerticalScrollBar().setUnitIncrement(70);
                    this.fillWithSplRegistryServers();
                    Aladin.makeAdd(this.splRegistryPanel, scroll, "Center");
                    JPanel submit = new JPanel();
                    submit.setName("SubmitPanel");
                    JButton b = new JButton(LOAD);
                    submit.add(b);
                    b.addActionListener(this);
                    b.setToolTipText(TIPLOAD);
                    b = new JButton(CLOSE);
                    submit.add(b);
                    b.addActionListener(this);
                    b.setToolTipText(TIPCLOSE);
                    Aladin.makeAdd(this.registryPanel, submit, "South");
                    this.info.setText(CHOOSEFROMTAPSERVERSTEXT);
                } else {
                    this.showSplListNotLoaded();
                }
            }
            catch (Exception e) {
                this.showSplListNotLoaded();
            }
            Aladin.makeCursor(this.splRegistryPanel, 0);
        }
        this.pack();
    }

    public void addUrlPanel() {
        JPanel urlClientPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 1, 1);
        c.gridx = 0;
        c.insets = new Insets(10, 1, 1, 1);
        c.weightx = 0.05;
        urlClientPanel.add((Component)new JLabel(TAPURLCLIENTFIELDLABEL), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.userProvidedTapUrl = new JTextField();
        this.userProvidedTapUrl.setPreferredSize(new Dimension(240, Server.HAUT));
        c.anchor = 17;
        c.fill = 2;
        urlClientPanel.add((Component)this.userProvidedTapUrl, c);
        JButton loadUserUrl = new JButton(LOAD);
        loadUserUrl.setActionCommand("LOADCLIENTTAPURL");
        loadUserUrl.addActionListener(this);
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 1, 1, 35);
        c.weightx = 0.05;
        c.gridx = 2;
        urlClientPanel.add((Component)loadUserUrl, c);
        JPanel header = new JPanel(new BorderLayout(0, 7));
        header.add((Component)urlClientPanel, "North");
        this.info.setText(WAITLOADINGTAPSERVERSLIST);
        header.add((Component)this.info, "West");
        this.registryPanel.add((Component)header, "North");
        this.pack();
    }

    public void showListNotLoaded(JComponent component) {
        component.removeAll();
        component.add(new JLabel(NOTAPSERVERSCONFIGUREDMESSAGE));
    }

    public synchronized void showSplListNotLoaded() {
        this.showListNotLoaded(this.splRegistryPanel);
    }

    public void showCompleteListNotLoaded() {
        this.showListNotLoaded(this.treeRegistryPanel);
    }

    public void showRegistryNotLoaded() {
        this.info.setText(NOTAPSERVERSCONFIGUREDMESSAGE);
        this.showCompleteListNotLoaded();
        this.showSplListNotLoaded();
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAllServers() {
        JPanel jPanel = this.treeRegistryPanel;
        synchronized (jPanel) {
            int scrollWidth = 400;
            int scrollHeight = 350;
            this.completeListPanelScroll = new JPanel();
            try {
                if (this.tapManager.isValidTapServerList()) {
                    this.info.setText(CHOOSEFROMTAPSERVERSTEXT);
                    if (this.fillWithRegistryServers(null)) {
                        JPanel check = new JPanel();
                        check.add(new JLabel(FILTER + ": "));
                        this.filter = new JTextField(15);
                        check.add(this.filter);
                        this.filter.addKeyListener(this);
                        JButton b = new JButton(GO);
                        check.add(b);
                        b.addActionListener(this);
                        b = new JButton(RESET);
                        check.add(b);
                        b.addActionListener(this);
                        JScrollPane scroll = new JScrollPane(this.completeListPanelScroll);
                        scroll.setSize(scrollWidth, scrollHeight);
                        scroll.setBackground(Color.white);
                        scroll.getVerticalScrollBar().setUnitIncrement(70);
                        Aladin.makeCursor(this.treeRegistryPanel, 1);
                        this.treeRegistryPanel.removeAll();
                        this.treeRegistryPanel.add((Component)check, "North");
                        Aladin.makeAdd(this.treeRegistryPanel, scroll, "Center");
                    }
                } else {
                    this.showCompleteListNotLoaded();
                }
            }
            catch (Exception e) {
                this.showCompleteListNotLoaded();
            }
            this.treeRegistryPanel.revalidate();
            this.treeRegistryPanel.repaint();
            Aladin.makeCursor(this.treeRegistryPanel, 0);
        }
        this.pack();
    }

    public void setInit() {
        this.splRegistryPanel.removeAll();
        this.splRegistryPanel.setLayout(new BorderLayout(0, 0));
        this.treeRegistryPanel.removeAll();
        this.treeRegistryPanel.setLayout(new BorderLayout(0, 0));
        this.addUrlPanel();
        this.completeListPanelScroll = new JPanel();
        this.completeListPanelScroll.add(new JLabel(WAITLOADINGTAPSERVERSLIST));
        Aladin.makeAdd(this.treeRegistryPanel, this.completeListPanelScroll, "Center");
        this.splListPanelScroll = new JPanel();
        this.splListPanelScroll.add(new JLabel(WAITLOADINGTAPSERVERSLIST));
        Aladin.makeAdd(this.splRegistryPanel, this.splListPanelScroll, "Center");
    }

    private boolean fillWithSplRegistryServers() {
        Vector<Vector<String>> datalabels = this.tapManager.getPreSelectedTapServers();
        return this.fillWithSplListRegistryServers(datalabels);
    }

    private boolean fillWithRegistryServers(String mask) {
        this.tapManager.populateTapServersFromTree(mask);
        return this.fillWithRegistryServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillWithSplListRegistryServers(Vector<Vector<String>> datalabels) {
        boolean result = false;
        JPanel jPanel = this.splListPanelScroll;
        synchronized (jPanel) {
            this.splListPanelScroll.removeAll();
            this.splListPanelScroll.setLayout(new BorderLayout(1, 1));
            if (datalabels != null && !datalabels.isEmpty()) {
                this.splServersDataLabelTable = new SimpleDataLabelTable(this.aladin, datalabels);
                this.preselectedServersTable = new TwoColorJTable(this.splServersDataLabelTable);
                this.preselectedServersTable.setGridColor(Color.lightGray);
                this.preselectedServersTable.setSelectionMode(0);
                this.preselectedServersTable.getColumnModel().getColumn(0).setPreferredWidth(150);
                this.preselectedServersTable.getColumnModel().getColumn(1).setPreferredWidth(320);
                this.preselectedServersTable.getColumnModel().getColumn(2).setPreferredWidth(700);
                this.preselectedServersTable.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.preselectedServersTable.getTableHeader().getDefaultRenderer(), this.splServersDataLabelTable));
                this.preselectedServersTable.getTableHeader().addMouseListener(new TableHeaderListener());
                this.splListPanelScroll.add((Component)this.preselectedServersTable, "Center");
                this.splListPanelScroll.add((Component)this.preselectedServersTable.getTableHeader(), "North");
                result = true;
            } else {
                this.splListPanelScroll.add(new JLabel(NOTAPSERVERSCONFIGUREDMESSAGE));
            }
            this.splListPanelScroll.revalidate();
            this.splListPanelScroll.repaint();
        }
        return result;
    }

    private boolean fillWithRegistryServers() {
        this.completeListPanelScroll.removeAll();
        this.completeListPanelScroll.setLayout(new BorderLayout(1, 1));
        Vector<String> datalabels = TapManager.allTapServerLabels;
        boolean result = false;
        if (datalabels != null && !datalabels.isEmpty()) {
            this.allServersDataLabelTable = new MocDataLabelTable(this.aladin, datalabels);
            this.allServersTable = new TwoColorJTable(this.allServersDataLabelTable);
            this.allServersTable.setGridColor(Color.lightGray);
            this.allServersTable.setSelectionMode(0);
            this.allServersTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.allServersTable.getColumnModel().getColumn(1).setPreferredWidth(320);
            this.allServersTable.getColumnModel().getColumn(2).setPreferredWidth(700);
            this.allServersTable.setRowSelectionInterval(0, 0);
            this.allServersTable.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.allServersTable.getTableHeader().getDefaultRenderer(), this.allServersDataLabelTable));
            this.allServersTable.getTableHeader().addMouseListener(new TableHeaderListener());
            this.completeListPanelScroll.add((Component)this.allServersTable, "Center");
            this.completeListPanelScroll.add((Component)this.allServersTable.getTableHeader(), "North");
            result = true;
        } else {
            this.completeListPanelScroll.add(new JLabel(NOTAPSERVERSCONFIGUREDMESSAGE));
        }
        this.completeListPanelScroll.revalidate();
        this.completeListPanelScroll.repaint();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (!(o instanceof JButton)) {
            return;
        }
        String s = ((JButton)o).getActionCommand();
        if (s.equals(INFO)) {
            for (int i = 0; i < this.aladin.dialog.server.length; ++i) {
                if (o != this.aladin.dialog.server[i].statusReport) continue;
                this.aladin.dialog.server[i].showStatusReport();
            }
        } else if (s.equals(CLOSE)) {
            this.setVisible(false);
        } else if (s.equals(GO)) {
            this.go();
        } else if (s.equals(RESET)) {
            Aladin.makeCursor(this.registryPanel, 1);
            this.reset();
            Aladin.makeCursor(this.registryPanel, 0);
        } else if (s.equals(LOAD)) {
            try {
                Aladin.makeCursor(this, 1);
                long startTime = TapManager.getTimeToLog();
                if (Aladin.levelTrace >= 4) {
                    System.out.println("In tapframeserver starting to load: " + startTime);
                }
                this.tapManager.setSelectedServerLabel();
                if (this.selectedServerLabel != null) {
                    if (this.selectedServerLabel == null || this.selectedServerLabel.size() < 2 || this.selectedServerLabel.get(labelId) == null || this.selectedServerLabel.get(urlId) == null) {
                        this.tapManager.showTapRegistryForm();
                    }
                    String nodeTable = null;
                    String gluActionName = null;
                    MocItem2 mocItem = this.aladin.directory.multiProp.getItem(this.selectedServerLabel.firstElement());
                    if (mocItem != null) {
                        MyProperties prop = this.aladin.directory.multiProp.getItem((String)this.selectedServerLabel.firstElement()).prop;
                        nodeTable = prop.get("tap_tablename");
                        gluActionName = prop.get("tap_glutag");
                    }
                    this.tapManager.loadTapServer(gluActionName, this.selectedServerLabel.get(labelId), this.selectedServerLabel.get(urlId), nodeTable);
                    this.aladin.dialog.show(this.aladin.dialog.tapServer);
                }
                Aladin.error(this, TAPNOFILELOAD);
            }
            catch (Exception e1) {
                Aladin.error(this, e1.getMessage());
            }
            finally {
                Aladin.makeCursor(this, 0);
            }
        } else if (s.equals("LOADCLIENTTAPURL")) {
            this.loadInputUrlServer();
        }
    }

    private void loadInputUrlServer() {
        try {
            Aladin.makeCursor(this, 1);
            if (this.userProvidedTapUrl.getText() != null && !this.userProvidedTapUrl.getText().isEmpty()) {
                URL tapUrl = new URL(this.userProvidedTapUrl.getText());
                Aladin.trace(3, "Will create tap client for: " + tapUrl);
                this.tapManager.loadTapServer(null, tapUrl.toString(), tapUrl.toString(), null);
                this.aladin.dialog.show(this.aladin.dialog.tapServer);
            }
        }
        catch (MalformedURLException e1) {
            if (Aladin.levelTrace >= 3) {
                e1.printStackTrace();
            }
            Aladin.error(this, INCORRECTTAPURLMESSAGE);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
        }
        finally {
            Aladin.makeCursor(this, 0);
        }
    }

    private void go() {
        Aladin.makeCursor(this, 1);
        String mask = this.filter.getText().trim();
        if (mask.length() == 0) {
            mask = null;
        }
        this.fillWithRegistryServers(mask);
        this.pack();
        Aladin.makeCursor(this, 0);
    }

    public void reset() {
        this.fillWithRegistryServers("");
        this.reloadRegistryPanel();
    }

    public void reloadRegistryPanel() {
        this.splRegistryPanel.revalidate();
        this.splRegistryPanel.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.go();
        }
    }

    static {
        INFO = " ? ";
        labelId = 0;
        urlId = 2;
        descriptionId = 1;
    }

    class TableHeaderRenderer
    extends DefaultTableCellRenderer {
        TableCellRenderer renderer;
        DataLabelTable dataLabelTable;

        public TableHeaderRenderer(TableCellRenderer defaultRenderer, DataLabelTable dataLabelTable) {
            this.renderer = defaultRenderer;
            this.dataLabelTable = dataLabelTable;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int idxSortedColView = table.convertColumnIndexToView(this.dataLabelTable.idxSortedCol);
            if (comp instanceof JLabel) {
                if (column == idxSortedColView) {
                    ImageIcon icon = this.dataLabelTable.ascSort ? Util.getAscSortIcon() : Util.getDescSortIcon();
                    ((JLabel)comp).setIcon(icon);
                    ((JLabel)comp).setHorizontalTextPosition(10);
                } else {
                    ((JLabel)comp).setIcon(null);
                }
            }
            return comp;
        }
    }

    class TableHeaderListener
    extends MouseAdapter {
        TableHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int column;
            JTable table = null;
            DataLabelTable model = null;
            Vector<Object> data = null;
            if (TapFrameServer.this.preselectedServersTable.getTableHeader().equals(e.getSource())) {
                table = TapFrameServer.this.preselectedServersTable;
                data = TapManager.splTapServerLabels;
                model = TapFrameServer.this.splServersDataLabelTable;
            } else {
                table = TapFrameServer.this.allServersTable;
                data = TapManager.allTapServerLabels;
                model = TapFrameServer.this.allServersDataLabelTable;
            }
            TableColumnModel columnModel = table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            model.idxSortedCol = column = table.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column != -1) {
                if (column == 1) {
                    int idx = table.getSelectedRow();
                    Object selected = idx >= 0 ? data.get(idx) : null;
                    model.defaultSortServers();
                    model.notifyTableChanged();
                    this.selectItem(selected, table, data);
                    return;
                }
                Comparator comp = new Comparator(){

                    public final int compare(Object a, Object b) {
                        String val1 = null;
                        String val2 = null;
                        if (a instanceof String) {
                            val1 = (String)a;
                            val2 = (String)b;
                        } else if (a instanceof Vector) {
                            val1 = ((Vector)a).get(column);
                            val2 = ((Vector)b).get(column);
                        }
                        return ((Comparable)((Object)val1)).compareTo(val2);
                    }
                };
                int idx = table.getSelectedRow();
                Object selected = idx >= 0 ? data.get(idx) : null;
                Collections.sort(data, comp);
                if (!model.ascSort) {
                    Collections.reverse(data);
                }
                model.ascSort = !model.ascSort;
                model.notifyTableChanged();
                this.selectItem(selected, table, data);
            }
        }

        private void selectItem(final Object o, final JTable table, final Vector data) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.clearSelection();
                    if (o == null) {
                        return;
                    }
                    int idxSelected = data.indexOf(o);
                    if (idxSelected >= 0) {
                        table.addRowSelectionInterval(idxSelected, idxSelected);
                    }
                }
            });
        }
    }
}

