/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Server;
import cds.aladin.TapClient;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class TapClientModesRenderer
extends BasicComboBoxRenderer {
    private static final long serialVersionUID = -4372535217338044431L;
    TapClient tapClient;
    public static Map<String, String> tooltipMap = null;

    public TapClientModesRenderer(TapClient tapClient) {
        this.tapClient = tapClient;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel option = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (index < 0) {
            this.setText("Mode");
            option.setEnabled(true);
            if (this.tapClient.model != null && this.tapClient.model.getSelectedItem() != null && this.tapClient.model.getSelectedItem() != null) {
                this.setText("Mode: " + this.tapClient.model.getSelectedItem());
            }
        } else if (value == "Basic" && this.tapClient.serverGlu == null) {
            this.makeDisabled(option, value, TapClient.NOGLURECFOUND);
            option.setSize(0, 0);
        } else if (value == "Obscore" && this.tapClient.obscoreTables.isEmpty()) {
            this.makeDisabled(option, value, "Obscore client");
        } else {
            String tooltip = null;
            String valueTxt = (String)value;
            this.setText(valueTxt);
            tooltip = valueTxt.equalsIgnoreCase(this.tapClient.nodeName) ? tooltipMap.get("NODE") : tooltipMap.get(value);
            this.setToolTipText(tooltip);
            this.setIcon(null);
            option.setEnabled(true);
        }
        this.setPreferredSize(new Dimension(105, Server.HAUT));
        return this;
    }

    public void makeDisabled(JLabel option, Object value, String tooltip) {
        this.setText((String)value);
        this.setIcon(null);
        option.setVisible(false);
        option.setEnabled(false);
        this.setToolTipText(tooltip);
    }

    static {
        tooltipMap = new HashMap<String, String>();
        tooltipMap.put("Basic", Aladin.chaine.getString("GLU_TAPMODESTOOLTIP"));
        tooltipMap.put("NODE", Aladin.chaine.getString("NODE_TAPMODESTOOLTIP"));
        tooltipMap.put("Generic", Aladin.chaine.getString("GENERIC_TAPMODESTOOLTIP"));
        tooltipMap.put("Templates", Aladin.chaine.getString("EXAMPLE_TAPMODESTOOLTIP"));
        tooltipMap.put("Obscore", Aladin.chaine.getString("OBSCORE_TAPMODESTOOLTIP"));
    }
}

