/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Cercle;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.Pickle;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.Tag;
import cds.tools.Util;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class SubFootprintBean {
    protected static final int POLYGON = 1;
    protected static final int CIRCLE = 2;
    protected static final int PICKLE = 3;
    protected static final int STRING = 4;
    protected int type = -1;
    private String name;
    private Vector<SubFootprintBean> subSubsFootprints = new Vector();
    private boolean inSphericalCoords = false;
    private double[] raOffset;
    private double[] decOffset;
    private double centerOffRa;
    private double centerOffDec;
    private double circleRadius;
    private double internalRad;
    private double externalRad;
    private double startAngle;
    private double angle;
    private double ra;
    private double dec;
    private String content;
    private String align;
    private Color c;

    protected SubFootprintBean() {
    }

    protected SubFootprintBean(double[] raOffset, double[] decOffset, String name) {
        this();
        this.type = 1;
        this.raOffset = raOffset;
        this.decOffset = decOffset;
    }

    protected SubFootprintBean(double ctrXOffset, double ctrYOffset, double radius, String name) {
        this();
        this.type = 2;
        this.centerOffRa = ctrXOffset;
        this.centerOffDec = ctrYOffset;
        this.circleRadius = radius;
    }

    protected SubFootprintBean(double ctrXOffset, double ctrYOffset, double startAngle, double angle, double intRad, double extRad, String name) {
        this();
        this.type = 3;
        this.centerOffRa = ctrXOffset;
        this.centerOffDec = ctrYOffset;
        this.startAngle = startAngle;
        this.angle = angle;
        this.internalRad = intRad;
        this.externalRad = extRad;
    }

    protected SubFootprintBean(double ra, double dec, String align, String content) {
        this();
        this.type = 4;
        this.ra = ra;
        this.dec = dec;
        this.align = align;
        this.content = content;
    }

    protected int getNbOfSubParts() {
        return this.subSubsFootprints.size();
    }

    public boolean isInSphericalCoords() {
        return this.inSphericalCoords;
    }

    public void setInSphericalCoords(boolean inSphericalCoords) {
        this.inSphericalCoords = inSphericalCoords;
    }

    protected void addSubFootprintBean(SubFootprintBean sub) {
        this.subSubsFootprints.addElement(sub);
    }

    protected Obj[] buildObjets(PlanField pf) {
        Vector<Obj> v = new Vector<Obj>();
        switch (this.type) {
            case 1: {
                int nbPts = this.raOffset.length;
                Ligne curLine = new Ligne(pf);
                v.addElement(curLine);
                double x = this.isInSphericalCoords() ? Math.toRadians(Math.cos(Math.toRadians(this.decOffset[this.decOffset.length - 1])) * this.raOffset[this.raOffset.length - 1]) : Util.tand(this.raOffset[this.raOffset.length - 1]);
                double y = this.isInSphericalCoords() ? Math.toRadians(this.decOffset[this.decOffset.length - 1]) : Util.tand(this.decOffset[this.decOffset.length - 1]);
                curLine.setXYTan(x, y);
                for (int j = 0; j < nbPts; ++j) {
                    Ligne newLine = new Ligne(pf);
                    v.addElement(newLine);
                    x = this.isInSphericalCoords() ? Math.toRadians(Math.cos(Math.toRadians(this.decOffset[j])) * this.raOffset[j]) : Util.tand(this.raOffset[j]);
                    y = this.isInSphericalCoords() ? Math.toRadians(this.decOffset[j]) : Util.tand(this.decOffset[j]);
                    newLine.setXYTan(Util.tand(this.raOffset[j]), Util.tand(this.decOffset[j]));
                    newLine.debligne = curLine;
                    curLine = newLine;
                }
                break;
            }
            case 2: {
                double xv = this.isInSphericalCoords() ? Math.toRadians(Math.cos(Math.toRadians(this.centerOffDec)) * this.centerOffRa) : Util.tand(this.centerOffRa);
                double yv = this.isInSphericalCoords() ? Math.toRadians(this.centerOffDec) : Util.tand(this.centerOffDec);
                double rv = this.isInSphericalCoords() ? Math.toRadians(this.circleRadius) : Util.tand(this.circleRadius);
                Cercle c = new Cercle(pf, null, xv, yv, rv);
                v.addElement(c);
                break;
            }
            case 3: {
                if (this.angle == 0.0) {
                    Aladin.trace(3, "Can not create a pickle with an angle of 0 !");
                    break;
                }
                Pickle p = new Pickle((Plan)pf, null, Util.tand(this.centerOffRa), Util.tand(this.centerOffDec), Util.tand(this.internalRad), Util.tand(this.externalRad), this.startAngle, this.angle);
                v.addElement(p);
                break;
            }
            case 4: {
                Tag t = new Tag(pf, this.content, this.ra, this.dec);
                v.addElement(t);
                break;
            }
        }
        Enumeration<SubFootprintBean> e = this.subSubsFootprints.elements();
        while (e.hasMoreElements()) {
            SubFootprintBean sub = e.nextElement();
            SubFootprintBean.addArrayObjectsToVector(v, sub.buildObjets(pf));
        }
        Object[] o = new Obj[v.size()];
        v.copyInto(o);
        v = null;
        return o;
    }

    protected static void addArrayObjectsToVector(Vector<Obj> v, Obj[] o) {
        if (o == null) {
            return;
        }
        for (int i = 0; i < o.length; ++i) {
            if (o[i] == null) continue;
            v.addElement(o[i]);
        }
    }

    protected String getName() {
        return this.name == null ? "" : this.name;
    }

    protected String getDesc() {
        return "";
    }

    protected Color getColor() {
        return this.c;
    }

    protected void setColor(Color c) {
        this.c = c;
    }

    protected void setName(String name) {
        this.name = name;
    }
}

