/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Glu;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Hashtable;

public class StandardFormsReader {
    private static StandardFormsReader instance = null;
    private Hashtable<String, String> stdServerForms = null;

    public static synchronized StandardFormsReader getInstance() {
        if (instance == null) {
            instance = new StandardFormsReader();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StandardFormsReader() {
        FilterInputStream inputStream = null;
        try {
            String fileLine;
            this.stdServerForms = new Hashtable();
            inputStream = new DataInputStream(this.getClass().getResourceAsStream("/StandardForms.dic"));
            String stdForm = null;
            StringBuilder record = new StringBuilder();
            while ((fileLine = ((DataInputStream)inputStream).readLine()) != null) {
                String value;
                String name;
                if (fileLine.equals("") || fileLine.charAt(0) == '#' || (name = Glu.getName(fileLine)) == null || (value = Glu.getValue(fileLine, (DataInputStream)inputStream)) == null) continue;
                if (name.equals("Aladin.StdForm")) {
                    if (record.length() != 0) {
                        this.setStdServerForms(stdForm, record);
                    }
                    stdForm = value;
                }
                record.append(fileLine).append("\n");
            }
            if (stdForm != null) {
                this.setStdServerForms(stdForm, record);
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                System.err.println("Standardforms.dic not loaded error: " + e);
                e.printStackTrace();
            }
            Aladin.error("Standardforms.dic not loaded !", 1);
        }
        finally {
            block18: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        if (Aladin.levelTrace < 3) break block18;
                        System.err.println("error when closing Standardforms.dic: " + e);
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Hashtable<String, String> getStdServerForms() {
        return this.stdServerForms;
    }

    public void setStdServerForms(String formName, StringBuilder record) {
        this.stdServerForms.put(formName, record.toString());
        record.setLength(0);
    }

    public void setStdServerForms(Hashtable<String, String> stdServerForms) {
        this.stdServerForms = stdServerForms;
    }
}

