/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CalibFreq;
import cds.aladin.CanvasColorMap;
import cds.aladin.Coord;
import cds.aladin.Icon;
import cds.aladin.IconSpectroBar;
import cds.aladin.IconSpectroClose;
import cds.aladin.IconSpectroLock;
import cds.aladin.IconSpectroMove;
import cds.aladin.IconSpectroRGB;
import cds.aladin.IconSpectroTarget;
import cds.aladin.IconSpectroUnit;
import cds.aladin.Plan;
import cds.aladin.PlanHips3D;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.RepereHips3D;
import cds.aladin.SED;
import cds.aladin.Tile;
import cds.aladin.Tool;
import cds.aladin.ViewSimple;
import cds.aladin.Widget;
import cds.aladin.WidgetSpectrogram;
import cds.moc.FMoc;
import cds.moc.SMoc;
import cds.tools.Util;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class Spectrogram
extends JComponent
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
Widget {
    private static double LIMIT_WAVE = 3.0E11;
    private static final int MARGE_BUTTONS = 2;
    private static final int DELAY_ANIMATION = 100;
    private static final int LABEL_TOP = 0;
    private static final int LABEL_LEFT = 1;
    private static final int LABEL_RIGHT = 2;
    private static final int BAR = 0;
    private static final int LINE = 1;
    private static final int SIMPLE = 0;
    private static final int SELECTED = 1;
    private static final int UNDERMOUSE = 2;
    private static final int RED = 4;
    private static final int BLUE = 8;
    private static final int MAXUNIT = 4;
    static final int AUTO = 0;
    static final int FREQ = 1;
    static final int WAVE = 2;
    static final int VELO = 3;
    static final int NORGB = 0;
    static final int RGB = 1;
    private static final int BARWIDTH = 4;
    private static final int MH = 15;
    private static int MB = 16;
    protected Aladin aladin;
    protected ViewSimple v;
    private int modeDraw;
    private int unitMode;
    private int modeRGB;
    private ArrayList<Bar> listBar = null;
    private ArrayList<Icon> listButtons = null;
    private int stateID;
    private int overZoomGap;
    private int mouseX;
    private int mouseY;
    private int mouseDragX;
    private int mouseDragY;
    private boolean flagMouseDrag = false;
    private boolean onNothing = false;
    private boolean myFocus = false;
    private double freqSelected;
    private double freqRed;
    private double freqBlue;
    private double freqMiddle;
    private double freqLast;
    private double lastRange;
    private double lastFreqMin;
    private double lastFreqMax;
    private String lastLabel;
    private Coord lastCoord;
    private int lastModeUnit;
    private boolean flagReverse;
    protected RepereHips3D target = null;
    private PlanTool ptool = null;
    private boolean flagTargetDragged = false;
    private boolean flagPoigneeDragged = false;
    private PointD lastTargetPos = null;
    private boolean isTargetLocked;
    private boolean onTarget = false;
    private boolean onPoignee = false;
    private Coord ocoo = null;
    private FMoc fmocLocal = null;
    private Bar lastBarUnderMouse = null;
    private Icon lastIconUnderMouse = null;
    private Cursor parentCursor = null;
    private HashMap<Integer, LastAnimation> memoLastAnimation = new HashMap();
    private WidgetSpectrogram voc = null;

    protected Spectrogram(Aladin aladin, ViewSimple v) {
        this.aladin = aladin;
        this.v = v;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.reset();
        this.createButtons();
    }

    protected void reset() {
        this.listBar = null;
        this.freqLast = Double.NaN;
        this.freqBlue = Double.NaN;
        this.freqRed = Double.NaN;
        this.lastFreqMax = Double.NaN;
        this.lastFreqMin = Double.NaN;
        this.freqMiddle = Double.NaN;
        this.freqSelected = Double.NaN;
        this.lastFreqMax = Double.NaN;
        this.lastFreqMin = Double.NaN;
        this.lastRange = Double.NaN;
        this.lastCoord = null;
        this.lastLabel = null;
        this.lastModeUnit = 0;
        this.modeDraw = 1;
        this.modeRGB = 0;
        this.overZoomGap = 0;
        this.stateID = 0;
        this.mouseY = -1;
        this.mouseX = -1;
        this.mouseDragX = -1;
        this.isTargetLocked = false;
        this.target = null;
        this.ptool = null;
    }

    private void createButtons() {
        this.listButtons = new ArrayList();
        this.listButtons.add(new IconSpectroClose(this));
        this.listButtons.add(new IconSpectroMove(this));
        this.listButtons.add(new IconSpectroBar(this));
        this.listButtons.add(new IconSpectroRGB(this));
        this.listButtons.add(new IconSpectroUnit(this));
        this.listButtons.add(new IconSpectroTarget(this));
        this.listButtons.add(new IconSpectroLock(this));
    }

    protected double getFrequence() {
        return this.freqSelected;
    }

    protected void setFrequence(double frequence) {
        this.setFrequence(frequence, false);
    }

    protected void setMyFocus(boolean hasFocus) {
        if (hasFocus != this.myFocus) {
            this.repaint();
        }
        this.myFocus = hasFocus;
    }

    protected boolean hasMyFocus() {
        return this.myFocus;
    }

    protected void setFrequence(double frequence, boolean resetFreqMiddle) {
        if (resetFreqMiddle) {
            this.freqMiddle = Double.NaN;
        }
        double deltaFreq = frequence - this.freqSelected;
        if (!Double.isNaN(this.freqRed)) {
            this.freqRed += deltaFreq;
        }
        if (!Double.isNaN(this.freqBlue)) {
            this.freqBlue += deltaFreq;
        }
        this.freqLast = this.freqSelected = frequence;
        this.incrStateID();
    }

    protected void setFreqRed(double freqRed) {
        this.freqLast = this.freqRed = freqRed;
        this.modeRGB = 1;
        this.incrStateID();
    }

    protected void setFreqBlue(double freqBlue) {
        this.freqLast = this.freqBlue = freqBlue;
        this.modeRGB = 1;
        this.incrStateID();
    }

    protected double getFreqRed() {
        return this.freqRed;
    }

    protected double getFreqBlue() {
        return this.freqBlue;
    }

    protected boolean isModeRGB() {
        return this.modeRGB != 0;
    }

    protected void setModeRGB(boolean mode) {
        if (!mode) {
            this.modeRGB = 0;
        } else {
            if (Double.isNaN(this.freqRed) || Double.isNaN(this.freqBlue)) {
                double freq = this.getFrequence();
                this.freqRed = freq - this.lastRange * 2.0;
                this.freqBlue = freq + this.lastRange * 2.0;
            }
            this.modeRGB = 1;
        }
        this.incrStateID();
        this.getPlan().nextImgID();
        this.getPlan().askForRepaint();
    }

    protected int getStateID() {
        return this.hashCode() + this.stateID;
    }

    private void incrStateID() {
        ++this.stateID;
    }

    protected void setFrequenceOnAllSelectedViews(double frequence) {
        this.aladin.view.setFrequence(frequence, false);
    }

    protected void setModeBar(boolean mode) {
        this.modeDraw = mode ? 0 : 1;
    }

    protected boolean isModeBar() {
        return this.modeDraw == 0;
    }

    protected double[] getFreqRange() {
        return new double[]{this.lastFreqMin, this.lastFreqMax};
    }

    protected boolean isDragging() {
        return this.flagPoigneeDragged || this.flagTargetDragged || this.mouseDragX != -1;
    }

    private PointD getOriginalPosition(MouseEvent e) {
        return this.v.getPosition((double)e.getX() + (double)this.voc.getX(), (double)e.getY() + (double)this.voc.getY());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.getPlan().selected = true;
        int x = e.getX();
        int y = e.getY();
        this.flagMouseDrag = true;
        try {
            if (!this.flagTargetDragged && (this.onPoignee || this.flagPoigneeDragged)) {
                this.flagPoigneeDragged = true;
                this.aladin.view.extendClip(this.target);
                double deltaXYView = Math.sqrt(Math.pow(this.mouseDragX - x, 2.0) + Math.pow(this.mouseDragY - y, 2.0));
                PointD p = this.getOriginalPosition(e);
                double deltaX = Math.abs(this.target.xv[this.v.n] - p.x);
                double deltaY = Math.abs(this.target.yv[this.v.n] - p.y);
                double rayon = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                if (deltaXYView > 3.0) {
                    this.target.setRayon(this.v, rayon);
                    this.aladin.view.extendClip(this.target);
                    this.aladin.view.quickRepaintAll();
                    this.mouseDragX = x;
                    this.mouseDragY = y;
                }
                return;
            }
            if (this.onTarget || this.flagTargetDragged) {
                this.flagTargetDragged = true;
                PointD p = this.v.getPosition((double)x, (double)y);
                if (this.lastTargetPos != null) {
                    double dx = p.x - this.lastTargetPos.x;
                    double dy = p.y - this.lastTargetPos.y;
                    this.isTargetLocked = true;
                    this.target.deltaPosition(this.v, dx, dy);
                    this.target.setCoord(this.v);
                    this.aladin.view.newView(1);
                    this.aladin.view.quickRepaintAll();
                }
                this.target.setSelected(true);
                this.lastTargetPos = p;
                return;
            }
            Bar b = this.getBarAt(x, y);
            double freq = Double.NaN;
            if (b != null) {
                this.aladin.localisation.setTextAffichage(b.getCmd());
                freq = b.freq;
            }
            if (this.lastBarUnderMouse == null) {
                return;
            }
            boolean shiftPressed = e.isShiftDown();
            int sens = 1;
            if ((this.lastBarUnderMouse.mode & 1) != 0) {
                this.freqSelected = freq;
            } else if ((this.lastBarUnderMouse.mode & 4) != 0) {
                this.setFreqRed(freq);
                if (shiftPressed) {
                    this.setFreqBlue(this.freqSelected - (double)sens * (freq - this.freqSelected));
                }
            } else if ((this.lastBarUnderMouse.mode & 8) != 0) {
                this.setFreqBlue(freq);
                if (shiftPressed) {
                    this.setFreqRed(this.freqSelected + (double)sens * (this.freqSelected - freq));
                }
            } else {
                int deltaX = this.mouseDragX - e.getX();
                int nbBar = deltaX / this.getBarWidth();
                if (nbBar == 0) {
                    return;
                }
                sens = this.flagReverse ? 1 : -1;
                double deltaFreq = this.lastBarUnderMouse.getFreqRes() * (double)nbBar;
                double f = this.freqSelected - (double)sens * deltaFreq;
                this.freqMiddle = Double.isNaN(this.freqMiddle) ? this.freqSelected : (this.freqMiddle -= (double)sens * deltaFreq);
                this.selectView(e);
                this.setFrequenceOnAllSelectedViews(f);
            }
            this.getPlan().askForRepaint(this.v);
            this.mouseDragX = x;
            this.mouseDragY = y;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void selectView(MouseEvent e) {
        if (!e.isShiftDown()) {
            this.aladin.view.unSelectAllView();
            this.v.selectThisView();
        } else {
            this.aladin.view.selectCompatibleViews();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastTargetPos = this.v.getPosition((double)e.getX(), (double)e.getY());
        this.selectView(e);
        this.getPlan().selected = true;
        this.mouseDragX = e.getX();
        this.mouseDragY = e.getY();
        this.flagMouseDrag = false;
        this.initFreqMiddle(this.freqSelected);
        this.myFocus = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Icon ic;
        this.mouseX = -1;
        this.lastTargetPos = null;
        this.flagTargetDragged = false;
        this.flagPoigneeDragged = false;
        if (this.mouseDragX != -1) {
            this.mouseDragX = -1;
            if (this.flagMouseDrag) {
                this.flagMouseDrag = false;
                return;
            }
        }
        if ((ic = this.getButtonAt(e.getX(), e.getY(), 0)) != null) {
            ic.submit();
        } else {
            Bar b = this.getBarAt(e.getX(), e.getY());
            if (b != null) {
                this.setFrequenceOnAllSelectedViews(b.freq);
                this.aladin.localisation.setTextSaisie(b.getCmd());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.parentCursor = this.voc.getParent().getCursor();
        Aladin.makeCursor(this.voc.getParent(), 2);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseY = -1;
        this.mouseX = -1;
        if (this.parentCursor != null) {
            this.voc.getParent().setCursor(this.parentCursor);
        }
        this.onNothing = true;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Bar b;
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        Icon ic = this.getButtonAt(this.mouseX, this.mouseY, 0);
        if (ic != null) {
            ic.mouseMoved(e);
        }
        if (this.lastIconUnderMouse != ic) {
            if (ic == null) {
                this.lastIconUnderMouse.mouseExited(e);
            } else {
                ic.mouseEntered(e);
            }
        }
        this.lastIconUnderMouse = ic;
        if (ic == null && (b = (this.lastBarUnderMouse = this.getBarAt(this.mouseX, this.mouseY))) != null) {
            this.aladin.localisation.setTextAffichage(b.getCmd());
        }
    }

    private Icon getButtonAt(int x, int y, int marge) {
        if (this.listButtons == null) {
            return null;
        }
        for (Icon i : this.listButtons) {
            if (!i.getRectAbs(marge).contains(x, y)) continue;
            return i;
        }
        return null;
    }

    private Bar getBarAt(int x, int y) {
        if (this.listBar == null) {
            return null;
        }
        for (Bar b : this.listBar) {
            if (!b.rect.contains(x, y)) continue;
            return b;
        }
        return null;
    }

    protected int getOverZoomGap() {
        return this.overZoomGap;
    }

    protected boolean setOverZoomGap(int gap) {
        PlanHips3D p = this.getPlan();
        int order = p.getOrderInView(this.v) + gap;
        if (order < p.orderMin) {
            return false;
        }
        if (order > p.orderMax) {
            return false;
        }
        this.overZoomGap = gap;
        return true;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int incr;
        this.selectView(e);
        int wheelRotation = e.getWheelRotation();
        if (wheelRotation == 0) {
            return;
        }
        int n = incr = wheelRotation < 0 ? 1 : -1;
        if (this.setOverZoomGap(this.getOverZoomGap() + incr)) {
            this.getPlan().askForRepaint(this.v);
        }
        this.adjustFreqMiddle();
    }

    protected void adjustFreqMiddle() {
        if (Double.isNaN(this.freqMiddle)) {
            return;
        }
        double f = Double.isNaN(this.freqLast) ? this.freqSelected : this.freqLast;
        this.freqMiddle = (this.freqMiddle + f) / 2.0;
    }

    private void initFreqMiddle(double f) {
        if (!Double.isNaN(f) && !Double.isNaN(this.freqMiddle)) {
            return;
        }
        this.freqMiddle = f;
    }

    private double getFreqMiddle() {
        return Double.isNaN(this.freqMiddle) ? this.getFrequence() : this.freqMiddle;
    }

    @Override
    public void paintComponent(final Graphics g) {
        if (this.voc.adjustWidgetControl()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Util.pause(10);
                    Spectrogram.this.draw(g, Spectrogram.this.getWidth(), Spectrogram.this.getHeight());
                }
            });
        } else {
            this.draw(g, this.getWidth(), this.getHeight());
        }
    }

    protected PlanHips3D getPlan() {
        return (PlanHips3D)this.v.pref;
    }

    private String getModeString(int mode) {
        StringBuilder s = new StringBuilder();
        if ((mode & 1) != 0) {
            s.append(" SELECTED");
        }
        if ((mode & 2) != 0) {
            s.append(" UNDERMOUSE");
        }
        if ((mode & 4) != 0) {
            s.append(" RED");
        }
        if ((mode & 8) != 0) {
            s.append(" BLUE");
        }
        return s.toString();
    }

    private Coord getTargetCoord() {
        this.lastCoord = this.isTargetLocked && this.target != null ? new Coord(this.target.raj, this.target.dej) : this.v.getCooCentre();
        return this.lastCoord;
    }

    private double getTargetRadius() {
        return this.target.getRadius();
    }

    protected boolean inTarget(MouseEvent e) {
        boolean on;
        if (this.target == null) {
            return false;
        }
        PointD p = this.v.getPosition((double)e.getX(), (double)e.getY());
        this.onTarget = this.target.in(this.v, p.x, p.y);
        double rayon = this.target.getRayon(this.v) * this.v.zoom;
        this.onPoignee = rayon > 7.0 && this.target.onPoignee(this.v, p.x, p.y);
        boolean bl = on = this.onTarget || this.onPoignee;
        if (on && e instanceof MouseWheelEvent) {
            return false;
        }
        boolean flagRedraw = this.target.isSelected() != on;
        this.target.setSelect(on);
        if (flagRedraw) {
            this.aladin.view.repaintAll();
        }
        return on;
    }

    protected void drawTarget(Graphics g) {
        PlanHips3D p = this.getPlan();
        Coord coo = this.getTargetCoord();
        if (this.ptool == null) {
            this.ptool = new PlanTool(this.aladin);
            this.target = new RepereHips3D((Plan)this.ptool, this.v, coo, p.getPixelResolution() * 3.0);
            this.ptool.pcat.setObjetFast(this.target);
            this.aladin.calque.repaintAll();
        } else {
            this.target.setRaDec(coo.al, coo.del);
        }
        this.ptool.c = this.isTargetLocked ? Color.red : Color.green;
        this.target.projection(this.v);
        this.ptool.pcat.draw(g, null, this.v, true, 0, 0);
        if (!this.onNothing || this.onPoignee || this.onTarget) {
            int order = p.getOrderInView(this.v) + this.overZoomGap + p.getOrderTile();
            try {
                long[] list = p.getNpix(order, coo, this.getTargetRadius());
                if (list.length <= 256) {
                    double f = 0.75;
                    g.setColor(new Color((int)((double)this.ptool.c.getRed() * f), (int)((double)this.ptool.c.getGreen() * f), (int)((double)this.ptool.c.getBlue() * f)));
                    for (long npix : list) {
                        Hpix hpix = new Hpix(order, npix, p.getFrameOrigin());
                        hpix.draw(g, this.v);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private FMoc getExtractFMoc() {
        Coord coo = this.getTargetCoord();
        if (!coo.equals(this.ocoo)) {
            try {
                PlanHips3D p = this.getPlan();
                int spaceOrder = p.moc.getSpaceOrder() + p.getOrderTile();
                double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
                long spaceNpix = CDSHealpix.ang2pix_nest(spaceOrder, polar[0], polar[1]);
                this.ocoo = coo;
                this.fmocLocal = p.moc.intersection(new SMoc(spaceOrder + "/" + spaceNpix)).getFreqMoc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fmocLocal;
    }

    private int getUnitMode(double fq) {
        int unitMode = this.getUnitMode();
        if (unitMode != 0) {
            return unitMode;
        }
        unitMode = !Double.isNaN(this.getPlan().getRestFreq()) ? 3 : (fq > LIMIT_WAVE ? 2 : 1);
        return unitMode;
    }

    protected int getUnitMode() {
        return this.unitMode;
    }

    protected void switchUnitMode() {
        ++this.unitMode;
        if (this.unitMode == 3 && Double.isNaN(this.getPlan().getRestFreq())) {
            ++this.unitMode;
        }
        if (this.unitMode >= 4) {
            this.unitMode = 1;
        }
    }

    protected void switchLockMode() {
        this.isTargetLocked = !this.isTargetLocked;
        this.aladin.view.repaintAll();
    }

    protected void gotoOnTarget() {
        this.aladin.view.gotoThere(new Coord(this.target.raj, this.target.dej));
    }

    protected boolean isTargetLocked() {
        return this.isTargetLocked;
    }

    private int getBarWidth() {
        return (int)(4.0f * Aladin.getUIScale());
    }

    protected void draw(Graphics g, int width, int height) {
        block56: {
            int barWidth = this.getBarWidth();
            boolean wakeUp = false;
            try {
                int incI;
                int nbBar;
                int nbTiles;
                int nbTilesBefore;
                PlanHips3D p = this.getPlan();
                int orderTile = p.getOrderTile();
                int tileWidth = (int)CDSHealpix.pow2(orderTile);
                int orderZTile = p.getOrderZTile();
                int tileDepth = (int)CDSHealpix.pow2(orderZTile);
                Coord coo = this.getTargetCoord();
                double radius = this.getTargetRadius();
                int order = p.getOrderInView(this.v) + this.overZoomGap;
                if (order < p.orderMin) {
                    order = p.orderMin;
                    ++this.overZoomGap;
                } else if (order > p.orderMax) {
                    order = p.orderMax;
                    --this.overZoomGap;
                }
                long[] npixList = p.getNpix(order + orderTile, coo, radius);
                double centralFreq = this.getFreqMiddle();
                if (Double.isNaN(centralFreq)) {
                    return;
                }
                double frequence = this.getFrequence();
                int orderZ = p.getOrderZInView(this.v) + this.overZoomGap;
                int channel = p.getChannel(this.v, orderZ, centralFreq);
                long npixZCentral = CalibFreq.freq2pix(orderZ, centralFreq);
                long npixRed = -1L;
                long npixBlue = -1L;
                if (this.isModeRGB()) {
                    npixRed = CalibFreq.freq2pix(orderZ + orderZTile, this.getFreqRed());
                    npixBlue = CalibFreq.freq2pix(orderZ + orderZTile, this.getFreqBlue());
                }
                if ((nbTilesBefore = (nbTiles = (nbBar = width / barWidth) / tileDepth + 1) / 2 + 1) == 0) {
                    nbTilesBefore = 1;
                }
                int nbTilesToLoad = 2 * nbTilesBefore + 1;
                int[] spectra = new int[nbTilesToLoad * tileDepth];
                int minVal = Integer.MAX_VALUE;
                for (int i = 0; i < nbTilesBefore; ++i) {
                    for (int sens = -1; sens <= 1; sens += 2) {
                        if (i == 0) {
                            sens = 1;
                        }
                        long npixZ = npixZCentral + (long)(i * sens);
                        int offsetSpectra = (nbTilesToLoad / 2 + i * sens) * tileDepth;
                        int nbPixel = 0;
                        byte[] extrait = null;
                        long onpixTile = -1L;
                        Tile tile = null;
                        for (long npix : npixList) {
                            long npixTile = npix / (long)(tileWidth * tileWidth);
                            if (npixTile != onpixTile) {
                                Addr addr = new Addr(order, npixTile, orderZ, npixZ);
                                if (p.isOutMoc(addr)) continue;
                                tile = p.getTile(addr, true, false);
                                if (tile != null) {
                                    tile.resetTimer();
                                    if (i != 0) {
                                        tile.priority = 20 + i;
                                    }
                                }
                                onpixTile = npixTile;
                            }
                            if (tile != null) {
                                if (tile.getStatus() == 6) {
                                    extrait = tile.getSpectraPix8(npix);
                                } else {
                                    wakeUp = true;
                                }
                            }
                            if (extrait == null) continue;
                            for (int j = 0; j < extrait.length; ++j) {
                                int val = 0xFF & extrait[j];
                                if (spectra[offsetSpectra + j] + val < spectra[offsetSpectra + j]) {
                                    extrait = null;
                                    break;
                                }
                                int n = offsetSpectra + j;
                                spectra[n] = spectra[n] + val;
                            }
                            ++nbPixel;
                        }
                        if (extrait == null) continue;
                        for (int j = 0; j < extrait.length; ++j) {
                            int val = spectra[offsetSpectra + j];
                            spectra[offsetSpectra + j] = val /= nbPixel;
                            if (val <= 0 || val >= minVal) continue;
                            minVal = val;
                        }
                    }
                }
                long npixFull = npixZCentral * (long)tileDepth;
                double fq = CalibFreq.pix2freq(orderZ + orderZTile, npixFull);
                this.lastModeUnit = this.getUnitMode(fq);
                this.flagReverse = this.lastModeUnit == 2 || this.lastModeUnit == 3;
                IndexColorModel cm = (IndexColorModel)p.getCM();
                IndexColorModel ic = p.typeCM == 0 && !p.isReverse() ? cm : CanvasColorMap.getCM(p.cmControl[0], p.cmControl[1], p.cmControl[2], false, 0, p.getTransfertFct(), p.isTransparent());
                int start = channel;
                int end = channel + 2 * nbTilesBefore * tileDepth;
                int xInit = width / 2 - barWidth * tileDepth * nbTilesBefore;
                FMoc fmocLocal = this.getExtractFMoc();
                double firstFreq = Double.NaN;
                double lastFreq = Double.NaN;
                long npixFullFrequence = CalibFreq.freq2pix(orderZ + orderZTile, frequence);
                ArrayList<Bar> nList = new ArrayList<Bar>(100);
                boolean first = true;
                int n = incI = this.flagReverse ? -1 : 1;
                if (this.flagReverse) {
                    int j = start;
                    start = end;
                    end = j;
                }
                g.setFont(Aladin.SBOLD);
                MB = g.getFontMetrics().getAscent() + 6;
                int heightUsed = height - 15 - MB;
                double fct = (double)heightUsed / 256.0;
                this.lastLabel = null;
                Polygon pol = new Polygon();
                int delta = (int)((double)ic.getRed(minVal) * fct) - 15;
                if (delta > heightUsed / 2) {
                    delta = heightUsed / 2;
                }
                long time = System.currentTimeMillis();
                LastAnimation lastAnimation = this.memoLastAnimation.get(this.v.hashCode());
                long lastTime = lastAnimation == null ? 0L : lastAnimation.time;
                int lastDelta = lastAnimation == null ? delta : lastAnimation.delta;
                long dt = time - lastTime;
                if (Math.abs(lastDelta - delta) > 2) {
                    this.v.repaint(100L);
                }
                if (dt < 100L) {
                    delta = lastDelta;
                } else {
                    delta = (delta + lastDelta) / 2;
                    if (lastAnimation == null) {
                        lastAnimation = new LastAnimation();
                    }
                    lastAnimation.delta = delta;
                    lastAnimation.time = time;
                    this.memoLastAnimation.put(this.v.hashCode(), lastAnimation);
                }
                int i = start;
                int x = xInit;
                while (i != end) {
                    if (x >= 0) {
                        if (x > width) break;
                        npixFull = (npixZCentral - (long)nbTilesBefore) * (long)tileDepth + (long)i;
                        fq = CalibFreq.pix2freq(orderZ + orderZTile, npixFull);
                        if (first) {
                            firstFreq = fq;
                            first = false;
                        }
                        lastFreq = fq;
                        boolean selected = npixFullFrequence == npixFull;
                        boolean startTile = npixFull % (long)tileDepth == 0L;
                        int pix8 = spectra[i];
                        int v = ic.getRed(pix8);
                        int h = (int)((double)v * fct);
                        if (h > 0) {
                            h -= delta;
                        }
                        if (h < 0) {
                            h = 0;
                        }
                        int y = height - MB - h;
                        String s = this.getPlan().isHipsSeq ? orderZ + orderZTile + "/" + npixFull : this.getLabel(fq, this.lastModeUnit);
                        Bar b = new Bar(x, y, barWidth, h, fq, orderZ + orderZTile, npixFull, s, startTile, orderZ, npixFull / (long)tileDepth);
                        boolean inMoc = fmocLocal == null || fmocLocal.isIncluding(orderZ + orderZTile, npixFull);
                        b.setInMoc(inMoc);
                        nList.add(b);
                        if (this.modeDraw == 0) {
                            pol.addPoint(x, y);
                            pol.addPoint(x + barWidth, y);
                        } else {
                            pol.addPoint(x + barWidth / 2, y);
                        }
                        boolean underMouse = !this.flagMouseDrag && b.rect.contains(this.mouseX, this.mouseY);
                        b.setMode((underMouse ? 2 : 0) | (selected ? 1 : 0) | (npixFull == npixRed ? 4 : 0) | (npixFull == npixBlue ? 8 : 0));
                        Color cv = new Color(cm.getRed(spectra[i]), cm.getGreen(spectra[i]), cm.getBlue(spectra[i]));
                        b.setColorBar(cv);
                        b.setColorLabel(npixFull == npixRed ? Color.red : (npixFull == npixBlue ? new Color(50, 50, 255) : (selected ? Color.green : Color.magenta)));
                        if (selected) {
                            double range;
                            this.lastLabel = s;
                            double fq1 = CalibFreq.pix2freqStart(orderZ + orderZTile, npixFullFrequence);
                            double fq2 = CalibFreq.pix2freqStart(orderZ + orderZTile, npixFullFrequence + 1L);
                            this.lastRange = Math.abs(fq1 - fq2);
                            if (this.lastModeUnit == 3) {
                                double velo1 = CalibFreq.freq2Velo(fq1, this.getPlan().getRestFreq());
                                double velo2 = CalibFreq.freq2Velo(fq2, this.getPlan().getRestFreq());
                                range = CalibFreq.velo2Freq(velo1 - velo2, this.getPlan().getRestFreq());
                            } else if (this.lastModeUnit == 2) {
                                double wave1 = CalibFreq.freq2Wave(fq1);
                                double wave2 = CalibFreq.freq2Wave(fq2);
                                range = CalibFreq.wave2Freq(wave1 - wave2);
                            } else {
                                range = fq2 - fq1;
                            }
                            s = "[" + this.getLabel(range, this.lastModeUnit) + "]";
                            b.setLabelDown(s);
                        }
                    }
                    i += incI;
                    x += barWidth;
                }
                Bar bs = null;
                Bar bu = null;
                Bar br = null;
                Bar bb = null;
                for (Bar b : nList) {
                    if ((b.mode & 2) != 0) {
                        bu = b;
                    }
                    if ((b.mode & 1) != 0) {
                        bs = b;
                    }
                    if ((b.mode & 8) != 0) {
                        bb = b;
                    }
                    if ((b.mode & 4) == 0) continue;
                    br = b;
                }
                this.drawPolygon(g, width, height, pol, nList);
                if (bu != null) {
                    bu.drawBar(g);
                }
                if (bs != null) {
                    bs.drawBar(g);
                }
                if (bb != null) {
                    bb.drawBar(g);
                }
                if (br != null) {
                    br.drawBar(g);
                }
                if (this.aladin.calque.hasGrid() && this.aladin.calque.getGrid() == 2) {
                    for (Bar b : nList) {
                        b.drawHipsGrid(g);
                    }
                }
                if (bu != null) {
                    bu.drawLabel(g, 0);
                }
                if (bs != null) {
                    bs.drawLabel(g, 0);
                }
                if (bb != null) {
                    bb.drawLabel(g, bb.rect.x < bs.rect.x ? 1 : 2);
                }
                if (br != null) {
                    br.drawLabel(g, br.rect.x < bs.rect.x ? 1 : 2);
                }
                String fqMin = null;
                String fqMax = null;
                if (!Double.isNaN(lastFreq)) {
                    fqMin = this.getLabel(firstFreq, this.lastModeUnit);
                    fqMax = this.getLabel(lastFreq, this.lastModeUnit);
                    this.setFreqMinMax(firstFreq, lastFreq);
                }
                this.drawScale(g, width, height, MB, fqMin, fqMax);
                this.drawButtons(g, width, height, MB);
                int y = height - MB;
                g.setColor(Color.lightGray);
                for (Bar b : nList) {
                    if (b.inMoc) continue;
                    g.drawLine(b.rect.x, y, b.rect.x + b.rect.width, y);
                    g.drawLine(b.rect.x, y - 1, b.rect.x + b.rect.width, y - 1);
                }
                this.listBar = nList;
                if (wakeUp) {
                    p.tryWakeUp();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block56;
                e.printStackTrace();
            }
        }
    }

    private void drawPolygon(Graphics g, int width, int height, Polygon pol, ArrayList<Bar> nList) {
        Bar b = nList.get(nList.size() - 1);
        pol.addPoint(b.rect.x, height - MB);
        b = nList.get(0);
        pol.addPoint(b.rect.x, height - MB);
        Bar bmin = null;
        Bar bmax = null;
        for (Bar b1 : nList) {
            if (b1.rect.height > 0 && (bmin == null || b1.rect.height < bmin.rect.height)) {
                bmin = b1;
            }
            if (bmax != null && b1.rect.height <= bmax.rect.height) continue;
            bmax = b1;
        }
        if (bmax == null || bmin == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Paint paint = g2d.getPaint();
        GradientPaint gradient = new GradientPaint(width / 2, bmin.rect.y, bmin.cBar, width / 2, bmax.rect.y, bmax.cBar);
        g2d.setPaint(gradient);
        g.fillPolygon(pol);
        g2d.setPaint(paint);
        g.setColor(!this.myFocus ? this.aladin.view.infoColor : Color.green);
        for (int i = 1; i < pol.npoints - 2; ++i) {
            g.drawLine(pol.xpoints[i - 1], pol.ypoints[i - 1], pol.xpoints[i], pol.ypoints[i]);
        }
    }

    private void setFreqMinMax(double freq1, double freq2) {
        if (freq1 < freq2) {
            this.lastFreqMin = freq1;
            this.lastFreqMax = freq2;
        } else {
            this.lastFreqMax = freq1;
            this.lastFreqMin = freq2;
        }
    }

    private String getLabel(double freq, int mode) {
        double velo;
        String rep = mode == 3 ? (Math.abs(velo = CalibFreq.freq2Velo(freq, this.getPlan().getRestFreq())) > 1000.0 ? Util.round(velo / 1000.0, 1) + "km/s" : Util.round(velo, 1) + "m/s") : (mode == 2 ? SED.getUnitWave(SED.freq2Wave(freq), "m", 5) : SED.getUnitFreq(freq, "Hz", 5));
        return rep;
    }

    private String trimUnit(String s) {
        int offset;
        if (s == null) {
            return s;
        }
        for (offset = s.length() - 1; offset > 0 && !Character.isDigit(s.charAt(offset)); --offset) {
        }
        return s.substring(0, offset + 1);
    }

    protected String getLastLabel() {
        return this.lastLabel;
    }

    private boolean mustDrawLegende() {
        return this.v.getWidth() > 250 && !this.getPlan().isHipsSeq;
    }

    private boolean mustDrawLabelDown() {
        return this.v.getWidth() > 400;
    }

    private boolean mustDrawButtons() {
        return this.v.getWidth() > 200;
    }

    private void drawButtons(Graphics g, int width, int height, int MB) {
        if (!this.mustDrawButtons()) {
            return;
        }
        int x = width - 4;
        int y = height - MB + 1;
        for (Icon i : this.listButtons) {
            x = x - i.getPreferredSize().width - 2;
            Graphics g1 = g.create();
            g1.translate(x, y);
            i.setXYAbs(x, y);
            i.drawLogo(g1);
        }
    }

    private void drawScale(Graphics g, int width, int height, int MB, String frMin, String frMax) {
        int w;
        int bord = this.aladin.view.getModeView() > 5 ? 2 : 4;
        int X = 0;
        int Y = height - MB;
        int frMaxX = w = width - 2;
        if (this.aladin.view.infoBorder) {
            g.setColor(Color.black);
            g.fillRect(X - 1, Y - bord - 1, 3, bord + 2);
            g.fillRect(X - 1, Y - 1, w + 2, 3);
            g.fillRect(X + w - 1, Y - bord - 1, 3, bord + 2);
        }
        g.setColor(this.aladin.view.infoColor);
        g.drawLine(X, Y - bord, X, Y);
        g.drawLine(X, Y, X + w, Y);
        g.drawLine(X + w, Y, X + w, Y - bord);
        if (this.overZoomGap > 0) {
            int gapNbBar = (int)CDSHealpix.pow2(this.overZoomGap);
            int i = -1;
            for (Bar b : this.listBar) {
                if (i == -1) {
                    i = -((int)(b.npix % (long)gapNbBar + 1L));
                }
                if (i % gapNbBar == 0) {
                    g.drawLine(b.rect.x, b.rect.y + b.rect.height - 2, b.rect.x, b.rect.y + b.rect.height);
                }
                ++i;
            }
        }
        if (!this.mustDrawLegende()) {
            return;
        }
        int y = Y - 3;
        if (frMin != null) {
            if (!this.aladin.view.infoBorder) {
                g.drawString(frMin, X + 1, y);
            } else {
                Util.drawStringOutline(g, frMin, X + 1, y, null, Color.black);
            }
        }
        if (frMax != null) {
            int sz = g.getFontMetrics().stringWidth(frMax);
            frMaxX -= sz;
            if (!this.aladin.view.infoBorder) {
                g.drawString(frMax, frMaxX, y);
            } else {
                Util.drawStringOutline(g, frMax, frMaxX, y, null, Color.black);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public WidgetSpectrogram getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetSpectrogram(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
        this.voc.setCollapsed(false);
        this.voc.setFadable(false);
    }

    public void adjustWidgetControl() {
        this.voc.adjustWidgetControl();
    }

    @Override
    public void paintCollapsed(Graphics g) {
        Tool.drawSpectra(g, 0, 5, Color.white);
    }

    @Override
    public boolean onNothing(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (Math.abs(y - (this.getHeight() - MB)) < 12) {
            this.onNothing = false;
        } else {
            boolean bl = this.onNothing = !this.flagMouseDrag && this.getBarAt(x, y) == null && this.getButtonAt(x, y, 2) == null;
        }
        if (this.onNothing) {
            this.mouseX = -1;
        }
        if (this.onNothing) {
            Util.toolTip(this.v, null);
        }
        return this.onNothing;
    }

    class Bar {
        Rectangle rect;
        int mode;
        double freq;
        int order;
        long npix;
        String label;
        String labelDown;
        Color cBar;
        Color cLabel;
        boolean inMoc;
        boolean startTile;
        int orderTile;
        long npixTile;

        Bar(int x, int y, int width, int height, double freq, int order, long npix, String label, boolean startTile, int orderTile, long npixTile) {
            this.rect = new Rectangle(x, y, width, height);
            this.freq = freq;
            this.label = label;
            this.order = order;
            this.npix = npix;
            this.startTile = startTile;
            this.orderTile = orderTile;
            this.npixTile = npixTile;
            this.mode = 0;
        }

        void setMode(int mode) {
            this.mode = mode;
        }

        void setLabelDown(String s) {
            this.labelDown = s;
        }

        void setColorBar(Color c) {
            this.cBar = c;
        }

        void setColorLabel(Color c) {
            this.cLabel = c;
        }

        void setInMoc(boolean flag) {
            this.inMoc = flag;
        }

        String getCmd() {
            Aladin cfr_ignored_0 = Spectrogram.this.aladin;
            if (Aladin.levelTrace >= 3) {
                return this.label + " (f" + this.order + "/" + this.npix + ")";
            }
            return this.label;
        }

        double getFreqRes() {
            try {
                return CalibFreq.pix2freqStart(this.order, this.npix + 1L) - CalibFreq.pix2freqStart(this.order, this.npix);
            }
            catch (Exception e) {
                e.printStackTrace();
                return Double.NaN;
            }
        }

        void drawBar(Graphics g) {
            g.setColor((this.mode & 0xF) != 0 ? this.cLabel : this.cBar);
            g.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }

        void drawHipsGrid(Graphics g) {
            if (!this.startTile) {
                return;
            }
            g.setColor(Spectrogram.this.aladin.view.gridColor);
            int y1 = this.rect.y;
            int h1 = this.rect.height;
            if (h1 < 10) {
                h1 = 10;
                y1 = this.rect.y + this.rect.height - h1;
            }
            g.drawLine(this.rect.x, y1, this.rect.x, y1 + h1);
            g.setFont(Aladin.fontResize(new Font("SansSerif", 0, Spectrogram.this.aladin.view.gridFontSize - 2)));
            int w = g.getFontMetrics().stringWidth(this.orderTile + "");
            int x = this.rect.x + 2;
            int y = this.rect.y + this.rect.height - 8;
            g.drawString(this.orderTile + "", x, y - 4);
            g.drawString(this.npixTile + "", x + w + 4, y + 4);
            g.drawString("/", x + w, y);
        }

        void drawLabel(Graphics g, int pos) {
            int y1;
            int x1;
            int sz;
            String s;
            if (Spectrogram.this.getPlan().isHipsSeq) {
                s = this.order + "/" + this.npix;
            } else {
                s = this.label;
                if ((this.mode & 0xE) != 0) {
                    s = Spectrogram.this.trimUnit(s);
                }
            }
            if (s != null) {
                sz = g.getFontMetrics().stringWidth(s);
                g.setColor(this.cLabel);
                if (pos == 2) {
                    x1 = this.rect.x + Spectrogram.this.getBarWidth() + 1;
                    y1 = this.rect.y + this.rect.height - 3;
                } else if (pos == 1) {
                    x1 = this.rect.x - sz - 2;
                    y1 = this.rect.y + this.rect.height - 6;
                } else {
                    x1 = this.rect.x + Spectrogram.this.getBarWidth() / 2 - sz / 2;
                    y1 = this.rect.y - 2;
                }
                if (y1 - g.getFontMetrics().getAscent() <= 0) {
                    y1 = g.getFontMetrics().getAscent();
                }
                if (!Spectrogram.this.aladin.view.infoBorder) {
                    g.drawString(s, x1, y1);
                } else {
                    Util.drawStringOutline(g, s, x1, y1, null, Color.black);
                }
            }
            if (!Spectrogram.this.getPlan().isHipsSeq && this.labelDown != null && Spectrogram.this.mustDrawLabelDown()) {
                sz = g.getFontMetrics().stringWidth(this.labelDown);
                g.setColor(this.cLabel);
                x1 = this.rect.x + Spectrogram.this.getBarWidth() / 2 - sz / 2;
                y1 = this.rect.y + this.rect.height + g.getFontMetrics().getHeight() - 2;
                if (!Spectrogram.this.aladin.view.infoBorder) {
                    g.drawString(this.labelDown, x1, y1);
                } else {
                    Util.drawStringOutline(g, this.labelDown, x1, y1, null, Color.black);
                }
            }
        }

        public String toString() {
            return "Bar " + this.order + "/" + this.npix + " " + this.label + " mode=" + Spectrogram.this.getModeString(this.mode);
        }
    }

    private class LastAnimation {
        int delta;
        long time;

        private LastAnimation() {
        }
    }
}

