/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.Server;
import cds.aladin.SourceStat;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JTextField;

public class SourceStatRing
extends SourceStat {
    protected double internalRadius = 0.0;

    protected SourceStatRing(Plan plan) {
        super(plan);
    }

    protected SourceStatRing(Plan plan, ViewSimple v, double x, double y, String id) {
        super(plan, v, x, y, id);
    }

    protected SourceStatRing(Plan plan, ViewSimple v, Coord c, String id) {
        super(plan, v, c, id);
    }

    public double getInternalRadius() {
        return this.internalRadius;
    }

    protected void setInternalRadius(String r) throws Exception {
        this.internalRadius = Server.getAngleInArcmin(r, 1) / 60.0;
        if (this.internalRadius > this.getRadius()) {
            throw new Exception();
        }
        this.resume();
    }

    @Override
    protected void otherProp(Vector propList) {
        final SourceStatRing myself = this;
        final JTextField testRadius = new JTextField(10);
        final PropAction updateRadius = new PropAction(){

            @Override
            public int action() {
                testRadius.setText(Coord.getUnit(SourceStatRing.this.getInternalRadius()));
                return 1;
            }
        };
        PropAction changRadius = new PropAction(){

            @Override
            public int action() {
                testRadius.setForeground(Color.black);
                String oval = Coord.getUnit(SourceStatRing.this.getRadius());
                try {
                    String nval = testRadius.getText();
                    if (nval.equals(oval)) {
                        return -1;
                    }
                    ((SourceStatRing)myself).setInternalRadius(nval);
                    return 1;
                }
                catch (Exception e1) {
                    updateRadius.action();
                    testRadius.setForeground(Color.red);
                    return 0;
                }
            }
        };
        propList.add(Prop.propFactory("internalradius", "Internal radius", "", testRadius, updateRadius, changRadius));
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!super.draw(g, v, dx, dy)) {
            return false;
        }
        double r = this.getInternalRadius();
        if (r == 0.0) {
            return false;
        }
        int l = (int)(r * v.getZoom());
        Point p = this.getViewCoord(v, l, l);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        g.setColor(this.getColor());
        if (this.hasPhot(v.pref) && v.pref == this.planBase) {
            Util.drawFillOval(g, p.x - l, p.y - l, l * 2, l * 2, 0.2f * this.plan.getOpacityLevel(), null);
        } else {
            g.drawOval(p.x - l, p.y - l, l * 2, l * 2);
        }
        return true;
    }
}

