/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.SliderCube;
import cds.aladin.SliderDensity;
import cds.aladin.SliderEpoch;
import cds.aladin.SliderOpacity;
import cds.aladin.SliderSize;
import cds.aladin.SliderZoom;
import cds.aladin.Zoom;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class SliderPanel
extends JPanel {
    static final int MINZOOM = Zoom.mzn.length;
    static final int MAXZOOM = 67;
    public static final int MINSLIDERBG = 0;
    public static final int MAXSLIDERBG = 60;
    public static final int MINSLIDER = Zoom.mzn.length - 7;
    public static final int MAXSLIDER = Zoom.mzn.length + 7;
    protected SliderSize sizeSlider;
    protected SliderOpacity opacitySlider;
    protected SliderZoom zoomSlider;
    protected SliderEpoch epochSlider;
    protected SliderCube cubeSlider;
    protected SliderDensity densitySlider;
    private JPanel sp;
    Aladin aladin;

    protected SliderPanel() {
    }

    protected SliderPanel(Aladin aladin) {
        this.aladin = aladin;
        this.cubeSlider = new SliderCube(aladin);
        this.epochSlider = new SliderEpoch(aladin);
        this.sizeSlider = new SliderSize(aladin);
        this.densitySlider = new SliderDensity(aladin);
        this.opacitySlider = new SliderOpacity(aladin);
        this.zoomSlider = new SliderZoom(aladin);
        this.setLayout(new BorderLayout());
        this.setBackground(aladin.getBackground());
        this.setOpaque(true);
        this.sp = new JPanel(new BorderLayout());
        this.sp.setBackground(aladin.getBackground());
        this.adjustSliderPanel();
        this.add((Component)this.sp, "Center");
    }

    protected void adjustSliderPanel() {
        JPanel p = new JPanel(new GridLayout(0, 1, 1, 1));
        p.setBackground(this.aladin.getBackground());
        if (this.aladin.configuration.isSliderEpoch()) {
            p.add(this.epochSlider);
        }
        if (this.aladin.configuration.isSliderSize()) {
            p.add(this.sizeSlider);
        }
        if (this.aladin.configuration.isSliderDensity()) {
            p.add(this.densitySlider);
        }
        if (this.aladin.configuration.isSliderCube()) {
            p.add(this.cubeSlider);
        }
        if (this.aladin.configuration.isSliderOpac()) {
            p.add(this.opacitySlider);
        }
        if (this.aladin.configuration.isSliderZoom()) {
            p.add(this.zoomSlider);
        }
        boolean flagValidate = false;
        if (this.sp.getComponentCount() > 0) {
            this.sp.removeAll();
            flagValidate = true;
        }
        this.sp.add((Component)p, "Center");
        if (flagValidate) {
            this.sp.revalidate();
        }
    }
}

