/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.SliderPlusMoins;
import cds.astro.Astrotime;
import java.awt.Graphics;

public class SliderEpoch
extends SliderPlusMoins {
    String defaultLabel;

    public SliderEpoch(Aladin aladin) {
        super(aladin, aladin.getChaine().getString("SLIDEREPOCH"), 1500, 2500, 1, 100);
        this.setTooltip(aladin.getChaine().getString("SLIDEREPOCHTIP"));
        this.defaultLabel = this.label.getText();
        this.label.setToolTipText(aladin.getChaine().getString("SLIDEREPOCHLABELTIP"));
    }

    @Override
    protected void setDefault() {
        double yr = 2000.0;
        try {
            String ep;
            Plan pi = this.aladin.calque.getPlanBase();
            if (pi instanceof PlanImage && (ep = ((PlanImage)pi).getDateObs()) != null) {
                Astrotime t = new Astrotime();
                t.set(ep);
                yr = t.getJyr();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.slider.setValue(yr);
        this.submit(0);
    }

    @Override
    void submit(int inc) {
        Plan[] p = this.getPlanCatalog();
        if (p == null) {
            return;
        }
        for (Plan p1 : p) {
            try {
                p1.setEpoch(this.slider.getValue() + (double)inc + "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.aladin.view.coteDist != null) {
            this.aladin.view.getCurrentView().createCoteDist();
        }
        this.aladin.calque.repaintAll();
    }

    Plan[] getPlanCatalog() {
        Plan[] p = this.aladin.calque.getPlans();
        int n = 0;
        for (Plan p1 : p) {
            if (!p1.selected || !p1.hasPM()) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        Plan[] p2 = new Plan[n];
        n = 0;
        for (Plan p1 : p) {
            if (!p1.selected || !p1.hasPM()) continue;
            p2[n++] = p1;
        }
        return p2;
    }

    @Override
    public void paintComponent(Graphics g) {
        Plan[] p = this.getPlanCatalog();
        if (p != null) {
            this.setEnabled(true);
            int yr = (int)(p[0].getEpoch().getJyr() + 0.5);
            this.label.setText("J" + yr);
            this.slider.setValue(yr);
        } else {
            this.slider.setValue(this.slider.min);
            this.label.setText(this.defaultLabel);
            this.setEnabled(false);
        }
        super.paintComponent(g);
    }
}

