/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CalibFreq;
import cds.aladin.Plan;
import cds.aladin.PlanHips3D;
import cds.aladin.SliderPlusMoins;
import cds.aladin.ViewSimple;
import java.awt.Graphics;

public class SliderCube
extends SliderPlusMoins {
    public SliderCube(Aladin aladin) {
        super(aladin, aladin.getChaine().getString("SLIDERCUBE"), 0, 10, 1);
        this.setTooltip(aladin.getChaine().getString("SLIDERCUBETIP"));
    }

    @Override
    void submit(int inc) {
        Plan p = this.getPlanCube();
        if (p == null) {
            return;
        }
        double value = this.getValue() + (double)inc;
        p.changeImgID();
        if (p instanceof PlanHips3D) {
            this.setFrequence((PlanHips3D)p, (int)value);
        } else {
            this.setChannel(p, value);
        }
        this.aladin.view.repaintAll();
    }

    void setFrequence(PlanHips3D plan, int value) {
        block3: {
            try {
                int orderZFull = plan.getOrderZInCurrentView() + plan.getOrderZTile();
                double freqMin = plan.getFrequenceMin();
                long npixZMin = CalibFreq.freq2pix(orderZFull, freqMin);
                double freq = CalibFreq.pix2freq(orderZFull, (long)value + npixZMin);
                for (ViewSimple v : this.aladin.view.getSelectedView()) {
                    v.setFrequence(freq, true);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    void setChannel(Plan p, double channel) {
        int[] vn = this.aladin.view.getNumView(p);
        if (vn != null) {
            for (int i = 0; i < vn.length; ++i) {
                this.aladin.view.setCubeFrame(this.aladin.view.viewSimple[vn[i]], channel, true);
            }
        } else {
            p.setCubeFrame(channel);
        }
    }

    Plan getPlanCube() {
        Plan[] p;
        for (Plan p1 : p = this.aladin.calque.getPlans()) {
            if (!p1.selected || !p1.isCubeClassique() && !(p1 instanceof PlanHips3D)) continue;
            return p1;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        Plan p = this.getPlanCube();
        if (p != null) {
            this.setEnabled(true);
            if (p instanceof PlanHips3D) {
                this.setParamHips3D((PlanHips3D)p);
            } else {
                this.setParamCube(p);
            }
        } else {
            this.slider.setValue(this.slider.min);
            this.setEnabled(false);
        }
        super.paintComponent(g);
    }

    private void setParamHips3D(PlanHips3D p) {
        block2: {
            ViewSimple v = this.aladin.view.getCurrentView();
            try {
                int orderZFull = p.getOrderZInCurrentView() + p.getOrderZTile();
                double freqMin = p.getFrequenceMin();
                int npixZMin = (int)CalibFreq.freq2pix(orderZFull, freqMin);
                double freqMax = p.getFrequenceMax();
                int npixZMax = (int)CalibFreq.freq2pix(orderZFull, freqMax);
                int npixZFull = (int)CalibFreq.freq2pix(orderZFull, p.getFrequence(v));
                this.slider.setMinMax(0, npixZMax - npixZMin);
                this.slider.setValue(npixZFull - npixZMin);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
    }

    private void setParamCube(Plan p) {
        this.slider.setMinMax(0, p.getDepth() - 1);
        this.slider.setValue(p.getZ());
    }
}

