/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FootprintBean;
import cds.aladin.FootprintParser;
import cds.aladin.MyInputStream;
import cds.aladin.PlanField;
import cds.aladin.Server;
import cds.aladin.ServerFile;
import cds.aladin.Tok;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class ServerFoV
extends Server
implements TableModel {
    static final int MAXLINE = 7;
    String LOAD;
    Vector<FoVItem> fovList;
    JTable table;
    TableModelListener tableListener;
    JTextField roll;
    String info1;
    String info2;
    String angle;
    String angle1;
    String edit;
    String fovedit;
    int idxSortedCol = 1;
    boolean ascSort;
    protected static String idLastRegistered;
    static final String[][] FOV;
    private boolean dynFoV = false;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = Aladin.chaine.getString("FOVINFO");
        this.info1 = Aladin.chaine.getString("FOVINFO1");
        this.info2 = Aladin.chaine.getString("FOVINFO2");
        this.angle = Aladin.chaine.getString("FOVANGLE");
        this.angle1 = Aladin.chaine.getString("FOVANGLE1");
        this.angle = this.angle + " (" + this.angle1 + ")";
        this.edit = Aladin.chaine.getString("FOVEDIT");
        this.LOAD = Aladin.chaine.getString("FOVLOAD");
        this.fovedit = "FovEditor";
    }

    protected ServerFoV(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.aladinLabel = "Instrument Field of Views (FoV)";
        this.aladinMenu = "FoV...";
        this.type = 8;
        this.aladinLogo = "FoVLogo.gif";
        this.grab = null;
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        this.setBounds(0, 0, WIDTH, HEIGHT);
        int y = 20;
        JPanel tp = new JPanel();
        tp.setBackground(Aladin.BLUE);
        Dimension d = this.makeTitle(tp, this.description);
        tp.setBounds(XWIDTH / 2 - d.width / 2, y, d.width, d.height);
        this.add(tp);
        JLabel l = new JLabel(this.info1);
        l.setBounds(182, y += d.height + 10, 400, 20);
        this.add(l);
        l = new JLabel(this.info2);
        l.setBounds(92, y += 15, 300, 20);
        y += 20;
        this.add(l);
        JPanel tPanel = new JPanel();
        tPanel.setBackground(Aladin.BLUE);
        int h = this.makeTargetPanel(tPanel, 2);
        tPanel.setBounds(0, y, XWIDTH, h);
        y += h;
        this.add(tPanel);
        this.modeCoo = 5;
        this.modeRad = 0;
        JLabel label = new JLabel(this.addDot(this.angle));
        label.setFont(Aladin.BOLD);
        label.setBounds(10, y, 150, HAUT);
        this.add(label);
        this.roll = new JTextField("0.0");
        this.roll.setBounds(160, y, XWIDTH - 160, HAUT);
        y += HAUT + MARGE + 10;
        this.add(this.roll);
        this.table = new TwoColorJTable(this);
        this.table.setGridColor(Color.lightGray);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.table.getTableHeader().getDefaultRenderer()));
        this.table.getTableHeader().addMouseListener(new TableHeaderListener());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(110);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(80);
        JScrollPane sc = new JScrollPane(this.table);
        sc.setBounds(10, y, XWIDTH, 150);
        y += 150;
        this.add(sc);
        JButton b = new JButton(this.edit);
        b.setOpaque(false);
        b.addActionListener(this);
        b.setBounds(190, y += 10, 150, HAUT);
        this.add(b);
        b = new JButton(this.LOAD);
        b.setOpaque(false);
        b.addActionListener(this);
        b.setBounds(350, y, 100, HAUT);
        this.add(b);
        this.setMaxComp(sc);
        this.initStaticFoV();
    }

    @Override
    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        String instrument = null;
        double roll = 0.0;
        Tok st = new Tok(criteria, " ,");
        instrument = st.nextToken();
        if (instrument != null) {
            instrument = instrument.toUpperCase();
        }
        if (st.hasMoreTokens()) {
            try {
                roll = Double.valueOf(st.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initDynamicFoV();
        this.aladin.targetHistory.add(target);
        return this.creatFieldPlane(target, roll, instrument, label);
    }

    protected PlanField fieldPlanFactory(String target, double roll, String instrument, String label) {
        this.loadRemoteFoV();
        FootprintBean fpBean = this.getFovBeanByID(instrument);
        label = this.getDefaultLabelIfRequired(label, instrument);
        PlanField pf = fpBean != null ? new PlanField(this.aladin, target, fpBean, label, roll) : new PlanField(this.aladin, target, roll, instrument, label);
        return pf;
    }

    protected int creatFieldPlane(String target, double roll, String instrument, String label) {
        if (instrument == null || instrument.equals("")) {
            Aladin.error(this.WNEEDCHECK, 1);
            return -1;
        }
        this.loadRemoteFoV();
        FootprintBean fpBean = this.getFovBeanByID(instrument);
        label = this.getDefaultLabelIfRequired(label, instrument);
        this.aladin.targetHistory.add(target);
        if (fpBean != null) {
            return this.aladin.calque.newPlanField(fpBean, target, label, roll);
        }
        return this.aladin.calque.newPlanField(target, roll, instrument, label);
    }

    @Override
    protected String resolveTargetName(String s) {
        return this.resolveTargetNameNow(s);
    }

    @Override
    public void submit() {
        int n;
        String t = this.getTarget();
        String s = this.roll.getText().trim();
        double r = s.length() == 0 ? 0.0 : Double.valueOf(s);
        int idx = this.table.getSelectedRow();
        if (idx >= 0) {
            FoVItem fov = this.fovList.elementAt(idx);
            s = fov.id;
        } else {
            s = null;
        }
        String code = null;
        if (s != null) {
            code = "get FoV(" + Tok.quote(s) + ")";
            this.aladin.console.printCommand(code + " " + t);
        }
        if ((n = this.creatFieldPlane(t, r, s, null)) != -1) {
            this.ball.setMode(1);
            if (code != null) {
                this.aladin.calque.getPlan(n).setBookmarkCode(code + " $TARGET");
            }
        } else {
            this.ball.setMode(3);
        }
    }

    public boolean registerNewFovTemplate(String id, PlanField pf) {
        if (this.findFoVIndex(id) >= 0) {
            Aladin.trace(3, "PlanField " + id + " is already registered !! Existing definition will be erased");
        }
        this.addFoV(id, pf);
        idLastRegistered = id;
        return true;
    }

    public FootprintBean getFovBeanByID(String id) {
        return FootprintParser.getBeanFromID(id);
    }

    public void selectFOV(String id) {
        int i = this.findFoVIndex(id);
        this.table.getSelectionModel().setSelectionInterval(i, i);
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Instrument";
            }
            case 1: {
                return "Telescope";
            }
            case 2: {
                return "Description";
            }
            case 3: {
                return "Author";
            }
        }
        return "";
    }

    int findFoVIndex(String id) {
        for (int i = 0; i < this.fovList.size(); ++i) {
            FoVItem fov = this.fovList.elementAt(i);
            if (!fov.id.equals(id)) continue;
            return i;
        }
        return -1;
    }

    boolean addFoV(String id, PlanField pf) {
        int i = this.findFoVIndex(id);
        FoVItem fov = new FoVItem(id, pf);
        if (i >= 0) {
            this.fovList.setElementAt(fov, i);
        } else {
            this.fovList.addElement(fov);
        }
        this.idxSortedCol = 1;
        this.ascSort = true;
        this.fireTable();
        return true;
    }

    boolean addFoV(String instr, String telesc, String descr, String orig) {
        String id = ServerFoV.makeID(instr, telesc);
        int i = this.findFoVIndex(id);
        FoVItem fov = new FoVItem(instr, telesc, descr, orig);
        if (i >= 0) {
            this.fovList.setElementAt(fov, i);
        } else {
            this.fovList.addElement(fov);
        }
        this.idxSortedCol = 1;
        this.ascSort = true;
        this.fireTable();
        return true;
    }

    private void notifyTableChanged() {
        int n = this.fovList.size();
        this.tableListener.tableChanged(new TableModelEvent(this, n, n, -1, 1));
    }

    private void fireTable() {
        this.defaultSortFoV();
        this.notifyTableChanged();
    }

    private void defaultSortFoV() {
        Collections.sort(this.fovList, new Comparator<FoVItem>(){

            @Override
            public int compare(FoVItem f1, FoVItem f2) {
                int n = f1.telescope.compareTo(f2.telescope);
                if (n != 0) {
                    return n;
                }
                return f1.instrument.compareTo(f2.instrument);
            }
        });
        if (!this.ascSort) {
            Collections.reverse(this.fovList);
        }
        this.ascSort = !this.ascSort;
    }

    @Override
    public int getRowCount() {
        return this.fovList == null ? -1 : this.fovList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FoVItem fov = this.fovList.elementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return fov.instrument;
            }
            case 1: {
                return fov.telescope;
            }
            case 2: {
                return fov.description;
            }
            case 3: {
                return fov.origine == null ? "?" : fov.origine;
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableListener = l;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    private void initStaticFoV() {
        this.fovList = new Vector();
        for (int i = 0; i < FOV.length; ++i) {
            FoVItem fov = new FoVItem(FOV[i][0], FOV[i][1], FOV[i][2], FOV[i][3]);
            this.fovList.add(fov);
        }
    }

    @Override
    public void show() {
        this.initDynamicFoV();
        super.show();
    }

    private void initDynamicFoV() {
        if (this.dynFoV) {
            return;
        }
        new Thread("initFov"){

            @Override
            public void run() {
                ServerFoV.this.loadRemoteFoV();
            }
        }.start();
    }

    protected void loadRemoteFoV() {
        block3: {
            if (this.dynFoV) {
                return;
            }
            try {
                this.dynFoV = true;
                Aladin.trace(3, "Loading FoV definitions...");
                MyInputStream in = new MyInputStream(Aladin.cache.get("http://aladin.cds.unistra.fr/java/FOVs.xml"));
                this.aladin.processFovVOTable(in, false);
            }
            catch (Exception e1) {
                if (Aladin.levelTrace < 3) break block3;
                e1.printStackTrace();
            }
        }
    }

    static String makeID(String instrument, String telescope) {
        return instrument + "." + telescope;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof JButton) {
            String menu = ((JButton)o).getActionCommand();
            if (menu.equals(this.edit)) {
                this.aladin.buildFoV();
            } else if (menu.equals(this.LOAD)) {
                ((ServerFile)this.aladin.dialog.localServer).browseFile();
            }
        }
        super.actionPerformed(e);
    }

    static {
        FOV = new String[][]{{"MEGAPRIME", "CFHT", "Wide field imaging camera + guiders", "CFH"}, {"CFH12K", "CFHT", "Large field camera", "CFH"}, {"WIRCAM", "CFHT", "Wide field IR camera", "CFH"}, {"ESPADONS", "CFHT", "Echelle Spectropolarimetric device", "CFH"}, {"EPICMOS", "XMM", "Sensitive imaging (0.1 to 15 keV)", "CDS"}, {"EPICpn", "XMM", "High resolution (<0.03ms)", "CDS"}};
    }

    class TableHeaderRenderer
    extends DefaultTableCellRenderer {
        TableCellRenderer renderer;

        public TableHeaderRenderer(TableCellRenderer defaultRenderer) {
            this.renderer = defaultRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int idxSortedColView = table.convertColumnIndexToView(ServerFoV.this.idxSortedCol);
            if (comp instanceof JLabel) {
                if (column == idxSortedColView) {
                    ImageIcon icon = ServerFoV.this.ascSort ? Util.getAscSortIcon() : Util.getDescSortIcon();
                    ((JLabel)comp).setIcon(icon);
                    ((JLabel)comp).setHorizontalTextPosition(10);
                } else {
                    ((JLabel)comp).setIcon(null);
                }
            }
            return comp;
        }
    }

    class TableHeaderListener
    extends MouseAdapter {
        TableHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int column;
            TableColumnModel columnModel = ServerFoV.this.table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            ServerFoV.this.idxSortedCol = column = ServerFoV.this.table.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column != -1) {
                if (column == 1) {
                    int idx = ServerFoV.this.table.getSelectedRow();
                    FoVItem selected = idx >= 0 ? ServerFoV.this.fovList.get(idx) : null;
                    ServerFoV.this.defaultSortFoV();
                    ServerFoV.this.notifyTableChanged();
                    this.selectItem(selected);
                    return;
                }
                Comparator comp = new Comparator(){

                    public final int compare(Object a, Object b) {
                        String val2 = null;
                        String val1 = null;
                        switch (column) {
                            case 0: {
                                val1 = ((FoVItem)a).instrument;
                                val2 = ((FoVItem)b).instrument;
                                break;
                            }
                            case 2: {
                                val1 = ((FoVItem)a).description;
                                val2 = ((FoVItem)b).description;
                                break;
                            }
                            case 3: {
                                val1 = ((FoVItem)a).origine;
                                val2 = ((FoVItem)b).origine;
                            }
                        }
                        return ((Comparable)((Object)val1)).compareTo(val2);
                    }
                };
                int idx = ServerFoV.this.table.getSelectedRow();
                FoVItem selected = idx >= 0 ? ServerFoV.this.fovList.get(idx) : null;
                Collections.sort(ServerFoV.this.fovList, comp);
                if (!ServerFoV.this.ascSort) {
                    Collections.reverse(ServerFoV.this.fovList);
                }
                ServerFoV.this.ascSort = !ServerFoV.this.ascSort;
                ServerFoV.this.notifyTableChanged();
                this.selectItem(selected);
            }
        }

        private void selectItem(final Object o) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServerFoV.this.table.clearSelection();
                    if (o == null) {
                        return;
                    }
                    int idxSelected = ServerFoV.this.fovList.indexOf(o);
                    if (idxSelected >= 0) {
                        ServerFoV.this.table.addRowSelectionInterval(idxSelected, idxSelected);
                    }
                }
            });
        }
    }

    class FoVItem {
        String instrument;
        String telescope;
        String description;
        String origine;
        String id;
        PlanField pf;

        FoVItem(String instr, String telesc, String desc, String orig) {
            this.instrument = instr;
            this.telescope = telesc;
            this.description = desc;
            this.origine = orig == null ? "" : orig;
            this.id = this.instrument;
            this.pf = null;
        }

        FoVItem(String id, PlanField pf) {
            this.id = id;
            this.pf = pf;
            this.instrument = pf.getInstrumentName();
            this.telescope = pf.getTelescopeName();
            this.description = pf.getInstrumentDesc();
            this.origine = pf.getOrigine();
            if (this.instrument == null || this.instrument.length() == 0) {
                this.instrument = id;
            }
        }
    }
}

