/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FootprintBean;
import cds.aladin.FootprintParser;
import cds.aladin.Fov;
import cds.aladin.MetaDataTree;
import cds.aladin.PlanField;
import cds.aladin.ResourceNode;
import cds.aladin.TreeBuilder;
import cds.aladin.TreeView;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;
import cds.savot.pull.SavotPullParser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class SIAPExtBuilder
extends TreeBuilder {
    static final String UT_SIMPLEQUERY = "dal:SimpleQueryResponse";
    static final String UT_DALEXTENSIONS = "dal:QueryResponseExtensions";
    static final String UT_GENFEATURES = "Observation.DataID.Collection";
    static final String UT_GENFEATURES_DEPRECATED = "Observation/DataCollection";
    static final String UT_CHARACTERIZATION = "Observation/ivoa:Characterization";
    static final String UT_DATAACCESS = "Observation.Provenance.DataViewsAndAccess";
    static final String UT_DATAACCESS_DEPRECATED = "Observation/DataViewsAndAccess";
    static final String UT_COMPOSITION = "Observation/Provenance/Processing/Composition";
    static final String UT_RADEC = "ivoa:Characterization[ucd=pos]/Coverage/Location";
    static final String UT_MINRADEC = "ivoa:Characterization[ucd=pos]/Coverage/Bounds/min";
    static final String UT_MAXRADEC = "ivoa:Characterization[ucd=pos]/Coverage/Bounds/max";
    static final String UT_OBS_DATASET_ID = "Observation.DataID.DatasetID";
    static final String UT_OBS_DATASET_ID_DEPRECATED = "Observation/Identifier";
    static final String FOV_POS_ANGLE = "stc:AstroCoordSystem.CoordFrame.Cart2DRefFrame.Transform2.PosAngle";
    private SavotPullParser parser;
    private SavotVOTable votable;
    SavotResource orgSiapRes;
    SavotResource dalExtRes;
    SavotTable genFeatTab;
    SavotTable characTab;
    SavotTable dataAccessTab;
    SavotTable compositionTab;
    private Hashtable namesToNodes;
    private Hashtable altNamesToNodes;
    private int obsRefIndex;
    private int idxRefRelObs;
    private Vector alreadyAdded;
    private Vector otherTabs;
    private boolean isFootprintDoc = false;
    private Vector potentialKeys;
    private Hashtable keyToNodes;
    private String obsRefID;
    private String obsNameID;

    SIAPExtBuilder(Aladin aladin, String target) {
        super(aladin, target);
    }

    protected ResourceNode build(SavotPullParser p) throws Exception {
        int i;
        Aladin.trace(3, "Begin parsing of SIAP extensions document");
        this.reset();
        this.parser = p;
        if (this.parser == null) {
            throw new Exception("Null parser passed to SIAPExtBuilder class");
        }
        this.votable = this.parser.getVOTable();
        this.preCheck();
        this.searchSortOrder(this.votable);
        if (this.orgSiapRes == null) {
            throw new Exception("Could not find SIAP results section, parsing aborted !");
        }
        ResourceNode root = new ResourceNode(this.aladin, "root");
        root.type = 0;
        root.isSIAPEvol = true;
        SavotField[] initFields = this.createDescription(this.orgSiapRes.getFieldSet(0));
        Aladin.trace(3, "orgsiapres : " + this.orgSiapRes);
        Aladin.trace(3, "initFields.length : " + initFields.length);
        String[] idFields = new String[initFields.length];
        for (int i2 = 0; i2 < initFields.length; ++i2) {
            idFields[i2] = initFields[i2].getId();
            if (!initFields[i2].getUtype().equals(UT_OBS_DATASET_ID) && !initFields[i2].getUtype().equals(UT_OBS_DATASET_ID_DEPRECATED)) continue;
            this.potentialKeys.addElement(initFields[i2].getId());
        }
        this.obsRefID = this.getObsRefID(initFields);
        this.obsNameID = this.getObsNameID(initFields);
        int bandPassIdx = this.findFieldByUCD("VOX:BandPass_ID", initFields);
        Aladin.trace(3, "obsRefID : " + this.obsRefID);
        Aladin.trace(3, "obsNameID : " + this.obsNameID);
        this.obsRefIndex = this.findValIndex(idFields, this.obsRefID);
        this.idxRefRelObs = this.findValIndex(idFields, this.obsNameID);
        Vector<String> desc = new Vector<String>();
        this.namesToNodes = new Hashtable();
        this.altNamesToNodes = new Hashtable();
        ResourceNode[] siapRes = this.processSIAPEvolResource(this.orgSiapRes);
        this.registerKeyVal(initFields, siapRes);
        if (siapRes.length > 0) {
            root.siapSortFields = siapRes[0].description;
            ResourceNode n = siapRes[0];
            for (i = 0; i < n.description.length; ++i) {
                desc.addElement(n.description[i]);
            }
        }
        if (this.isOnlyOrgSiap()) {
            Aladin.trace(3, "Processed as basic SIAP");
            for (int i3 = 0; i3 < siapRes.length; ++i3) {
                root.addChild(siapRes[i3]);
            }
        }
        if (this.dalExtRes != null) {
            Aladin.trace(3, "Entering processing of gen feat tab");
            this.processGenFeatTab(siapRes, desc);
        }
        this.alreadyAdded = new Vector();
        if (this.characTab != null) {
            Aladin.trace(3, "Entering processing of charac");
            this.processCharac();
        }
        if (this.compositionTab != null) {
            Aladin.trace(3, "Entering processing of composition table");
            this.processCompositionTab();
        }
        if (this.dataAccessTab != null) {
            Aladin.trace(3, "Entering processing of dataaccess table");
            this.processDataAccessTab();
        }
        Enumeration eGenTab = this.otherTabs.elements();
        while (eGenTab.hasMoreElements()) {
            this.processGenericTable((SavotTable)eGenTab.nextElement());
        }
        if (!this.isOnlyOrgSiap()) {
            for (i = 0; i < siapRes.length; ++i) {
                if (this.alreadyAdded.contains(siapRes[i])) continue;
                root.addChild(siapRes[i]);
                siapRes[i].isLeaf = siapRes[i].getNbOfChildren() <= 0;
                this.alreadyAdded.addElement(siapRes[i]);
            }
        }
        Enumeration e = root.getChildren();
        while (e.hasMoreElements()) {
            ((ResourceNode)e.nextElement()).isObs = true;
        }
        if (this.sortItems == null && bandPassIdx >= 0) {
            this.sortItems = new String[1];
            this.sortItems[0] = initFields[bandPassIdx].getId();
            if (this.sortItems[0] == null || this.sortItems[0].length() == 0) {
                this.sortItems[0] = initFields[bandPassIdx].getName();
            }
            if (this.sortItems[0] == null || this.sortItems[0].length() == 0) {
                this.sortItems = null;
            }
        }
        if (this.sortItems != null) {
            MetaDataTree.doSortSiapEvol(this.sortItems, root);
        }
        this.reset();
        return root;
    }

    private void processGenericTable(SavotTable table) {
        String tabName = table.getId();
        Hashtable<ResourceNode, ResourceNode> keyToTabRes = new Hashtable<ResourceNode, ResourceNode>();
        SavotField[] fields = this.createDescription(table.getFields());
        int obsRefIndex = this.findKey(fields);
        if (obsRefIndex < 0) {
            Aladin.trace(3, "Could not find key field when processing generic table");
            return;
        }
        Aladin.trace(3, tabName);
        Aladin.trace(3, "+++ : " + obsRefIndex);
        TRSet trs = table.getData().getTableData().getTRs();
        if (trs.getItemCount() == 0) {
            return;
        }
        List e = trs.getItems();
        for (SavotTR tr : e) {
            TDSet tds = tr.getTDs();
            String keyVal = tds.getContent(obsRefIndex);
            ResourceNode node = this.getNodeFromKey(fields[obsRefIndex], keyVal);
            if (node == null) {
                Aladin.trace(3, "Could not find an observation with key " + keyVal);
                continue;
            }
            if (keyToTabRes.get(node) == null) {
                node.isLeaf = false;
                if (node.location != null) {
                    node.hasData = true;
                }
                ResourceNode child = new ResourceNode(this.aladin, tabName);
                child.isLeaf = false;
                node.addChild(child);
                keyToTabRes.put(node, child);
            }
            ResourceNode parentNode = (ResourceNode)keyToTabRes.get(node);
            ResourceNode n = this.createSIAPNode(tr, fields);
            parentNode.addChild(n);
            this.setDatasetType(n);
            Aladin.trace(3, "key : " + keyVal);
            Aladin.trace(3, "***" + this.namesToNodes.get(keyVal));
        }
    }

    private void processDataAccessTab() {
        int descIndex;
        int dataOrgaIndex;
        SavotField[] fields = this.createDescription(this.dataAccessTab.getFields());
        Hashtable<String, ResourceNode> namesToDataAccess = new Hashtable<String, ResourceNode>();
        TRSet trSet = this.dataAccessTab.getData().getTableData().getTRs();
        if (trSet.getItems() == null) {
            return;
        }
        List e = trSet.getItems();
        int obsRefIndex = this.findFieldByID(this.obsRefID, fields);
        int locationIndex = this.findFieldByUtype("Observation.Provenance.DataViewsAndAccess.AccessReference", fields);
        if (locationIndex < 0) {
            locationIndex = this.findFieldByID("LinktoPixels", fields);
        }
        if ((dataOrgaIndex = this.findFieldByUtype("Observation.Provenance.DataViewsAndAccess.ViewType", fields)) < 0) {
            dataOrgaIndex = this.findFieldByID("DataOrganisation", fields);
        }
        if ((descIndex = this.findFieldByUtype("Observation.Provenance.DataViewsAndAccess.ViewDescription", fields)) < 0) {
            descIndex = this.findFieldByID("desc", fields);
        }
        int numberIndex = this.findFieldByID("number", fields);
        int mapParamIndex = this.findFieldByID("MapPare", fields);
        String descStr = null;
        String dataOrgaStr = null;
        String locationStr = null;
        for (SavotTR tr : e) {
            String[] params;
            TDSet tds = tr.getTDs();
            String obsRef = tds.getContent(obsRefIndex);
            ResourceNode parent = (ResourceNode)this.namesToNodes.get(obsRef);
            if (parent == null) continue;
            ResourceNode curDataAccessNode = (ResourceNode)namesToDataAccess.get(obsRef);
            if (curDataAccessNode == null) {
                curDataAccessNode = new ResourceNode(this.aladin, "Data Access");
                namesToDataAccess.put(obsRef, curDataAccessNode);
                parent.addChild(curDataAccessNode);
                parent.isLeaf = false;
            }
            String nbPatch = "";
            if (numberIndex >= 0) {
                nbPatch = tds.getContent(numberIndex).trim();
            }
            String mapParam = "";
            if (mapParamIndex >= 0) {
                mapParam = tds.getContent(mapParamIndex).trim();
            }
            boolean cutout = false;
            if (locationIndex >= 0) {
                locationStr = tds.getContent(locationIndex);
            }
            if (dataOrgaIndex >= 0) {
                dataOrgaStr = tds.getContent(dataOrgaIndex);
            }
            if (descIndex >= 0) {
                descStr = tds.getContent(descIndex);
            }
            cutout = dataOrgaStr != null && dataOrgaStr.equalsIgnoreCase("CUTOUTS");
            ResourceNode newNode = new ResourceNode(this.aladin, parent);
            newNode.name = "View";
            newNode.isLeaf = true;
            newNode.cutout = cutout;
            newNode.location = locationStr;
            if (newNode.cutout) {
                String cutoutCenter = this.getRequestedPos() != null ? this.getRequestedPos() : newNode.explanation[newNode.ra] + " " + newNode.explanation[newNode.de];
                newNode.setCutoutTarget(cutoutCenter, false);
            }
            if (dataOrgaStr.equals("RETRIEVAL")) {
                newNode.indexing = "HTML";
            }
            if (descStr != null && descStr.indexOf("characterization XML") >= 0) {
                newNode.type = 6;
            }
            if (nbPatch.length() > 0) {
                newNode.maxImgNumber = nbPatch;
            }
            if (mapParam.length() > 0 && (params = SIAPExtBuilder.split(mapParam, ",")).length == 2) {
                try {
                    newNode.beginVel = Double.valueOf(params[0]);
                    newNode.velStep = Double.valueOf(params[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            newNode.dataOrga = dataOrgaStr.trim();
            if (descStr != null && descStr.length() > 0) {
                newNode.name = descStr.trim();
            } else if (dataOrgaStr != null && dataOrgaStr.length() > 0) {
                newNode.name = dataOrgaStr.trim();
            }
            this.setDatasetType(newNode);
            curDataAccessNode.addChild(newNode);
        }
    }

    private void processCompositionTab() {
        SavotField[] fields = this.createDescription(this.compositionTab.getFields());
        int obsRefIndex = this.findFieldByID(this.obsRefID, fields);
        int relatedObsIndex = this.findFieldByID("RelatedObservation", fields);
        int compositionDescIdx = this.findFieldByUtype("Observation/Provenance/Processing/Composition/description", fields);
        Hashtable<String, ResourceNode> namesToMembers = new Hashtable<String, ResourceNode>();
        TRSet trSet = this.compositionTab.getData().getTableData().getTRs();
        List e = trSet.getItems();
        for (SavotTR tr : e) {
            String relatedObs;
            Vector children;
            String obsRef = ((SavotTD)tr.getTDs().getItemAt(obsRefIndex)).getContent();
            ResourceNode parent = (ResourceNode)this.namesToNodes.get(obsRef);
            if (parent == null) continue;
            ResourceNode curMembersNode = (ResourceNode)namesToMembers.get(obsRef);
            if (curMembersNode == null) {
                curMembersNode = compositionDescIdx >= 0 ? new ResourceNode(this.aladin, ((SavotTD)tr.getTDs().getItemAt(compositionDescIdx)).getContent()) : new ResourceNode(this.aladin, "Members");
                namesToMembers.put(obsRef, curMembersNode);
                parent.addChild(curMembersNode);
                parent.isLeaf = false;
            }
            if ((children = (Vector)this.altNamesToNodes.get(relatedObs = ((SavotTD)tr.getTDs().getItemAt(relatedObsIndex)).getContent())) == null) continue;
            Enumeration eChildren = children.elements();
            while (eChildren.hasMoreElements()) {
                ResourceNode child = (ResourceNode)eChildren.nextElement();
                curMembersNode.addChild(child);
                this.alreadyAdded.addElement(child);
                if (child.altName == null) continue;
                child.name = child.altName;
            }
        }
    }

    private void processCharac() {
        SavotField[] fields = this.createDescription(this.characTab.getFields());
        int obsRefIndex = this.findFieldByID(this.obsRefID, fields);
        Hashtable<String, ResourceNode> namesToInfo = new Hashtable<String, ResourceNode>();
        TRSet trSet = this.characTab.getData().getTableData().getTRs();
        List e = trSet.getItems();
        for (SavotTR tr : e) {
            Fov fov;
            String obsRef = ((SavotTD)tr.getTDs().getItemAt(obsRefIndex)).getContent();
            ResourceNode parent = (ResourceNode)this.namesToNodes.get(obsRef);
            if (parent == null) continue;
            ResourceNode curInfoNode = (ResourceNode)namesToInfo.get(obsRef);
            if (curInfoNode == null) {
                curInfoNode = new ResourceNode(this.aladin, "Info/Metadata");
                namesToInfo.put(obsRef, curInfoNode);
                parent.addChild(curInfoNode);
                parent.isLeaf = false;
            }
            if ((fov = this.getFovFromCharac(tr.getTDs(), fields)) != null) {
                parent.setFov(fov);
            }
            ResourceNode n = this.createSIAPNode(tr, fields);
            n.name = "CHARACTERIZATION";
            n.type = 5;
            curInfoNode.addChild(n);
        }
    }

    private void processGenFeatTab(ResourceNode[] tab, Vector desc) {
        this.processFov(tab, this.dalExtRes);
        if (this.idxRefRelObs < 0) {
            Aladin.trace(3, "idxRefRelObs is null, stop processing of genFeatTab");
            return;
        }
        Hashtable genFeatNodes = new Hashtable();
        this.processGenFeat(this.dalExtRes, genFeatNodes, desc);
        for (int i = 0; i < tab.length; ++i) {
            ResourceNode n = tab[i];
            ((Vector)this.altNamesToNodes.get(n.explanation[this.idxRefRelObs])).addElement(n);
            n.links = new Hashtable();
            block1: for (int j = 0; j < n.description.length; ++j) {
                String key = n.description[j] + n.explanation[j];
                ResourceNode associatedNode = (ResourceNode)genFeatNodes.get(key);
                if (associatedNode == null) continue;
                associatedNode.isLeaf = false;
                n.links.put(n.description[j], associatedNode);
                for (int k = 0; k < associatedNode.description.length; ++k) {
                    if (!associatedNode.description[k].equals("Organisation")) continue;
                    n.origin = associatedNode.explanation[k];
                    continue block1;
                }
            }
        }
    }

    private void preCheck() {
        ResourceSet resources = this.votable.getResources();
        Aladin.trace(3, "nb rsources : " + resources.getItemCount());
        for (int i = 0; i < resources.getItemCount(); ++i) {
            SavotResource resource = (SavotResource)resources.getItemAt(i);
            this.checkIfOrgSiap(resource);
            if (this.checkIfDalExt(resource)) continue;
            TableSet tSet = resource.getTables();
            for (int j = 0; j < tSet.getItemCount(); ++j) {
                Aladin.trace(3, "Process table " + j);
                SavotTable tab = (SavotTable)tSet.getItemAt(j);
                if (this.genFeatTab == null && (tab.getUtype().trim().equalsIgnoreCase(this.getUType(UT_GENFEATURES)) || tab.getUtype().trim().equalsIgnoreCase(this.getUType(UT_GENFEATURES_DEPRECATED)))) {
                    this.genFeatTab = tab;
                    continue;
                }
                if (this.characTab == null && tab.getUtype().trim().equalsIgnoreCase(this.getUType(UT_CHARACTERIZATION))) {
                    this.characTab = tab;
                    continue;
                }
                if (this.dataAccessTab == null && (tab.getUtype().trim().equalsIgnoreCase(this.getUType(UT_DATAACCESS)) || tab.getUtype().trim().equalsIgnoreCase(this.getUType(UT_DATAACCESS_DEPRECATED)))) {
                    this.dataAccessTab = tab;
                    continue;
                }
                if (this.compositionTab == null && tab.getUtype().trim().equalsIgnoreCase(this.getUType(UT_COMPOSITION))) {
                    this.compositionTab = tab;
                    continue;
                }
                if (i == 0) continue;
                this.otherTabs.addElement(tab);
            }
        }
    }

    private boolean isOnlyOrgSiap() {
        return this.dalExtRes == null && this.characTab == null && this.compositionTab == null && this.dalExtRes == null && this.dataAccessTab == null && this.genFeatTab == null;
    }

    private ResourceNode[] processSIAPEvolResource(SavotResource res) {
        Aladin.trace(3, "Processing original SIAP resource");
        SavotField[] fields = this.createDescription(res.getFieldSet(0));
        if (res.getData(0) == null) {
            return null;
        }
        if (res.getData(0).getTableData() == null) {
            return null;
        }
        TRSet obsSet = res.getData(0).getTableData().getTRs();
        ResourceNode[] resTab = new ResourceNode[obsSet.getItemCount()];
        for (int i = 0; i < resTab.length; ++i) {
            resTab[i] = this.createSIAPNode((SavotTR)obsSet.getItemAt(i), fields);
            resTab[i].isSIAPEvol = true;
            if (this.idxRefRelObs >= 0 && this.obsRefIndex >= 0) {
                resTab[i].altName = resTab[i].explanation[this.obsRefIndex];
            }
            if (this.obsRefIndex >= 0) {
                this.namesToNodes.put(resTab[i].explanation[this.obsRefIndex], resTab[i]);
            }
            if (this.idxRefRelObs < 0 || this.altNamesToNodes.get(resTab[i].explanation[this.idxRefRelObs]) != null) continue;
            this.altNamesToNodes.put(resTab[i].explanation[this.idxRefRelObs], new Vector());
        }
        return resTab;
    }

    private void checkIfOrgSiap(SavotResource resource) {
        if (this.orgSiapRes != null) {
            return;
        }
        if (resource.getUtype().trim().equalsIgnoreCase(this.getUType(UT_SIMPLEQUERY)) || resource.getType().equalsIgnoreCase("results")) {
            this.orgSiapRes = resource;
        }
    }

    private boolean checkIfDalExt(SavotResource resource) {
        if (this.dalExtRes != null) {
            return false;
        }
        if (resource.getUtype().trim().equalsIgnoreCase(this.getUType(UT_DALEXTENSIONS)) || resource.getUtype().trim().equalsIgnoreCase("dal:footprint.geom")) {
            this.isFootprintDoc = true;
            this.dalExtRes = resource;
            return true;
        }
        return false;
    }

    private Fov getFovFromCharac(TDSet tds, SavotField[] fields) {
        double maxPosDEC;
        double maxPosRA;
        double minPosDEC;
        double minPosRA;
        double posDEC;
        double posRA;
        Fov fov = null;
        int indexPos = this.findFieldByUtype(this.getUType(UT_RADEC), fields);
        int indexMinPos = this.findFieldByUtype(this.getUType(UT_MINRADEC), fields);
        int indexMaxPos = this.findFieldByUtype(this.getUType(UT_MAXRADEC), fields);
        if (indexPos < 0 || indexMinPos < 0 || indexMaxPos < 0) {
            return null;
        }
        String posStr = tds.getContent(indexPos);
        String minPosStr = tds.getContent(indexMinPos);
        String maxPosStr = tds.getContent(indexMaxPos);
        try {
            String[] tab = SIAPExtBuilder.split(posStr, " ");
            posRA = Double.valueOf(tab[0]);
            posDEC = Double.valueOf(tab[1]);
            tab = SIAPExtBuilder.split(minPosStr, " ");
            minPosRA = Double.valueOf(tab[0]);
            minPosDEC = Double.valueOf(tab[1]);
            tab = SIAPExtBuilder.split(maxPosStr, " ");
            maxPosRA = Double.valueOf(tab[0]);
            maxPosDEC = Double.valueOf(tab[1]);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        fov = new Fov(posRA, posDEC, new double[]{minPosRA, minPosDEC}, new double[]{maxPosRA, maxPosDEC}, 0.0);
        return fov;
    }

    private String getUType(String s) {
        return s;
    }

    private void reset() {
        this.parser = null;
        this.votable = null;
        this.orgSiapRes = null;
        this.dalExtRes = null;
        this.otherTabs = new Vector();
        this.potentialKeys = new Vector();
        this.keyToNodes = new Hashtable();
        this.sortItems = null;
        this.isFootprintDoc = false;
    }

    private String getObsRefID(SavotField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            Aladin.trace(3, "Reading field : " + fields[i].getId());
            if (!fields[i].getUtype().equals(UT_OBS_DATASET_ID) && !fields[i].getUtype().equals(UT_OBS_DATASET_ID_DEPRECATED)) continue;
            return fields[i].getId();
        }
        return null;
    }

    private String getObsNameID(SavotField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getUtype().equals("Observation/TargetName")) continue;
            return fields[i].getId();
        }
        return null;
    }

    private void setDatasetType(ResourceNode node) {
        String type = node.getFieldValFromUtype("Observation.Provenance.DataViewsAndAccess.ViewType");
        if (type == null) {
            node.getFieldValFromUtype("DatasetType");
        }
        if (type == null) {
            type = node.dataOrga;
        }
        if (type == null) {
            type = node.getFieldValFromUtype("Access.Format");
        }
        if (type == null) {
            return;
        }
        if (type.equalsIgnoreCase("RETRIEVAL")) {
            node.indexing = "HTML";
        } else if (type.equalsIgnoreCase("IMAGE")) {
            node.type = 1;
        } else if (type.equalsIgnoreCase("CUBE")) {
            node.type = 4;
        } else if (type.equalsIgnoreCase("SPECTRUM") || type.startsWith("spectrum")) {
            node.type = 3;
        } else if (type.equalsIgnoreCase("CATALOGUE")) {
            node.type = 7;
        } else if (type.startsWith("text/xml")) {
            node.type = 2;
        }
    }

    private int findKey(SavotField[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (!this.isPotentialKey(fields[i])) continue;
            return i;
        }
        return -1;
    }

    private ResourceNode getNodeFromKey(SavotField field, String keyVal) {
        return (ResourceNode)this.keyToNodes.get(field.getId() + "__" + keyVal);
    }

    private boolean isPotentialKey(SavotField field) {
        String id = field.getId();
        if (id == null || id.length() == 0) {
            return false;
        }
        return this.potentialKeys.contains(id);
    }

    private void registerKeyVal(SavotField[] fields, ResourceNode[] nodes) {
        for (int i = 0; i < fields.length; ++i) {
            if (!this.isPotentialKey(fields[i])) continue;
            Aladin.trace(3, "Field " + fields[i].getId() + " might be a key");
            String keyID = fields[i].getId();
            for (int j = 0; j < nodes.length; ++j) {
                ResourceNode node = nodes[j];
                String keyVal = node.explanation[i];
                this.keyToNodes.put(keyID + "__" + keyVal, node);
            }
        }
    }

    private void processFov(ResourceNode[] siapNodes, SavotResource res) {
        int nbRes;
        Aladin.trace(3, "Entering processFov");
        ResourceSet resources = res.getResources();
        if (resources == null || (nbRes = resources.getItemCount()) == 0) {
            return;
        }
        Vector<SavotResource> v = new Vector<SavotResource>();
        for (int i = 0; i < nbRes; ++i) {
            SavotResource curRes = (SavotResource)resources.getItemAt(i);
            if (!curRes.getUtype().equalsIgnoreCase("ivoa:characterization[ucd=pos]/coverage/support") && !curRes.getUtype().equalsIgnoreCase("char:SpatialAxis.coverage.support")) continue;
            v.addElement(curRes);
        }
        if (v.size() == 0) {
            Aladin.trace(3, "Did not find any FoV description !");
            return;
        }
        Object[] resToParse = new SavotResource[v.size()];
        v.copyInto(resToParse);
        v = null;
        FootprintParser fpParse = new FootprintParser((SavotResource[])resToParse);
        Hashtable<String, FootprintBean> fpHash = fpParse.getFooprintHash();
        for (int i = 0; i < siapNodes.length; ++i) {
            double posAngle;
            double dec;
            double ra;
            FootprintBean fpBean;
            ResourceNode curNode = siapNodes[i];
            String key = curNode.getFieldValFromUtype("ivoa:characterization[ucd=pos]/coverage/support/@id");
            if (key == null) {
                key = curNode.getFieldValFromUtype("dal:footprint.geom.id");
            }
            if (key == null || key.length() == 0 || (fpBean = fpHash.get(key)) == null) continue;
            try {
                int idx;
                String decStr;
                String raStr = curNode.getFieldValFromUcd("POS_EQ_RA_MAIN");
                if (raStr == null) {
                    raStr = curNode.getFieldValFromUcd("pos.eq.ra;meta.main");
                }
                if ((decStr = curNode.getFieldValFromUcd("POS_EQ_DEC_MAIN")) == null) {
                    decStr = curNode.getFieldValFromUcd("pos.eq.dec;meta.main");
                }
                double[] pos = TreeView.getDeciCoord(raStr, decStr);
                ra = pos[0];
                dec = pos[1];
                String posAngStr = curNode.getFieldValFromUtype(FOV_POS_ANGLE);
                if (posAngStr == null) {
                    posAngStr = curNode.getFieldValFromName("PA");
                }
                if (posAngStr == null) {
                    posAngStr = curNode.getFieldValFromName("Position Angle");
                }
                if (posAngStr == null) {
                    posAngStr = "0";
                }
                if ((idx = posAngStr.indexOf(176)) < 0) {
                    idx = posAngStr.indexOf("deg");
                }
                if (idx < 0) {
                    idx = posAngStr.indexOf(" ");
                }
                if (idx < 0) {
                    idx = posAngStr.indexOf("'");
                }
                if (idx < 0) {
                    idx = posAngStr.indexOf(34);
                }
                if (idx < 0) {
                    idx = posAngStr.indexOf("arc");
                }
                if (idx > 0) {
                    posAngStr = posAngStr.substring(0, idx);
                }
                try {
                    posAngle = Double.valueOf(posAngStr);
                }
                catch (Exception e) {
                    Aladin.trace(3, "Could not find position angle field, assuming value is 0");
                    posAngle = 0.0;
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                continue;
            }
            PlanField pf = new PlanField(this.aladin, fpBean, key);
            pf.make(ra, dec, posAngle);
            curNode.setFov(new Fov(this.aladin, fpBean, key, ra, dec, posAngle));
        }
    }
}

