/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.Legende;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.PlanCatalog;
import cds.aladin.Repere;
import cds.aladin.Slide;
import cds.aladin.Source;
import cds.aladin.Tool;
import cds.aladin.ViewSimple;
import cds.astro.Parsing;
import cds.astro.Unit;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SED
extends JPanel {
    private static final String SEDGLUTAG = "VizieR.sed";
    static final int margeHaut = 20;
    static final int margeBas = 30;
    static final int margeDroite = 30;
    static final int margeGauche = 10;
    static final char MU = '\u00b5';
    static final char NU = '\u03bd';
    static final char TILDE = '\u223c';
    private static final double EPSILON = 0.1;
    private static final double WAVEMIN = 0.2;
    private static final double WAVEMAX = 30.0;
    private static final double FREQMIN = 10000.0;
    private static final double FREQMAX = 1000000.0;
    private static final double WAVEOPTMIN = 0.3;
    private static final double WAVEOPTMAX = 1.0;
    private static final double REFMIN = 1.0;
    private static final double REFMAX = 10.0;
    private static final double FREQOPTMIN = SED.wave2Freq(1.0);
    private static final double FREQOPTMAX = SED.wave2Freq(0.3);
    private static final Color LIGHTGRAY = new Color(125, 125, 125);
    private Aladin aladin;
    private PlanCatalog plan;
    private String source;
    private double radius;
    private Repere simRep;
    private String url;
    private float transparency;
    private double absMin;
    private double absMax;
    private double fluxMin;
    private double fluxMax;
    private double coefX;
    private double coefY;
    private boolean readyToDraw;
    private boolean planeAlreadyCreated;
    private boolean flagWavelength;
    private int xOptMin;
    private int xOptMax;
    private int yRefMin;
    private int yRefMax;
    private ArrayList<SEDItem> sedList;
    private int w;
    private Rectangle rCroix;
    private Rectangle rWave;
    private Rectangle rHelp;
    private Rectangle rMore;
    private double currentAbs = Double.NaN;
    private double currentFlux = Double.NaN;
    private int currentX;
    private int currentY;
    private SEDItem siIn;
    private TimeIcon timeIcon;
    private TableIcon tableIcon;
    private static Color COLOROPT;
    private static Color COLORREF;
    static boolean first;
    private boolean isLoading = false;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private static String TIMEPLOT;
    private static String TABLEICON;
    private boolean blinkState = false;
    private Timer timerBlink = null;
    static final double C = 2.99792458E8;
    private static final String[] UNITFREQ;
    private static final String[] UNITWAVE;
    private static final String[] UNITJY;

    public SED(Aladin aladin) {
        this.aladin = aladin;
        this.transparency = 0.5f;
        this.flagWavelength = aladin.configuration.getSEDWave();
        this.radius = 5.0;
        COLOROPT = Aladin.DARK_THEME ? new Color(47, 68, 83) : new Color(234, 234, 255);
        COLORREF = Aladin.DARK_THEME ? Aladin.COLOR_STACK_HIGHLIGHT : new Color(255, 234, 234);
        this.w = Math.round(5.0f * aladin.getUIScale());
        this.timeIcon = new TimeIcon();
        this.tableIcon = new TableIcon();
    }

    protected void setRepere(Repere simRep) {
        this.simRep = simRep;
    }

    protected void setSource(String source) {
        if (source == null && first) {
            System.out.println("SED.setSource(" + source + ")");
            first = false;
        }
        this.source = source;
    }

    protected void setRadius(double radius) {
        this.radius = radius;
    }

    public int getCount() {
        if (this.sedList == null) {
            return -1;
        }
        return this.sedList.size();
    }

    public void clear() {
        this.readyToDraw = false;
        this.planeAlreadyCreated = false;
        this.xOptMin = 0;
        this.xOptMax = 0;
        this.yRefMin = 0;
        this.yRefMax = 0;
        this.fluxMax = 0.0;
        this.fluxMin = 0.0;
        this.absMax = 0.0;
        this.absMin = 0.0;
        this.sedList = null;
    }

    protected void addFromIterator(Iterator<Source> it) {
        block3: {
            this.planeAlreadyCreated = true;
            this.readyToDraw = false;
            try {
                if (this.plan == null) {
                    this.plan = new PlanCatalog(this.aladin);
                }
                this.createSEDlist(it);
                this.setPosition();
                this.aladin.calque.zoom.zoomView.flagSED = true;
                this.aladin.calque.repaintAll();
            }
            catch (Exception e) {
                this.aladin.view.zoomview.setSED(null, null);
                this.aladin.command.printConsole("!!! VizieR photometry parsing error => " + e.getMessage());
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    protected void setHighLight(Source o) {
        for (SEDItem si : this.sedList) {
            si.highLight = si.o == o;
        }
    }

    protected void loadFromSource(String position, String source) {
        block2: {
            this.clear();
            this.source = source;
            try {
                Aladin.trace(2, "VizieR photometry loading around source \"" + source + "\"...");
                this.url = "" + this.aladin.glu.getURL(SEDGLUTAG, Glu.quote(position) + " " + this.radius);
                Aladin.trace(2, "Phot. loading: " + this.url);
                this.loadASync(this.url);
            }
            catch (Exception e) {
                this.aladin.view.zoomview.setSED(null, null);
                this.aladin.command.printConsole("!!! VizieR photometry builder error [" + source + "] => " + e.getMessage());
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
    }

    private void createStackPlane() {
        if (this.planeAlreadyCreated) {
            return;
        }
        this.planeAlreadyCreated = true;
        this.plan.label = "PHOT " + this.source;
        this.plan.objet = this.source;
        try {
            this.plan.u = new URL(this.url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aladin.calque.newPlan(this.plan);
        this.plan.planReady(true);
        this.aladin.calque.selectPlan(this.plan);
    }

    protected synchronized boolean isLoading() {
        return this.isLoading;
    }

    private synchronized void setIsLoading(boolean flag) {
        this.isLoading = flag;
    }

    private void loadASync(final String url) {
        this.readyToDraw = false;
        this.planeAlreadyCreated = false;
        this.setIsLoading(true);
        this.clear();
        this.aladin.view.zoomview.repaint();
        this.plan = new PlanCatalog(this.aladin);
        this.plan.pcat = new Pcat(this.plan, Color.black, this.aladin.calque, this.aladin.status, this.aladin);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Util.pause(10);
                MyInputStream inParam = null;
                try {
                    inParam = Util.openAnyStream(url, 10000);
                    ((SED)SED.this).plan.pcat.tableParsing(inParam, "TABLE");
                    SED.this.parseAndDraw();
                }
                catch (Exception e) {
                    try {
                        inParam = Util.openAnyStream(url, 20000);
                        ((SED)SED.this).plan.pcat.tableParsing(inParam, "TABLE");
                        SED.this.parseAndDraw();
                    }
                    catch (Exception e1) {
                        ((SED)SED.this).aladin.view.zoomview.setSED(null, null);
                        ((SED)SED.this).aladin.command.printConsole("!!! VizieR photometry parsing error => " + e1.getMessage());
                        SED.this.aladin;
                        if (Aladin.levelTrace >= 3) {
                            e1.printStackTrace();
                        }
                    }
                }
                finally {
                    if (inParam != null) {
                        try {
                            inParam.close();
                        }
                        catch (Exception exception) {}
                    }
                    SED.this.setIsLoading(false);
                }
            }
        }.start();
    }

    private void parseAndDraw() throws Exception {
        this.createSEDlist(this.plan.iterator());
        this.setPosition();
        this.aladin.calque.zoom.zoomView.flagSED = true;
        this.aladin.calque.repaintAll();
    }

    private void activateTimePlot() {
        boolean rep = false;
        int ntime = -1;
        int n = 0;
        String val0 = null;
        try {
            for (SEDItem si : this.sedList) {
                Source s = si.o;
                if (ntime >= 0 || (ntime = this.getField(s, 5)) >= 0) {
                    String val = s.getValue(ntime).trim();
                    if (!(val.length() <= 0 || val0 != null && val0.equals(val))) {
                        val0 = val;
                        ++n;
                    }
                    if (n <= true) continue;
                    rep = true;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timeIcon.activate(rep);
    }

    private boolean hasTimePlot() {
        if (!this.planeAlreadyCreated) {
            return false;
        }
        for (int i = 0; i < this.aladin.view.getNbView(); ++i) {
            ViewSimple v = this.aladin.view.viewSimple[i];
            if (!v.isPlotTime() || v.pref != this.plan) continue;
            return true;
        }
        return false;
    }

    protected double getFreq(Source s) {
        return this.getSEDValue(s, 1);
    }

    protected double getFlux(Source s) {
        return this.getSEDValue(s, 2);
    }

    protected double getFluxErr(Source s) {
        double x = this.getSEDValue(s, 3);
        if (Double.isNaN(x)) {
            return 0.0;
        }
        return x;
    }

    private int getField(Source s, int sed) {
        Legende leg = s.getLeg();
        for (int i = 0; i < leg.field.length; ++i) {
            if (leg.field[i].sed != sed) continue;
            return i;
        }
        return -1;
    }

    private double getSEDValue(Source s, int sed) {
        try {
            int i = this.getField(s, sed);
            String val = s.getValue(i);
            return Double.parseDouble(val.trim());
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    protected String getSEDId(Source s) {
        int i = this.getField(s, 4);
        try {
            return s.getValue(i);
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    private void createSEDlist(Iterator<?> it) {
        if (this.sedList == null) {
            this.sedList = new ArrayList();
        }
        while (it.hasNext()) {
            Source s = (Source)it.next();
            double freq = this.getFreq(s);
            double flux = this.getFlux(s);
            if (Double.isNaN(freq) || Double.isNaN(flux) || freq <= 0.0 || flux <= 0.0) continue;
            double fluxErr = this.getFluxErr(s);
            String sedId = this.getSEDId(s);
            s.setSelect(true);
            SEDItem si = new SEDItem(s, freq, flux, fluxErr, sedId);
            this.sedList.add(si);
        }
        this.activateTimePlot();
    }

    protected boolean getSEDWave() {
        return this.flagWavelength;
    }

    private void setPosition() {
        if (this.sedList == null) {
            return;
        }
        this.fluxMin = Double.MAX_VALUE;
        this.absMin = Double.MAX_VALUE;
        this.fluxMax = Double.MIN_VALUE;
        this.absMax = Double.MIN_VALUE;
        for (SEDItem si : this.sedList) {
            if (this.absMin > si.freq) {
                this.absMin = si.freq;
            }
            if (si.flux - si.fluxErr > 0.0) {
                if (this.fluxMin > si.flux - si.fluxErr) {
                    this.fluxMin = si.flux - si.fluxErr;
                }
            } else if (this.fluxMin > 0.1) {
                this.fluxMin = 0.1;
            }
            if (this.absMax < si.freq) {
                this.absMax = si.freq;
            }
            if (!(this.fluxMax < si.flux + si.fluxErr)) continue;
            this.fluxMax = si.flux + si.fluxErr;
        }
        if (this.flagWavelength) {
            double fr = SED.freq2Wave(this.absMin);
            this.absMin = SED.freq2Wave(this.absMax);
            this.absMax = fr;
            if (this.absMin > 0.2) {
                this.absMin = 0.2;
            }
            if (this.absMax < 30.0) {
                this.absMax = 30.0;
            }
        } else {
            if (this.absMin > 10000.0) {
                this.absMin = 10000.0;
            }
            if (this.absMax < 1000000.0) {
                this.absMax = 1000000.0;
            }
        }
        Dimension dim = this.getDimension();
        dim.width -= 40;
        dim.height -= 50;
        double rangeAbs = SED.LOG(this.absMax) - SED.LOG(this.absMin);
        double rangeFlux = SED.LOG(this.fluxMax) - SED.LOG(this.fluxMin);
        this.coefX = (double)dim.width / rangeAbs;
        this.coefY = (double)dim.height / rangeFlux;
        for (SEDItem si : this.sedList) {
            double fr = this.flagWavelength ? SED.freq2Wave(si.freq) : si.freq;
            double x = (SED.LOG(fr) - SED.LOG(this.absMin)) * this.coefX;
            double y = (SED.LOG(si.flux) - SED.LOG(this.fluxMin)) * this.coefY;
            si.setBox((int)x, (int)((double)dim.height - y));
            if (si.fluxErr == 0.0) continue;
            double hy = 0.0;
            if (si.flux - si.fluxErr > 0.0) {
                hy = (SED.LOG(si.flux - si.fluxErr) - SED.LOG(this.fluxMin)) * this.coefY;
            }
            double by = (SED.LOG(si.flux + si.fluxErr) - SED.LOG(this.fluxMin)) * this.coefY;
            si.setBoxErr((int)((double)dim.height - by), (int)((double)dim.height - hy));
        }
        this.yRefMin = (int)((SED.LOG(1.0) - SED.LOG(this.fluxMin)) * this.coefY);
        this.yRefMax = (int)((SED.LOG(10.0) - SED.LOG(this.fluxMin)) * this.coefY);
        if (this.flagWavelength) {
            this.xOptMin = (int)((SED.LOG(SED.freq2Wave(FREQOPTMAX)) - SED.LOG(this.absMin)) * this.coefX);
            this.xOptMax = (int)((SED.LOG(SED.freq2Wave(FREQOPTMIN)) - SED.LOG(this.absMin)) * this.coefX);
        } else {
            this.xOptMin = (int)((SED.LOG(FREQOPTMIN) - SED.LOG(this.absMin)) * this.coefX);
            this.xOptMax = (int)((SED.LOG(FREQOPTMAX) - SED.LOG(this.absMin)) * this.coefX);
        }
        this.readyToDraw = true;
    }

    private double getCurrentAbs(double x) {
        if (!this.readyToDraw) {
            return Double.NaN;
        }
        return SED.POW(x / this.coefX + SED.LOG(this.absMin));
    }

    double getCurrentFlux(double y) {
        if (!this.readyToDraw) {
            return Double.NaN;
        }
        return SED.POW(y / this.coefY + SED.LOG(this.fluxMin));
    }

    public Dimension getDimension() {
        return new Dimension(this.aladin.calque.zoom.zoomView.getWidth(), this.aladin.calque.zoom.zoomView.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(Graphics g) {
        String s;
        Dimension dim = this.getDimension();
        if (dim.width != this.lastWidth || dim.height != this.lastHeight) {
            this.setPosition();
            this.lastWidth = dim.width;
            this.lastHeight = dim.height;
        }
        int haut = 20;
        int bas = dim.height - 30;
        int gauche = 10;
        int droite = dim.width - 30;
        g.setColor(Aladin.COLOR_BACKGROUND);
        g.fillRect(0, 0, dim.width, dim.height);
        if (this.yRefMin != this.yRefMax) {
            g.setColor(COLORREF);
            g.fillRect(gauche, bas - Math.max(this.yRefMin, this.yRefMax), droite - gauche, Math.abs(this.yRefMax - this.yRefMin + 1));
        }
        if (this.xOptMin != this.xOptMax) {
            g.setColor(COLOROPT);
            g.fillRect(gauche + Math.min(this.xOptMin, this.xOptMax), haut, Math.abs(this.xOptMax - this.xOptMin + 1), bas - haut);
        }
        int arrow = 3;
        g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
        g.drawLine(gauche, haut, gauche, bas);
        g.drawLine(gauche, haut, gauche - arrow, haut + arrow);
        g.drawLine(gauche, haut, gauche + arrow, haut + arrow);
        g.drawLine(gauche, bas, droite, bas);
        g.drawLine(droite, bas, droite - arrow, bas - arrow);
        g.drawLine(droite, bas, droite - arrow, bas + arrow);
        g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
        g.setFont(Aladin.SSPLAIN);
        g.drawString("log f(\u03bd)", gauche - 2, haut - 4);
        g.drawString(this.fluxMax == 0.0 ? "" : SED.getUnitJy(this.fluxMax), gauche + 4, haut + 6);
        g.drawString("log " + (this.flagWavelength ? (char)'\u00b5' : '\u03bd'), droite + 2, bas);
        g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
        if (!Double.isNaN(this.currentAbs)) {
            g.drawLine(this.currentX, bas, this.currentX, bas - 5);
            g.setFont(Aladin.SSPLAIN);
            g.drawString(Util.myRound(SED.LOG(this.currentAbs) + "", 1), this.currentX, bas - 8);
            if (this.siIn == null) {
                g.setFont(Aladin.BOLD);
                s = !this.flagWavelength ? SED.getUnitFreq(this.currentAbs) : SED.getUnitWave(this.currentAbs);
                g.drawString(s, 5, dim.height - 3);
            }
        }
        g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
        if (!Double.isNaN(this.currentFlux)) {
            g.drawLine(gauche, this.currentY, gauche + 5, this.currentY);
            g.setFont(Aladin.SSPLAIN);
            g.drawString(Util.myRound(SED.LOG(this.currentFlux) + "", 1), gauche + 10, this.currentY);
            if (this.siIn == null) {
                g.setFont(Aladin.BOLD);
                s = SED.getUnitJy(this.currentFlux);
                g.drawString(s, dim.width - 5 - g.getFontMetrics().stringWidth(s), dim.height - 3);
            }
        }
        this.drawCroix(g);
        this.drawWave(g);
        this.drawMore(g);
        this.drawHelp(g);
        SEDItem siIn = null;
        if (this.sedList == null || !this.readyToDraw) {
            s = Aladin.chaine.getString("SEDLOADING");
            int x = dim.width / 2 - g.getFontMetrics().stringWidth(s) / 2;
            int y = (haut + bas) / 2 - 20;
            this.drawBlink(g, x - 15, y + 10);
            g.setFont(Aladin.ITALIC);
            g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
            g.drawString(s, x, y += 18);
            s = Coord.getUnit(this.radius / 3600.0) + " around";
            g.drawString(s, dim.width / 2 - g.getFontMetrics().stringWidth(s) / 2, y += 18);
            s = this.source;
            g.drawString(s, dim.width / 2 - g.getFontMetrics().stringWidth(s) / 2, y += 18);
            if (this.sedList == null || !this.readyToDraw) {
                return;
            }
        } else {
            this.stopBlink();
            g.setFont(Aladin.SPLAIN);
            Composite c = ((Graphics2D)g).getComposite();
            try {
                ((Graphics2D)g).setComposite(Util.getImageComposite(this.transparency));
                for (SEDItem si : this.sedList) {
                    if (si.highLight) {
                        siIn = si;
                    }
                    si.draw(g);
                }
            }
            finally {
                ((Graphics2D)g).setComposite(c);
            }
            if (siIn != null) {
                siIn.draw(g);
            }
        }
        if (siIn == null) {
            g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
            g.setFont(Aladin.SPLAIN);
            s = this.flagWavelength ? SED.getUnitWave(this.absMin) : SED.getUnitFreq(this.absMin);
            g.drawString(s, gauche, bas + 10);
            s = this.flagWavelength ? SED.getUnitWave(this.absMax) : SED.getUnitFreq(this.absMax);
            g.drawString(s, 20 + droite - g.getFontMetrics().stringWidth(s), bas + 10);
        }
        if (this.source != null) {
            g.setColor(Aladin.COLOR_GREEN);
            g.setFont(Aladin.BOLD);
            String s1 = "VizieR Phot. at " + Coord.getUnit(this.radius / 3600.0);
            int size = g.getFontMetrics().stringWidth(s1);
            int x = dim.width / 2 - size / 2;
            if (x < 50) {
                x = 50;
            }
            g.drawString(s1, x, haut - 4);
            if (Double.isNaN(this.currentFlux) && Double.isNaN(this.currentAbs) && siIn == null) {
                s1 = this.source;
                size = g.getFontMetrics().stringWidth(s1);
                x = dim.width / 2 - size / 2;
                if (x < 50) {
                    x = 50;
                }
                g.drawString(s1, x, dim.height - 7);
            }
        }
        this.timeIcon.draw(g);
        this.tableIcon.draw(g);
    }

    private void drawCroix(Graphics g) {
        int width = this.getDimension().width;
        g.setColor(Aladin.COLOR_BUTTON_BACKGROUND);
        this.rCroix = new Rectangle(width - this.w - 4, 1, this.w + 4, this.w + 4);
        g.fillRect(this.rCroix.x, this.rCroix.y, this.rCroix.width, this.rCroix.height);
        g.setColor(Color.red);
        g.drawLine(width - this.w - 3, 2, width - 3, this.w + 2);
        g.drawLine(width - this.w - 3, 3, width - 3, this.w + 3);
        g.drawLine(width - this.w - 3, this.w + 2, width - 3, 2);
        g.drawLine(width - this.w - 3, this.w + 3, width - 3, 3);
    }

    private void drawBlink(Graphics g, int x, int y) {
        if (this.timerBlink == null) {
            this.timerBlink = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((SED)SED.this).aladin.calque.zoom.zoomView.repaint();
                }
            });
        }
        this.timerBlink.start();
        Slide.drawBall(g, x, y, this.blinkState ? Color.white : Color.green);
        this.blinkState = !this.blinkState;
    }

    private void stopBlink() {
        if (this.timerBlink == null) {
            return;
        }
        this.timerBlink.stop();
    }

    private void drawMore(Graphics g) {
        Dimension dim = this.getDimension();
        g.setColor(Aladin.COLOR_BUTTON_BACKGROUND);
        this.rMore = new Rectangle(dim.width - this.w - 4, 16 + 3 * this.w, this.w + 4, this.w + 4);
        g.fillRect(this.rMore.x, this.rMore.y, this.rMore.width, this.rMore.height);
        g.setColor(this.flagWavelength ? Color.blue : Color.red);
        g.setFont(Aladin.SBOLD);
        g.drawString("+", this.rMore.x + this.w / 2, this.rMore.y + 3 + this.w);
    }

    private void drawWave(Graphics g) {
        Dimension dim = this.getDimension();
        g.setColor(Aladin.COLOR_BUTTON_BACKGROUND);
        this.rWave = new Rectangle(dim.width - this.w - 4, 11 + 2 * this.w, this.w + 4, this.w + 4);
        g.fillRect(this.rWave.x, this.rWave.y, this.rWave.width, this.rWave.height);
        g.setColor(this.flagWavelength ? Color.blue : Color.red);
        g.setFont(Aladin.SBOLD);
        g.drawString("\u223c", this.rWave.x + this.w / 4, this.rWave.y + 3 + this.w);
    }

    private void drawHelp(Graphics g) {
        Dimension dim = this.getDimension();
        g.setColor(Aladin.COLOR_BUTTON_BACKGROUND);
        this.rHelp = new Rectangle(dim.width - this.w - 4, 6 + this.w, this.w + 4, this.w + 4);
        g.fillRect(this.rHelp.x, this.rHelp.y, this.rHelp.width, this.rHelp.height);
        g.setColor(Color.blue);
        g.setFont(Aladin.SBOLD);
        g.drawString("?", this.rHelp.x + this.w / 2, this.rHelp.y + 3 + this.w);
    }

    private void createTimePlot() {
        if (!this.planeAlreadyCreated) {
            this.createStackPlane();
        }
        Source s = this.sedList.get(0).o;
        int nTime = this.getField(s, 5);
        int nFlux = this.getField(s, 2);
        this.aladin.createPlotCat(this.plan, nTime, nFlux, false);
    }

    protected void mouseRelease(int x, int y) {
        if (this.timeIcon.inside(x, y)) {
            this.createTimePlot();
        }
        if (this.tableIcon.inside(x, y)) {
            if (!this.planeAlreadyCreated) {
                this.createStackPlane();
            }
        } else if (this.rCroix.contains(x, y)) {
            this.aladin.view.zoomview.setSED(null, null);
        } else if (this.rMore.contains(x, y)) {
            this.more();
        } else if (this.rHelp.contains(x, y)) {
            this.help();
        } else if (this.rWave.contains(x, y)) {
            this.flagWavelength = !this.flagWavelength;
            this.setPosition();
            this.aladin.view.zoomview.repaint();
        } else if (this.siIn != null) {
            int bloc = 1;
            if (!this.planeAlreadyCreated) {
                this.createStackPlane();
            } else {
                bloc = 2;
            }
            this.aladin.view.showSource(this.siIn.o, false, true);
            this.aladin.mesure.mcanvas.show(this.siIn.o, bloc);
            this.aladin.calque.repaintAll();
        } else if (this.simRep != null) {
            this.aladin.view.setRepere(new Coord(this.simRep.raj, this.simRep.dej), true);
            this.aladin.calque.repaintAll();
        }
    }

    private void more() {
        if (this.source == null) {
            return;
        }
        this.aladin.glu.showDocument("VizieR.sed.home", Glu.quote(this.source) + " " + this.radius);
    }

    private void help() {
        Aladin.info(Aladin.chaine.getString("SEDHELP"));
    }

    protected void mouseExit() {
        this.currentFlux = Double.NaN;
        this.currentAbs = Double.NaN;
    }

    private void toolTip(String k) {
        String s = k == null ? null : Aladin.chaine.getString(k);
        Util.toolTip(this.aladin.view.zoomview, s, true);
    }

    protected void mouseMove(int x, int y) {
        if (this.timeIcon.inside(x, y)) {
            this.toolTip("TIMEPLOTHELP");
            return;
        }
        if (this.tableIcon.inside(x, y)) {
            this.toolTip("TABLEICONHELP");
            return;
        }
        if (this.rCroix != null && this.rCroix.contains(x, y)) {
            this.toolTip("SEDCLOSE");
            return;
        }
        if (this.rMore.contains(x, y)) {
            this.toolTip("SEDMORE");
            return;
        }
        if (this.rWave.contains(x, y)) {
            this.toolTip("SEDFREQWAVE");
            return;
        }
        if (this.rHelp.contains(x, y)) {
            this.toolTip("SEDHELPTIP");
            return;
        }
        this.toolTip(null);
        this.siIn = null;
        if (this.sedList == null) {
            return;
        }
        for (SEDItem si : this.sedList) {
            si.highLight = false;
        }
        for (SEDItem si : this.sedList) {
            if (!si.contains(x, y)) continue;
            si.highLight = true;
            this.siIn = si;
            break;
        }
        if (this.siIn != null) {
            this.aladin.view.showSource(this.siIn.o, false, true);
            this.aladin.mesure.mcanvas.show(this.siIn.o, 1);
        }
        Dimension dim = this.getDimension();
        this.currentAbs = x > 10 && x < dim.width - 30 ? this.getCurrentAbs(x - 10) : Double.NaN;
        this.currentFlux = y > 34 && y < dim.height - 30 - (x > 40 ? 0 : 14) ? this.getCurrentFlux((double)(dim.height - 50) - (double)(y - 20)) : Double.NaN;
        this.currentX = x;
        this.currentY = y;
    }

    protected boolean mouseWheel(MouseWheelEvent e) {
        int n = e.getWheelRotation();
        if (n == 0) {
            return false;
        }
        float x = this.transparency + (float)n * 0.1f;
        if (x > 1.0f) {
            x = 1.0f;
        }
        if ((double)x < 0.2) {
            x = 0.2f;
        }
        if (x == this.transparency) {
            return false;
        }
        this.transparency = x;
        return true;
    }

    public static double freq2Wave(double freq) {
        return 2.99792458E8 / freq;
    }

    public static double wave2Freq(double wave) {
        return 2.99792458E8 / wave;
    }

    public static double LOG(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    public static double POW(double x) {
        return Math.exp(x * Math.log(10.0));
    }

    static double parseFrequence(String s) {
        double freq = SED.getValue(s, "Hz");
        if (Double.isNaN(freq)) {
            double wave = SED.getValue(s, "m");
            if (Double.isNaN(wave)) {
                return Double.NaN;
            }
            freq = SED.wave2Freq(wave);
        }
        return freq;
    }

    static double getValue(String valUnitSrc, String unitTrg) {
        try {
            Unit n = new Unit();
            Parsing p = new Parsing(valUnitSrc);
            if (!n.parse(p)) {
                return Double.NaN;
            }
            Unit f = new Unit();
            f.setUnit(unitTrg);
            n.convertTo(f);
            return n.getValue();
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static final String getUnitFreq(double val, String u) {
        return SED.getUnit(val, u, UNITFREQ, 3);
    }

    public static final String getUnitWave(double val, String u) {
        return SED.getUnit(val, u, UNITWAVE, 3);
    }

    public static final String getUnitFreq(double val, String u, int decimal) {
        return SED.getUnit(val, u, UNITFREQ, decimal);
    }

    public static final String getUnitWave(double val, String u, int decimal) {
        return SED.getUnit(val, u, UNITWAVE, decimal);
    }

    public static final String getUnit(double val, String u, String[] UNIT, int decimal) {
        int i = Util.indexInArrayOf(u, UNIT, true);
        if (i < 0) {
            return null;
        }
        double fct = 1.0;
        while (i > 0) {
            fct *= 1000.0;
            --i;
        }
        return SED.getUnit(val * fct, UNIT, decimal);
    }

    public static final String getUnitFreq(double val) {
        return SED.getUnit(val * 1.0E9, UNITFREQ);
    }

    public static final String getUnitJy(double val) {
        return SED.getUnit(val * 1000000.0, UNITJY);
    }

    public static String getUnitWave(double val) {
        return SED.getUnit(val * 1000.0, UNITWAVE);
    }

    private static String getUnit(double val, String[] unit) {
        return SED.getUnit(val, unit, 1);
    }

    private static String getUnit(double val, String[] unit, int decimal) {
        int u;
        for (u = 0; val >= 1000.0 && u < unit.length - 1; ++u, val /= 1000.0) {
        }
        NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(decimal);
        return nf.format(val) + unit[u];
    }

    static {
        first = true;
        TIMEPLOT = null;
        TABLEICON = null;
        UNITFREQ = new String[]{"qHz", "rHz", "yHz", "zHz", "aHz", "fHz", "pHz", "nHz", "\u00b5Hz", "mHz", "Hz", "kHz", "MHz", "GHz", "THz", "PHz", "EHz", "ZHz", "YHz", "RHz", "QHz"};
        UNITWAVE = new String[]{"nm", "\u00b5m", "mm", "m", "km", "Mm", "Gm"};
        UNITJY = new String[]{"\u00b5Jy", "mJy", "Jy", "kJy", "MJy", "GJy", "TJy", "PJy"};
    }

    class TimeIcon {
        int w = 18;
        Rectangle in;
        boolean inside = false;
        boolean activate = false;

        TimeIcon() {
            if (TIMEPLOT == null) {
                SED.this.aladin;
                TIMEPLOT = Aladin.chaine.getString("TIMEPLOT");
            }
        }

        void activate(boolean flag) {
            this.activate = flag;
        }

        boolean inside(int x, int y) {
            this.inside = !SED.this.hasTimePlot() && this.activate && this.in != null && this.in.contains(x, y);
            return this.inside;
        }

        void draw(Graphics g) {
            if (!this.activate || SED.this.hasTimePlot()) {
                return;
            }
            Color c = this.inside ? Aladin.COLOR_FOREGROUND : Aladin.COLOR_CONTROL_FOREGROUND;
            g.setFont(Aladin.SSPLAIN);
            FontMetrics fm = g.getFontMetrics();
            Dimension dim = SED.this.getDimension();
            int x = dim.width - fm.stringWidth(TIMEPLOT) - 25;
            int y = 5;
            Tool.drawPlot(g, x, y, this.w, this.w, c, Aladin.COLOR_MEASUREMENT_BACKGROUND, true);
            Slide.drawClock(g, x + 2, y + 7, 4, Color.black, Color.white);
            g.drawString(TIMEPLOT, x + this.w / 2 - fm.stringWidth(TIMEPLOT) / 2, y + this.w + fm.getHeight());
            this.in = new Rectangle(x, y, this.w, this.w + fm.getHeight());
        }
    }

    class TableIcon {
        int w = 18;
        Rectangle in;
        boolean inside = false;

        TableIcon() {
            if (TABLEICON == null) {
                TABLEICON = "table";
            }
        }

        boolean inside(int x, int y) {
            this.inside = !SED.this.planeAlreadyCreated && this.in != null && this.in.contains(x, y);
            return this.inside;
        }

        void draw(Graphics g) {
            if (SED.this.planeAlreadyCreated) {
                return;
            }
            Color c = this.inside ? Aladin.COLOR_FOREGROUND : Aladin.COLOR_CONTROL_FOREGROUND;
            g.setColor(c);
            g.setFont(Aladin.SSPLAIN);
            FontMetrics fm = g.getFontMetrics();
            Dimension dim = SED.this.getDimension();
            int x = dim.width - fm.stringWidth(TIMEPLOT) - 55;
            int y = 5;
            int L = 8;
            int dx = 8;
            for (int i = 0; i < 5; ++i) {
                int h = y + i * 2 + 10;
                g.drawLine(dx + x - L - i, h, dx + x - 5 - i, h);
                g.drawLine(dx + x - 2 - i, h, dx + x, h);
                g.drawLine(dx + x + 3, h, dx + x + 5 + i, h);
                g.drawLine(dx + x + 8 + i, h, dx + x + L + 1 + i, h);
            }
            g.drawString(TABLEICON, x + this.w / 2 - fm.stringWidth(TABLEICON) / 2, y + this.w + fm.getHeight());
            this.in = new Rectangle(x, y, this.w + 5, this.w + fm.getHeight());
        }
    }

    private class SEDItem {
        private double freq;
        private double flux;
        private double fluxErr;
        private String sedId;
        private Source o;
        private boolean highLight;
        private Rectangle r;
        private int by;
        private int hy;
        static final int W = 6;

        private SEDItem(Source o, double freq, double flux, double fluxErr, String sedId) {
            this.o = o;
            this.freq = freq;
            this.flux = flux;
            this.fluxErr = fluxErr;
            this.sedId = sedId;
            this.hy = 0;
            this.by = 0;
        }

        private void setBox(int x, int y) {
            this.r = new Rectangle(10 + x - 3, 20 + y - 3, 6, 6);
        }

        private void setBoxErr(int by, int hy) {
            this.by = 20 + by;
            this.hy = 20 + hy;
        }

        private boolean contains(int x, int y) {
            return this.r.contains(x, y);
        }

        private void draw(Graphics g) {
            g.setColor(this.o.getColor());
            Util.fillCircle5(g, this.r.x + 3, this.r.y + 3);
            if (Math.abs(this.by - this.hy) > 5) {
                g.drawLine(this.r.x + 3, this.by, this.r.x + 3, this.hy);
                g.drawLine(this.r.x + 1, this.by, this.r.x + 6 - 1, this.by);
                g.drawLine(this.r.x + 1, this.hy, this.r.x + 6 - 1, this.hy);
            }
            if (this.highLight) {
                g.setColor(Aladin.COLOR_GREEN);
                g.drawRect(this.r.x, this.r.y, this.r.width, this.r.height);
                g.setFont(Aladin.BOLD);
                Dimension dim = SED.this.getDimension();
                FontMetrics fm = g.getFontMetrics();
                int height = fm.getHeight();
                g.drawString(this.sedId, dim.width / 2 - fm.stringWidth(this.sedId) / 2, dim.height - height - 2);
                String s = !SED.this.flagWavelength ? SED.getUnitFreq(this.freq) : SED.getUnitWave(SED.freq2Wave(this.freq));
                g.drawString(s, 5, SED.this.getDimension().height - 3);
                s = SED.getUnitJy(this.flux);
                g.drawString(s, dim.width - 5 - fm.stringWidth(s), SED.this.getDimension().height - 3);
            }
        }
    }
}

