/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyRobot;
import cds.aladin.ScriptFactory;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class RobotAction {
    public static RobotAction PUSH = new RobotAction();
    public static RobotAction TYPE = new RobotAction();
    public static RobotAction PAUSE = new RobotAction();
    public static RobotAction SELECT = new RobotAction();
    public static RobotAction TOFRONT = new RobotAction();
    public static RobotAction ADJUSTPOS = new RobotAction();
    public static RobotAction INFO = new RobotAction();
    private RobotAction action = null;
    private String comp;
    private String optParam;
    String paramSet;

    public RobotAction() {
    }

    public RobotAction(RobotAction action, String comp, String optParam) {
        this.setAction(action);
        this.setComp(comp.trim());
        this.setParam(ScriptFactory.decode(optParam));
    }

    public void doAction(Point loc, Component comp, Aladin aladinInst) {
        if (this.action == null) {
            return;
        }
        if (this.action == PUSH) {
            loc.setLocation(loc.x + 5, loc.y + 2);
            Window parentWindow = SwingUtilities.getWindowAncestor(comp);
            if (parentWindow != null) {
                parentWindow.toFront();
            }
            MyRobot.moveTo(loc.x, loc.y, aladinInst);
            MyRobot.press(loc, comp);
        } else if (this.action == TYPE) {
            loc.setLocation(loc.x + 5, loc.y + 7);
            MyRobot.moveTo(loc.x, loc.y, aladinInst);
            MyRobot.press(loc, comp);
            MyRobot.type(this.paramSet, comp);
        } else if (this.action == PAUSE) {
            int nbMs = 1000;
            if (this.optParam != null) {
                try {
                    nbMs = Integer.parseInt(this.optParam);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MyRobot.pause(nbMs);
        } else if (this.action == SELECT) {
            MyRobot.select(this.paramSet, comp, loc);
        } else if (this.action == TOFRONT) {
            MyRobot.toFront(comp);
        } else if (this.action == ADJUSTPOS) {
            MyRobot.adjustPos(comp);
        } else if (this.action == INFO) {
            MyRobot.info(this.optParam, aladinInst);
        }
    }

    public static RobotAction getActionFromString(String s) {
        if (s.equals("ADJUSTPOS")) {
            return ADJUSTPOS;
        }
        if (s.equals("PAUSE")) {
            return PAUSE;
        }
        if (s.equals("PUSH")) {
            return PUSH;
        }
        if (s.equals("SELECT")) {
            return SELECT;
        }
        if (s.equals("TOFRONT")) {
            return TOFRONT;
        }
        if (s.equals("TYPE")) {
            return TYPE;
        }
        if (s.equals("INFO")) {
            return INFO;
        }
        return null;
    }

    public RobotAction getAction() {
        return this.action;
    }

    public void setAction(RobotAction action) {
        this.action = action;
    }

    public String getComp() {
        return this.comp;
    }

    public void setComp(String comp) {
        this.comp = comp;
    }

    public String getParam() {
        return this.optParam;
    }

    public void setParam(String optParam) {
        this.optParam = optParam;
    }
}

