/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.Plan;
import cds.aladin.PlanHips;
import cds.aladin.PlanHips3D;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlink;
import cds.aladin.Projection;
import cds.aladin.Repere;
import cds.aladin.StatPixels;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Graphics;
import java.awt.Point;
import java.net.URLEncoder;

public class RepereSpectrum
extends Repere {
    private StatPixels statPixels = new StatPixels();

    protected RepereSpectrum(Plan plan, ViewSimple v, double x, double y) {
        super(plan, v, x, y);
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        try {
            this.getStatistics(v.pref, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.drawCross(g, v, dx, dy);
        if (this.isSelected() && this.plan.aladin.view.nbSelectedObjet() <= 2) {
            this.cutOn();
        } else {
            this.cutOff();
        }
        return super.draw(g, v, dx, dy);
    }

    protected void drawCross(Graphics g, ViewSimple v, int dx, int dy) {
        Point p = this.getViewCoord(v, this.L, this.L);
        if (p == null) {
            return;
        }
        p.x += dx;
        p.y += dy;
        g.setColor(this.getColor());
        Util.drawCircle7(g, p.x, p.y);
    }

    @Override
    public String getObjType() {
        return "Spectrum";
    }

    @Override
    protected void remove() {
        this.cutOff();
    }

    protected void cutOff() {
        this.plan.aladin.calque.zoom.zoomView.stopHist();
        this.plan.aladin.calque.zoom.zoomView.cutOff(this);
    }

    @Override
    protected boolean cutOn() {
        ViewSimple v = this.plan.aladin.view.getCurrentView();
        if (v == null || this.plan.aladin.toolBox.getTool() == 8) {
            return false;
        }
        Plan pc = v.pref;
        if (!pc.isCubeClassique()) {
            return false;
        }
        double x = this.xv[v.n];
        double y = this.yv[v.n];
        int n = pc.getDepth();
        int[] res = new int[n];
        if (((PlanImage)pc).isIn((int)x, (int)y)) {
            try {
                for (int z = 0; z < n; ++z) {
                    res[z] = pc.getPixel8bit(z, x, y) & 0xFF;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.plan.aladin.calque.zoom.zoomView.setCut(this, res, 0);
        return true;
    }

    @Override
    public boolean hasPhot() {
        return true;
    }

    @Override
    public boolean hasPhot(Plan p) {
        return p.isCubeClassique();
    }

    @Override
    protected int getStatsHashcode(Plan p, int z) {
        return this.getPixelStatsCle(p, z).hashCode();
    }

    protected String getPixelStatsCle(Plan p, int z) {
        if (z == -1 && p.isCubeClassique()) {
            z = (int)p.getZ();
        }
        String sync = p.isSync() ? "sync" : "";
        return this.raj + "," + this.dej + "," + p.hashCode() + (p.isCubeClassique() ? "," + z : "") + "," + sync + (p instanceof PlanHips ? ((PlanHips)p).getOrderInCurrentView() + "" : "");
    }

    @Override
    public double[] getStatisticsRaDecPix(Plan p, int z) throws Exception {
        if (p.isCubeClassique() && z == -1) {
            z = (int)p.getZ();
        }
        this.resumeStatistics(p, z);
        return this.statPixels.getStatisticsRaDecPix();
    }

    @Override
    public double[] getStatistics(Plan p, int z) throws Exception {
        if (p.isCubeClassique() && z == -1) {
            z = (int)p.getZ();
        }
        this.resumeStatistics(p, z);
        return this.statPixels.getStatistics();
    }

    protected void callHips2Spectra(PlanHips3D p) {
        String target = URLEncoder.encode(new Coord(this.raj, this.dej) + "");
        String hipsurl = URLEncoder.encode(p.url);
        String url = "https://alasky.cds.unistra.fr/hips-cube-services/pixel-stats-hips3d?hips=" + hipsurl + "&region=cone&RA=" + this.raj + "&DEC=" + this.dej + "&SR=0.002&format=html_and_buttons";
        p.aladin.glu.showDocument(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resumeStatistics(Plan p, int z) throws Exception {
        double pixelSurf;
        if (p instanceof PlanHips3D) {
            return true;
        }
        Projection proj = p.projd;
        if (!p.hasAvailablePixels()) {
            throw new Exception("getStats error: image without pixel values");
        }
        if (!this.hasPhot(p)) {
            throw new Exception("getStats error: not compatible image");
        }
        if (!Projection.isOk(proj)) {
            throw new Exception("getStats error: image without astrometrical calibration");
        }
        String cle = this.getPixelStatsCle(p, z);
        if (!this.statPixels.reinit(cle)) {
            return false;
        }
        if (p.type == 16 || p.type == 22) {
            PlanHips pbg = (PlanHips)p;
            int orderFile = pbg.getOrderInCurrentView();
            long nsideLosange = pbg.getTileWidth();
            int orderPix = pbg.getOrderInCurrentView() + pbg.getOrderTile();
            pixelSurf = CDSHealpix.pixRes(orderPix) / 3600.0;
            pixelSurf *= pixelSurf;
            Coord coo = new Coord(this.raj, this.dej);
            coo = Localisation.frameToFrame(coo, 0, pbg.frameOrigin);
            double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
            long npix = CDSHealpix.ang2pix_nest(orderPix, polar[0], polar[1]);
            long npixFile = npix / (nsideLosange * nsideLosange);
            double pix = pbg.getHealpixPixel(orderFile, npixFile, npix, z, 2);
            if (Double.isNaN(pix)) {
                return true;
            }
            pix = pix * pbg.bScale + pbg.bZero;
            polar = CDSHealpix.pix2ang_nest(orderPix, npix);
            polar = CDSHealpix.polarToRadec(polar);
            coo.al = polar[0];
            coo.del = polar[1];
            coo = Localisation.frameToFrame(coo, pbg.frameOrigin, 0);
            this.statPixels.addPix(coo.al, coo.del, pix);
        } else {
            boolean isCube = p instanceof PlanImageBlink;
            PlanImage pi = (PlanImage)p;
            pixelSurf = proj.getPixResAlpha() * proj.getPixResDelta();
            Coord c = new Coord(this.raj, this.dej);
            proj.getXY(c);
            int xc = (int)c.x;
            int yc = (int)c.y;
            try {
                double pix;
                if (!isCube) {
                    pi.setLockCacheFree(true);
                    pi.pixelsOriginFromCache();
                } else if (z < 0 || z > ((PlanImageBlink)pi).getDepth()) {
                    throw new Exception("Cube index out of frame range");
                }
                if (!pi.isIn(xc, yc)) {
                    boolean coo = true;
                    return coo;
                }
                double d = pix = isCube ? ((PlanImageBlink)pi).getPixel(xc, pi.height - yc - 1, z) : pi.getPixelInDouble(xc, yc);
                if (Double.isNaN(pix)) {
                    boolean bl = true;
                    return bl;
                }
                proj.getCoord(c);
                this.statPixels.addPix(c.al, c.del, pix);
            }
            finally {
                if (!isCube) {
                    pi.setLockCacheFree(false);
                }
            }
        }
        this.statPixels.setSurface(pixelSurf);
        return true;
    }
}

