/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Repere;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class RepereSimbad
extends Repere {
    static final int ARROWLENGTH = 15;
    static final int BORDER = 35;
    private static int SIZECROSS = 5;
    private Aladin aladin;
    private boolean inCross;
    private boolean inLabel;
    private boolean inBiblio;
    private Rectangle cross;
    private Rectangle label;
    private Rectangle biblio;

    protected RepereSimbad(Aladin aladin, ViewSimple v, Coord c) {
        super(null, v, c);
        this.aladin = aladin;
        this.setSize(15);
        this.inBiblio = false;
        this.inLabel = false;
        this.inCross = false;
    }

    @Override
    protected void setD() {
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(DF);
        this.dw = m.stringWidth(this.id) + 35;
        this.dh = HF;
        try {
            this.dw = m.stringWidth(this.getId(this.id)) + 35;
            int w = m.stringWidth("Type : " + this.getType(this.id)) + 35;
            if (w > this.dw) {
                this.dw = w;
            }
            if ((w = m.stringWidth("Mag : " + this.getMag(this.id)) + 35) > this.dw) {
                this.dw = w;
            }
            this.dh = (int)((double)this.dh * 5.4);
        }
        catch (Exception e) {
            int w = m.stringWidth("unknown by Simbad") + 35 - 5;
            if (w > this.dw) {
                this.dw = w;
            }
            this.dh *= 3;
        }
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        double l = (double)this.L / v.getZoom();
        double xc = this.xv[v.n];
        double yc = this.yv[v.n];
        return xc <= x + l + (double)(this.dw / 2) && xc >= x - l - (double)(this.dw / 2) && yc <= y + l + (double)(this.dh / 2) && yc >= y - l - (double)(this.dh / 2);
    }

    private String getId(String id) {
        int i = id.lastIndexOf(40);
        return id.substring(0, i).trim();
    }

    private String getMag(String id) {
        int i = id.lastIndexOf(40);
        int j = id.indexOf(44, i + 1);
        return id.substring(i + 1, j).trim();
    }

    private String getType(String id) {
        int i = id.lastIndexOf(40);
        int j = id.indexOf(44, i + 1);
        return id.substring(j + 1, id.length() - 1).trim();
    }

    @Override
    protected boolean inLabel(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.cross != null) {
            boolean inCross1 = this.cross.contains(x, y);
            if (inCross1 != this.inCross) {
                v.repaint();
            }
            this.inCross = inCross1;
        }
        if (this.biblio != null) {
            boolean inBiblio1 = this.biblio.contains(x, y);
            if (inBiblio1 != this.inBiblio) {
                v.repaint();
            }
            this.inBiblio = inBiblio1;
        }
        if (this.label == null) {
            return false;
        }
        boolean inLabel1 = this.label.contains(x, y);
        if (inLabel1 != this.inLabel) {
            v.repaint();
        }
        this.inLabel = inLabel1;
        return this.inLabel;
    }

    private void drawCross(Graphics g, ViewSimple v, int x, int y) {
        if (v.n != v.aladin.view.getMouseNumView()) {
            return;
        }
        g.setColor(this.inCross ? Color.red : Color.gray);
        g.drawLine(x, y, x + SIZECROSS, y + SIZECROSS);
        g.drawLine(x + 1, y, x + SIZECROSS + 1, y + SIZECROSS);
        g.drawLine(x + 2, y, x + SIZECROSS + 2, y + SIZECROSS);
        g.drawLine(x + SIZECROSS, y, x, y + SIZECROSS);
        g.drawLine(x + SIZECROSS + 1, y, x + 1, y + SIZECROSS);
        g.drawLine(x + SIZECROSS + 2, y, x + 2, y + SIZECROSS);
        this.cross = new Rectangle(x, y - 2, SIZECROSS + 2, SIZECROSS + 2);
    }

    private void drawLabel(Graphics g, ViewSimple v, int x, int y, String s) {
        g.setColor(Aladin.COLOR_BLUE);
        g.setFont(Aladin.BOLD);
        g.drawString(s, x, y);
        if (v != this.aladin.view.getMouseView()) {
            return;
        }
        int w = g.getFontMetrics().stringWidth(s);
        this.label = new Rectangle(x - 1, y - 16, w + 2, 16);
        if (this.inLabel) {
            g.drawLine(x - 1, y + 3, x + w + 2, y + 3);
            g.drawLine(x - 1, y + 4, x + w + 2, y + 4);
        }
    }

    private void drawBiblio(Graphics g, ViewSimple v, int x, int y) {
        g.setColor(Aladin.COLOR_BLUE);
        String s = "Biblio";
        int w = g.getFontMetrics().stringWidth(s);
        g.drawString(s, x -= w + 5, y);
        if (v != this.aladin.view.getMouseView()) {
            return;
        }
        this.biblio = new Rectangle(x - 1, y - 16, w + 2, 16);
        if (this.inBiblio) {
            g.drawLine(x - 1, y + 3, x + w + 2, y + 3);
            g.drawLine(x - 1, y + 4, x + w + 2, y + 4);
        }
    }

    protected void openSimbadID() {
        int offset = this.id.indexOf(40);
        if (offset < 0) {
            return;
        }
        String obj = this.id.substring(0, offset).trim();
        this.aladin.glu.showDocument("smb.query", Tok.quote(obj));
    }

    protected void openSimbadBiblio() {
        int offset = this.id.indexOf(40);
        if (offset < 0) {
            return;
        }
        String obj = this.id.substring(0, offset).trim();
        this.aladin.glu.showDocument("simbad.score", Tok.quote(obj));
    }

    protected void dispose() {
        this.aladin.view.simRep = null;
        this.aladin.view.stopSED(false);
    }

    protected boolean action() {
        if (this.inLabel) {
            this.openSimbadID();
        } else if (this.inBiblio) {
            this.openSimbadBiblio();
        } else if (this.inCross) {
            this.dispose();
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        Point p = this.getViewCoord(v, this.L, this.L);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        g.setColor(JAUNEPALE);
        g.drawLine(p.x, p.y - this.L, p.x, p.y - 3);
        g.setColor(Color.black);
        g.drawLine(p.x + 1, p.y - this.L, p.x + 1, p.y - 3);
        g.setColor(JAUNEPALE);
        Util.drawCircle5(g, p.x, p.y);
        g.setColor(Color.black);
        Util.drawCircle7(g, p.x, p.y);
        g.setColor(CARTOUCHE_BACKGROUND);
        g.fillRoundRect(p.x - this.dw / 2, p.y - this.L - this.dh - 1, this.dw - 2, this.dh + 3, 10, 10);
        try {
            int x = p.x - this.dw / 2 + 5;
            int y = p.y - 4 * this.L - 6;
            String s = this.getId(this.id);
            this.drawLabel(g, v, x, y, s);
            g.setFont(Aladin.ITALIC);
            g.setColor(CARTOUCHE_FOREGROUND);
            g.drawString("Type: " + this.getType(this.id), p.x - this.dw / 2 + 15, p.y - 3 * this.L - 4);
            g.drawString("Mag : " + this.getMag(this.id), p.x - this.dw / 2 + 15, p.y - 2 * this.L - 4);
            g.setColor(CARTOUCHE_FOREGROUND.darker());
            s = "by Simbad";
            g.setFont(g.getFont().deriveFont(g.getFont().getSize2D() - 2.0f));
            x = p.x + this.dw / 2 - 5 - g.getFontMetrics().stringWidth(s);
            y = p.y - this.L - 3;
            g.drawString(s, x, y);
            this.drawBiblio(g, v, x, y);
        }
        catch (Exception e) {
            g.setColor(CARTOUCHE_FOREGROUND);
            g.drawString(this.id, p.x - this.dw / 2 + 5, p.y - 2 * this.L - 5);
            g.setColor(CARTOUCHE_FOREGROUND.darker());
            g.setFont(Aladin.ITALIC);
            g.setFont(g.getFont().deriveFont(g.getFont().getSize2D() - 2.0f));
            String s = "unknown by Simbad";
            int x = p.x + this.dw / 2 - 5 - g.getFontMetrics().stringWidth(s);
            int y = p.y - this.L - 3;
            g.drawString(s, x, y);
        }
        this.drawCross(g, v, p.x + this.dw / 2 - SIZECROSS - 7, p.y - this.L - this.dh + 3);
        return true;
    }
}

