/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.Repere;
import cds.aladin.SourceStat;
import cds.aladin.ViewSimple;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class RepereHips3D
extends SourceStat {
    protected RepereHips3D(Plan plan, ViewSimple v, Coord c, double radius) {
        super(plan, v, c, null);
        this.radius = radius;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        this.drawCross(g, v, dx, dy);
        return super.draw(g, v, dx, dy);
    }

    @Override
    protected void statDraw(Graphics g, ViewSimple v, int xvOrig, int yvOrig, int xvLabel, int yvLabel) {
    }

    @Override
    protected void resume() {
    }

    protected void drawCross(Graphics g, ViewSimple v, int dx, int dy) {
        Point p = this.getViewCoord(v, 5, 5);
        if (p == null) {
            return;
        }
        p.x += dx;
        p.y += dy;
        Color c = this.getColor();
        g.setColor(c);
        Repere.drawReticule(g, p.x, p.y, 5, 0, c);
    }

    @Override
    public String getObjType() {
        return "SpectrumHips3D";
    }

    @Override
    public boolean hasPhot() {
        return false;
    }

    @Override
    public boolean hasPhot(Plan p) {
        return false;
    }
}

