/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.FastMath;
import cds.tools.Util;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextField;

public class Repere
extends Position {
    static final int DEFAULT = 0;
    static final int TARGET = 1;
    static final int TARGETL = 2;
    static final int ARROW = 3;
    static final int CENTER = 4;
    static final int ROTCENTER = 5;
    protected int L = 5;
    private double radius;
    protected int dw;
    protected int dh;
    protected int type = 0;
    protected Color couleur = null;
    private static final String C = "|";
    Position rotcenter = null;
    private boolean flagIn = false;
    static final Color JAUNEPALE = new Color(255, 255, 225);
    static final Color CARTOUCHE_FOREGROUND = new Color(200, 203, 207);
    static final Color CARTOUCHE_BACKGROUND = new Color(50, 50, 50);

    protected Repere(Plan plan, ViewSimple v, double x, double y) {
        super(plan, v, x, y, 0.0, 0.0, 5, null);
    }

    protected Repere(Plan plan) {
        super(plan);
    }

    protected Repere(Plan plan, Coord c) {
        super(plan, null, 0.0, 0.0, c.al, c.del, 2, null);
    }

    protected Repere(Plan plan, ViewSimple v, Coord c) {
        super(plan, v, 0.0, 0.0, c.al, c.del, 2, null);
    }

    protected Repere(Plan plan, ViewSimple v, double x, double y, double raj, double dej) {
        super(plan, v, x, y, raj, dej, 3, null);
        this.setId();
        this.setWithLabel(false);
    }

    public Vector getProp() {
        Vector<Prop> propList = super.getProp();
        if (this.hasRayon()) {
            final Repere myself = this;
            final JTextField testRadius = new JTextField(10);
            final PropAction updateRadius = new PropAction(){

                @Override
                public int action() {
                    testRadius.setText(Coord.getUnit(Repere.this.getRadius()));
                    return 1;
                }
            };
            PropAction changRadius = new PropAction(){

                @Override
                public int action() {
                    testRadius.setForeground(Color.black);
                    String oval = Coord.getUnit(Repere.this.getRadius());
                    try {
                        String nval = testRadius.getText();
                        if (nval.equals(oval)) {
                            return -1;
                        }
                        ((Repere)myself).setRadius(nval);
                        return 1;
                    }
                    catch (Exception e1) {
                        updateRadius.action();
                        testRadius.setForeground(Color.red);
                        return 0;
                    }
                }
            };
            propList.add(Prop.propFactory("radius", "Radius", "", testRadius, updateRadius, changRadius));
        }
        final Couleur col = new Couleur(this.couleur, true);
        final PropAction changeCouleur = new PropAction(){

            @Override
            public int action() {
                Color c = col.getCouleur();
                if (c == Repere.this.couleur) {
                    return -1;
                }
                Repere.this.couleur = c;
                return 1;
            }
        };
        col.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeCouleur.action();
                Repere.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("color", "Color", "Alternative color", col, null, changeCouleur));
        return propList;
    }

    @Override
    protected String getSpecificAJInfo() {
        return this.id + C + (this.hasRayon() ? Double.valueOf(this.getRadius()) : "");
    }

    @Override
    protected void setSpecificAJInfo(String s) {
        block3: {
            StringTokenizer tok = new StringTokenizer(s, C);
            String s1 = tok.nextToken();
            String string = this.id = s1.length() == 0 ? null : s1;
            if (tok.hasMoreTokens()) {
                try {
                    this.radius = Double.parseDouble(tok.nextToken());
                }
                catch (Exception e) {
                    if (Aladin.levelTrace != 3) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getObjType() {
        return "Phot";
    }

    protected void setType(int type) {
        this.type = type;
    }

    protected void setRotCenterType(Position o) {
        this.type = 5;
        this.rotcenter = o;
    }

    protected int getType() {
        return this.type;
    }

    protected boolean isLargeReticle() {
        return this.type == 2;
    }

    protected void setSize(int L) {
        this.L = L;
    }

    @Override
    protected void setCoord(ViewSimple v) {
        super.setCoord(v);
        this.setId();
    }

    @Override
    protected void setPosition(ViewSimple v, double x, double y) {
        super.setPosition(v, x, y);
        this.setId();
    }

    @Override
    protected void deltaPosition(ViewSimple v, double x, double y) {
        super.deltaPosition(v, x, y);
        this.setId();
    }

    @Override
    protected void deltaRaDec(double dra, double dde) {
        super.deltaRaDec(dra, dde);
        this.setId();
    }

    protected void reprojection(ViewSimple v) {
        super.projection(v);
    }

    protected void setD() {
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(DF);
        this.dw = m.stringWidth(this.id) + 25;
        this.dh = HF;
    }

    @Override
    public void setColor(Color c) {
        this.couleur = c;
    }

    protected void setRadius(String r) {
        this.radius = Server.getAngleInArcmin(r, 1) / 60.0;
    }

    void setRayon(ViewSimple v, double r) {
        Coord c = new Coord();
        Projection proj = v.getProj().copy();
        proj.setProjCenter(0.0, 0.0);
        double d = 0.0;
        c.del = 0.0;
        c.al = 0.0;
        proj.getXY(c);
        if (Double.isNaN(c.del)) {
            proj = v.getProj().copy();
            c.al = this.raj;
            c.del = this.dej;
            d = this.dej;
            proj.getXY(c);
        }
        c.y += r;
        proj.getCoord(c);
        this.radius = Math.abs(d - c.del);
    }

    protected void setId(String s) {
        this.id = s;
        this.setD();
    }

    void setId() {
        this.id = this.plan.aladin.localisation.J2000ToString(this.raj, this.dej);
        this.setD();
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        double r = this.getRayon(v);
        if (r > 0.0) {
            return (x - this.xv[v.n]) * (x - this.xv[v.n]) + (y - this.yv[v.n]) * (y - this.yv[v.n]) <= r * r;
        }
        double l = (double)this.L / v.getZoom();
        double xc = this.xv[v.n];
        double yc = this.yv[v.n];
        return xc <= x + l && xc >= x - l && yc <= y + l && yc >= y - l;
    }

    protected boolean inLabel(ViewSimple v, double x, double y) {
        boolean rep;
        this.flagIn = rep = this.inLabel1(v, x, y);
        return rep;
    }

    private boolean inLabel1(ViewSimple v, double x, double y) {
        Point p = this.getViewCoord(v, this.L, this.L);
        if (p == null) {
            return false;
        }
        return x >= (double)(p.x - this.dw / 2) && x <= (double)(p.x + this.dw / 2) && y >= (double)(p.y - this.L - this.dh - 1) && y <= (double)(p.y - this.L + 5);
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        Point p1;
        if (!this.isVisible()) {
            return clip;
        }
        int L = (int)Math.ceil(Math.max((double)this.L, this.getRayon(v) * v.getZoom()));
        Point p = this.getViewCoord(v, L, L);
        if (p == null) {
            return clip;
        }
        int D = L;
        if (this.type == 4 || this.type == 5) {
            D = (int)Math.min(Math.max(2.0, v.getZoom() * 3.0), 16.0);
        }
        clip = Repere.unionRect(clip, p.x - D, p.y - D, D * 2, D * 2);
        if (this.type == 5 && (p1 = v.getViewCoord(this.rotcenter.xv[v.n], this.rotcenter.yv[v.n])) != null) {
            clip = Repere.unionRect(clip, p1.x - D, p1.y - D, D * 2, D * 2);
        }
        if (this.isSelected()) {
            clip = Repere.unionRect(clip, p.x - L - 4, p.y - L - 4, L * 2 + 8, L * 2 + 8);
        }
        if (this.isWithLabel()) {
            clip = Repere.unionRect(clip, p.x - this.dw / 2, p.y - L - 1 - this.dh - 1, this.dw, this.dh);
        }
        return clip;
    }

    protected Rectangle getClipRayon(ViewSimple v) {
        Rectangle clip = null;
        if (!this.isVisible()) {
            return null;
        }
        int L = (int)Math.ceil(this.getRayon(v) * v.getZoom());
        Point p = this.getViewCoord(v, L, L);
        if (p == null) {
            return null;
        }
        if (this.isSelected()) {
            clip = Repere.unionRect(clip, p.x - L - 4, p.y - L - 4, L * 2 + 8, L * 2 + 8);
        }
        return clip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Color getColor() {
        if (this.type == 1 || this.type == 2) {
            this.couleur = Color.magenta.darker();
        }
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.type == 3) {
            this.couleur = Color.red;
            return this.couleur;
        } else {
            if (this.plan == null) return Color.black;
            if (this.plan.type != 10) return this.plan.c;
            this.couleur = ((PlanField)this.plan).getColor(this);
        }
        return this.couleur;
    }

    public static void drawReticule(Graphics g, int x, int y, int demiLargeur, int demiCentre, Color c) {
        g.setColor(c);
        g.drawLine(x - demiLargeur, y, x - demiCentre, y);
        g.drawLine(x + demiCentre, y, x + demiLargeur, y);
        g.drawLine(x, y - demiLargeur, x, y - demiCentre);
        g.drawLine(x, y + demiLargeur, x, y + demiCentre);
        g.drawLine(x - demiLargeur, ++y, x - demiCentre, y);
        g.drawLine(x + demiCentre, y, x + demiLargeur, y);
        g.drawLine(++x, --y - demiLargeur, x, y - demiCentre);
        g.drawLine(x, y + demiLargeur, x, y + demiCentre);
    }

    @Override
    public boolean hasSurface() {
        return this.radius > 0.0;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    protected boolean hasRayon() {
        return this.radius > 0.0;
    }

    @Override
    public boolean hasPhot() {
        return this.hasRayon();
    }

    public boolean hasPhot(Plan p) {
        if (!this.hasPhot()) {
            return false;
        }
        return p.hasAvailablePixels();
    }

    @Override
    public String getCommand() {
        String r = this.plan.aladin.localisation.getFrame() == 11 ? Util.myRound(this.getRayon(this.plan.aladin.view.getCurrentView())) : Coord.getUnit(this.getRadius());
        return "draw phot(" + this.getLocalisation() + "," + r + ")";
    }

    protected double getRayon(ViewSimple v) {
        Coord c = new Coord();
        Projection proj = v.getProj();
        if (this.radius == 0.0 || v.pref == null || !Projection.isOk(proj)) {
            return 0.0;
        }
        c.al = this.raj;
        c.del = this.dej + this.radius;
        proj.getXY(c);
        double dy = this.yv[v.n] - c.y;
        double dx = this.xv[v.n] - c.x;
        return Math.sqrt(dx * dx + dy * dy);
    }

    protected void drawSpecialCircle(Graphics g, ViewSimple v) {
        Coord c = new Coord();
        Point p1 = new Point(0, 0);
        Point p2 = new Point(0, 0);
        Projection proj = v.getProj().copy();
        for (double theta = 0.0; theta < 6.3; theta += 0.1) {
            c.del = this.dej + this.radius * FastMath.sin(theta);
            c.al = this.raj + this.radius * FastMath.cos(theta);
            proj.getXY(c);
            if (Double.isNaN(c.x)) continue;
            p2 = v.getViewCoord(p2, c.x, c.y);
            if (theta > 0.0) {
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
            p1.x = p2.x;
            p1.y = p2.y;
        }
    }

    protected boolean onPoignee(ViewSimple v, double x, double y) {
        double r = this.getRayon(v) + 1.0;
        for (int i = 0; i < 4; ++i) {
            double xc = this.xv[v.n];
            double yc = this.yv[v.n];
            if (i == 0) {
                yc += r;
            } else if (i == 2) {
                yc -= r;
            } else {
                xc = i == 1 ? (xc += r) : (xc -= r);
            }
            double dx = x - xc;
            double dy = y - yc;
            double l = (double)this.L / v.getZoom();
            if (l < 1.0) {
                l = 1.0;
            }
            if (!(dx * dx + dy * dy < l * l)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        Point p = this.getViewCoord(v, this.L, this.L);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        g.setColor(this.getColor());
        switch (this.type) {
            case 1: 
            case 2: {
                int demiLargeur = (int)Math.min(Math.max(8.0, v.getZoom() * 12.0), 32.0);
                int demiCentre = Math.max(Math.min(demiLargeur - 7, demiLargeur / 3), 2);
                if (demiLargeur > 10) {
                    g.drawLine(p.x, p.y, p.x, p.y);
                }
                if (this.type == 2) {
                    demiLargeur = 3000;
                }
                Repere.drawReticule(g, p.x, p.y, demiLargeur, demiCentre, this.getColor());
                break;
            }
            case 4: {
                int demiLargeur = (int)Math.min(Math.max(2.0, v.getZoom() * 3.0), 16.0);
                int demiCentre = 2 * demiLargeur / 3;
                Repere.drawReticule(g, p.x, p.y, demiLargeur, demiCentre, this.getColor());
                break;
            }
            case 5: {
                if (!Aladin.ROTATEFOVCENTER) {
                    return false;
                }
                Util.drawCircle7(g, p.x, p.y);
                Point p1 = v.getViewCoord(this.rotcenter.xv[v.n], this.rotcenter.yv[v.n]);
                if (p1 == null) {
                    return false;
                }
                g.drawLine(p.x, p.y, p1.x, p1.y);
                break;
            }
            case 0: {
                g.drawLine(p.x - this.L, p.y, p.x + this.L, p.y);
                g.drawLine(p.x, p.y - this.L, p.x, p.y + this.L);
                break;
            }
            case 3: {
                g.drawLine(p.x, p.y - this.L, p.x, p.y - 3);
                g.drawLine(p.x, p.y - 3, p.x - 3, p.y - 6);
                g.drawLine(p.x, p.y - 3, p.x + 3, p.y - 6);
            }
        }
        if (this.isWithLabel() && !this.hasRayon()) {
            if (this.id == null) {
                this.setId();
            }
            g.drawString(this.id, p.x - this.dw / 2, p.y - this.L - 1);
        }
        if (this.isSelected()) {
            g.setColor(Color.green);
            this.drawSelect(g, v);
        }
        return true;
    }

    private static String getId(String id) {
        int i = id.lastIndexOf(40);
        return id.substring(0, i).trim();
    }

    private static String getMag(String id) {
        int i = id.lastIndexOf(40);
        int j = id.indexOf(44, i + 1);
        return id.substring(i + 1, j).trim();
    }

    private static String getType(String id) {
        int i = id.lastIndexOf(40);
        int j = id.indexOf(44, i + 1);
        return id.substring(j + 1, id.length() - 1).trim();
    }

    @Override
    protected void drawSelect(Graphics g, ViewSimple v) {
        if (this.type == 5) {
            this.drawRotCenterSelect(g, v);
        } else if (!this.hasRayon()) {
            super.drawSelect(g, v);
        } else {
            this.drawSelect1(g, v);
        }
    }

    protected void drawSelect1(Graphics g, ViewSimple v) {
        Rectangle r = this.getClipRayon(v);
        int xc = 0;
        int yc = 0;
        Color c = g.getColor();
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    xc = r.x + r.width / 2 - 4;
                    yc = r.y;
                    break;
                }
                case 1: {
                    xc = r.x + r.width / 2 - 4;
                    yc = r.y + r.height - 4;
                    break;
                }
                case 2: {
                    xc = r.x + r.width - 4;
                    yc = r.y + r.height / 2 - 4;
                    break;
                }
                case 3: {
                    xc = r.x;
                    yc = r.y + r.height / 2 - 4;
                }
            }
            g.setColor(c);
            g.fillRect(xc + 1, yc + 1, 4, 4);
            g.setColor(Color.black);
            g.drawRect(xc, yc, 4, 4);
        }
        g.setColor(c);
    }

    protected void drawRotCenterSelect(Graphics g, ViewSimple v) {
        Point p = this.getViewCoord(v, this.L, this.L);
        g.setColor(Color.green);
        Util.fillCircle5(g, p.x, p.y);
        g.setColor(Color.black);
        Util.drawCircle5(g, p.x, p.y);
    }
}

