/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.Plan;
import cds.aladin.PlanHips;
import cds.aladin.ViewSimple;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.util.Enumeration;
import java.util.Vector;

public final class Projection {
    static final int NO = 0;
    static final int ALADIN = 1;
    static final int WCS = 2;
    static final int SIMPLE = 3;
    static final int QUADRUPLET = 4;
    static final int PLOT = 5;
    static final String[] NAME = new String[]{"-", "Aladin reduction", "WCS reduction", "Simple reduction", "Matching star red.", "Squattered plot"};
    protected Plan plan = null;
    protected int frame = 0;
    protected String label = null;
    protected double raj;
    protected double dej;
    protected double alphai;
    protected double deltai;
    protected double cx;
    protected double cy;
    protected double rm;
    protected double rm1;
    protected double r;
    protected double r1;
    protected double rot;
    protected boolean sym;
    protected int system;
    protected int t;
    protected int modeCalib;
    protected boolean toNorth;
    protected Calib c;
    protected Coord[] coo;
    static String[] alaProj = null;
    static String[] alaProjToType = null;
    static String[] alaProj1 = new String[]{"Spheric", "Tangential", "Aitoff", "Zenital equal area", "Stereographic", "Cartesian", "Mercator", "Mollweide", "Arc"};
    static String[] alaProjToType1 = new String[]{"SIN", "TAN", "AIT", "ZEA", "STG", "CAR", "MER", "MOL", "ARC"};
    static String[] alaProjBeta = new String[]{"HEALPix"};
    static String[] alaProjToTypeBeta = new String[]{"HPX"};
    private double flipPlotX = 1.0;
    private double flipPlotY = 1.0;
    private boolean logPlotX = false;
    private boolean logPlotY = false;
    private Projection projNorth = null;
    private static boolean flagUN = true;
    private Coord cotmp = new Coord();

    private static void initAlaProj() {
        if (alaProj != null) {
            return;
        }
        if (!Aladin.BETA) {
            alaProj = alaProj1;
            alaProjToType = alaProjToType1;
        } else {
            int n1 = alaProj1.length;
            int nBeta = alaProjBeta.length;
            alaProj = new String[n1 + nBeta];
            alaProjToType = new String[n1 + nBeta];
            System.arraycopy(alaProj1, 0, alaProj, 0, n1);
            System.arraycopy(alaProjBeta, 0, alaProj, n1, nBeta);
            System.arraycopy(alaProjToType1, 0, alaProjToType, 0, n1);
            System.arraycopy(alaProjToTypeBeta, 0, alaProjToType, n1, nBeta);
        }
    }

    public static String getProjType(int i) {
        Projection.initAlaProj();
        return alaProjToType[i];
    }

    public static int getProjType(String projectionName) {
        Projection.initAlaProj();
        int i = Util.indexInArrayOf(projectionName, alaProj, true);
        if (i >= 0) {
            projectionName = alaProjToType[i];
        }
        return Util.indexInArrayOf(projectionName, Calib.projType, true);
    }

    public static int getAlaProjIndex(String projectionName) {
        Projection.initAlaProj();
        int i = Util.indexInArrayOf(projectionName, alaProj, true);
        if (i >= 0) {
            return i;
        }
        return Util.indexInArrayOf(projectionName, alaProjToType, true);
    }

    public static String[] getAlaProj() {
        Projection.initAlaProj();
        return alaProj;
    }

    public static String getAlaProj(int i) {
        Projection.initAlaProj();
        return alaProj[i];
    }

    protected Projection() {
        this.modeCalib = 0;
    }

    protected Projection(Projection p) {
        this.c = p.c;
        this.plan = p.plan;
        this.adjustParamByCalib(this.c);
    }

    protected double getRaMax() {
        return Projection.getRaMax(this.t);
    }

    protected static double getRaMax(int t) {
        return t == 1 || t == 2 || t == 12 ? 180.0 : 360.0;
    }

    protected double getDeMax() {
        return this.t == 1 || this.t == 2 || this.t == 12 || this.t == 4 || this.t == 7 || this.t == 17 || this.t == 11 || this.t == 5 || this.t == 3 ? 180.0 : 360.0;
    }

    protected Projection(double refX, double refY, double x, double y, double refW, double refH, double w, double h, boolean flipX, boolean flipY, boolean logX, boolean logY, Plan plan) {
        this.modeCalib = 5;
        this.raj = this.alphai = refX;
        this.dej = this.deltai = refY;
        this.cx = x;
        this.cy = y;
        this.rm = refW;
        this.rm1 = refH;
        this.r = w;
        this.r1 = h;
        this.flipPlotX = flipX ? -1.0 : 1.0;
        this.flipPlotY = flipY ? -1.0 : 1.0;
        this.logPlotX = logX;
        this.logPlotY = logY;
        this.plan = plan;
    }

    private double log(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    private double exp(double x) {
        return Math.exp(x * Math.log(10.0));
    }

    protected double getFctXPlot() {
        return this.r / (this.logPlotX ? this.log(this.rm) : this.rm);
    }

    protected double getFctYPlot() {
        return this.r1 / (this.logPlotY ? this.log(this.rm1) : this.rm1);
    }

    protected Coord getXYPlot(Coord coo) {
        if (Double.isNaN(coo.al)) {
            coo.x = Double.NaN;
            coo.y = Double.NaN;
            return coo;
        }
        try {
            double valX = this.logPlotX ? this.log(coo.al) : coo.al - this.alphai;
            double valY = this.logPlotY ? this.log(coo.del) : coo.del - this.deltai;
            coo.x = valX * this.r / (this.logPlotX ? this.log(this.rm - this.alphai) : this.rm) * this.flipPlotX + this.cx;
            coo.y = valY * -this.r1 / (this.logPlotY ? this.log(this.rm1 - this.deltai) : this.rm1) * this.flipPlotY + this.cy;
            if (Double.isInfinite(coo.x) || Double.isInfinite(coo.y)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            coo.x = Double.NaN;
            coo.y = Double.NaN;
        }
        return coo;
    }

    protected Coord getCoordPlot(Coord coo) {
        if (Double.isNaN(coo.x)) {
            coo.al = Double.NaN;
            coo.del = Double.NaN;
            return coo;
        }
        try {
            double valX = coo.x - this.cx;
            double valY = coo.y - this.cy;
            double al = valX * (this.logPlotX ? this.log(this.rm - this.alphai) : this.rm) / this.r * this.flipPlotX;
            coo.al = (this.logPlotX ? this.exp(al) : al) + this.alphai;
            double del = valY * -(this.logPlotY ? this.log(this.rm1 - this.deltai) : this.rm1) / this.r1 * this.flipPlotY;
            coo.del = (this.logPlotY ? this.exp(del) : del) + this.deltai;
            if (Double.isInfinite(coo.al) || Double.isInfinite(coo.del)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            coo.al = Double.NaN;
            coo.del = Double.NaN;
        }
        return coo;
    }

    protected boolean isFlipXPlot() {
        return this.flipPlotX == -1.0;
    }

    protected boolean isFlipYPlot() {
        return this.flipPlotY == -1.0;
    }

    protected boolean isLogXPlot() {
        return this.logPlotX;
    }

    protected boolean isLogYPlot() {
        return this.logPlotY;
    }

    protected void flipPlot(int n, boolean flag) {
        if (n == 0) {
            this.flipPlotX = flag ? -1.0 : 1.0;
        } else {
            this.flipPlotY = flag ? -1.0 : 1.0;
        }
    }

    protected void logPlot(int n, boolean flag) {
        if (n == 0) {
            this.logPlotX = flag;
        } else {
            this.logPlotY = flag;
        }
    }

    protected Projection(String label, int type, double alphai, double deltai, double rm, double cx, double cy, double r, double rot, boolean sym, int t, int system, Plan plan) {
        this(label, type, alphai, deltai, rm, rm, cx, cy, r, r, rot, sym, t, system, plan);
    }

    protected Projection(String label, int type, double alphai, double deltai, double rm, double rm1, double cx, double cy, double r, double r1, double rot, boolean sym, int t, int system, Plan plan) {
        this.c = new Calib(alphai, deltai, cx, cy, r, r1, rm, rm1, rot, t, sym, system);
        this.adjustParamByCalib(this.c);
        this.modeCalib = type;
        this.label = label;
        if (this.label == null) {
            this.label = Projection.getName(type, t);
        }
        this.plan = plan;
    }

    public Projection(int type, Calib c, Plan plan) {
        this.c = c;
        this.adjustParamByCalib(c);
        this.modeCalib = type;
        this.label = Projection.getName(type, 0);
        this.plan = plan;
    }

    protected Projection copy() {
        Projection p = new Projection();
        p.frame = this.frame;
        p.raj = this.raj;
        p.dej = this.dej;
        p.alphai = this.alphai;
        p.deltai = this.deltai;
        p.cx = this.cx;
        p.cy = this.cy;
        p.rm = this.rm;
        p.r = this.r;
        p.rm1 = this.rm1;
        p.r1 = this.r1;
        p.rot = this.rot;
        p.sym = this.sym;
        p.t = this.t;
        p.system = this.system;
        p.modeCalib = this.modeCalib;
        String string = p.label = this.label == null ? null : new String(this.label);
        if (this.coo != null) {
            p.coo = new Coord[this.coo.length];
            System.arraycopy(this.coo, 0, p.coo, 0, this.coo.length);
        }
        p.c = this.c == null ? null : Calib.copy(this.c);
        p.plan = this.plan;
        return p;
    }

    protected Projection toNorth(double angle) {
        if (this.rot == angle) {
            return this;
        }
        if (this.projNorth == null || this.projNorth.c.getProjRot() != angle) {
            this.projNorth = new Projection();
            this.projNorth.c = new Calib(this.alphai, this.deltai, this.cx, this.cy, this.r, this.r1, this.rm, this.rm1, angle, this.t, false, this.system);
            this.projNorth.adjustParamByCalib(this.projNorth.c);
            this.projNorth.modeCalib = this.modeCalib;
            this.projNorth.label = Projection.getName(this.modeCalib, this.t);
            this.projNorth.coo = null;
        }
        return this.projNorth;
    }

    protected void crop(double x, double y, double w, double h) {
        this.c.cropping(x, y, w, h);
        this.adjustParamByCalib(this.c);
    }

    protected void cropAndZoom(double x, double y, double w, double h, double zoom) {
        this.c.cropAndZoom(x, y, w, h, zoom);
        this.adjustParamByCalib(this.c);
    }

    protected void modify(String label, int modeCalib, double alphai, double deltai, double rm, double rm1, double cx, double cy, double r, double r1, double rot, boolean sym, int t, int system) {
        this.c = new Calib(alphai, deltai, cx, cy, r, r1, rm, rm1, rot, t, sym, system);
        this.adjustParamByCalib(this.c);
        this.modeCalib = modeCalib;
        if (label == null) {
            this.label = Projection.getName(modeCalib, t);
        }
        this.coo = null;
    }

    public void setProjSym(boolean sym) {
        this.modify(this.label, this.modeCalib, this.alphai, this.deltai, this.rm, this.rm1, this.cx, this.cy, this.r, this.r1, this.rot, sym, this.t, this.system);
    }

    public void setProj(int type) {
        this.modify(this.label, this.modeCalib, this.alphai, this.deltai, this.rm, this.rm1, this.cx, this.cy, this.r, this.r1, this.rot, this.sym, type, this.system);
    }

    protected void setProjCenter(double ra, double dec) {
        Coord c = new Coord(ra, dec);
        if (this.frame != 0) {
            c = Localisation.frameToFrame(c, 0, this.frame);
        }
        this.modify(this.label, this.modeCalib, c.al, c.del, this.rm, this.rm1, this.cx, this.cy, this.r, this.r1, this.rot, this.sym, this.t, this.system);
    }

    protected void setProjRot(double rota) {
        this.modify(this.label, this.modeCalib, this.alphai, this.deltai, this.rm, this.rm, this.cx, this.cy, this.r, this.r, rota, this.sym, this.t, this.system);
    }

    protected void deltaProjRot(double drot) {
        double rota = this.rot + drot;
        if (rota > 360.0) {
            rota -= 360.0;
        } else if (rota < 0.0) {
            rota += 360.0;
        }
        this.modify(this.label, this.modeCalib, this.alphai, this.deltai, this.rm, this.rm, this.cx, this.cy, this.r, this.r, rota, this.sym, this.t, this.system);
    }

    protected void deltaProjCenter(double dra, double ddec) {
        double ra = this.alphai + dra;
        double de = this.deltai + ddec;
        double rota = this.rot;
        if (de > 89.95) {
            de = 180.0 - de;
            ra += 180.0;
            rota += 180.0;
        } else if (de < -89.95) {
            de = -de - 180.0;
            ra += 180.0;
            rota -= 180.0;
        }
        if (ra > 360.0) {
            ra -= 360.0;
        } else if (ra < 0.0) {
            ra += 360.0;
        }
        if (rota > 360.0) {
            rota -= 360.0;
        } else if (rota < 0.0) {
            rota += 360.0;
        }
        this.modify(this.label, this.modeCalib, ra, de, this.rm, this.rm, this.cx, this.cy, this.r, this.r, rota, this.sym, this.t, this.system);
    }

    protected void deltaProjXYCenter(double deltaX, double deltaY) {
        this.c.Xcen += deltaX;
        this.c.Ycen += deltaY;
        this.adjustParamByCalib(this.c);
    }

    protected static boolean isOk(Projection p) {
        return p != null && p.modeCalib != 0;
    }

    protected static int getDefaultType(double radius) {
        return radius < 2.0 ? 2 : (radius < 60.0 ? 5 : 4);
    }

    protected void modify(String label, Coord[] coo) {
        if (label == null) {
            label = Projection.getName(this.modeCalib, this.t);
        }
        this.label = label;
        this.modeCalib = 4;
        this.coo = coo;
        this.c = this.c.recalibrate(coo);
        this.adjustParamByCalib(this.c);
    }

    protected void modify(String label, Calib c) {
        if (label == null) {
            label = Projection.getName(this.modeCalib, this.t);
        }
        this.label = label;
        this.modeCalib = 2;
        this.coo = this.coo;
        this.c = c;
        this.coo = null;
        this.adjustParamByCalib(c);
    }

    protected void adjustParamByCalib(Calib c) {
        try {
            Coord co = c.getProjCenter();
            this.cx = co.x;
            this.cy = co.y;
            this.alphai = co.al;
            this.deltai = co.del;
            co = c.getImgCenter();
            co = Localisation.frameToFrame(co, this.frame, 0);
            this.raj = co.al;
            this.dej = co.del;
        }
        catch (Exception co) {
            // empty catch block
        }
        double w = c.getImgWidth();
        double h = c.getImgHeight();
        this.rm = w * 60.0;
        this.rm1 = h * 60.0;
        this.r = c.getImgSize().width;
        this.r1 = c.getImgSize().height;
        this.rot = c.getProjRot();
        this.sym = c.getProjSym();
        this.system = c.getSystem();
        this.t = c.getProj();
    }

    protected double getPixResAlpha() throws Exception {
        return this.c.getImgWidth() / (double)this.c.getImgSize().width;
    }

    protected double getPixResDelta() throws Exception {
        return this.c.getImgHeight() / (double)this.c.getImgSize().height;
    }

    protected void resize(int scale) {
        try {
            this.c = this.c.resize(scale);
        }
        catch (Exception e) {
            return;
        }
        this.adjustParamByCalib(this.c);
    }

    protected void resize(int scale, double cx, double cy, int xpix, int ypix) {
        this.c = this.c.resize(scale, cx, cy, xpix, ypix);
        this.adjustParamByCalib(this.c);
    }

    protected void flip(int methode) {
        if (methode == 0 || methode == 2) {
            this.c = this.c.flipBU();
        }
        if (methode == 1 || methode == 2) {
            this.c = this.c.flipRL();
        }
        this.adjustParamByCalib(this.c);
    }

    public String toString() {
        return (this.label == null ? "" : this.label + " ") + Projection.getName(this.modeCalib, this.t) + " " + this.alphai + "," + this.deltai + "=>" + this.cx + "," + this.cy + " (" + this.rm + "x" + this.rm1 + ")/(" + this.r + "x" + this.r1 + ") " + (this.rot != 0.0 ? "rot=" + this.rot + "deg " : "") + (this.sym ? "RA_symetry " : "") + "system=" + this.system + " " + Localisation.REPERE[this.frame];
    }

    protected boolean isLargeField() {
        return (this.rm > 2700.0 || this.rm1 > 2700.0) && !this.isXYLinear();
    }

    protected boolean isModifiable() {
        return this.modeCalib == 3 || this.modeCalib == 4 || this.modeCalib == 2;
    }

    protected boolean isXYLinear() {
        return this.modeCalib == 5 || this.c != null && this.c.system == 7;
    }

    protected static String getName(int type, int t) {
        try {
            return type == 3 ? Calib.getProjName(t) : NAME[type];
        }
        catch (Exception e) {
            return "noname";
        }
    }

    protected String getName() {
        return Projection.getName(this.modeCalib, this.t);
    }

    protected String getWCS() {
        StringBuffer s = new StringBuffer();
        Vector key = new Vector(20);
        Vector value = new Vector(20);
        try {
            this.getWCS(key, value);
        }
        catch (Exception e) {
            System.err.println("GetWCS error");
            return null;
        }
        Enumeration ekey = key.elements();
        Enumeration evalue = value.elements();
        while (ekey.hasMoreElements()) {
            String skey = (String)ekey.nextElement();
            String svalue = (String)evalue.nextElement();
            s.append(skey + "= " + svalue + "\n");
        }
        return s.toString();
    }

    protected void getWCS(Vector key, Vector value) throws Exception {
        this.c.GetWCS(key, value);
        if (this.isEquatorial()) {
            return;
        }
        Enumeration ekey = key.elements();
        Enumeration evalue = value.elements();
        int i = 0;
        while (ekey.hasMoreElements()) {
            String ctype;
            String skey = (String)ekey.nextElement();
            String svalue = (String)evalue.nextElement();
            if (skey.startsWith("CTYPE1")) {
                ctype = Localisation.CTYPE1[this.frame];
                svalue = ctype + svalue.substring(ctype.length());
                value.setElementAt(svalue, i);
            } else if (skey.startsWith("CTYPE2")) {
                ctype = Localisation.CTYPE2[this.frame];
                svalue = ctype + svalue.substring(ctype.length());
                value.setElementAt(svalue, i);
            } else if (skey.startsWith("RADECSYS")) {
                String radecsys = Localisation.RADECSYS[this.frame];
                if (radecsys == null) {
                    key.remove(i);
                    value.remove(i);
                } else {
                    value.setElementAt(radecsys, i);
                }
            }
            ++i;
        }
    }

    protected static Projection getEquivalentProj(Projection p) throws Exception {
        if (p.isEquatorial() || p.system != Calib.GALACTIC) {
            return p;
        }
        p.c = new Calib(new HeaderFits(p.getWCS()));
        p.adjustParamByCalib(p.c);
        p.frame = 0;
        return p;
    }

    private boolean isEquatorial() {
        return this.frame == 0 || this.frame == 1 || this.frame == 5 || this.frame == 6 || this.frame == 7 || this.frame == 8 || this.frame == 9 || this.frame == 10;
    }

    protected static double round(double x) {
        return Math.ceil(x * 10.0) / 10.0;
    }

    protected boolean isUncompatibleBody(Projection p) {
        int r = this.isUncompatibleBody1(p);
        if (r != 1) {
            Plan plan = p.plan;
            if (!Aladin.aladin.isFullScreen()) {
                Aladin.aladin.uncompatibleFrameWarning(this.getBody(), p.getBody());
            }
        }
        return r == 0;
    }

    protected int isUncompatibleBody1(Projection p) {
        if (!Projection.isOk(p)) {
            return 0;
        }
        if (!Aladin.aladin.configuration.isPlanet()) {
            return 1;
        }
        if (Aladin.aladin.configuration.isPlanetNotCheck()) {
            return 1;
        }
        String body = this.getBody();
        String pbody = p.getBody();
        if ("__PLOT__".equalsIgnoreCase(body) || "__PLOT__".equalsIgnoreCase(pbody)) {
            return 1;
        }
        if (body == null || pbody == null) {
            return -1;
        }
        return body.equals(pbody) ? 1 : 0;
    }

    protected String getBody() {
        return this.plan == null ? null : this.plan.body;
    }

    protected boolean agree(Projection p, ViewSimple v) {
        return this.agree(p, v, true);
    }

    protected boolean agree(Projection p, ViewSimple v, boolean testBG) {
        if (p == null) {
            return false;
        }
        if (this == p) {
            return true;
        }
        if (this.isUncompatibleBody(p)) {
            return false;
        }
        if (p.rm > 1800.0) {
            return true;
        }
        double z = 1.0;
        if (v != null) {
            if (testBG && v.pref != null && v.pref instanceof PlanHips) {
                return true;
            }
            z = v.getZoom();
        }
        Coord c1 = new Coord();
        c1.al = p.raj;
        c1.del = p.dej;
        Coord c2 = new Coord();
        c2.al = this.raj;
        c2.del = this.dej;
        double dist = Coord.getDist(c1, c2);
        double somme = (this.rm + p.rm) * Math.sqrt(2.0) / 120.0;
        if (z < 1.0) {
            somme /= z;
        }
        if (this.rm > 45.0 || p.rm > 45.0) {
            return true;
        }
        return dist <= somme;
    }

    public Coord getCoord(Coord coo) {
        Coord c = this.getCoordNative(coo);
        if (this.modeCalib == 5 || this.isXYLinear()) {
            return c;
        }
        if (this.frame == 0 || coo.al == Double.NaN) {
            return c;
        }
        Localisation.frameToFrame(c, this.frame, 0);
        return c;
    }

    protected Coord getCoordNative(Coord coo) {
        if (this.modeCalib == 5) {
            return this.getCoordPlot(coo);
        }
        if (Double.isNaN(coo.x)) {
            coo.al = Double.NaN;
            coo.del = Double.NaN;
            return coo;
        }
        try {
            this.cotmp.x = coo.x + 0.5;
            this.cotmp.y = coo.y - 0.5;
            this.c.GetCoord(this.cotmp);
            coo.al = this.cotmp.al;
            coo.del = this.cotmp.del;
        }
        catch (Exception e) {
            coo.al = Double.NaN;
            coo.del = Double.NaN;
        }
        return coo;
    }

    public Coord getXY(Coord coo) {
        if (this.modeCalib == 5) {
            return this.getXYPlot(coo);
        }
        if (Double.isNaN(coo.al)) {
            coo.x = Double.NaN;
            coo.y = Double.NaN;
            return coo;
        }
        try {
            if (this.frame == 0 || this.isXYLinear()) {
                this.c.GetXY(coo);
            } else {
                this.cotmp.al = coo.al;
                this.cotmp.del = coo.del;
                this.cotmp = Localisation.frameToFrame(this.cotmp, 0, this.frame);
                this.c.GetXY(this.cotmp);
                coo.x = this.cotmp.x;
                coo.y = this.cotmp.y;
            }
            if (!Double.isNaN(coo.x)) {
                coo.x -= 0.5;
                coo.y += 0.5;
            }
        }
        catch (Exception e) {
            coo.x = Double.NaN;
            coo.y = Double.NaN;
        }
        return coo;
    }

    protected Coord getXYNative(Coord coo) {
        if (this.modeCalib == 5) {
            return this.getXYPlot(coo);
        }
        if (Double.isNaN(coo.al)) {
            coo.x = Double.NaN;
            coo.y = Double.NaN;
            return coo;
        }
        try {
            this.c.GetXY(coo);
            if (!Double.isNaN(coo.x)) {
                coo.x -= 0.5;
                coo.y += 0.5;
            }
        }
        catch (Exception e) {
            coo.x = Double.NaN;
            coo.y = Double.NaN;
        }
        return coo;
    }

    protected Coord getProjCenter() {
        if (this.modeCalib == 5) {
            Coord c = new Coord(this.alphai, this.deltai);
            c.x = this.cx;
            c.y = this.cy;
            return c;
        }
        Coord coo = this.c.getProjCenter();
        return Localisation.frameToFrame(coo, this.frame, 0);
    }

    protected boolean sensDirect() {
        if (this.c == null) {
            return false;
        }
        return this.c.sensDirect();
    }
}

