/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.ServerTap;
import cds.aladin.WhereGridConstraint;
import javax.swing.JLabel;

public class PositionConstraint
extends WhereGridConstraint {
    private static final long serialVersionUID = 1L;
    private String raConstraint;
    private String decConstraint;
    private String radiusConstraint;
    private String selectedDecColumnName;
    private String selectedRaColumnName;
    private String tableName;

    public PositionConstraint(ServerTap serverTap) {
        super(serverTap);
    }

    public PositionConstraint(ServerTap serverTap, String raConstraint, String decConstraint, String radiusConstraint, String tableName, String selectedRaColumnName, String selectedDecColumnName) {
        super(serverTap, new JLabel("Ra= " + raConstraint), new JLabel("Dec= " + decConstraint), new JLabel("Radius= " + radiusConstraint));
        this.raConstraint = raConstraint;
        this.decConstraint = decConstraint;
        this.radiusConstraint = radiusConstraint;
        this.selectedRaColumnName = selectedRaColumnName;
        this.selectedDecColumnName = selectedDecColumnName;
        this.tableName = tableName;
    }

    @Override
    public String getAdqlString() throws Exception {
        String alias;
        StringBuffer whereClause = new StringBuffer();
        if (this.andOrOperator != null) {
            whereClause.append(this.andOrOperator.getSelectedItem()).append(" ");
        }
        alias = (alias = this.serverTap.tapClient.tablesMetaData.get(this.tableName).getAlias()) != null ? alias + "." : "";
        whereClause.append(String.format("CONTAINS(POINT('ICRS', %1$s%2$s, %1$s%3$s), CIRCLE('ICRS', %4$s, %5$s, %6$s)) = 1", alias, this.selectedRaColumnName, this.selectedDecColumnName, this.raConstraint, this.decConstraint, this.radiusConstraint)).append(" ");
        return whereClause.toString();
    }

    public String getSelectedRaColumnName() {
        return this.selectedRaColumnName;
    }

    public void setSelectedRaColumnName(String selectedRaColumnName) {
        this.selectedRaColumnName = selectedRaColumnName;
    }

    public String getSelectedDecColumnName() {
        return this.selectedDecColumnName;
    }

    public void setSelectedDecColumnName(String selectedDecColumnName) {
        this.selectedDecColumnName = selectedDecColumnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

