/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinException;
import cds.aladin.AladinPlugin;
import cds.aladin.PluginDescription;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class Plugins
extends ClassLoader
implements Runnable,
ListModel,
Comparator,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    private Aladin aladin;
    protected Vector plugs;
    private boolean flagErrorDir = false;
    private static char FS = Util.FS.charAt(0);
    static JFrame controleur = null;
    private PluginDescription plugDesc;
    private JButton removePlug;
    private JList listPlugs;
    private MyClassloader classLoader;
    private Thread thread = null;
    private ListDataListener listListener;

    public Plugins(Aladin aladin) {
        this.aladin = aladin;
        this.plugs = new Vector();
        this.classLoader = new MyClassloader(new URL[0], this.getClass().getClassLoader());
        this.scanDir(this.getPlugPath());
    }

    public void close() {
        if (this.classLoader == null) {
            return;
        }
        try {
            this.classLoader.close();
            this.classLoader = null;
            this.aladin.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent DragSourceDropEvent2) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dragExit(DragSourceEvent DragSourceEvent2) {
    }

    @Override
    public void dragOver(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable tr = dropTargetDropEvent.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : fileList) {
                    this.copyInPlug(file);
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
            this.reload();
        }
        catch (Exception e) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    private void copyInPlug(File f) throws Exception {
        int n;
        String name = f.getName();
        File outf = new File(this.getPlugPath() + FS + name);
        RandomAccessFile in = new RandomAccessFile(f, "r");
        RandomAccessFile out = new RandomAccessFile(outf, "rw");
        byte[] buf = new byte[512];
        for (long size = in.length(); size > 0L; size -= (long)n) {
            n = in.read(buf);
            out.write(buf, 0, n);
        }
        in.close();
        out.close();
    }

    private void scanDir(String dir) {
        block2: {
            try {
                this.addInClassPath(dir);
                this.scan(new File(dir));
            }
            catch (Throwable t) {
                if (Aladin.levelTrace < 3) break block2;
                t.printStackTrace();
            }
        }
    }

    private void addInClassPath(String dir) throws Exception {
        block2: {
            try {
                URL u = new File(dir).toURL();
                this.classLoader.addURL(u);
            }
            catch (Throwable e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
    }

    protected String getPlugPath() {
        String dir;
        block3: {
            dir = System.getProperty("user.home") + FS + Aladin.CACHE + FS + "Plugins";
            try {
                File f = new File(dir);
                if (!f.isDirectory() && !f.mkdir()) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                this.flagErrorDir = true;
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
        return dir;
    }

    protected void showFrame() {
        if (controleur == null) {
            controleur = new JFrame(Aladin.chaine.getString("PLUGINFO"));
            Aladin.setIcon(controleur);
            controleur.setLocation(50, 100);
            controleur.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    controleur.setVisible(false);
                }
            });
            JPanel p = new JPanel(new BorderLayout(5, 5));
            controleur.getContentPane().add(p);
            this.listPlugs = new JList(this);
            this.listPlugs.setVisibleRowCount(10);
            this.listPlugs.setFixedCellWidth(200);
            this.listPlugs.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Plugins.this.selectionne();
                }
            });
            p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel p1 = new JPanel(new BorderLayout());
            JTextArea t = new JTextArea(Aladin.chaine.getString("PLUGWARNING"));
            p1.add((Component)t, "North");
            t.setWrapStyleWord(true);
            t.setLineWrap(true);
            t.setEditable(false);
            t.setFont(t.getFont().deriveFont(2));
            t.setBackground(controleur.getContentPane().getBackground());
            JPanel p2 = new JPanel();
            p2.add(new JLabel(Aladin.chaine.getString("PLUGLOC")));
            JTextField g = new JTextField(this.getPlugPath(), 35);
            p2.add(g);
            g.setEditable(false);
            JButton b = new JButton(Aladin.chaine.getString("PLUGRELOAD"));
            p2.add(b);
            b.setToolTipText(Aladin.chaine.getString("PLUGRELOADTIP"));
            b.setMargin(new Insets(0, 0, 0, 0));
            b.setFont(b.getFont().deriveFont(0));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Plugins.this.reload();
                }
            });
            p1.add((Component)p2, "South");
            p.add((Component)p1, "North");
            p.add((Component)new JScrollPane(this.listPlugs), "West");
            this.plugDesc = new PluginDescription(this.aladin);
            p.add((Component)this.plugDesc, "Center");
            p1 = new JPanel();
            p1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            b = new JButton(Aladin.chaine.getString("PLUGDOWNLOAD"));
            p1.add(b);
            b.setToolTipText(Aladin.chaine.getString("PLUGDOWNLOADTIP"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Plugins)Plugins.this).aladin.glu.showDocument("Http", "http://aladin.cds.unistra.fr/java/nph-aladin.pl?frame=plugRep", true);
                }
            });
            b = new JButton(Aladin.chaine.getString("PLUGUPLOAD"));
            p1.add(b);
            b.setToolTipText(Aladin.chaine.getString("PLUGUPLOADTIP"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Plugins)Plugins.this).aladin.glu.showDocument("mailto:plugin@aladin.cds.unistra.fr?Subject=Aladin plugin&Body=%0A%0ADear Aladin team,%0A%0AYou will find, joined to this mail, my Aladin plugin source code%0A%0ABy this letter, I certify that this code does not content any spyware or other  malicious code. I certify the content of the author lists and other descriptions in the source code.%0A%0ABy this letter, I accept that the CDS team compiles this plugin and distributes the resulting compiled code [with/without] the source version.%0A%0A[***DO NOT FORGET TO ATTACH YOUR PLUGIN SOURCE CODE ***]");
                }
            });
            b = new JButton(Aladin.chaine.getString("PLUGADD"));
            p1.add(b);
            b.setToolTipText(Aladin.chaine.getString("PLUGADDTIP"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Plugins.this.addPlugin();
                }
            });
            b = this.removePlug = new JButton(Aladin.chaine.getString("PLUGREMOVE"));
            p1.add(this.removePlug);
            b.setToolTipText(Aladin.chaine.getString("PLUGREMOVETIP"));
            b.setEnabled(false);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Plugins.this.removePlugin();
                }
            });
            b = new JButton(Aladin.chaine.getString("PLUGMOREINFO"));
            p1.add(b);
            b.setToolTipText(Aladin.chaine.getString("PLUGMOREINFOTIP"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Plugins)Plugins.this).aladin.glu.showDocument("Http", "http://aladin.cds.unistra.fr/java/nph-aladin.pl?frame=plugins", true);
                }
            });
            b = new JButton(Aladin.chaine.getString("CLOSE"));
            p1.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controleur.setVisible(false);
                }
            });
            p.add((Component)p1, "South");
            new DropTarget(this.listPlugs, this);
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.listPlugs, 3, this);
            this.aladin.log("PluginControl", this.getSize() + " plugin" + (this.getSize() > 1 ? "s" : ""));
        }
        controleur.pack();
        controleur.setVisible(true);
        if (this.thread == null) {
            this.setThread(new Thread((Runnable)this, "AladinPluginControl")).start();
        }
    }

    @Override
    public void run() {
        Util.pause(1000);
        while (controleur != null && controleur.isVisible()) {
            this.plugDesc.resume();
            Util.pause(1000);
        }
        this.setThread(null);
    }

    private synchronized Thread setThread(Thread t) {
        this.thread = t;
        return this.thread;
    }

    private void selectionne() {
        String name = (String)this.listPlugs.getSelectedValue();
        AladinPlugin ap = this.find(name);
        this.plugDesc.setPlugin(ap);
        this.removePlug.setEnabled(this.listPlugs.getSelectedValue() != null);
    }

    private void removePlugin() {
        if (!Aladin.confirmation(controleur, Aladin.chaine.getString("PLUGCONF"))) {
            return;
        }
        Object[] s = this.listPlugs.getSelectedValues();
        for (int i = 0; i < s.length; ++i) {
            try {
                AladinPlugin ap = this.find((String)s[i]);
                String s1 = ap.getClass().getName();
                File f = new File(this.getPlugPath() + FS + s1 + ".class");
                boolean ok = f.delete();
                if (!ok) {
                    int j = s1.indexOf(46);
                    if (j > 0) {
                        s1 = s1.substring(j + 1);
                    }
                    f = new File(this.getPlugPath() + FS + s1 + ".jar");
                    ok = f.delete();
                }
                if (ok) {
                    Aladin.trace(3, "Remove " + f.getCanonicalPath());
                    continue;
                }
                Aladin.error("Cannot arrive to remove [" + f.getCanonicalPath() + "]");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.reload();
    }

    private void addPlugin() {
        try {
            FileDialog f = new FileDialog((Frame)controleur, "Plugin");
            f.setVisible(true);
            if (f.getFile() == null) {
                return;
            }
            File file = new File(f.getDirectory() + f.getFile());
            this.copyInPlug(file);
            Aladin.trace(3, "Copy " + file.getCanonicalPath());
            this.reload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reload() {
        if (this.flagErrorDir) {
            Aladin.error(controleur, "No access to the Aladin plugin directory !");
            return;
        }
        this.plugDesc.setPlugin(null);
        this.plugs.clear();
        this.scanDir(this.getPlugPath());
        this.listListener.contentsChanged(new ListDataEvent(this, 0, 0, this.plugs.size()));
        if (this.plugs.size() > 0) {
            this.listPlugs.setSelectedIndex(0);
            this.selectionne();
        }
        this.aladin.pluginReload();
    }

    private void scan(File dir) {
        Aladin.trace(3, "Scanning plugs in [" + dir + "]");
        this.scan(dir, 0);
        Collections.sort(this.plugs, this);
    }

    public int compare(Object a1, Object b1) {
        int bp;
        AladinPlugin a = (AladinPlugin)a1;
        AladinPlugin b = (AladinPlugin)b1;
        int ap = a.category() == null ? 0 : 1;
        int n = bp = b.category() == null ? 0 : 1;
        if (ap == bp) {
            return a.menu().compareTo(b.menu());
        }
        return bp - ap;
    }

    private void scan(File dir, int level) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] f = dir.listFiles();
        for (int i = 0; i < f.length; ++i) {
            if (f[i].isDirectory()) {
                this.scan(f[i], level + 1);
                continue;
            }
            String name = f[i].getAbsolutePath();
            if (name.endsWith(".jar")) {
                this.scanJar(name);
                continue;
            }
            if (!name.endsWith(".class") || name.indexOf(36) >= 0) continue;
            int pos = name.length() + 1;
            for (int j = level; j >= 0; --j) {
                pos = name.lastIndexOf(FS, pos - 1);
            }
            String n = name.substring(pos >= 0 ? pos + 1 : 0, name.length() - 6).replace(FS, '.');
            try {
                Class<?> plugin = this.classLoader.loadClass(n);
                this.tryToAdd(n, plugin);
                continue;
            }
            catch (Throwable e) {
                System.err.println("Cannot load plugin " + name + "\n ==> " + e.getMessage());
            }
        }
    }

    private boolean testVersion(AladinPlugin ap) {
        String version = ap.version();
        if (version == null) {
            return true;
        }
        int offset = Util.indexOfIgnoreCase(version, "Aladin v", 0);
        if (offset < 0) {
            return true;
        }
        return !(this.aladin.realNumVersion("v12.646") < this.aladin.realNumVersion(version.substring(offset + 7)));
    }

    private boolean tryToAdd(String name, Class plugin) throws Throwable {
        if (!name.equals("cds.aladin.AladinPlugin") && AladinPlugin.class.isAssignableFrom(plugin)) {
            Constructor ct = plugin.getConstructor(new Class[0]);
            AladinPlugin ap = (AladinPlugin)ct.newInstance(new Object[0]);
            if (!this.testVersion(ap)) {
                throw new Exception("Too old Aladin version for this plugin [" + ap.menu() + "=> " + ap.version() + "]");
            }
            ap.setAladin(this.aladin);
            if (this.find(ap.menu()) != null) {
                throw new Exception("Duplicated plugin [" + ap.menu() + "]");
            }
            Aladin.trace(3, "Plugin [" + name + "] loaded => " + ap.menu());
            this.plugs.add(ap);
            return true;
        }
        return false;
    }

    private void scanJar(String jarName) {
        boolean trouve = false;
        try {
            this.addInClassPath(jarName);
            ZipFile zipFile = new ZipFile(jarName);
            Enumeration<? extends ZipEntry> e1 = zipFile.entries();
            while (e1.hasMoreElements()) {
                ZipEntry entry = e1.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || name.indexOf(36) >= 0) continue;
                name = name.substring(0, name.length() - 6);
                name = name.replace('/', '.');
                try {
                    Class<?> plugin = this.classLoader.loadClass(name);
                    trouve = trouve || this.tryToAdd(name, plugin);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.err.println("Cannot load plugin " + name + "\n ==> " + e.getMessage());
                }
            }
            zipFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String[] getNames() {
        String[] names = new String[this.plugs.size()];
        Enumeration e = this.plugs.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            AladinPlugin ap = (AladinPlugin)e.nextElement();
            names[i] = (ap.category() != null ? ap.category() + "/" : "") + ap.menu();
            ++i;
        }
        return names;
    }

    protected AladinPlugin find(String name) {
        Enumeration e = this.plugs.elements();
        while (e.hasMoreElements()) {
            AladinPlugin ap = (AladinPlugin)e.nextElement();
            if (ap.menu().equalsIgnoreCase(name)) {
                return ap;
            }
            if (!name.equalsIgnoreCase(ap.scriptCommand())) continue;
            return ap;
        }
        return null;
    }

    protected AladinPlugin findScript(String cmd) {
        Enumeration e = this.plugs.elements();
        while (e.hasMoreElements()) {
            AladinPlugin ap = (AladinPlugin)e.nextElement();
            String s = ap.scriptCommand();
            if (s == null || !s.equals(cmd)) continue;
            return ap;
        }
        return null;
    }

    protected boolean execPlugin(String name) throws AladinException {
        AladinPlugin ap = this.find(name);
        if (ap == null) {
            return false;
        }
        boolean inThread = ap.inSeparatedThread();
        Aladin.trace(1, "Exec plugin " + (inThread ? "asynchroneously " : "") + " [" + name + "]...");
        if (inThread) {
            ap.start();
        } else {
            ap.exec();
        }
        return true;
    }

    protected String execPluginByScript(String cmd, String[] param) {
        AladinPlugin ap = this.findScript(cmd);
        if (ap == null) {
            return "Plugin " + cmd + " not found";
        }
        Aladin.trace(1, "Exec plugin by script [" + cmd + "]...");
        return ap.execScriptCommand(param);
    }

    protected void cleanup() {
        Enumeration e = this.plugs.elements();
        while (e.hasMoreElements()) {
            AladinPlugin ap = (AladinPlugin)e.nextElement();
            try {
                ap.cleanup();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean isSync() {
        Enumeration e = this.plugs.elements();
        while (e.hasMoreElements()) {
            AladinPlugin ap = (AladinPlugin)e.nextElement();
            if (!ap.hasBeenStarted() || ap.isSync()) continue;
            return false;
        }
        return true;
    }

    public Object getElementAt(int index) {
        return ((AladinPlugin)this.plugs.elementAt(index)).menu();
    }

    @Override
    public int getSize() {
        return this.plugs.size();
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listListener = l;
    }

    public class MyClassloader
    extends URLClassLoader {
        public MyClassloader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

