/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinException;
import cds.aladin.AladinPlugin;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PluginDescription
extends JPanel {
    private static String AUTHOR;
    private static String VERSION;
    private static String CAT;
    private static String ORIGIN;
    private static String STATE;
    private static String SCRIPT;
    private static String NOSUPPORT;
    private static String SCRIPTHELP;
    private static String THREAD;
    private static String RUNNING;
    private static String ACTIVE;
    private static String SUSPENDED;
    private static String IDLE;
    private static String START;
    private static String STOP;
    private static String SUSPEND;
    private static String RESUME;
    private Aladin aladin;
    private AladinPlugin ap;
    private JLabel name;
    private JLabel author;
    private JLabel version;
    private JLabel cat;
    private JLabel state;
    private JLabel script;
    private JLabel thread;
    private JLabel url;
    private JTextArea descr;
    private JButton start;
    private JButton stop;
    private JButton suspend;
    private JButton resume;
    private JButton help;
    private static final Dimension DIM;

    protected PluginDescription(Aladin a) {
        this.aladin = a;
        AUTHOR = "Author";
        VERSION = "Version";
        CAT = "Category";
        STATE = "State";
        ORIGIN = "Origin";
        SCRIPT = "Scripting";
        SCRIPTHELP = "Script usage?";
        NOSUPPORT = "Not supported";
        THREAD = "Threaded";
        RUNNING = "running";
        ACTIVE = "active";
        IDLE = "idle";
        START = "Start";
        STOP = "Stop";
        SUSPEND = "Suspend";
        SUSPENDED = "Sleeping";
        RESUME = "Resume";
        this.createPanel();
    }

    private String getInfo(String s) {
        if (s == null || s.trim().length() == 0) {
            return "";
        }
        return s;
    }

    private void createPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(1, 3, 1, 3);
        c.anchor = 17;
        Insets in = new Insets(1, 2, 1, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        c.gridx = 0;
        c.fill = 0;
        c.anchor = 10;
        c.insets.bottom += 5;
        JLabel l = this.name = new JLabel();
        p.add((Component)this.name, c);
        l.setFont(l.getFont().deriveFont(3, l.getFont().getSize2D() + 2.0f));
        l.setForeground(Aladin.COLOR_GREEN);
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets.bottom -= 5;
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(AUTHOR + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        l = this.author = new JLabel();
        p.add((Component)this.author, c);
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(VERSION + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        l = this.version = new JLabel();
        p.add((Component)this.version, c);
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(CAT + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        l = this.cat = new JLabel();
        p.add((Component)this.cat, c);
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(ORIGIN + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        l = this.url = new JLabel();
        p.add((Component)this.url, c);
        l.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (((JLabel)e.getSource()).getToolTipText() == null) {
                    return;
                }
                ((PluginDescription)PluginDescription.this).aladin.glu.showDocument("Http", ((JLabel)e.getSource()).getToolTipText(), true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (((JLabel)e.getSource()).getToolTipText() == null) {
                    return;
                }
                PluginDescription.this.url.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (((JLabel)e.getSource()).getToolTipText() == null) {
                    return;
                }
                PluginDescription.this.url.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (((JLabel)e.getSource()).getToolTipText() == null) {
                    return;
                }
                PluginDescription.this.url.setForeground(new Color(128, 0, 128));
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.gridwidth = 2;
        c.insets.top += 5;
        c.weighty = 1.0;
        c.weightx = 1.0;
        JTextArea t = this.descr = new JTextArea();
        p.add((Component)new JScrollPane(this.descr), c);
        t.setWrapStyleWord(true);
        t.setLineWrap(true);
        t.setEditable(false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets.top -= 5;
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(SCRIPT + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        l = this.script = new JLabel();
        p.add((Component)this.script, c);
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(THREAD + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        l = this.thread = new JLabel();
        p.add((Component)this.thread, c);
        l.setFont(l.getFont().deriveFont(0));
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(STATE + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        this.state = l = new JLabel();
        p.add((Component)l, c);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)p, "Center");
        p = new JPanel();
        JButton b = this.help = new JButton(SCRIPTHELP);
        p.add(this.help);
        b.setMargin(in);
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginDescription.this.ap.scriptHelp() == null) {
                    return;
                }
                ((PluginDescription)PluginDescription.this).aladin.command.execHelpCmd(PluginDescription.this.ap.scriptHelp());
                ((PluginDescription)PluginDescription.this).aladin.f.toFront();
            }
        });
        this.start = b = new JButton(START);
        p.add(b);
        b.setEnabled(false);
        b.setMargin(in);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PluginDescription.this.ap.start();
                }
                catch (AladinException e1) {
                    e1.printStackTrace();
                    PluginDescription.this.aladin;
                    Aladin aladin = PluginDescription.this.aladin;
                    StringBuilder stringBuilder = new StringBuilder();
                    PluginDescription.this.aladin;
                    Aladin.error(aladin, stringBuilder.append(Aladin.chaine.getString("PLUGERROR")).append("\n\n").append(e1.getMessage()).toString());
                }
                Util.pause(100);
                PluginDescription.this.resume();
            }
        });
        this.stop = b = new JButton(STOP);
        p.add(b);
        b.setEnabled(false);
        b.setMargin(in);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginDescription.this.ap.stop();
                Util.pause(100);
                PluginDescription.this.resume();
            }
        });
        this.suspend = b = new JButton(SUSPEND);
        p.add(b);
        b.setEnabled(false);
        b.setMargin(in);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginDescription.this.ap.suspend();
                Util.pause(100);
                PluginDescription.this.resume();
            }
        });
        this.resume = b = new JButton(RESUME);
        p.add(b);
        b.setEnabled(false);
        b.setMargin(in);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginDescription.this.ap.resume();
                Util.pause(100);
                PluginDescription.this.resume();
            }
        });
        this.add((Component)p, "South");
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public Dimension getPreferredSize() {
        return DIM;
    }

    protected void setPlugin(AladinPlugin ap) {
        this.ap = ap;
        this.name.setText(ap == null ? "" : this.getInfo(ap.menu()));
        this.author.setText(ap == null ? "" : this.getInfo(ap.author()));
        this.version.setText(ap == null ? "" : this.getInfo(ap.version()));
        this.descr.setText(ap == null ? "" : this.getInfo(ap.description()));
        this.script.setText(ap == null ? "" : (ap.scriptCommand() == null ? NOSUPPORT : ap.scriptCommand()) + "   ");
        if (ap != null) {
            this.script.setFont(this.script.getFont().deriveFont(ap.scriptCommand() == null ? 0 : 1));
        }
        this.thread.setText(ap == null ? "" : (ap.inSeparatedThread() ? "true" : "false"));
        this.cat.setText(ap == null ? "" : this.getInfo(ap.category()));
        this.help.setEnabled(ap == null ? false : ap.scriptHelp() != null);
        this.url.setText(ap == null ? "" : this.getInfo(ap.url()));
        if (ap == null) {
            this.url.setText("");
        } else if (ap.url() != null) {
            this.url.setForeground(Color.blue);
            Util.toolTip(this.url, ap.url());
            this.url.setText(PluginDescription.cut(ap.url(), 60));
        } else {
            Util.toolTip(this.url, null);
        }
        this.resume();
    }

    protected void resume() {
        boolean suspended;
        if (this.ap == null) {
            this.state.setText("");
            this.start.setEnabled(false);
            this.stop.setEnabled(false);
            this.resume.setEnabled(false);
            this.suspend.setEnabled(false);
            return;
        }
        boolean threaded = this.ap.inSeparatedThread();
        boolean running = suspended = this.ap.isSuspended();
        this.state.setText(suspended ? SUSPENDED : (!(running = this.ap.isRunning()) ? IDLE : (threaded ? RUNNING : ACTIVE)));
        this.state.setForeground(suspended ? Color.orange : (running ? Color.red : Aladin.COLOR_GREEN));
        this.start.setEnabled(!running);
        this.stop.setEnabled(running);
        this.resume.setEnabled(threaded && running && suspended);
        this.suspend.setEnabled(threaded && running && !suspended);
    }

    static String cut(String s, int m) {
        int n = s.length();
        if (n <= m) {
            return s;
        }
        return s.substring(0, m - 2) + "...";
    }

    static {
        DIM = new Dimension(400, 400);
    }
}

