/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.prop.PropPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlasticPreferences
extends JFrame
implements ActionListener {
    protected static final String PREF_AUTOCONNECT = "PlasticAutoconnect";
    protected static final String PREF_LAUNCHHUB = "PlasticLaunchHub";
    protected static final String PREF_SENDPOS = "PlasticSendPos";
    protected static final String PREF_SELECT = "PlasticSelect";
    protected static final String PREF_HIGHLIGHT = "PlasticHighlight";
    static String TITLE;
    static String DEFAUTOCONNECT;
    static String AUTOCONNECT;
    static String DEFLAUNCHHUB;
    static String LAUNCHHUB;
    static String DEFSELECTOBJECTS;
    static String SELECTOBJECTS;
    static String DEFHIGHLIGHTOBJECT;
    static String HIGHLIGHTOBJECT;
    static String DEFSENDPOSITION;
    static String SENDPOSITION;
    static String APPLY;
    static String CLOSE;
    private JCheckBox autoconnectCb;
    private JCheckBox launchhubCb;
    private JCheckBox selectobjectsCb;
    private JCheckBox highlightCb;
    private JCheckBox sendpositionCb;
    private Aladin a;

    public PlasticPreferences(Aladin a) {
        this.a = a;
        Aladin.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PlasticPreferences.this.setVisible(false);
            }
        });
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 7, 5, 7));
        this.buildFrame();
    }

    private void buildFrame() {
        this.createChaine();
        this.setTitle(TITLE);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JLabel info = new JLabel(TITLE, 0);
        info.setFont(Aladin.LITALIC);
        Aladin.makeAdd(this.getContentPane(), info, "North");
        Aladin.makeAdd(this.getContentPane(), this.createPanel(), "Center");
        Aladin.makeAdd(this.getContentPane(), this.getValidPanel(), "South");
        this.pack();
    }

    private JPanel createPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        PropPanel.addFilet(p, g, c);
        PropPanel.addSectionTitle(p, DEFAUTOCONNECT, g, c);
        this.autoconnectCb = new JCheckBox(AUTOCONNECT);
        PropPanel.addCouple(p, "", this.autoconnectCb, g, c);
        PropPanel.addFilet(p, g, c);
        PropPanel.addSectionTitle(p, DEFLAUNCHHUB, g, c);
        this.launchhubCb = new JCheckBox(LAUNCHHUB);
        PropPanel.addCouple(p, "", this.launchhubCb, g, c);
        PropPanel.addFilet(p, g, c);
        PropPanel.addSectionTitle(p, DEFSELECTOBJECTS, g, c);
        this.selectobjectsCb = new JCheckBox(SELECTOBJECTS);
        PropPanel.addCouple(p, "", this.selectobjectsCb, g, c);
        PropPanel.addFilet(p, g, c);
        PropPanel.addSectionTitle(p, DEFHIGHLIGHTOBJECT, g, c);
        this.highlightCb = new JCheckBox(HIGHLIGHTOBJECT);
        PropPanel.addCouple(p, "", this.highlightCb, g, c);
        PropPanel.addFilet(p, g, c);
        PropPanel.addSectionTitle(p, DEFSENDPOSITION, g, c);
        this.sendpositionCb = new JCheckBox(SENDPOSITION);
        PropPanel.addCouple(p, "", this.sendpositionCb, g, c);
        PropPanel.addFilet(p, g, c);
        return p;
    }

    private JPanel getValidPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        p.setFont(Aladin.LBOLD);
        JButton b = new JButton(APPLY);
        p.add(b);
        b.addActionListener(this);
        b = new JButton(CLOSE);
        p.add(b);
        b.addActionListener(this);
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String what = ae.getActionCommand();
        if (CLOSE.equals(what)) {
            this.setVisible(false);
        } else if (APPLY.equals(what)) {
            try {
                if (this.apply()) {
                    this.setVisible(false);
                }
            }
            catch (Exception e) {
                Aladin.error(this, " " + e.getMessage(), 1);
            }
        }
    }

    public boolean apply() {
        this.a.configuration.set(PREF_AUTOCONNECT, String.valueOf(this.autoconnectCb.isSelected()));
        this.a.configuration.set(PREF_LAUNCHHUB, String.valueOf(this.launchhubCb.isSelected()));
        this.a.configuration.set(PREF_SELECT, String.valueOf(this.selectobjectsCb.isSelected()));
        this.a.configuration.set(PREF_HIGHLIGHT, String.valueOf(this.highlightCb.isSelected()));
        this.a.configuration.set(PREF_SENDPOS, String.valueOf(this.sendpositionCb.isSelected()));
        this.a.saveConfig();
        return true;
    }

    protected void showPrefs() {
        this.updateCbState();
        this.setVisible(true);
        this.toFront();
    }

    protected boolean getBooleanValue(String propName) {
        String s = this.a.configuration.get(propName);
        return s == null ? this.getDefaultValue(propName) : new Boolean(s).booleanValue();
    }

    private boolean getDefaultValue(String propName) {
        return true;
    }

    private void updateCbState() {
        String s = this.a.configuration.get(PREF_AUTOCONNECT);
        boolean state = s == null ? this.getDefaultValue(PREF_AUTOCONNECT) : new Boolean(s).booleanValue();
        this.autoconnectCb.setSelected(state);
        s = this.a.configuration.get(PREF_LAUNCHHUB);
        state = s == null ? this.getDefaultValue(PREF_LAUNCHHUB) : new Boolean(s).booleanValue();
        this.launchhubCb.setSelected(state);
        s = this.a.configuration.get(PREF_SELECT);
        state = s == null ? this.getDefaultValue(PREF_SELECT) : new Boolean(s).booleanValue();
        this.selectobjectsCb.setSelected(state);
        s = this.a.configuration.get(PREF_HIGHLIGHT);
        state = s == null ? this.getDefaultValue(PREF_HIGHLIGHT) : new Boolean(s).booleanValue();
        this.highlightCb.setSelected(state);
        s = this.a.configuration.get(PREF_SENDPOS);
        state = s == null ? this.getDefaultValue(PREF_SENDPOS) : new Boolean(s).booleanValue();
        this.sendpositionCb.setSelected(state);
    }

    private void createChaine() {
        TITLE = Aladin.chaine.getString("PPTITLE");
        DEFAUTOCONNECT = Aladin.chaine.getString("PPDEFAUTOCONNECT");
        AUTOCONNECT = Aladin.chaine.getString("PPAUTOCONNECT");
        DEFLAUNCHHUB = Aladin.chaine.getString("PPDEFLAUNCHHUB");
        LAUNCHHUB = Aladin.chaine.getString("PPLAUNCHHUB");
        DEFSELECTOBJECTS = Aladin.chaine.getString("PPDEFSELECTOBJECTS");
        SELECTOBJECTS = Aladin.chaine.getString("PPSELECTOBJECTS");
        DEFHIGHLIGHTOBJECT = Aladin.chaine.getString("PPDEFHIGHLIGHTOBJECT");
        HIGHLIGHTOBJECT = Aladin.chaine.getString("PPHIGHLIGHTOBJECT");
        DEFSENDPOSITION = Aladin.chaine.getString("PPDEFSENDPOSITION");
        SENDPOSITION = Aladin.chaine.getString("PPSENDPOSITION");
        APPLY = Aladin.chaine.getString("UPAPPLY");
        CLOSE = Aladin.chaine.getString("UPCLOSE");
    }
}

