/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.PlanMoc1D;
import cds.aladin.Plot;
import cds.aladin.ViewSimple;
import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.Graphics;

public class PlanMocT
extends PlanMoc1D {
    private static final int MAXDRAWCELL = 300;
    private static final int MINLIMIT = 9;

    public PlanMocT(Aladin a) {
        super(a);
        this.type = 24;
    }

    protected PlanMocT(Aladin aladin, MyInputStream in, String label, String url) {
        super(aladin, 24, in, null, label, url);
    }

    protected PlanMocT(Aladin aladin, TMoc moc, String label, String url) {
        super(aladin, 24, null, moc, label, url);
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        boolean isEmpty = this.moc.isEmpty();
        if (!isEmpty) {
            PlanMocT.ADD(buf, "\n* Start: ", Astrodate.JDToDate(this.getMin()));
            PlanMocT.ADD(buf, "\n* End: ", Astrodate.JDToDate(this.getMax()));
        }
        PlanMocT.ADD(buf, "\n* # ranges: ", this.moc.getNbRanges() + "");
        int order = ((Moc1D)this.moc).getMocOrder();
        int drawOrder = isEmpty ? -1 : this.getDrawOrder1D();
        PlanMocT.ADD(buf, "\n", "* Resolution: " + Util.getTemps(TMoc.getDuration(order)));
        PlanMocT.ADD(buf, "\n", "* Order: " + (order == drawOrder ? order + "" : drawOrder + "/" + order));
        if (isEmpty) {
            PlanMocT.ADD(buf, "\n \nRAM: ", Util.getUnitDisk(this.moc.getMem()));
        }
    }

    @Override
    protected boolean isTime() {
        return true;
    }

    @Override
    protected double getMin() {
        double tmin = ((TMoc)this.moc).getTimeMin();
        if (tmin == -1.0) {
            tmin = Double.NaN;
        }
        return tmin;
    }

    @Override
    protected double getMax() {
        double tmax = ((TMoc)this.moc).getTimeMax();
        if (tmax == -1.0) {
            tmax = Double.NaN;
        }
        return tmax;
    }

    @Override
    protected double[] getTimeRange() {
        return new double[]{this.getMin(), this.getMax()};
    }

    @Override
    protected Moc createOneMoc() {
        return new TMoc();
    }

    @Override
    protected int getDrawingOrder(ViewSimple v) {
        int o;
        Plot plot = v.plot;
        double dureeView = plot.getMax() - plot.getMin();
        for (o = 61; o >= 9; --o) {
            double nbCell = dureeView / ((double)TMoc.getDuration(o) / 8.64E10);
            if (!(nbCell < 300.0)) continue;
            return o;
        }
        return o;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        if (!v.isPlotTime()) {
            return;
        }
        this.drawIn1DView(g, v);
    }

    protected void drawInTimeView(Graphics g, ViewSimple v) {
        this.drawIn1DView(g, v);
    }

    @Override
    protected int getStackIndex() {
        return this.timeStackIndex;
    }

    @Override
    protected double getValue(long hash) {
        return TMoc.getTime(hash);
    }

    @Override
    protected void planReadyPost() {
        this.aladin.view.createView4TMOC(this);
    }
}

