/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Couleur;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.PlanMocAlgo;
import cds.aladin.PlanMocST;
import cds.moc.Moc;
import cds.moc.STMoc;

public class PlanMocSTAlgo
extends PlanMocST {
    public PlanMocSTAlgo(Aladin aladin, String label, PlanMoc[] pList, int op, int spaceOrder, int timeOrder, long maxSize, String maxPriority) {
        super(aladin);
        PlanMoc p1 = pList[0];
        p1.copy(this);
        this.type = 25;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String s = PlanMocSTAlgo.getFonction(p1, pList, op, timeOrder);
        if (label == null) {
            label = s;
        }
        this.setLabel(label);
        Aladin.trace(3, "STMOC computation: " + Plan.TYPE[this.type] + " => " + s);
        try {
            this.moc = p1.getMoc().clone();
            if (op == 4) {
                this.moc = this.moc.complement();
            } else if (op == 5) {
                ((STMoc)this.moc).setMocOrder(timeOrder, spaceOrder);
            } else {
                block12: for (int i = 1; i < pList.length; ++i) {
                    Moc m1 = this.moc;
                    Moc m2 = pList[i].getMoc();
                    if (!this.isCompatible(m1, m2)) {
                        throw new Exception("Uncompatible MOCs");
                    }
                    try {
                        if (timeOrder >= 0) {
                            m1.setTimeOrder(timeOrder);
                            m2.setTimeOrder(timeOrder);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (spaceOrder >= 0) {
                            m1.setSpaceOrder(spaceOrder);
                            m2.setSpaceOrder(spaceOrder);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    switch (op) {
                        case 0: {
                            this.moc = m1.union(m2);
                            continue block12;
                        }
                        case 1: {
                            this.moc = m1.intersection(m2);
                            continue block12;
                        }
                        case 2: {
                            this.moc = m1.subtraction(m2);
                            continue block12;
                        }
                        case 3: {
                            this.moc = m1.difference(m2);
                        }
                    }
                }
            }
            if (maxSize != -1L) {
                ((STMoc)this.moc).reduction(maxSize, maxPriority);
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = e.getMessage();
            this.flagOk = false;
        }
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        this.flagOk = true;
        this.setActivated(this.flagOk);
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + s + "]");
    }

    private boolean isCompatible(Moc m1, Moc m2) {
        String a = m1.getSpaceSys();
        String b = m2.getSpaceSys();
        if (!(a == null && b == null || a.equals(b))) {
            return false;
        }
        a = m1.getTimeSys();
        b = m2.getTimeSys();
        return a == null && b == null || a.equals(b);
    }

    @Override
    protected void launchLoading() {
    }

    private static String getFonction(PlanMoc p1, PlanMoc[] pList, int op, int order) {
        return PlanMocAlgo.getFonction(p1, pList, op, order);
    }
}

