/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanMoc1D;
import cds.aladin.PlanMocFromST;
import cds.aladin.PlanMocT;
import cds.aladin.PlanMocTFromST;
import cds.aladin.RectangleD;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class PlanMocST
extends PlanMocT {
    private PlanMocFromST smocH = null;
    private PlanMocTFromST tmocH = null;
    private PlanMocFromST smocS = null;
    private PlanMocTFromST tmocS = null;
    private double cov = -1.0;
    private double[] oLastDrawTimeRange = null;
    private SMoc oLastDrawMoc = null;
    private SMoc lastCurrentSpaceMoc = null;
    private TMoc lastCurrentTimeMoc = null;
    private RectangleD lastR = null;
    private Hpix lastHpix = null;

    public PlanMocST(Aladin a) {
        super(a);
        this.type = 25;
        this.initST();
    }

    protected PlanMocST(Aladin aladin, MyInputStream in, String label, Coord c, double radius, String url) {
        super(aladin);
        this.dis = in;
        this.url = url;
        this.type = 25;
        this.useCache = false;
        this.frameOrigin = 0;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "STMOC";
        }
        this.setLabel(label);
        this.co = c;
        this.coRadius = radius;
        Aladin.trace(3, "STMOC creation: " + Plan.TYPE[this.type] + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected PlanMocST(Aladin aladin, STMoc moc, String label, Coord c, double radius, String url) {
        super(aladin);
        this.moc = moc;
        this.url = url;
        this.useCache = false;
        this.frameOrigin = 0;
        this.type = 25;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "STMOC";
        }
        this.setLabel(label);
        this.co = c;
        this.coRadius = radius;
        Aladin.trace(3, "STMOC creation: " + Plan.TYPE[this.type] + (c != null ? " around " + c : ""));
        this.suite();
    }

    @Override
    protected void suiteSpecific() {
        super.suiteSpecific();
        this.initST();
    }

    protected boolean isOneTimeRange() {
        return false;
    }

    protected void changeTimeRange(double jdmin, double jdmax) throws Exception {
        if (!this.isOneTimeRange()) {
            throw new Exception("Not a oneTimeRange STMOC");
        }
        long min = TMoc.getNpix(jdmin);
        long max = TMoc.getNpix(jdmax) + 1L;
        STMoc m = (STMoc)this.moc;
        m.range.r[0] = min;
        m.range.r[1] = max;
    }

    private double getFullCoverage() {
        if (this.cov >= 0.0) {
            return this.cov;
        }
        if (this.cov == -2.0) {
            return -1.0;
        }
        this.cov = -2.0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PlanMocST.this.cov = ((STMoc)PlanMocST.this.moc).getSpaceMoc().getCoverage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return this.cov;
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        boolean timeEmpty;
        STMoc stmoc = (STMoc)this.moc;
        boolean bl = timeEmpty = stmoc.getTimeMin() == -1.0;
        if (!timeEmpty) {
            PlanMocST.ADD(buf, "\n* Start: ", Astrodate.JDToDate(stmoc.getTimeMin()));
            PlanMocST.ADD(buf, "\n* End: ", Astrodate.JDToDate(stmoc.getTimeMax()));
        }
        PlanMocST.ADD(buf, "\n* # ranges: ", stmoc.getNbRanges() + "");
        int timeOrder = stmoc.getTimeOrder();
        PlanMocST.ADD(buf, "\n* Time res: ", Util.getTemps(TMoc.getDuration(timeOrder)));
        int drawOrder = timeEmpty ? -1 : this.getDrawOrder1D();
        PlanMocST.ADD(buf, "\n", "* Time order: " + (timeOrder == drawOrder ? timeOrder + "" : "draw:" + drawOrder + "/" + timeOrder));
        double cov = this.getFullCoverage();
        boolean spaceEmpty = cov == 0.0;
        double degrad = Math.toDegrees(1.0);
        double skyArea = Math.PI * 4 * degrad * degrad;
        String body = this.getBody();
        if (body == null) {
            body = "?";
        }
        PlanMocST.ADD(buf, "\n \n* Space: ", spaceEmpty ? "--empty--" : Coord.getUnit(skyArea * cov, false, true) + "^2, " + Util.round(cov * 100.0, 3) + "% of " + body);
        int spaceOrder = stmoc.getSpaceOrder();
        PlanMocST.ADD(buf, "\n* Space res: ", Coord.getUnit(CDSHealpix.pixRes(spaceOrder) / 3600.0));
        drawOrder = spaceEmpty ? -1 : this.getSpaceDrawOrder();
        PlanMocST.ADD(buf, "\n", "* Space order: " + (drawOrder == -1 ? Integer.valueOf(spaceOrder) : (spaceOrder == drawOrder ? spaceOrder + "" : "draw:" + drawOrder + "/" + spaceOrder)));
        if (!spaceEmpty || !timeEmpty) {
            PlanMocST.ADD(buf, "\n \nRAM: ", Util.getUnitDisk(stmoc.getMem()));
        }
    }

    protected int getSpaceDrawOrder() {
        return this.lastOrderDrawn;
    }

    @Override
    protected double getMin() {
        double tmin = ((STMoc)this.moc).getTimeMin();
        if (tmin == -1.0) {
            tmin = Double.NaN;
        }
        return tmin;
    }

    @Override
    protected double getMax() {
        double tmax = ((STMoc)this.moc).getTimeMax();
        if (tmax == -1.0) {
            tmax = Double.NaN;
        }
        return tmax;
    }

    @Override
    protected boolean waitForPlan() {
        if (this.dis != null) {
            this.error = null;
            try {
                if (this.moc == null && this.dis != null) {
                    this.moc = this.createOneMoc();
                    this.readMoc(this.moc, this.dis);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                this.error = "MOC error";
                return false;
            }
        }
        this.analyseMoc(this.moc);
        return true;
    }

    protected SMoc getCurrentSpaceMoc(ViewSimple v) throws Exception {
        return this.getCurrentSpaceMoc(v, false);
    }

    protected SMoc getCurrentSpaceMoc(ViewSimple v, boolean echoCommand) throws Exception {
        long tmax;
        double[] t = v.getTimeRange();
        if (v == this.aladin.view.getCurrentView()) {
            this.oLastDrawTimeRange = t;
        }
        long tmin = Double.isNaN(t[0]) ? -1L : TMoc.getNpix(t[0]);
        long l = tmax = Double.isNaN(t[1]) ? Long.MAX_VALUE : TMoc.getNpix(t[1]);
        if (echoCommand) {
            String range = Double.isNaN(t[0]) && Double.isNaN(t[1]) ? "" : (Double.isNaN(t[0]) ? " -timeRange=NaN/" + Astrodate.JDToDate(t[1]) : (Double.isNaN(t[1]) ? " -timeRange=" + Astrodate.JDToDate(t[0]) + "/NaN" : " -timeRange=" + Astrodate.JDToDate(t[0]) + "/" + Astrodate.JDToDate(t[1])));
            this.aladin.console.printCommand("cmoc" + range + " " + Tok.quote(this.label));
        }
        try {
            return ((STMoc)this.moc).getSpaceMoc(tmin, tmax);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected SMoc getCurrentSpaceMoc(ViewSimple v, STMoc moc) throws Exception {
        double[] t = v.getTimeRange();
        if (v == this.aladin.view.getCurrentView()) {
            this.oLastDrawTimeRange = t;
        }
        long tmin = Double.isNaN(t[0]) ? -1L : TMoc.getNpix(t[0]);
        long tmax = Double.isNaN(t[1]) ? Long.MAX_VALUE : TMoc.getNpix(t[1]);
        try {
            return moc.getSpaceMoc(tmin, tmax);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected TMoc getCurrentTimeMoc() {
        try {
            return ((STMoc)this.moc).getTimeMoc(this.isDisplayedInView() ? this.oLastDrawMoc : null);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected STMoc getCurrentSpaceTimeMoc() {
        try {
            return new STMoc((TMoc)this.tmocS.moc, (SMoc)this.smocS.moc);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected boolean hasSelection() {
        return true;
    }

    private boolean isDisplayedInView() {
        int m = this.aladin.view.getNbView();
        for (int i = 0; i < m; ++i) {
            ViewSimple v = this.aladin.view.viewSimple[i];
            if (v.isFree() || !v.selected || v.isPlotTime()) continue;
            return true;
        }
        return false;
    }

    private ViewSimple getViewPlot() {
        int m = this.aladin.view.getNbView();
        for (int i = 0; i < m; ++i) {
            if (!this.aladin.view.viewSimple[i].isPlotTime()) continue;
            return this.aladin.view.viewSimple[i];
        }
        return null;
    }

    private boolean isDisplayedInPlot() {
        ViewSimple v = this.getViewPlot();
        return v != null && v.selected;
    }

    @Override
    protected void memoNewTime() {
        ViewSimple v = this.aladin.view.getCurrentView();
        this.oLastDrawTimeRange = v.getTimeRange();
        this.oiz = -1L;
        this.askForRepaint();
    }

    protected void memoNewSpace() {
        this.oLastDrawMoc = this.isDisplayedInView() ? this.getLastDrawMoc() : null;
        this.mocLowReset();
        this.oiz = -1L;
        this.askForRepaint();
    }

    protected boolean isSpaceModified() {
        if (!this.isDisplayedInPlot()) {
            return false;
        }
        SMoc m = this.isDisplayedInView() ? this.getLastDrawMoc() : null;
        boolean rep = !this.mocEquals(m, this.oLastDrawMoc);
        return rep;
    }

    public boolean mocEquals(Moc m1, Moc m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return ((SMoc)m1).equals(m2);
    }

    @Override
    protected boolean isTimeModified() {
        ViewSimple v = this.aladin.view.getCurrentView();
        double[] t = v.getTimeRange();
        boolean rep = (Double.isNaN(t[0]) && Double.isNaN(this.oLastDrawTimeRange[0]) || t[0] == this.oLastDrawTimeRange[0]) && (Double.isNaN(t[1]) && Double.isNaN(this.oLastDrawTimeRange[1]) || t[1] == this.oLastDrawTimeRange[1]);
        return !rep;
    }

    @Override
    protected SMoc getSpaceMocLow(ViewSimple v, int order, int gapOrder) {
        SMoc m;
        block3: {
            STMoc m1 = (STMoc)this.getSpaceMocLow1(v, order, gapOrder);
            m = null;
            try {
                m = this.getCurrentSpaceMoc(v, m1);
                if (m.getMocOrder() >= 3) {
                    m.setMinOrder(3);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
        return m;
    }

    @Override
    protected Moc createOneMoc() {
        return new STMoc();
    }

    @Override
    protected SMoc getSpaceMoc() {
        SMoc m;
        block3: {
            ViewSimple v = this.aladin.view.getCurrentView();
            if (this.lastCurrentSpaceMoc != null && !this.isTimeModified()) {
                return this.lastCurrentSpaceMoc;
            }
            m = null;
            try {
                m = this.getCurrentSpaceMoc(v);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
        this.lastCurrentSpaceMoc = m;
        this.memoNewTime();
        return this.lastCurrentSpaceMoc;
    }

    protected TMoc getTimeMoc() {
        TMoc m;
        if (this.lastCurrentTimeMoc != null && !this.isSpaceModified()) {
            return this.lastCurrentTimeMoc;
        }
        this.lastCurrentTimeMoc = m = this.getCurrentTimeMoc();
        this.memoNewSpace();
        return this.lastCurrentTimeMoc;
    }

    private void initST() {
        this.smocH = new PlanMocFromST(this, false);
        this.tmocH = new PlanMocTFromST(this, false);
        this.smocS = new PlanMocFromST(this, true);
        this.tmocS = new PlanMocTFromST(this, true);
    }

    private void repaintST() {
        this.tmocS.oiz = -2L;
        this.smocS.oiz = -2L;
        this.tmocH.oiz = -2L;
        this.smocH.oiz = -2L;
        this.aladin.view.repaintAll();
    }

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        if (v.isPlotTime()) {
            this.drawInTimeView(g, v);
            if (this.aladin.view.isMultiView()) {
                this.tmocS.drawInTimeView(g, v);
                this.tmocH.drawInTimeView(g, v);
            }
        } else {
            this.drawInSpaceView(g, v);
            if (this.aladin.view.isMultiView()) {
                this.smocS.drawInSpaceView(g, v);
                this.smocH.drawInSpaceView(g, v);
            }
        }
    }

    private boolean isDiff(Moc s1, Moc s2) {
        return s1 == null && s2 != null || s1 != null && !s1.equals(s2);
    }

    public boolean inTimeView(ViewSimple v, MouseEvent e, boolean select) {
        if (this.lastRectDrawn == null) {
            return false;
        }
        if (!Aladin.MOC2DSELECTABLE) {
            select = false;
        }
        String info = null;
        int xview = e.getX();
        int yview = e.getY();
        boolean trouve = false;
        SMoc sh = (SMoc)this.smocH.moc;
        TMoc th = (TMoc)this.tmocH.moc;
        SMoc ss = (SMoc)this.smocS.moc;
        TMoc ts = (TMoc)this.tmocS.moc;
        Iterator iterator = this.lastRectDrawn.iterator();
        while (iterator.hasNext()) {
            PlanMoc1D.MyRect r;
            PlanMoc1D.MyRect r1 = r = (PlanMoc1D.MyRect)iterator.next();
            if (r.width < 2.0) {
                r1 = new PlanMoc1D.MyRect(r.x - 1.0, r.y, 3.0, r.height);
            }
            if (!r1.contains(xview, yview)) continue;
            if (select && this.lastR == r) {
                return true;
            }
            this.lastR = r;
            try {
                STMoc m1;
                th = new TMoc();
                th.add(61, r.start, r.end - 1L);
                STMoc m = (STMoc)this.moc;
                if (!select && m.getNbCells() > 10000 && r.order <= 30 && (m1 = (STMoc)this.getLastLowMoc()) != null) {
                    m = m1;
                }
                sh = m.getSpaceMoc(r.start, r.end - 1L);
                trouve = true;
                if (select) {
                    if (ts != null && e.isShiftDown()) {
                        ss = ss.union(sh);
                        ts = ts.union(th);
                    } else if (ss == null || e.isControlDown()) {
                        ss = sh;
                        ts = th;
                    } else {
                        ss = null;
                        ts = null;
                    }
                }
                String start = Astrodate.JDToDate(TMoc.getTime(r.start), true, true);
                int t1 = start.indexOf(84);
                String end = Astrodate.JDToDate(TMoc.getTime(r.end - 1L), true, true);
                int t2 = end.indexOf(84);
                info = "\n \n* Start: " + start.substring(0, t1) + "\n   " + start.substring(t1 + 1) + "\n\n \n* End: " + end.substring(0, t2) + "\n   " + end.substring(t2 + 1) + "\n\n \n* Duration: " + Util.getTemps(r.end - r.start);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            break;
        }
        if (!trouve) {
            sh = null;
            th = null;
        }
        if (this.updateMocSH(sh, th, ss, ts)) {
            this.repaintST();
            this.aladin.calque.select.setMessageInfo(info);
        }
        return trouve;
    }

    private boolean updateMocSH(Moc sh, Moc th, Moc ss, Moc ts) {
        boolean update = false;
        if (this.isDiff(sh, this.smocH.moc)) {
            update = true;
            this.smocH.moc = sh;
            this.smocH.arrayMoc = null;
        }
        if (this.isDiff(th, this.tmocH.moc)) {
            update = true;
            this.tmocH.moc = th;
            this.tmocH.arrayMoc = null;
        }
        if (this.isDiff(ss, this.smocS.moc)) {
            update = true;
            this.smocS.moc = ss;
            this.smocS.arrayMoc = null;
        }
        if (this.isDiff(ts, this.tmocS.moc)) {
            update = true;
            this.tmocS.moc = ts;
            this.tmocS.arrayMoc = null;
        }
        return update;
    }

    public boolean inSpaceView(ViewSimple v, MouseEvent e, boolean select) {
        if (this.arrayHpix == null) {
            return false;
        }
        int xview = e.getX();
        int yview = e.getY();
        boolean trouve = false;
        SMoc sh = (SMoc)this.smocH.moc;
        TMoc th = (TMoc)this.tmocH.moc;
        SMoc ss = (SMoc)this.smocS.moc;
        TMoc ts = (TMoc)this.tmocS.moc;
        for (Hpix r : this.arrayHpix) {
            if (!r.contains(v, xview, yview)) continue;
            if (!select && this.lastHpix == r) {
                return true;
            }
            this.lastHpix = r;
            try {
                sh = new SMoc();
                sh.add(r.order, r.start);
                th = ((STMoc)this.moc).getTimeMoc(sh);
                trouve = true;
                if (!select) break;
                if (ss != null && e.isShiftDown()) {
                    ss = ss.union(sh);
                    ts = ts.union(th);
                    break;
                }
                if (ss == null || e.isControlDown()) {
                    ss = sh;
                    ts = th;
                    break;
                }
                ss = null;
                ts = null;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            break;
        }
        if (!trouve) {
            sh = null;
            th = null;
        }
        if (this.updateMocSH(sh, th, ss, ts)) {
            this.repaintST();
            this.aladin.calque.select.setMessageInfo("");
        }
        return trouve;
    }

    @Override
    protected void planReadyPost() {
        this.aladin.view.createView4TMOC(this);
    }
}

