/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanMoc1D;
import cds.aladin.PlanMocF;
import cds.aladin.PlanMocFFromSF;
import cds.aladin.PlanMocFromSF;
import cds.aladin.RectangleD;
import cds.aladin.SED;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.moc.FMoc;
import cds.moc.Moc;
import cds.moc.SFMoc;
import cds.moc.SMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class PlanMocSF
extends PlanMocF {
    private PlanMocFromSF smocH = null;
    private PlanMocFFromSF fmocH = null;
    private PlanMocFromSF smocS = null;
    private PlanMocFFromSF fmocS = null;
    private double cov = -1.0;
    private double[] oLastDrawFreqRange = null;
    private SMoc oLastDrawMoc = null;
    private SMoc lastCurrentSpaceMoc = null;
    private FMoc lastCurrentFreqMoc = null;
    private RectangleD lastR = null;
    private Hpix lastHpix = null;

    public PlanMocSF(Aladin a) {
        super(a);
        this.type = 27;
        this.initSF();
    }

    protected PlanMocSF(Aladin aladin, MyInputStream in, String label, Coord c, double radius, String url) {
        super(aladin);
        this.dis = in;
        this.url = url;
        this.type = 27;
        this.useCache = false;
        this.frameOrigin = 0;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "SFMOC";
        }
        this.setLabel(label);
        this.co = c;
        this.coRadius = radius;
        Aladin.trace(3, "SFMOC creation: " + Plan.TYPE[this.type] + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected PlanMocSF(Aladin aladin, SFMoc moc, String label, Coord c, double radius, String url) {
        super(aladin);
        this.moc = moc;
        this.url = url;
        this.useCache = false;
        this.frameOrigin = 0;
        this.type = 27;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "SFMOC";
        }
        this.setLabel(label);
        this.co = c;
        this.coRadius = radius;
        Aladin.trace(3, "SFMOC creation: " + Plan.TYPE[this.type] + (c != null ? " around " + c : ""));
        this.suite();
    }

    @Override
    protected void suiteSpecific() {
        super.suiteSpecific();
        this.initSF();
    }

    protected boolean isOneFreqRange() {
        return false;
    }

    protected void changeFreqRange(double fmin, double fmax) throws Exception {
        if (!this.isOneFreqRange()) {
            throw new Exception("Not a oneFreqRange SFMOC");
        }
        long min = FMoc.getNpix(fmin);
        long max = FMoc.getNpix(fmax) + 1L;
        if (min == -1L || max == -1L) {
            throw new Exception("Frequency limits out of FMOC range");
        }
        SFMoc m = (SFMoc)this.moc;
        m.range.r[0] = min;
        m.range.r[1] = max;
    }

    private double getFullCoverage() {
        if (this.cov >= 0.0) {
            return this.cov;
        }
        if (this.cov == -2.0) {
            return -1.0;
        }
        this.cov = -2.0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PlanMocSF.this.cov = ((SFMoc)PlanMocSF.this.moc).getSpaceMoc().getCoverage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return this.cov;
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        SFMoc sfmoc = (SFMoc)this.moc;
        try {
            double cov;
            boolean freqEmpty;
            boolean bl = freqEmpty = sfmoc.getFreqMin() == -1.0;
            if (!freqEmpty) {
                PlanMocSF.ADD(buf, "\n* Start: ", this.getFreq(sfmoc.getFreqMin()));
                PlanMocSF.ADD(buf, "\n* End: ", this.getFreq(sfmoc.getFreqMax()));
            }
            PlanMocSF.ADD(buf, "\n* # ranges: ", sfmoc.getNbRanges() + "");
            int freqOrder = sfmoc.getFreqOrder();
            int drawOrder = freqEmpty ? -1 : this.getDrawOrder1D();
            PlanMocSF.ADD(buf, "\n", "* Freq order: " + (freqOrder == drawOrder ? freqOrder + "" : "draw:" + drawOrder + "/" + freqOrder));
            if (!freqEmpty) {
                double freqCenter = (sfmoc.getFreqMin() + sfmoc.getFreqMin()) / 2.0;
                PlanMocSF.ADD(buf, "\n", "* Central res.: " + SED.getUnitFreq(FMoc.getFreqCoverage(freqOrder, freqCenter)));
            }
            boolean spaceEmpty = (cov = this.getFullCoverage()) == 0.0;
            double degrad = Math.toDegrees(1.0);
            double skyArea = Math.PI * 4 * degrad * degrad;
            String body = this.getBody();
            if (body == null) {
                body = "?";
            }
            PlanMocSF.ADD(buf, "\n \n* Space: ", spaceEmpty ? "--empty--" : Coord.getUnit(skyArea * cov, false, true) + "^2, " + Util.round(cov * 100.0, 3) + "% of " + body);
            int spaceOrder = sfmoc.getSpaceOrder();
            PlanMocSF.ADD(buf, "\n* Space res: ", Coord.getUnit(CDSHealpix.pixRes(spaceOrder) / 3600.0));
            drawOrder = spaceEmpty ? -1 : this.getSpaceDrawOrder();
            PlanMocSF.ADD(buf, "\n", "* Space order: " + (drawOrder == -1 ? Integer.valueOf(spaceOrder) : (spaceOrder == drawOrder ? spaceOrder + "" : "draw:" + drawOrder + "/" + spaceOrder)));
            if (!spaceEmpty || !freqEmpty) {
                PlanMocSF.ADD(buf, "\n \nRAM: ", Util.getUnitDisk(sfmoc.getMem()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getSpaceDrawOrder() {
        return this.lastOrderDrawn;
    }

    @Override
    protected double getMin() {
        double fmin = -1.0;
        try {
            fmin = ((SFMoc)this.moc).getFreqMin();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fmin == -1.0) {
            fmin = Double.NaN;
        }
        return fmin;
    }

    @Override
    protected double getMax() {
        double fmax = -1.0;
        try {
            fmax = ((SFMoc)this.moc).getFreqMax();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fmax == -1.0) {
            fmax = Double.NaN;
        }
        return fmax;
    }

    @Override
    protected boolean waitForPlan() {
        if (this.dis != null) {
            this.error = null;
            try {
                if (this.moc == null && this.dis != null) {
                    this.moc = this.createOneMoc();
                    this.readMoc(this.moc, this.dis);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                this.error = "SFMOC error";
                return false;
            }
        }
        this.analyseMoc(this.moc);
        return true;
    }

    protected String getFreq(double f) {
        return SED.getUnitFreq(f, "Hz");
    }

    protected SMoc getCurrentSpaceMoc(ViewSimple v) {
        return this.getCurrentSpaceMoc(v, false);
    }

    protected SMoc getCurrentSpaceMoc(ViewSimple v, boolean echoCommand) {
        double[] f = v.getFreqRange();
        if (v == this.aladin.view.getCurrentView()) {
            this.oLastDrawFreqRange = f;
        }
        try {
            long max;
            long min = Double.isNaN(f[0]) ? -1L : FMoc.getNpix(f[0]);
            long l = max = Double.isNaN(f[1]) ? Long.MAX_VALUE : FMoc.getNpix(f[1]);
            if (min == -1L || max == -1L) {
                throw new Exception("FMoc.getNpix() out of FMOC range");
            }
            if (echoCommand) {
                String range = Double.isNaN(f[0]) && Double.isNaN(f[1]) ? "" : (Double.isNaN(f[0]) ? " -freqRange=NaN/" + this.getFreq(f[1]) : (Double.isNaN(f[1]) ? " -freqRange=" + this.getFreq(f[0]) + "/NaN" : " -freqRange=" + this.getFreq(f[0]) + "/" + this.getFreq(f[1])));
                this.aladin.console.printCommand("cmoc" + range + " " + Tok.quote(this.label));
            }
            return ((SFMoc)this.moc).getSpaceMoc(min, max);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected SMoc getCurrentSpaceMoc(ViewSimple v, SFMoc moc) {
        double[] f = v.getFreqRange();
        if (v == this.aladin.view.getCurrentView()) {
            this.oLastDrawFreqRange = f;
        }
        try {
            long max;
            long min = Double.isNaN(f[0]) ? 0L : FMoc.getNpix(f[0]);
            long l = max = Double.isNaN(f[1]) ? Long.MAX_VALUE : FMoc.getNpix(f[1]);
            if (min == -1L || max == -1L) {
                throw new Exception("FMoc.getNpix() out of FMOC range");
            }
            return moc.getSpaceMoc(min, max);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected FMoc getCurrentFreqMoc() {
        try {
            return ((SFMoc)this.moc).getFreqMoc(this.isDisplayedInView() ? this.oLastDrawMoc : null);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected SFMoc getCurrentSpaceFreqMoc() {
        try {
            return new SFMoc((FMoc)this.fmocS.moc, (SMoc)this.smocS.moc);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected boolean hasSelection() {
        return true;
    }

    private boolean isDisplayedInView() {
        int m = this.aladin.view.getNbView();
        for (int i = 0; i < m; ++i) {
            ViewSimple v = this.aladin.view.viewSimple[i];
            if (v.isFree() || !v.selected || v.isPlotTime()) continue;
            return true;
        }
        return false;
    }

    private ViewSimple getViewPlot() {
        int m = this.aladin.view.getNbView();
        for (int i = 0; i < m; ++i) {
            if (!this.aladin.view.viewSimple[i].isPlotFreq()) continue;
            return this.aladin.view.viewSimple[i];
        }
        return null;
    }

    private boolean isDisplayedInPlot() {
        ViewSimple v = this.getViewPlot();
        return v != null && v.selected;
    }

    protected void memoNewFreq() {
        ViewSimple v = this.aladin.view.getCurrentView();
        this.oLastDrawFreqRange = v.getFreqRange();
        this.oiz = -1L;
        this.askForRepaint();
    }

    protected void memoNewSpace() {
        this.oLastDrawMoc = this.isDisplayedInView() ? this.getLastDrawMoc() : null;
        this.mocLowReset();
        this.oiz = -1L;
        this.askForRepaint();
    }

    protected boolean isSpaceModified() {
        if (!this.isDisplayedInPlot()) {
            return false;
        }
        SMoc m = this.isDisplayedInView() ? this.getLastDrawMoc() : null;
        boolean rep = !this.mocEquals(m, this.oLastDrawMoc);
        return rep;
    }

    public boolean mocEquals(Moc m1, Moc m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return ((SMoc)m1).equals(m2);
    }

    protected boolean isFreqModified() {
        ViewSimple v = this.aladin.view.getCurrentView();
        double[] t = v.getFreqRange();
        boolean rep = (Double.isNaN(t[0]) && Double.isNaN(this.oLastDrawFreqRange[0]) || t[0] == this.oLastDrawFreqRange[0]) && (Double.isNaN(t[1]) && Double.isNaN(this.oLastDrawFreqRange[1]) || t[1] == this.oLastDrawFreqRange[1]);
        return !rep;
    }

    @Override
    protected SMoc getSpaceMocLow(ViewSimple v, int order, int gapOrder) {
        SFMoc m1 = (SFMoc)this.getSpaceMocLow1(v, order, gapOrder);
        SMoc m = this.getCurrentSpaceMoc(v, m1);
        try {
            m.setMinOrder(3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m;
    }

    @Override
    protected Moc createOneMoc() {
        return new SFMoc();
    }

    @Override
    protected SMoc getSpaceMoc() {
        SMoc m;
        ViewSimple v = this.aladin.view.getCurrentView();
        if (this.lastCurrentSpaceMoc != null && !this.isFreqModified()) {
            return this.lastCurrentSpaceMoc;
        }
        this.lastCurrentSpaceMoc = m = this.getCurrentSpaceMoc(v);
        this.memoNewFreq();
        return this.lastCurrentSpaceMoc;
    }

    protected FMoc getFreqMoc() {
        FMoc m;
        if (this.lastCurrentFreqMoc != null && !this.isSpaceModified()) {
            return this.lastCurrentFreqMoc;
        }
        this.lastCurrentFreqMoc = m = this.getCurrentFreqMoc();
        this.memoNewSpace();
        return this.lastCurrentFreqMoc;
    }

    private void initSF() {
        this.smocH = new PlanMocFromSF(this, false);
        this.fmocH = new PlanMocFFromSF(this, false);
        this.smocS = new PlanMocFromSF(this, true);
        this.fmocS = new PlanMocFFromSF(this, true);
    }

    private void repaintSF() {
        this.fmocS.oiz = -2L;
        this.smocS.oiz = -2L;
        this.fmocH.oiz = -2L;
        this.smocH.oiz = -2L;
        this.aladin.view.repaintAll();
    }

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        if (v.isPlotFreq()) {
            this.drawInFreqView(g, v);
            if (this.aladin.view.isMultiView()) {
                this.fmocS.drawInFreqView(g, v);
                this.fmocH.drawInFreqView(g, v);
            }
        } else {
            this.drawInSpaceView(g, v);
            if (this.aladin.view.isMultiView()) {
                this.smocS.drawInSpaceView(g, v);
                this.smocH.drawInSpaceView(g, v);
            }
        }
    }

    private boolean isDiff(Moc s1, Moc s2) {
        return s1 == null && s2 != null || s1 != null && !s1.equals(s2);
    }

    public boolean inFreqView(ViewSimple v, MouseEvent e, boolean select) {
        if (this.lastRectDrawn == null) {
            return false;
        }
        if (!Aladin.MOC2DSELECTABLE) {
            select = false;
        }
        String info = null;
        int xview = e.getX();
        int yview = e.getY();
        boolean trouve = false;
        SMoc sh = (SMoc)this.smocH.moc;
        FMoc fh = (FMoc)this.fmocH.moc;
        SMoc ss = (SMoc)this.smocS.moc;
        FMoc fs = (FMoc)this.fmocS.moc;
        Iterator iterator = this.lastRectDrawn.iterator();
        while (iterator.hasNext()) {
            PlanMoc1D.MyRect r;
            PlanMoc1D.MyRect r1 = r = (PlanMoc1D.MyRect)iterator.next();
            if (r.width < 2.0) {
                r1 = new PlanMoc1D.MyRect(r.x - 1.0, r.y, 3.0, r.height);
            }
            if (!r1.contains(xview, yview)) continue;
            if (select && this.lastR == r) {
                return true;
            }
            this.lastR = r;
            try {
                SFMoc m1;
                fh = new FMoc();
                fh.add(51, r.start, r.end - 1L);
                SFMoc m = (SFMoc)this.moc;
                if (!select && m.getNbCells() > 10000 && r.order <= 30 && (m1 = (SFMoc)this.getLastLowMoc()) != null) {
                    m = m1;
                }
                sh = m.getSpaceMoc(r.start, r.end - 1L);
                trouve = true;
                if (select) {
                    if (fs != null && fh.isIntersecting(fs)) {
                        ss = null;
                        fs = null;
                    } else if (fs != null && e.isShiftDown()) {
                        ss = ss.union(sh);
                        fs = fs.union(fh);
                    } else if (ss == null || e.isControlDown()) {
                        ss = sh;
                        fs = fh;
                    }
                }
                String start = SED.getUnitFreq(FMoc.getFreq(r.start));
                String end = SED.getUnitFreq(FMoc.getFreq(r.end - 1L));
                info = "\n \n* Start: " + start + "\n\n* End: " + end + "\n";
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            break;
        }
        if (!trouve) {
            sh = null;
            fh = null;
        }
        if (this.updateMocSH(sh, fh, ss, fs)) {
            this.repaintSF();
            this.aladin.calque.select.setMessageInfo(info);
        }
        return trouve;
    }

    public boolean inSpaceView(ViewSimple v, MouseEvent e, boolean select) {
        if (this.arrayHpix == null) {
            return false;
        }
        int xview = e.getX();
        int yview = e.getY();
        boolean trouve = false;
        SMoc sh = (SMoc)this.smocH.moc;
        FMoc fh = (FMoc)this.fmocH.moc;
        SMoc ss = (SMoc)this.smocS.moc;
        FMoc fs = (FMoc)this.fmocS.moc;
        for (Hpix r : this.arrayHpix) {
            if (!r.contains(v, xview, yview)) continue;
            if (!select && this.lastHpix == r) {
                return true;
            }
            this.lastHpix = r;
            try {
                sh = new SMoc();
                sh.add(r.order, r.start);
                fh = ((SFMoc)this.moc).getFreqMoc(sh);
                trouve = true;
                if (!select) break;
                if (ss != null && sh.isIntersecting(ss)) {
                    ss = null;
                    fs = null;
                    break;
                }
                if (ss != null && e.isShiftDown()) {
                    ss = ss.union(sh);
                    fs = fs.union(fh);
                    break;
                }
                if (ss != null && !e.isControlDown()) break;
                ss = sh;
                fs = fh;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            break;
        }
        if (!trouve) {
            sh = null;
            fh = null;
        }
        if (this.updateMocSH(sh, fh, ss, fs)) {
            this.repaintSF();
            this.aladin.calque.select.setMessageInfo("");
        }
        return trouve;
    }

    private boolean updateMocSH(Moc sh, Moc fh, Moc ss, Moc fs) {
        boolean update = false;
        if (this.isDiff(sh, this.smocH.moc)) {
            update = true;
            this.smocH.moc = sh;
            this.smocH.arrayMoc = null;
        }
        if (this.isDiff(fh, this.fmocH.moc)) {
            update = true;
            this.fmocH.moc = fh;
            this.fmocH.arrayMoc = null;
        }
        if (this.isDiff(ss, this.smocS.moc)) {
            update = true;
            this.smocS.moc = ss;
            this.smocS.arrayMoc = null;
        }
        if (this.isDiff(fs, this.fmocS.moc)) {
            update = true;
            this.fmocS.moc = fs;
            this.fmocS.arrayMoc = null;
        }
        return update;
    }

    @Override
    protected void planReadyPost() {
        this.aladin.view.createView4FMOC(this);
    }
}

