/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanHips;
import cds.aladin.PlanImage;
import cds.aladin.PlanMoc;
import cds.aladin.Position;
import cds.aladin.Source;
import cds.aladin.SourceFootprint;
import cds.aladin.Tile;
import cds.aladin.stc.STCObj;
import cds.moc.Healpix;
import cds.moc.SMoc;
import cds.tools.Util;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.CDSHealpix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class PlanMocGen
extends PlanMoc {
    private Plan[] p;
    private double radius;
    private boolean fov;
    private double pixMin;
    private double pixMax;
    private double threshold;
    private int order;
    private double gapPourcent;
    private boolean stop;

    protected PlanMocGen(Aladin aladin, String label, Plan[] p, int order, double radius, double pixMin, double pixMax, double threshold, boolean fov) {
        super(aladin, null, null, label, p[0].co, 30.0, null);
        this.p = p;
        this.order = order;
        this.radius = radius;
        this.pixMin = pixMin;
        this.pixMax = pixMax;
        this.threshold = threshold;
        this.fov = fov;
        this.pourcent = 0.0;
        this.gapPourcent = 100 / p.length;
        this.suiteSpecific();
        this.threading();
        this.log();
    }

    @Override
    protected void launchLoading() {
    }

    @Override
    protected boolean freePlan() {
        this.stop = true;
        return super.freePlan();
    }

    private void addMocFromCatalog(Plan p1, double radius, int order, boolean fov) throws Exception {
        int m;
        long t0;
        block13: {
            t0 = System.currentTimeMillis();
            this.stop = false;
            ((SMoc)this.moc).setMocOrder(order);
            SMoc m2 = new SMoc(order);
            m2.bufferOn(10000);
            Iterator<Obj> it = p1.iterator();
            m = 0;
            Healpix hpx = new Healpix();
            double incrPourcent = this.gapPourcent / (double)p1.getCounts();
            while (it.hasNext()) {
                Obj o = it.next();
                if (!(o instanceof Position)) continue;
                this.pourcent += incrPourcent;
                if (++m % 10000 == 0) {
                    block12: {
                        if (this.stop) {
                            throw new Exception("Abort");
                        }
                        try {
                            this.moc = this.moc.union(m2);
                        }
                        catch (Exception e) {
                            if (Aladin.levelTrace < 3) break block12;
                            e.printStackTrace();
                        }
                    }
                    m2.clear();
                }
                try {
                    if (!fov && radius == 0.0) {
                        long npix = hpx.ang2pix(order, ((Position)o).raj, ((Position)o).dej);
                        m2.add(order, npix);
                        continue;
                    }
                    SMoc m1 = null;
                    if (fov) {
                        List<STCObj> listStcs;
                        Source s = (Source)o;
                        SourceFootprint sf = s.getFootprint();
                        if (sf == null || (listStcs = sf.getStcObjects()) == null) continue;
                        m1 = Aladin.createMocRegion(listStcs, order, true);
                    } else {
                        m1 = Aladin.createMocRegionCircle(((Position)o).raj, ((Position)o).dej, radius, order, true);
                    }
                    m2.setRangeList(m2.seeRangeList().union(m1.seeRangeList()));
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) continue;
                    e.printStackTrace();
                }
            }
            try {
                this.moc = this.moc.union(m2);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block13;
                e.printStackTrace();
            }
        }
        long t1 = System.currentTimeMillis();
        Aladin.trace(4, "SMOC created in " + Util.getTemps((t1 - t0) * 1000L) + " (" + m + " sources)");
    }

    private void addMocFromImage(Plan p1, double pixMin, double pixMax) {
        boolean flagRange = !Double.isNaN(pixMin) || !Double.isNaN(pixMax);
        PlanImage pimg = (PlanImage)p1;
        Healpix hpx = new Healpix();
        int o1 = this.order;
        Coord coo = new Coord();
        double gap = 1.0;
        double gapA = 0.0;
        double gapD = 0.0;
        try {
            gapA = Math.min(p1.projd.getPixResAlpha(), p1.projd.getPixResDelta());
            o1 = this.order;
            while (CDSHealpix.pixRes(o1) / 3600.0 <= gapA * 2.0) {
                --o1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        gapD = CDSHealpix.pixRes(o1) / 3600.0;
        pimg.setLockCacheFree(true);
        pimg.pixelsOriginFromCache();
        ((SMoc)this.moc).bufferOn();
        double incrPourcent = this.gapPourcent / (double)pimg.naxis2;
        long oNpix = -1L;
        for (double y = 0.0; y < (double)pimg.naxis2; y += gap) {
            this.pourcent += incrPourcent;
            for (double x = 0.0; x < (double)pimg.naxis1; x += gap) {
                try {
                    coo.x = x;
                    coo.y = (double)pimg.naxis2 - y - 1.0;
                    if (pimg.getPixel8Byte((int)x, (int)coo.y) == 0 && Double.isNaN(pimg.getPixel((int)x, (int)y))) continue;
                    if (flagRange) {
                        double pix = pimg.getPixel((int)x, (int)y);
                        if (!Double.isNaN(pixMin) && pix < pixMin || !Double.isNaN(pixMax) && pix > pixMax) continue;
                    }
                    pimg.projd.getCoord(coo);
                    long npix = 0L;
                    npix = hpx.ang2pix(o1, coo.al, coo.del);
                    if (npix == oNpix) continue;
                    ((SMoc)this.moc).add(o1, npix);
                    oNpix = npix;
                    continue;
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) continue;
                    e.printStackTrace();
                }
            }
        }
        ((SMoc)this.moc).bufferOff();
        pimg.setLockCacheFree(false);
    }

    private void addMocFromPlanBG(Plan p1, int order, double pixMin, double pixMax) throws Exception {
        this.addMocFromPlanBG(p1, order, -1, pixMin, pixMax);
    }

    private void addMocFromPlanBG(Plan p1, int order, int infoTileWidth, double pixMin, double pixMax) throws Exception {
        int requiredHipsOrder;
        boolean flagRange = !Double.isNaN(pixMin) || !Double.isNaN(pixMax);
        PlanHips p = (PlanHips)p1;
        if (!p.hasOriginalPixels()) {
            p.switchFormat();
        }
        int tileOrder = infoTileWidth == -1 ? p.getOrderTile() : (int)CDSHealpix.log2(infoTileWidth);
        int tileWidth = (int)CDSHealpix.pow2(tileOrder);
        int z = (int)p.getZ();
        int channel = this.getChannel();
        if (order > tileOrder + p.orderMax) {
            order = tileOrder + p.orderMax;
            this.aladin.warning("MOC order greater than HiPS resolution. Assuming MOC order " + order);
        }
        int hipsOrder = requiredHipsOrder = order - tileOrder;
        int cellOrder = 0;
        int minHipsOrder = p.getOrderMin();
        if (minHipsOrder > requiredHipsOrder) {
            cellOrder = minHipsOrder - requiredHipsOrder;
            hipsOrder = minHipsOrder;
        }
        ((SMoc)this.moc).setMocOrder(order);
        ((SMoc)this.moc).setSpaceSys(p.frameOrigin == 3 ? "G" : (p.frameOrigin == 2 ? "E" : "C"));
        ((SMoc)this.moc).bufferOn();
        this.frameOrigin = p.frameOrigin;
        int n = (int)CDSHealpix.pow2(hipsOrder);
        n = 12 * n * n;
        try {
            this.createHealpixOrder(tileOrder - cellOrder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double incrPourcent = this.gapPourcent / (double)n;
        boolean first = true;
        int cellWidth = (int)CDSHealpix.pow2(cellOrder);
        int nbCell = tileWidth / cellWidth;
        int virtualTileWidth = tileWidth / cellWidth;
        for (int npixFile = 0; npixFile < n; ++npixFile) {
            Tile h;
            this.pourcent += incrPourcent;
            if (p.moc != null && p.isOutMoc(hipsOrder, npixFile) || (h = p.getTileLowLevel(new Addr(hipsOrder, npixFile, z), 2)) == null) continue;
            if (first && infoTileWidth == -1 && (long)h.width != CDSHealpix.pow2(tileOrder)) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("Warning, the HiPS \"" + p.label + "\" has missing or erroneous tileWidth propertie value => assuming " + h.width);
                }
                this.addMocFromPlanBG(p1, order, h.width, pixMin, pixMax);
                return;
            }
            first = false;
            long min = virtualTileWidth * virtualTileWidth * npixFile;
            try {
                for (int yCell = 0; yCell < nbCell; ++yCell) {
                    for (int xCell = 0; xCell < nbCell; ++xCell) {
                        double average = 0.0;
                        int nbPixels = 0;
                        for (int y = 0; y < cellWidth; ++y) {
                            for (int x = 0; x < cellWidth; ++x) {
                                int idx = (yCell * cellWidth + y) * h.width + xCell * cellWidth + x;
                                double pixel = h.getPixel(idx, channel, 0);
                                if (Double.isNaN(pixel) || this.isBlank && pixel == this.blank) continue;
                                pixel = pixel * p.bScale + p.bZero;
                                average += pixel;
                                ++nbPixels;
                            }
                        }
                        if (nbPixels == 0) continue;
                        if (flagRange && (!Double.isNaN(pixMin) && (average /= (double)nbPixels) < pixMin || !Double.isNaN(pixMax) && average > pixMax)) continue;
                        long npixMoc = min + (long)this.xy2hpx(yCell * virtualTileWidth + xCell);
                        ((SMoc)this.moc).add(order, npixMoc);
                    }
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ((SMoc)this.moc).bufferOff();
        try {
            String sys = p.body;
            if (sys != null) {
                this.moc.setSpaceSys(sys);
            } else {
                this.moc = this.toReferenceFrame("C");
            }
            this.frameOrigin = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addMocFromPlanBG(Plan p1, int order, double threshold) throws Exception {
        this.addMocFromPlanBG(p1, order, -1, threshold);
    }

    private void addMocFromPlanBG(Plan p1, int order, int infoTileWidth, double threshold) throws Exception {
        int requiredHipsOrder;
        PlanHips p = (PlanHips)p1;
        if (order == -1) {
            int n = order = infoTileWidth == -1 ? p.getOrderMaxPixel() : p.getOrderMax() + (int)CDSHealpix.log2(infoTileWidth);
            if (order > 12) {
                order = 12;
            }
        }
        if (!p.hasOriginalPixels()) {
            p.switchFormat();
        }
        int tileOrder = infoTileWidth == -1 ? p.getOrderTile() : (int)CDSHealpix.log2(infoTileWidth);
        int tileWidth = (int)CDSHealpix.pow2(tileOrder);
        int z = (int)p.getZ();
        int channel = this.getChannel();
        if (order > tileOrder + p.orderMax) {
            order = tileOrder + p.orderMax;
            this.aladin.warning("MOC order greater than HiPS resolution. Assuming MOC order " + order);
        }
        if (threshold == 0.0) {
            return;
        }
        if (threshold >= 1.0) {
            this.moc = this.moc.union(p.moc);
            return;
        }
        int hipsOrder = requiredHipsOrder = order - tileOrder;
        int cellOrder = 0;
        int minHipsOrder = p.getOrderMin();
        if (minHipsOrder > requiredHipsOrder) {
            cellOrder = minHipsOrder - requiredHipsOrder;
            hipsOrder = minHipsOrder;
        }
        ((SMoc)this.moc).setSpaceSys(p.frameOrigin == 3 ? "G" : (p.frameOrigin == 2 ? "E" : "C"));
        this.frameOrigin = p.frameOrigin;
        int n = (int)CDSHealpix.pow2(hipsOrder);
        n = 12 * n * n;
        try {
            this.createHealpixOrder(tileOrder - cellOrder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double incrPourcent = this.gapPourcent / (double)n;
        boolean first = true;
        int cellWidth = (int)CDSHealpix.pow2(cellOrder);
        int nbCell = tileWidth / cellWidth;
        int virtualTileWidth = tileWidth / cellWidth;
        ArrayList<PixCum> tileList = new ArrayList<PixCum>(n);
        Queue queue = new Queue(threshold);
        double somme = 0.0;
        for (int step = 0; step < 2; ++step) {
            if (step == 0) {
                for (int i = 0; i < n; ++i) {
                    tileList.add(new PixCum(i, 0.0));
                }
            } else {
                Collections.sort(tileList);
            }
            for (PixCum tile : tileList) {
                Tile h;
                if (tile.npix == -1L) continue;
                int tileNpix = (int)tile.npix;
                tile.npix = -1L;
                Aladin.trace(4, "Processing tile " + tileNpix + " (step " + (step + 1) + (step == 1 ? " mean=" + tile.val + " max=" + tile.max + " queue.size=" + queue.size() : "") + ")");
                double tileTotal = 0.0;
                double tileMax = 0.0;
                int tileNbPixel = 0;
                this.pourcent += incrPourcent / 2.0;
                if (p.moc != null && p.isOutMoc(hipsOrder, tileNpix) || (h = p.getTileLowLevel(new Addr(hipsOrder, tileNpix, z), 2)) == null) continue;
                if (first && infoTileWidth == -1 && (long)h.width != CDSHealpix.pow2(tileOrder)) {
                    if (Aladin.levelTrace >= 3) {
                        System.err.println("Warning, the HiPS \"" + p.label + "\" has missing or erroneous tileWidth propertie value => assuming " + h.width);
                    }
                    this.addMocFromPlanBG(p1, order, h.width, threshold);
                    return;
                }
                first = false;
                if (step == 1 && queue.size() > 0) {
                    PixCum last = (PixCum)queue.last();
                    if (last.val * somme > tile.max) continue;
                }
                long min = virtualTileWidth * virtualTileWidth * tileNpix;
                try {
                    for (int yCell = 0; yCell < nbCell; ++yCell) {
                        for (int xCell = 0; xCell < nbCell; ++xCell) {
                            double pixel = 0.0;
                            int nbPixels = 0;
                            for (int y = 0; y < cellWidth; ++y) {
                                for (int x = 0; x < cellWidth; ++x) {
                                    int idx = (yCell * cellWidth + y) * h.width + xCell * cellWidth + x;
                                    double localPixel = h.getPixel(idx, channel, 0);
                                    if (Double.isNaN(localPixel) || this.isBlank && localPixel == this.blank) continue;
                                    localPixel = localPixel * p.bScale + p.bZero;
                                    pixel += localPixel;
                                    ++nbPixels;
                                }
                            }
                            if (nbPixels == 0) continue;
                            if (step == 0) {
                                somme += pixel;
                                tileTotal += pixel;
                                if (tileNbPixel == 0 || pixel > tileMax) {
                                    tileMax = pixel;
                                }
                                ++tileNbPixel;
                                continue;
                            }
                            long npixMoc = min + (long)this.xy2hpx(yCell * virtualTileWidth + xCell);
                            queue.add(new PixCum(npixMoc, pixel /= somme));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (step != 0 || tileNbPixel <= 0) continue;
                tile.npix = tileNpix;
                tile.val = tileTotal;
                tile.max = tileMax;
            }
        }
        ((SMoc)this.moc).bufferOn();
        somme = 0.0;
        try {
            for (PixCum pc : queue) {
                long npix = pc.npix;
                if ((somme += pc.val) > threshold) break;
                ((SMoc)this.moc).add(order, npix);
            }
            ((SMoc)this.moc).bufferOff();
            String sys = p.body;
            if (sys != null) {
                this.moc.setSpaceSys(sys);
            } else {
                this.moc = this.toReferenceFrame("C");
            }
            this.frameOrigin = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean waitForPlan() {
        try {
            this.moc = new SMoc();
            ((SMoc)this.moc).setMinOrder(3);
            if (this.order != -1) {
                ((SMoc)this.moc).setMocOrder(this.order);
            }
            this.frameOrigin = 0;
            String body = this.p[0].getBody();
            this.setBody(body);
            if (body != null && body.equals("sky")) {
                body = "C";
            }
            this.moc.setSpaceSys(body);
            for (Plan p1 : this.p) {
                if (p1.isCatalog()) {
                    this.addMocFromCatalog(p1, this.radius, this.order, this.fov);
                    continue;
                }
                if (p1.isImage()) {
                    this.addMocFromImage(p1, this.pixMin, this.pixMax);
                    continue;
                }
                if (p1 instanceof PlanHips && !Double.isNaN(this.threshold)) {
                    this.addMocFromPlanBG(p1, this.order, this.threshold);
                    continue;
                }
                if (!(p1 instanceof PlanHips)) continue;
                this.addMocFromPlanBG(p1, this.order, this.pixMin, this.pixMax);
            }
        }
        catch (Exception e) {
            this.error = e.getMessage();
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.flagProcessing = false;
            return false;
        }
        this.flagProcessing = false;
        this.flagOk = true;
        return true;
    }

    public class Queue<E>
    extends TreeSet<PixCum> {
        private double threshold;
        private double somme;

        public Queue(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean add(PixCum e) {
            PixCum last;
            if (this.somme <= 0.0 || this.somme + e.val < this.threshold) {
                this.somme += e.val;
                super.add(e);
                return true;
            }
            double tot = 0.0;
            while ((last = (PixCum)this.last()) != null) {
                tot += last.val;
                this.somme -= last.val;
                if (!(tot < e.val)) break;
                this.pollLast();
            }
            if (tot != 0.0) {
                this.somme += e.val;
                super.add(e);
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            PixCum e = (PixCum)this.first();
            PixCum f = (PixCum)this.last();
            return this.size() + "/" + this.threshold + "/" + this.somme + "[" + e + ".." + f + "]";
        }
    }

    class PixCum
    implements Comparable {
        long npix;
        double val;
        double max;

        PixCum(long npix, double val) {
            this.npix = npix;
            this.val = val;
        }

        public int compareTo(Object o) {
            if (this.val == ((PixCum)o).val) {
                return this.npix == ((PixCum)o).npix ? 0 : (this.npix < ((PixCum)o).npix ? 1 : -1);
            }
            return this.val < ((PixCum)o).val ? 1 : -1;
        }

        public String toString() {
            return this.npix + "/" + this.val;
        }
    }
}

