/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.PlanMoc1D;
import cds.aladin.Plot;
import cds.aladin.SED;
import cds.aladin.ViewSimple;
import cds.moc.FMoc;
import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.tools.Util;
import java.awt.Graphics;

public class PlanMocF
extends PlanMoc1D {
    private static final int MAXDRAWCELL = 300;
    private static final int MINLIMIT = 9;
    public static final int BAND = 20;
    public static final int MARGE = 30;

    public PlanMocF(Aladin a) {
        super(a);
        this.type = 26;
    }

    protected PlanMocF(Aladin aladin, MyInputStream in, String label, String url) {
        super(aladin, 26, in, null, label, url);
    }

    protected PlanMocF(Aladin aladin, FMoc moc, String label, String url) {
        super(aladin, 26, null, moc, label, url);
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        boolean isEmpty = this.moc.isEmpty();
        if (!isEmpty) {
            PlanMocF.ADD(buf, "\n* Start: ", SED.getUnitFreq(this.getMin(), "Hz"));
            PlanMocF.ADD(buf, "\n* End: ", SED.getUnitFreq(this.getMax(), "Hz"));
        }
        PlanMocF.ADD(buf, "\n* # ranges: ", this.moc.getNbRanges() + "");
        int order = ((Moc1D)this.moc).getMocOrder();
        int drawOrder = isEmpty ? -1 : this.getDrawOrder1D();
        PlanMocF.ADD(buf, "\n", "* Order: " + (order == drawOrder ? order + "" : drawOrder + "/" + order));
        if (!isEmpty) {
            double freqCenter = (this.getMax() + this.getMin()) / 2.0;
            PlanMocF.ADD(buf, "\n", "* Central res.: " + SED.getUnitFreq(FMoc.getFreqCoverage(order, freqCenter)));
        }
        if (isEmpty) {
            PlanMocF.ADD(buf, "\n \nRAM: ", Util.getUnitDisk(this.moc.getMem()));
        }
    }

    @Override
    protected boolean isFreq() {
        return true;
    }

    @Override
    protected double getMin() {
        double fmin = ((FMoc)this.moc).getFreqMin();
        if (fmin == -1.0) {
            fmin = Double.NaN;
        }
        return fmin;
    }

    @Override
    protected double getMax() {
        double fmax = ((FMoc)this.moc).getFreqMax();
        if (fmax == -1.0) {
            fmax = Double.NaN;
        }
        return fmax;
    }

    @Override
    protected double[] getFreqRange() {
        return new double[]{this.getMin(), this.getMax()};
    }

    @Override
    protected Moc createOneMoc() {
        return new FMoc();
    }

    @Override
    protected int getDrawingOrder(ViewSimple v) {
        int o;
        Plot plot = v.plot;
        double freqCoverage = plot.getMax() - plot.getMin();
        double freqCenter = (plot.getMax() + plot.getMin()) / 2.0;
        for (o = 51; o >= 9; --o) {
            double cov = FMoc.getFreqCoverage(o, freqCenter);
            double nbCell = freqCoverage / cov;
            if (!(nbCell < 300.0)) continue;
            return o;
        }
        return o;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        if (!v.isPlotFreq()) {
            return;
        }
        this.drawInFreqView(g, v);
    }

    protected void drawInFreqView(Graphics g, ViewSimple v) {
        this.drawIn1DView(g, v);
    }

    @Override
    protected int getStackIndex() {
        return this.freqStackIndex;
    }

    @Override
    protected double getValue(long hash) {
        try {
            return FMoc.getFreq(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    @Override
    protected void planReadyPost() {
        this.aladin.view.createView4FMOC(this);
    }
}

