/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.Plot;
import cds.aladin.PointD;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.tools.Util;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class PlanMoc1D
extends PlanMoc {
    protected ArrayList<MyRect> lastRectDrawn = null;
    private int lastOrder1DDrawn = -1;
    private boolean mocLowReset = false;
    private static final int MAXDRAWCELL = 300;
    private static final int MINLIMIT = 9;
    private static final int BAND = 20;
    private static final int MARGE = 30;

    public PlanMoc1D(Aladin a) {
        super(a);
    }

    protected PlanMoc1D(Aladin aladin, int type, MyInputStream in, Moc moc, String label, String url) {
        super(aladin);
        this.dis = in;
        this.moc = moc;
        this.url = url;
        this.useCache = false;
        this.type = type;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = Plan.TYPE[type];
        }
        this.setLabel(label);
        Aladin.trace(3, "MOC creation: " + Plan.TYPE[type]);
        this.suite();
    }

    @Override
    protected abstract void addMessageInfo(StringBuilder var1, MyProperties var2);

    @Override
    protected abstract Moc createOneMoc();

    @Override
    protected boolean isTime() {
        return false;
    }

    @Override
    protected boolean isFreq() {
        return false;
    }

    protected abstract double getMin();

    protected abstract double getMax();

    protected abstract double getValue(long var1);

    protected abstract int getStackIndex();

    @Override
    protected boolean waitForPlan() {
        if (this.dis != null) {
            this.error = null;
            try {
                if (this.moc == null && this.dis != null) {
                    this.moc = this.createOneMoc();
                    this.readMoc(this.moc, this.dis);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                this.error = Plan.TYPE[this.type] + " error";
                return false;
            }
        }
        return true;
    }

    @Override
    protected void planReady(boolean ready) {
        this.setPourcent(-1.0);
        this.active = true;
        this.flagOk = ready;
        this.aladin.synchroPlan.stop(this.startingTaskId);
        this.flagWaitTarget = false;
        this.flagProcessing = false;
        this.planReadyPost();
        this.aladin.view.repaintAll();
    }

    protected abstract void planReadyPost();

    protected void mocLowReset() {
        this.mocLowReset = true;
    }

    protected int getDrawOrder1D() {
        return this.lastOrder1DDrawn;
    }

    protected Moc1D getMoc1DLow(Moc1D moc1D, int order, int gapOrder) {
        if (Aladin.NOGUI) {
            return moc1D;
        }
        if ((order += gapOrder) > moc1D.getMocOrder()) {
            order = moc1D.getMocOrder();
        }
        if (order < 0) {
            order = 0;
        }
        if (this.arrayMoc == null || this.arrayMoc[order] == null || this.mocLowReset) {
            this.initArrayMoc(order);
            int myOrder = order;
            try {
                int myMo = moc1D.getMocOrder();
                Aladin.trace(4, "PlanMoc1D.getMoc1DLow(" + myOrder + ") running...");
                Moc1D mocLow = myOrder == myMo ? moc1D : (Moc1D)moc1D.clone();
                mocLow.setMocOrder(myOrder);
                this.arrayMoc[myOrder] = mocLow;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Aladin.trace(4, "PlanMoc1D.getMoc1DLow(" + myOrder + ") done !");
            this.askForRepaint();
        }
        if (this.arrayMoc[order].isEmpty()) {
            int i;
            this.isLoading = true;
            for (i = order; i >= 9 && (this.arrayMoc[i] == null || this.arrayMoc[i].isEmpty()); --i) {
            }
            if (i >= 9) {
                order = i;
            }
        } else {
            this.isLoading = false;
        }
        this.lastOrder1DDrawn = order;
        return (Moc1D)this.arrayMoc[order];
    }

    protected abstract int getDrawingOrder(ViewSimple var1);

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        this.drawIn1DView(g, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawIn1DView(Graphics g, ViewSimple v) {
        Iterator<long[]> it;
        int drawingOrder;
        boolean flagfillIn;
        boolean flagBorder;
        Plot plot;
        block16: {
            Moc1D moc1D;
            block15: {
                if (this.moc == null) {
                    return;
                }
                moc1D = null;
                try {
                    moc1D = this.moc.getMoc1D();
                }
                catch (Exception e1) {
                    if (Aladin.levelTrace < 3) break block15;
                    e1.printStackTrace();
                }
            }
            plot = v.plot;
            flagBorder = this.isDrawingBorder();
            flagfillIn = this.isDrawingFillIn();
            g.setColor(this.c);
            double min = plot.getMin();
            double max = plot.getMax();
            drawingOrder = moc1D.getNbRanges() < 300 ? moc1D.getMocOrder() : this.getDrawingOrder(v);
            Moc1D lowMoc = this.getMoc1DLow(moc1D, drawingOrder, this.gapOrder);
            this.mocLowReset = false;
            it = null;
            try {
                it = lowMoc.rangeIterator(min, max);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block16;
                e.printStackTrace();
            }
        }
        if (it == null) {
            return;
        }
        ArrayList<MyRect> a = new ArrayList<MyRect>();
        while (it.hasNext()) {
            a.add(this.computeRectangle(plot, drawingOrder, it.next()));
        }
        if (flagfillIn && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Composite composite = g2d.getComposite();
            try {
                g2d.setComposite(Util.getImageComposite(this.getOpacityLevel() * this.getFactorOpacity()));
                for (RectangleD rectangleD : a) {
                    if (flagBorder && rectangleD.width <= 1.0) continue;
                    g.fillRect((int)rectangleD.x, (int)rectangleD.y, (int)rectangleD.width, (int)rectangleD.height);
                }
            }
            finally {
                g2d.setComposite(composite);
            }
        }
        if (flagBorder) {
            for (RectangleD rectangleD : a) {
                g.drawRect((int)rectangleD.x, (int)rectangleD.y, (int)rectangleD.width, (int)rectangleD.height);
            }
        }
        if (v == this.aladin.view.getMouseView()) {
            this.lastRectDrawn = a;
        }
    }

    private MyRect computeRectangle(Plot plot, int drawingOrder, long[] range) {
        MyRect r = new MyRect();
        r.start = range[0];
        r.end = range[1];
        r.order = drawingOrder;
        Coord c = new Coord();
        c.al = this.getValue(r.start);
        c.del = 0.0;
        plot.getProj().getXY(c);
        PointD a = plot.viewSimple.getPositionInView(c.x, c.y);
        c.al = this.getValue(r.end - 1L);
        plot.getProj().getXY(c);
        PointD b = plot.viewSimple.getPositionInView(c.x, c.y);
        r.x = a.x;
        r.y = plot.viewSimple.getHeight() - 15 * (this.getStackIndex() + 1) - 30;
        r.width = Math.abs(b.x - a.x);
        if (r.width < 1.0) {
            r.width = 1.0;
        }
        r.height = 20.0;
        return r;
    }

    class MyRect
    extends RectangleD {
        long start;
        long end;
        int order;

        MyRect() {
        }

        MyRect(double x, double y, double w, double h) {
            super(x, y, w, h);
        }
    }
}

