/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanImage;
import cds.tools.Util;

public class PlanImageResamp
extends PlanImage {
    protected static final int PPV = 0;
    protected static final int BILINEAIRE = 1;
    private byte[] pixelsOriginInit = null;
    private byte[] pixelsInit = null;
    private int widthInit;
    private int heightInit;
    private PlanImage prefResample = null;
    protected boolean fullPixel = false;
    protected int methode;

    protected PlanImageResamp(Aladin aladin, PlanImage p) {
        super(aladin, p);
        this.type = 5;
    }

    protected PlanImageResamp(Aladin aladin) {
        super(aladin);
        this.type = 5;
    }

    protected boolean isResample() {
        return this.pixelsInit != null;
    }

    @Override
    protected void planReady(boolean ready) {
        if (!ready) {
            super.planReady(ready);
            return;
        }
        this.setActivated(true);
        this.setPourcent(-1.0);
        this.flagOk = true;
        this.aladin.calque.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchResampleBy(PlanImage pref, int methode, boolean flagFullPixel) {
        this.fullPixel = flagFullPixel;
        this.methode = methode;
        if (this.fullPixel) {
            this.pixelsOriginFromCache();
            this.cacheAvailable(false);
            this.noCacheFromOriginalFile();
        } else {
            this.noOriginalPixels();
        }
        if (pref == null || pref == this) {
            if (this.isResample()) {
                this.setBufPixels8(this.pixelsInit);
                if (this.fullPixel) {
                    this.pixelsOrigin = this.pixelsOriginInit;
                }
                this.naxis1 = this.width = this.widthInit;
                this.naxis2 = this.height = this.heightInit;
                this.projd = this.projInit;
                this.changeImgID();
                this.aladin.view.repaintAll();
            }
            return;
        }
        this.prefResample = pref;
        this.flagOk = false;
        this.flagProcessing = true;
        this.aladin.calque.select.repaint();
        this.sendLog("Resample", " [" + this + " with " + pref + (methode == 1 ? "/bilinear" : "") + (this.fullPixel ? "/fullPix" : "") + "]");
        PlanImageResamp planImageResamp = this;
        synchronized (planImageResamp) {
            this.runme = new Thread((Runnable)this, "AladinBuildResamp");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    @Override
    protected boolean freePlan() {
        this.pixelsInit = null;
        this.pixelsOriginInit = null;
        return super.freePlan();
    }

    protected boolean resample() {
        boolean hasOrig;
        PlanImage pref = this.prefResample;
        Aladin.trace(3, "Resampling " + this + " with " + pref + " method=" + this.methode);
        Coord coo = new Coord();
        int x = 0;
        int y = 0;
        int w = pref.width;
        if (this.isResample()) {
            this.setBufPixels8(this.pixelsInit);
            if (this.fullPixel) {
                this.pixelsOrigin = this.pixelsOriginInit;
            }
        } else {
            this.pixelsInit = this.getBufPixels8();
            if (this.fullPixel) {
                this.pixelsOriginInit = this.pixelsOrigin;
            }
            this.widthInit = this.width;
            this.heightInit = this.height;
        }
        boolean bl = hasOrig = this.pixelsOriginInit != null;
        if (!pref.projd.c.TheSame(this.projInit.c)) {
            this.setBufPixels8(new byte[pref.getBufPixels8().length]);
            if (hasOrig) {
                this.pixelsOrigin = new byte[pref.getBufPixels8().length * this.nbytes];
            }
            for (int i = 0; i < pref.getBufPixels8().length; ++i) {
                coo.x = i % w;
                coo.y = i / w;
                pref.projd.getCoord(coo);
                if (Double.isNaN(coo.al)) continue;
                this.projInit.getXY(coo);
                if (!Double.isNaN(coo.x)) {
                    switch (this.methode) {
                        case 0: {
                            x = (int)Math.round(coo.x);
                            y = (int)Math.round(coo.y);
                            if (x < 0 || x >= this.widthInit || y < 0 || y >= this.heightInit) break;
                            this.getBufPixels8()[i] = this.pixelsInit[y * this.widthInit + x];
                            if (!hasOrig) break;
                            int pos1 = (this.heightInit - y - 1) * this.widthInit + x;
                            int pos2 = this.getBufPixels8().length - pref.width * (i / pref.width + 1) + i % pref.width;
                            this.copyPixVal(this.pixelsOriginInit, pos1, this.pixelsOrigin, pos2);
                            break;
                        }
                        case 1: {
                            double d3;
                            double d2;
                            double d1;
                            double d0;
                            int x1 = (int)Math.round(coo.x - 0.5);
                            int y1 = (int)Math.round(coo.y - 0.5);
                            int x2 = x1 + 1;
                            int y2 = y1 + 1;
                            if (x1 < 0 || x2 >= this.widthInit || y1 < 0 || y2 >= this.heightInit) break;
                            double p0 = 0xFF & this.pixelsInit[y1 * this.widthInit + x1];
                            double p1 = 0xFF & this.pixelsInit[y1 * this.widthInit + x2];
                            double p2 = 0xFF & this.pixelsInit[y2 * this.widthInit + x1];
                            double p3 = 0xFF & this.pixelsInit[y2 * this.widthInit + x2];
                            try {
                                d0 = 1.0 / (coo.x - (double)x1);
                                try {
                                    d1 = 1.0 / ((double)x2 - coo.x);
                                }
                                catch (Exception e) {
                                    d0 = 0.0;
                                    d1 = 1.0;
                                }
                            }
                            catch (Exception e) {
                                d0 = 1.0;
                                d1 = 0.0;
                            }
                            double pA = (p0 * d0 + p1 * d1) / (d0 + d1);
                            double pB = (p2 * d0 + p3 * d1) / (d0 + d1);
                            try {
                                d2 = 1.0 / (coo.y - (double)y1);
                                try {
                                    d3 = 1.0 / ((double)y2 - coo.y);
                                }
                                catch (Exception e) {
                                    d2 = 0.0;
                                    d3 = 1.0;
                                }
                            }
                            catch (Exception e) {
                                d2 = 1.0;
                                d3 = 0.0;
                            }
                            this.getBufPixels8()[i] = (byte)(0xFF & (int)((pA * d2 + pB * d3) / (d2 + d3)));
                            if (!hasOrig) break;
                            p0 = this.getPixVal(this.pixelsOriginInit, this.bitpix, (this.heightInit - y1 - 1) * this.widthInit + x1);
                            p1 = this.getPixVal(this.pixelsOriginInit, this.bitpix, (this.heightInit - y1 - 1) * this.widthInit + x2);
                            p2 = this.getPixVal(this.pixelsOriginInit, this.bitpix, (this.heightInit - y2 - 1) * this.widthInit + x1);
                            p3 = this.getPixVal(this.pixelsOriginInit, this.bitpix, (this.heightInit - y2 - 1) * this.widthInit + x2);
                            pA = (p0 * d0 + p1 * d1) / (d0 + d1);
                            pB = (p2 * d0 + p3 * d1) / (d0 + d1);
                            PlanImageResamp.setPixVal(this.pixelsOrigin, this.bitpix, this.getBufPixels8().length - pref.width * (i / pref.width + 1) + i % pref.width, (pA * d2 + pB * d3) / (d2 + d3));
                        }
                    }
                }
                if (i % 10000 != 0) continue;
                this.setPourcent(i * 100 / pref.getBufPixels8().length);
            }
        }
        this.naxis1 = this.width = pref.width;
        this.naxis2 = this.height = pref.height;
        this.projInit = this.projd.copy();
        this.projd = pref.projd.copy();
        this.setHasSpecificCalib();
        this.setPourcent(-1.0);
        Aladin.trace(3, "Resampling achieved...");
        this.flagProcessing = false;
        this.calculPixelsZoom();
        this.changeImgID();
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
        return true;
    }
}

